///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////
// TicTacToe.C: TicTacToe subsystem that encapsulates all
//              major components of the game
///////////////////////////////////////////////////////////////
#include "TicTacToe.h"
#include "GameBoard.h"
#include "Engine.h"
#include "Command.h"
#include "Message.h"
#include <Xm/Form.h>
#include <Xm/Separator.h>

TicTacToe::TicTacToe ( const char *name, Widget parent ) : 
UIComponent ( name )
{
    // Create the driving engine for the game
    
    _engine = new Engine ( this );
    
    // Create a form to hold all other widgets
    
    _w = XtCreateWidget ( _name, xmFormWidgetClass, 
			  parent, NULL, 0 );
    
    installDestroyHandler();
    
    // Separate the commands from the message area
    
    Widget sep = XtCreateManagedWidget ( "commandSeparator", 
					 xmSeparatorWidgetClass, 
					 _w, NULL, 0 );
    
    // Create the widgets for the UI Components
    
    _msgArea     = new Message ( "messages", _w );
    _commandArea = new Command ( "commands", _w, this );
    _gameBoard   = new GameBoard ( "gameBoard", _w, this );
    
    // Set up all constraints
    
    // The GameBoard is attached to the parent XmForm widget
    // on the top and sides; to an XmSeparator on the bottom
    
    XtVaSetValues ( _gameBoard->baseWidget(), 
		    XmNtopAttachment,    XmATTACH_FORM,
		    XmNleftAttachment,   XmATTACH_FORM,
		    XmNrightAttachment,  XmATTACH_FORM,
		    XmNbottomWidget,     sep,
		    XmNbottomAttachment, XmATTACH_WIDGET,
		    NULL );
    
    // Attach a separator widget to the top of the message area
    
    XtVaSetValues ( sep,
		    XmNtopAttachment,    XmATTACH_NONE,
		    XmNleftAttachment,   XmATTACH_FORM,
		    XmNrightAttachment,  XmATTACH_FORM,
		    XmNbottomWidget,     _msgArea->baseWidget(),
		    XmNbottomAttachment, XmATTACH_WIDGET,
		    NULL );
    
    // Attach the Message component to the separator,
    // and span the width of the Form widget
    
    XtVaSetValues ( _msgArea->baseWidget(),
		    XmNtopAttachment,    XmATTACH_NONE,
		    XmNleftAttachment,   XmATTACH_FORM,
		    XmNrightAttachment,  XmATTACH_FORM,
		    XmNbottomWidget,     _commandArea->baseWidget(),
		    XmNbottomAttachment, XmATTACH_WIDGET,
		    NULL );
    
    // Attach the Command component to the top, left, and right
    // sides of the form, so it floats along the top
    
    XtVaSetValues ( _commandArea->baseWidget(),
		    XmNtopAttachment,    XmATTACH_NONE,
		    XmNleftAttachment,   XmATTACH_FORM,
		    XmNrightAttachment,  XmATTACH_FORM,
		    XmNbottomAttachment, XmATTACH_FORM,
		    NULL );
    
    // Manage the widgets for all subcomponents, so that managing
    // the TicTacToe base widget displays everything
    
    _commandArea->manage();
    _gameBoard->manage();
    _msgArea->manage();
    _gameBoard->clear();
}

TicTacToe::~TicTacToe()
{
    delete _gameBoard;
    delete _msgArea;
    delete _commandArea;
    delete _engine;
}



























