///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////
// MenuDemoApp.C:
//////////////////////////////////////////////////////////////
#include "MenuDemoApp.h"
#include "QuitCmd.h"
#include "ManageCmd.h"
#include "IconifyCmd.h"
#include "NoOpCmd.h"
#include "MenuDemoWindow.h"

MenuDemoApp *theMenuDemoApp = new MenuDemoApp ( "MenuDemo" );
MainWindow  *window1 = new MenuDemoWindow ( "Window1" );
MainWindow  *window2 = new MenuDemoWindow ( "Window2" );
MainWindow  *window3 = new MenuDemoWindow ( "Window3" );
MenuDemoApp::MenuDemoApp ( const char * name ) : Application ( name )
{
    // Create the application-wide commands that appear in all menus
    
    _quit    = new QuitCmd ( "Quit" );
    _manage  = new ManageCmd ( "Open" );
    _iconify = new IconifyCmd ("Iconify" );
    
    // Create three NoOpCmd objects to demonstrate dependencies and
    // to demo the support for multiple interfaces to a single Cmd
    
    _x = new NoOpCmd ( "X" );
    _y = new NoOpCmd ( "Y" );
    _z = new NoOpCmd ( "Z", FALSE );
    
    // Specify relationships between the X, Y, and Z commands
    // Activating any command deactivates itself and activates
    // the other two commands
    
    _x->addToActivationList ( _y );
    _x->addToActivationList ( _z );
    _x->addToDeactivationList ( _x );
    
    _y->addToActivationList ( _x );
    _y->addToActivationList ( _z );
    _y->addToDeactivationList ( _y );
    
    _z->addToActivationList ( _x );
    _z->addToActivationList ( _y );
    _z->addToDeactivationList ( _z );
}
MenuDemoApp::~MenuDemoApp()
{
    delete _quit;
    delete _manage;
    delete _iconify;
    delete _x;
    delete _y;
    delete _z;
}






















































































































































































