///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////
// MenuDemoWindow.C: Demonstrate Cmd and MenuBar classes
/////////////////////////////////////////////////////////////
#include "MenuDemoWindow.h"
#include "MenuBar.h"
#include "MenuDemoApp.h"
#include "NoOpCmd.h"
#include "UndoCmd.h"
#include "CmdList.h"
#include <Xm/DrawingA.h>

MenuDemoWindow::MenuDemoWindow ( const char *name) : MenuWindow ( name )
{
    // Create three NoOpCmd objects to demonstrate relationships
    // between objects, as well as MotifApps undo facility
    
    _a = new NoOpCmd ( "A" );
    _b = new NoOpCmd ( "B" );
    _c = new NoOpCmd ( "C", FALSE );
    
    // Set up dependencies between objects
    // Each command disables itself once it is executed,
    // and enables the other two
    
    _a->addToActivationList ( _b );
    _a->addToActivationList ( _c );
    _a->addToDeactivationList ( _a );
    
    _b->addToActivationList ( _a );
    _b->addToActivationList ( _c );
    _b->addToDeactivationList ( _b );
    
    _c->addToActivationList ( _a );
    _c->addToActivationList ( _b );
    _c->addToDeactivationList ( _c );
}
Widget MenuDemoWindow::createWorkArea ( Widget parent )
{
    _canvas = XtCreateWidget ( "canvas", xmDrawingAreaWidgetClass,
			       parent,  NULL, 0 );
    return ( _canvas );    
}
void MenuDemoWindow::createMenuPanes()
{
    CmdList *cmdList;
    
    // Create an Application pane containing undo, 
    // and other application-wide commands
    
    cmdList = new CmdList( "Application" );
    cmdList->add ( theUndoCmd );        
    cmdList->add ( theMenuDemoApp->manageCmd() );
    cmdList->add ( theMenuDemoApp->iconifyCmd() );
    cmdList->add ( theMenuDemoApp->quitCmd() );
    _menuBar->addCommands ( cmdList );
    delete cmdList;
    
    // Create a menu pane of NoOpCmd objects to demonstrate
    // Cmd objects that have multiple interfaces 
    
    cmdList = new CmdList ( "XYZ" );
    cmdList->add ( theMenuDemoApp->xCmd() );
    cmdList->add ( theMenuDemoApp->yCmd() );
    cmdList->add ( theMenuDemoApp->zCmd() );
    _menuBar->addCommands ( cmdList );
    delete cmdList;
    
    // Create a window-specific menu pane, containing 
    // commands that are independent within each window
    
    cmdList = new CmdList ( "ABC" );
    cmdList->add ( _a );
    cmdList->add ( _b );
    cmdList->add ( _c );
    _menuBar->addCommands ( cmdList );
    delete cmdList;
}































