/*
 * Stack.h : definition of the dndStack class
 * Copyright (C) 1996 Csar Crusius
 *
 * This file is part of the DND Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*****************************************************************
*
* dndSTACK
*
* Class that implements a FILO list.
*
* LAST UPDATED:
*
* Jun 12, 1994	Implemented
*
******************************************************************/

#ifndef __DNDSTACKh__
#define __DNDSTACKh__

#include <OffiX/List.h>

class dndStack:public dndList
{
	void (*DropFunc)(dndPointer);

	public:

	dndStack(void(*func)(dndPointer)=NULL):dndList() { DropFunc=func; }
	void setdelfunc(void(*func)(dndPointer)) { DropFunc=func; }
	~dndStack() {}

	dndPointer pop(void);
	dndPointer drop(dndListIndex=1L);
	dndPointer push(dndPointer);
	dndPointer top(void);

	void swap(dndListIndex=2L);
	void rot(dndListIndex=3L);
	void unrot(dndListIndex=3L);

	dndPointer add(dndPointer obj)	{ return push(obj); }
	dndPointer remove(void)	{ return pop(); }
};

#endif
