.TH BS 1 "5 November 1992"
.SH NAME
bs \- a simple button shell for X11
.SH SYNOPSIS
.B bs
[
.I file
]
[
.I Xt options
]
.SH DESCRIPTION
.B bs
is a simple button shell for X11.
It is useful for repetitive tasks such as
edit-compile-run cycles,
and also as a general purpose menu.

.B bs
builds, displays, and let you interact with
a panel composed of labels and buttons.
Labels contain informative text and
buttons are associated with commands that are fed to a shell,
in a pipe.

.B bs
reads a panel description from the
.I file
given in the command line,
or from the file
.B .bsrc
in the current directory if no file is given.

There are 4 kinds of lines in the file describing the panel:
lines starting with a
.SM TAB;
lines with a
.SM TAB elsewhere;
lines without a
.SM TAB;
and empty lines.

Lines without a
.SM TAB
represent labels.
The text in the line appears verbatim in the panel.

Lines with a
.SM TAB
not on the first column represent buttons.
The text before the
.SM TAB
is the button text.
The text after the
.SM TAB
is a command fed to the shell when the button is pressed.

Lines starting with a
.SM TAB
are fed to the shell as soon as
.B bs
begins.
They typically contain variable definitions,
but they can contain command.
Because
.B bs
sends data to a shell using a single pipe that remains open throughout
the execution,
variables definitions remain after this initialization.

Panel layout is controled by empty lines.
Buttons and labels appear side by side, from left to right.
An empty line signals the start of a new row in the panel.
So,
descriptions of "horizontal" panels have no empty lines, and
descriptions of "vertical" panels have an empty line after each element,
including the last one.

.SM SPACE
characters are significant in labels and button labels.
They can be used for alignment,
provided a non-proportional font is used.

.B bs
automatically adds a button labeled "quit" in the end of the panel;
it does the obvious thing.

.SH EXAMPLE
Here is an example suitable for using TeX:

.DT
.nf
		F=paper
	paper
	edit	xterm -geometry 80x57+0+0 -title $F -e vi $F.tex &
	tex	latex $F.tex </dev/null
	dvi	xdvi -hushspecials -geometry +0+0 $F.dvi &
	ps	dvips -o $F.ps $F.dvi; ghostview $F.ps &
	print	dvips -f $F.dvi | lpr -h
.fi

A similar example would be adequate for compiling C programs.
.SH RESOURCES
.B bs
does not define any new resources.
It uses the following widgets from the Athena Widget set:
Command,
Form,
Label.
All standard X11 toolkit options are accepted on the command line.
.SH FILES
.BR .bsrc
.SH SEE ALSO
.BR sh (1)
.SH BUGS
Buttons should stay pressed until the corresponding command finishes.
Of course,
this only applies to commands that are run in the foreground.

/bin/sh is hard-coded into the program.
Other shells did not quite work.
.SH AUTHOR
Luiz Henrique de Figueiredo
(lhf@visgraf.impa.br)

Please send me your comments, bug reports, corrections, etc.
