#
# This is the only makefile that needs to be customized to
# port the software to a new architecture
#

# Architecture

ARCH = sunos5.4

# Directories

HOMEDIR=/solaris/usr/home/freedom
ROOTDIR=$(HOMEDIR)/FD1.32
LIBDIR= $(ROOTDIR)/lib/$(ARCH)
INSDIR= $(ROOTDIR)/freedom_software
BINDIR= $(ROOTDIR)/freedom_software/bin
INCDIR= $(ROOTDIR)/include

# softkey (workstation version only)

SECURITY = -DSECURITY
SECURITY_TARGET=security
SECURITY_LIBRARY=-lkey
CLEAN_SECURITY=clean_security

# Compiler and linker flags

CFLAGS =  -O2 -D_NO_PROTO -DEDITRES -DSVR4 -Dsun \
-I/opt/gnu/lib/gcc-lib/sparc-sun-solaris2.4/2.6.3/include \
-I$(INCDIR) -I/usr/openwin/include  \
-traditional -Dlint -DSOLARIS
#CFLAGS =  -g -D_NO_PROTO -DEDITRES -DSVR4 -Dsun \
-I/opt/gnu/lib/gcc-lib/sparc-sun-solaris2.4/2.6.3/include \
-I$(INCDIR) -I/usr/openwin/include  \
-traditional -Dlint -DSOLARIS

CC = /opt/gnu/bin/gcc

LDFLAGS= -L$(LIBDIR) -L/usr/openwin/lib -Xlinker -Bstatic
#LDFLAGS= -L$(LIBDIR) -L/usr/local/SUNWmotif/lib


# Libraries

#XLIBS = -Xlinker -Bstatic -lXm -Xlinker -Bdynamic -lXaw -lXmu -lXt -lXext -lX11  -lsocket -lgen  
#Problems with Solaris
#XLIBS = -Xlinker -Bstatic -lXm -lXaw -lXmu -lXt -lXext -Xlinker -Bdynamic -lX11  -Xlinker -Bstatic -lsocket -lw  -lnsl -lintl  -lgen   
XLIBS = -Xlinker -Bstatic -lXm  -lXmu -lXt -lXext -Xlinker -Bdynamic -lX11  -Xlinker -Bstatic  -lnsl -lintl -lgen   

ULIBS= -lfm -lbinder -lXedw -lRt -lXpm -letc  -lrdd -lX -lcommon $(SECURITY_LIBRARY) -lst
#UCBLIB = -Xlinker -Bstatic -L/usr/ucblib -lucb
SYSLIBS= -lm -ltermcap -Xlinker -Bdynamic -ldl $(UCBLIB)
LIBS= $(ULIBS) $(XLIBS) $(SYSLIBS)

#Pixmap (only the Motif library is statically linked)

PIXMAP_LIBS= -lXpm -Xlinker -Bstatic -lXm -Xlinker -Bdynamic \
-lXmu -lXt -lXext -lX11 -lm -lgen

RANLIB = true

# Common makefile for all architectures

include Makefile.common

