/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */


#ifndef _ARRAY_H
#define _ARRAY_H

#include <stdlib.h>
#include "Rt.h"



typedef struct _ArrayClassPart {
    int foo;  
} ArrayClassPart;

typedef struct _ArrayClassRec {
    ObjCoreClassPart core_class;
    ArrayClassPart array_class;
} ArrayClassRec;

extern  ArrayClassRec   arrayClassRec;
extern  ObjClass arrayObjClass;

typedef struct _ArrayPart {
   Obj *obj_array;	/* array of objects			      */
   unsigned int cnt;	/* object count				      */
   unsigned int max_cnt;
   unsigned int index;
   Obj current;		/* current array element			*/
   Obj *curr_addr;	 
   int flags;
} ArrayPart;

/*
 * Record
 */

typedef struct _ArrayRec { 
   ObjCorePart core;
   ArrayPart    arr;
} ArrayRec;


typedef ArrayRec  	*ArrayObj;
typedef ArrayClassRec	*ArrayObjClass;

#define RtARR_CHUNK_SIZE  4

#define RtNarrayCurrent "arrayCurrent"


#define RtARRAY_ADD	4000
#define RtARRAY_FIND	4001
#define RtARRAY_DELETE	4002
#define RtARRAY_FIRST	4003
#define RtARRAY_NEXT	4004

#endif
