/*
 * Freedom Desktop 
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#ifndef BROADCASTER_H
#define BROADCASTER_H

/*
 * Broadcaster: Object used to broadcast messages. The input
 * message is broadcasted to the list of receptors
 * stored in the object. 
 */

#include "Rt.h"


#define BC_CHUNK_SIZE           4

typedef struct _BroadcasterClassPart {
    int foo;  
} BroadcasterClassPart;

typedef struct _BroadcasterClassRec {
    ObjCoreClassPart core_class;
    BroadcasterClassPart broadcaster_class;
} BroadcasterClassRec;

extern  BroadcasterClassRec   broadCasterClassRec;
extern  ObjClass broadCasterObjClass;

typedef struct _Receptor {
   Obj object;		/* receptor			*/
   Obj new_msg;		/* new message			*/
} *Receptor;

typedef struct _BroadcasterPart {
#ifdef OLD
  Obj *object_list;     /* Broadcast the message to this list of objects */
#endif
  Receptor receptor_list; /* Broadcast the message to this list of objects */ 
  int max_cnt;		/* Size of the list of objects			*/
  int index; 		/* Index into the list of objects		*/   
  int new_id;           /* Broadcast message with this new message ID   */
  int new_flags;        /* New message flags                            */
  int new_type;		/* New message type				*/
  char *new_content;	/* New message content				*/
  int set_content;	/* use new_content as the content of the message*/ 
  int reset;            /* Reset the object                             */
  int negate;           /* Negate output. This applies to logical data  */
                        /* only       					*/
  int true_values;      /* Broadcast true values only                   */
  int stop_flow;        /* Block the flow of data                       */
  int multiplexer_mode;	/* Act as a multiplexer				*/
  int receiver_selected;/* Selected receiver (Multiplexer)		*/
  /* conversion section */
  MessageObj cnv_tbl;   /* Conversion table				*/
  int cnv_index;	/* Index to the coversion table			*/
  int cnv_max_cnt;
  int must_match;	/* The Message id must match at least of the    */
  			/* entries of the conversion table. Otherwise   */
  			/* the flow will stop (the message will not be  */
  			/* broadcasted)					*/   
} BroadcasterPart;

/*
 * Broadcaster record
 */
 
typedef struct _BroadcasterRec {
   ObjCorePart core;
   MessagePart message;
   BroadcasterPart broadcaster;
} BroadcasterRec;

typedef BroadcasterRec          *BroadcasterObj;
typedef BroadcasterClassRec     *BroadcasterObjClass;

#ifdef _NO_RESOURCE
#define RtNbcObjectList (((BroadcasterObj)(new))->broadcaster.object_list)
#define RtNbcNewId (((BroadcasterObj)(new))->broadcaster.new_id)
#define RtNbcNewFlags (((BroadcasterObj)(new))->broadcaster.new_flags)
#define RtNbcNewContent (((BroadcasterObj)(new))->broadcaster.new_content)
#define RtNbcNewType (((BroadcasterObj)(new))->broadcaster.new_type)
#define RtNbcNegate (((BroadcasterObj)(new))->broadcaster.negate)
#define RtNbcTrueValues (((BroadcasterObj)(new))->broadcaster.true_values)
#define RtNbcStopFlow (((BroadcasterObj)(new))->broadcaster.stop_flow)
#define RtNbcCount (((BroadcasterObj)(new))->broadcaster.index)
#define RtNbcMultiplexerMode (((BroadcasterObj)(new))->broadcaster.multiplexer_mode)
#define RtNbcReceiverSelected (((BroadcasterObj)(new))->broadcaster.receiver_selected)
#define RtNbcSetContent (((BroadcasterObj)(new))->broadcaster.set_content)
#define RtNbcMustMatch (((BroadcasterObj)(new))->broadcaster.must_match)
#else
#define RtNbcNewId "bcNewId"
#define RtNbcNewFlags "bcNewFlags"
#define RtNbcNewContent "bcNewContent"
#define RtNbcNewType "bcNewType"
#define RtNbcNegate "bcNegate"
#define RtNbcTrueValues "bcTrueValues"
#define RtNbcStopFlow "bcStopFlow"
#define RtNbcCount "bcCount"
#define RtNbcMultiplexerMode "bcMultiplexerMode"
#define RtNbcReceiverSelected "bcReceiverSelected"
#define RtNbcSetContent "bcSetContent"
#define RtNbcMustMatch "bcMustMatch"
#endif
#endif
