/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * Menu Object - Object used to handle Motif menus
 */

#ifndef _MENU_H
#define _MENU_H

#include "Rt.h"
#include "Widget.h"
#include <Xm/Separator.h>
#include <Xm/Label.h>
#include "PushBWrapper.h"

typedef struct _MenuClassPart {
    int foo;  
} MenuClassPart;

typedef struct _MenuClassRec {
    ObjCoreClassPart core_class;
    MenuClassPart menu_class;
} MenuClassRec;

extern  MenuClassRec   	menuClassRec;
extern  ObjClass 	menuObjClass;

typedef struct _MenuPart {
  int menu_type;	/* Menu type				*/
  char *title;		/* Menu title				*/
  int max_cnt;		/* Memory allocated 			*/
  int index;		/* Index to the next free entry		*/
  Obj *object_list;	/* List of objects (one object per each */
  			/* menu entry)				*/
  Obj receiver;		/* Send a message to this object when   */
  			/* any of the menu items is selected    */
  int one_instance;	/* No repetitions allowed		*/
  int cnt;		/* number of items			*/ 
} MenuPart;

/*
 * Menu record
 */

typedef struct _MenuRec { 
   ObjCorePart core;
   MessagePart message;
   BroadcasterPart broadcaster;
   ContainerPart container;
   RtWidgetPart widget;
   MenuPart menu;
} MenuRec;


typedef MenuRec  		*MenuObj;
typedef MenuClassRec		*MenuObjClass;

/*
 * Messages
 */
 
#define RtMEN_ADD_ITEM		1900
#define RtMEN_ADD_OBJECT	1901
#define RtMEN_DELETE_ITEM	1902

#define ML_CHUNK_SIZE	10

/*
 * Resources
 */
 
#ifdef _NO_RESOURCES
/* Object that receives the message when any of the menu 	*/
/* options is selected					     	*/
#define RtNmenuReceiver (((MenuObj)(new))->menu.receiver)
#define RtNmenuOneInstance (((MenuObj)(new))->menu.one_instance)
#define RtNmenuTitle (((MenuObj)(new))->menu.title)
#else
#define RtNmenuReceiver 	"menuReceiver"
#define RtNmenuOneInstance	"menuOneInstance" 
#define RtNmenuTitle 		"menuTitle"
#endif



#endif

