/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */


#ifndef MESSAGE_OBJ
#define MESSAGE_OBJ

#include "RtStrings.h"
#include "ObjCore.h"

/*
 * Message: object used for inter-object communication 
 */

typedef struct _MessageClassPart {
    int foo;  
} MessageClassPart;

typedef struct _MessageClassRec {
    ObjCoreClassPart core_class;
    MessageClassPart message_class;
} MessageClassRec;

extern  MessageClassRec   messageClassRec;
extern  ObjClass messageObjClass;


typedef struct _MessagePart {
   int id;              /* Message ID */
   char *content;       /* Message Content */
   int type;            /* data type       */
   char *client;        /* client information. This is used to store additional */
                        /* information                                          */
   unsigned int size;   /* Message size    */
   int flags;           /* Message flags   */
} MessagePart;

/*
 * Message record
 */

typedef struct _MessageRec {
   ObjCorePart core;
   MessagePart message;
} MessageRec;

typedef MessageRec      *MessageObj;
typedef MessageClassRec *MessageObjClass;

/*
 * Resources
 */
 
#ifdef _NO_RESOURCES
#define RtNmsgContent (((MessageObj)(new))->message.content)
#define RtNmsgId (((MessageObj)(new))->message.id)
#define RtNmsgSize (((MessageObj)(new))->message.size)
#define RtNmsgType (((MessageObj)(new))->message.type)
#define RtNmsgClient (((MessageObj)(new))->message.client)
#define RtNmsgFlags (((MessageObj)(new))->message.flags)
#else
#define RtNmsgContent "msgContent"
#define RtNmsgId "msgId"
#define RtNmsgSize "msgSize"
#define RtNmsgType "msgType"
#define RtNmsgClient "msgClient"
#define RtNmsgFlags "msgFlags"
#endif

/*
 * Message Types
 */
 
#define RtMSG_INT       1       /* integer */
#define RtMSG_STRING    2       /* string  */

/*
 * Flags
 */
 
#define RtMSG_ACTIVATE_OBJECT 1 /* Ask the receiver to activate itself */
                                /* the semantics is left to the        */
                                /* receiver                            */

#define RtMSG_REDIRECT_OUTPUT 2 /* Redirect the output of the object   */
#endif
