/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#ifndef STRING_H
#define STRING_H

#include "Rt.h"

/*
 * Macros and definitions
 */


typedef struct _StringClassPart {
    int foo;  
} StringClassPart;

typedef struct _StringClassRec {
    ObjCoreClassPart core_class;
    MessageClassPart message_class;
    BroadcasterClassPart broadcaster_class;
    StringClassPart string_class;
} StringClassRec;

extern  StringClassRec   stringClassRec;
extern  ObjClass stringObjClass;


typedef struct _StringPart {
  char *string1;
  char *string2;
  int reset;            /* reset the object                      */
  char *format;         /* format                                */
  char *current_format; 
  char *rem_format;     /* portion of the format that stiil needs */
                        /* to be processed                        */ 
  char *output; 
  int  done;            /* Ready to output data                  */
} StringPart;

/*
 * Object Record 
 */
 
typedef struct _StringRec {
   ObjCorePart core;
   MessagePart message;
   BroadcasterPart broadcaster;
   StringPart string;
} StringRec;

typedef StringRec       *StringObj;
typedef StringClassRec  *StringObjClass;

/*
 * Resources
 */
 
#ifdef _NO_RESOURCES
#define RtNstrString1 (((StringObj)(new))->string.string1)
#define RtNstrString2 (((StringObj)(new))->string.string2)
#define RtNstrFormat (((StringObj)(new))->string.format)
#else
#define RtNstrString1 "strString1"
#define RtNstrString2 "strString2"
#define RtNstrFormat "strFormat"
#endif

/*
 * Messages
 */
 
#define RtSTR_CMP       	2600
#define RtSET_STRING1   	2601
#define RtSET_STRING2   	2602
#define RtSTR_CAT       	2603
#define RtSTR_TOK       	2604
#define RtSTR_SUB_STRING       	2605

#define RtSTR_LARGE_SIZE        1024
#endif
