/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */


/*
 * Object used as a container for other objects.
 */
 
#include "Container.h"
 
void CNTInitialize ();
void CNTActivate ();
void CNTRealize ();
void CNTDestroy ();
void CNTSetValues ();
void CNTProcessMessage ();
static Obj search_for_object ();

static RtResource resources[] = {
   {RtNcontainerCurrent, NULL, RtPOINTER_TYPE, sizeof(void *), 
   RtOffset(ContainerObj,container.current), 0, NULL, 0, NULL},
};
	
ContainerClassRec containerClassRec = {
  {
    (ObjClass) &broadCasterClassRec,	/* superclass		*/
    "Container",		/* class name		*/
    NULL,	
    0,
    resources,			/* resource		*/
    RtNumber (resources),	/* number of resources  */
    /* object size              */  sizeof(ContainerRec),
    CNTInitialize,
    CNTRealize,
    NULL,
    CNTSetValues,
    CNTActivate,
    CNTDestroy,
    CNTProcessMessage,
    "container",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass containerObjClass = (ObjClass) &containerClassRec; 

void CNTSetValues (current, new)
ContainerObj current, new;
{
   /* Check - This should be done by the superclass */
   
   if (current->core.object_name != new->core.object_name)
        RtUpdateString (current->core.object_name, new->core.object_name);
}


void CNTInitialize (new)
ContainerObj new;
{
}

void CNTActivate (new)
ContainerObj new;
{
}


void CNTRealize (obj)
ContainerObj obj;
{
register Obj *op;
register int i = 0;

   op = obj->container.object_list;
   
   if (!op)
        return;

   /* traverse the list of objects and realize each one of them */
   
   while (i++ < obj->container.index)
        RtRealizeObject (*op++);
}


static void broadcast_message (obj, msg)
ContainerObj obj;
MessageObj msg;
{
register Obj *op;
register int i = 0;

   op = obj->container.object_list;
   
   if (!op)
        return;

   /* traverse the list of objects and realize each one of them */
   
   while (i++ < obj->container.index)
        RtSendMessage (*op++, msg);
}

void CNTDestroy (obj)
ContainerObj obj;
{
}

void CNTProcessMessage (obj, data, client)
ContainerObj obj;
void *data;
void *client;
{
Obj *tmp;
register int i = 0;
MessageObj msg;
char *content;
int message_id;

   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
   RtGetValue (msg, RtNmsgContent, &content);   

   switch (message_id) {
#ifdef OLD   
      case RtADD_RECEPTOR:
        /* Invoke the superclass method         */
        (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) data, NULL);
        break;
#endif        
      case RtCONTAINER_SEARCH_OBJECT:
        if (!content)
            return;
        /* Search for an object in the container */
        obj->container.current = search_for_object (obj, content);
        break;
      case RtADD_OBJECT:
        if (!obj->container.object_list) {
           obj->container.object_list = (Obj *) malloc (sizeof (Obj) 
                * CNT_CHUNK_SIZE);

           if (!obj->container.object_list)
                return;
                
           obj->container.max_cnt = CNT_CHUNK_SIZE;
        } else if (obj->container.index >= obj->container.max_cnt) {
           tmp = realloc (obj->container.object_list, sizeof (Obj) 
                        * (obj->container.max_cnt + CNT_CHUNK_SIZE));
           if (tmp) {
                obj->container.object_list = tmp;
                obj->container.max_cnt += CNT_CHUNK_SIZE;                     
           }
                           
        }
        
        if (obj->container.index >= obj->container.max_cnt)
           return;
       
        *(obj->container.object_list + obj->container.index) =
                        (Obj) content;
        obj->container.index++;
        break;
      case RtCONTAINER_BROADCAST_MESSAGE:
        broadcast_message (obj, (Obj) content);
        break;  
      default:
#ifdef DEBUG
        fprintf (stderr,
           "Container Object: unknown message ID, I don't know how to process this message\n");
#endif
	/* Invoke the superclass to process the message */
	RtSuperclassProcessMessage (containerObjClass,
		obj, data, client); 
        break;
   }
}

/*
 * search_for_object: search for an object in the container (by name)
 */
 
static Obj search_for_object (obj, content)
ContainerObj obj;
char *content;
{

register Obj *op;
register int i = 0;
char     *name;

   if (!obj || !content)
        return (NULL);

   op = obj->container.object_list;
   
   if (!op)
        return (NULL);

   /* traverse the list of objects searching for name */
   
   while (i++ < obj->container.index) {
        if (!*op) {
          op++;
          continue;
        }
        RtGetValue (*op, RtNobjName, &name);
                    
        if (name && !strcmp (name, content)) 
                return (*op);
        op++;
   }
   
   return (NULL);
}
