/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * Data Entry Object
 */

#include "DataEntry.h"

void DENTInitialize ();
void DENTDestroy ();
void DENTSetValues ();
void DENTProcessMessage ();

static RtResource resources[] = {
   {RtNdentObj, NULL, RtOBJ_TYPE, sizeof(Obj), 
   RtOffset(DataEntryObj,dent.obj), 0, NULL, 0, NULL},
   {RtNdentAutoPopup, NULL, RtBIT_TYPE, 1,
   RtOffset(DataEntryObj,dent.flags), 0, NULL, 0, RtDENT_AUTO_POPUP},
   {RtNdentAutoPopdown, NULL, RtBIT_TYPE, 1,
   RtOffset(DataEntryObj,dent.flags), 0, NULL, 0, RtDENT_AUTO_POPDOWN},
   {RtNdentEditMode, NULL, RtBIT_TYPE, 1,
   RtOffset(DataEntryObj,dent.flags), 0, NULL, 0, RtDENT_EDIT_MODE}
};

DataEntryClassRec dataEntryClassRec = {
  {
    (ObjClass) &rtWidgetClassRec,/* superclass		*/
    "Data Entry",		/* class name		*/
    NULL,	
    0,
    resources,			/* resource table	*/
    RtNumber (resources),	/* number of resources  */
    /* object size              */  sizeof(DataEntryRec),
    DENTInitialize,
    NULL,
    NULL,
    DENTSetValues,
    NULL,
    DENTDestroy,
    DENTProcessMessage,
    "dent",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass dataEntryObjClass = (ObjClass) &dataEntryClassRec; 

/*
 * DENTSetValues: set object resources
 */
 
void DENTSetValues (current, new)
DataEntryObj current, new;
{
   /* Check - This should be done by the superclass */
   
   if (current->core.object_name != new->core.object_name)
        RtUpdateString (current->core.object_name, 
        	new->core.object_name);
}


/*
 * DENTInitialize: initialize object
 */

void DENTInitialize (obj)
DataEntryObj obj;
{
#ifdef DEBUG
   obj->core.object_name = strdup ("Data Entry");
#endif
}


/*
 * DENTDestroy: destroy object
 */
 
void DENTDestroy (obj)
DataEntryObj obj;
{
}

/*
 * DENTProcessMessage: process object messages
 */
 
void DENTProcessMessage (obj, data, client)
DataEntryObj obj;
void *data;
char *client;
{
MessageObj msg, aux_msg;
char *content;
Obj new_obj;
int message_id;
Obj wrapper = NULL;
int sensitive;

   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
   RtGetValue (msg, RtNmsgContent, &content);   

   switch (message_id) {
      case RtDENT_SET_SENSITIVE:
        RtSetValue (stdmsg, RtNmsgId, RtCONTAINER_SEARCH_OBJECT);        
        RtSetValue(stdmsg, RtNmsgContent, content); 
      	RtSendMessage (obj, stdmsg, NULL);      	
        RtGetValue (obj, RtNcontainerCurrent, &wrapper);
        
	if (!wrapper) {
	   return;
	}
        RtGetValue (msg, RtNmsgClient, &sensitive);   
        RtSetValue (stdmsg, RtNmsgId, RtWIDGET_SET_SENSITIVE);        
        RtSetValue (stdmsg, RtNmsgContent, sensitive);        
      	RtSendMessage (wrapper, stdmsg, NULL);      	
	
        break;
      case RtDENT_LOAD:
        if (!obj->dent.obj || !content)
           return;
           
        if (obj->dent.flags & RtDENT_AUTO_POPUP) {
           RtSetValue (stdmsg, RtNmsgId, RtWIDGET_POPUP);
      	   RtSendMessage (obj, stdmsg, NULL);      	
        }   
        RtCopyObject ((Obj) content, obj->dent.obj);
#ifdef DEBUG
        fprintf (stderr, "DENTProcessMessage:RtDENT_LOAD\n");
        RtSetValue (stdmsg, RtNmsgId, RtPRINT_OBJECT);
        RtSendMessage (obj->dent.obj, stdmsg, NULL);
#endif
        break;
      case RtRELEASE_DATA:
        if (!obj->dent.obj)
           return;
        
        /* check status 		   */
        (obj->dent.obj)->core.status = 0;
        RtValidateResources (obj->dent.obj);
        if ((obj->dent.obj)->core.status)
           return;
            
        RtSetValue (stdmsg, RtNmsgId, RtVALIDATE);
        RtSendMessage (obj->dent.obj, stdmsg, NULL);

        if ((obj->dent.obj)->core.status)
           return;
            
        if (obj->dent.flags & RtDENT_AUTO_POPDOWN) {
           RtSetValue (stdmsg, RtNmsgId, RtWIDGET_POPDOWN);
      	   RtSendMessage (obj, stdmsg, NULL);      	
        }
        if (obj->dent.flags & RtDENT_EDIT_MODE)
           new_obj = obj->dent.obj;
        else 
           new_obj = RtCloneObject (obj->dent.obj);
#ifdef DEBUG
        fprintf (stderr, "DENTProcessMessage:RtRELEASE_DATA\n");
        RtSetValue (stdmsg, RtNmsgId, RtPRINT_OBJECT);
        RtSendMessage (new_obj, stdmsg, NULL);
#endif
        if (!new_obj)
           return;
        RtSetValue (stdmsg, RtNmsgId, RtMESSAGE); /* For now */
        RtSetValue (stdmsg, RtNmsgContent, new_obj);
        (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) stdmsg, NULL);
        break;
      case RtCLEAR:
        RtSetValue (stdmsg, RtNmsgId, RtCLEAR);
        RtSendMessage (obj->dent.obj, stdmsg, NULL);
        aux_msg = RtCreateMessage ();
        RtSetValue (stdmsg, RtNmsgId, RtCONTAINER_BROADCAST_MESSAGE); 
        RtSetValue (aux_msg, RtNmsgId, RtCLEAR);	
        RtSetValue (stdmsg, RtNmsgContent, aux_msg);
   	RtSuperclassProcessMessage (dataEntryObjClass,
   		obj, stdmsg, client);
        RtDestroyObject (aux_msg);
        break;
      default:
#ifdef DEBUG
   	fprintf (stderr, 
   	"DENTProcessMessage: I don't know how to process this message\n");
#endif
   	RtSuperclassProcessMessage (dataEntryObjClass,
   		obj, data, client);
        break;
   }
}

