/*
 * Freedom Desktop 
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * XmFileSelectionDialog wrapper Object - Object used to handle 
 * 					File Selection dialogs
 */

#include "FileSBWrapper.h"

void FSBWInitialize ();
void FSBWActivate ();
void FSBWDestroy ();
void FSBWRealize ();
void FSBWSetValues ();
void FSBWProcessMessage ();
void FSBWCancelButtonCB ();
void FSBWOkButtonCB ();
void FSBWHelpButtonCB ();
static void extended_file_selection ();

static RtResource resources[] = {
   {RtNfsbwUnmanageHelpButton, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(XmFileSBWrapperObj,file_wrapper.unmanage_help), 0, NULL, 0, 
   NULL},
   {RtNfsbwSelectionPolicy, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(XmFileSBWrapperObj,file_wrapper.selection_policy), 0, NULL, 0, 
   NULL},
   {RtNfsbwTypeMask, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(XmFileSBWrapperObj,file_wrapper.type_mask), 0, NULL, 0, 
   NULL},
};


XmFileSBWrapperClassRec xmFileSBWrapperClassRec = {
  {
    (ObjClass) &rtWidgetClassRec,	/* superclass		*/
    "File Selection Wrapper",	/* class name		*/
    NULL,	
    0,
    resources,			/* resource table	*/
    RtNumber (resources),	/* number of resources  */
    /* object size              */  sizeof(XmFileSBWrapperRec),
    FSBWInitialize,
    FSBWRealize,
    NULL,
    FSBWSetValues,
    FSBWActivate,
    FSBWDestroy,
    FSBWProcessMessage,
    "fsbw",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass xmFileSBWrapperObjClass = (ObjClass) &xmFileSBWrapperClassRec; 


/*
 * FSBWSetValues: set object resources
 */
 
void FSBWSetValues (current, new)
Obj current, new;
{
}

/*
 * FSBWRealize: realize object
 */
 
void FSBWRealize (obj)
XmFileSBWrapperObj obj;
{

Widget list_widget = NULL;

     
    if (!obj->widget.widget && !obj->widget.create_widget)
        return;

    /*
     * Check if the object has already been realized
     */
     
    if (obj->core.object_flags & RtOBJ_REALIZED)
        return;
    
    /*
     * Create the widget if needed
     */
         
    if (obj->widget.create_widget) {
       if (!obj->widget.parent)
          return;
       	obj->widget.widget = XmCreateFileSelectionDialog (
       		obj->widget.parent, "file_selection", NULL, 0);

    	XtVaSetValues (obj->widget.widget, 
           XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
           NULL);

       	if (obj->widget.widget) {
    	   XtVaSetValues (obj->widget.widget, XmNautoUnmanage, True,
    	   		NULL);
    	} else
    	   return;
    }

    /* Invoke the realize method of the superclass */
    (*rtWidgetObjClass->core_class.realize) (obj);

    
    if (obj->file_wrapper.type_mask)
       XtVaSetValues (obj->widget.widget, 
       		XmNfileTypeMask, obj->file_wrapper.type_mask,
       		NULL);
   
    /* extended selection */
    if (obj->file_wrapper.selection_policy == XmEXTENDED_SELECT ) {
        extended_file_selection (obj);
    }
    
    /* unmanage help button */
    if (obj->file_wrapper.unmanage_help)
           XtUnmanageChild (XmFileSelectionBoxGetChild (obj->widget.widget, 
                XmDIALOG_HELP_BUTTON));
    else
           XtManageChild (XmFileSelectionBoxGetChild (obj->widget.widget, 
                XmDIALOG_HELP_BUTTON));

    XtAddCallback (obj->widget.widget, XmNokCallback, 
    	FSBWOkButtonCB, obj);
    XtAddCallback (obj->widget.widget, XmNcancelCallback, 
    	FSBWCancelButtonCB, 
        obj);
    XtAddCallback (obj->widget.widget, XmNhelpCallback, 
    	FSBWHelpButtonCB, obj);
    obj->core.object_flags |= RtOBJ_REALIZED;
    
}

/*
 * _XCeventLoop: process events
 */
 
static _XCeventLoop (widget, wait_in_loop)
Widget widget;
int *wait_in_loop;
{
   XtAppContext app_con;
   XEvent event;
   
   if (!widget)
        return;
        
   app_con = XtWidgetToApplicationContext (widget);
   while (*wait_in_loop) {
        XtAppNextEvent (app_con, &event);
        XtDispatchEvent (&event);      
   }

}

/*
 * FSBWInitialize: initialize object
 */
 
void FSBWInitialize (obj)
XmFileSBWrapperObj obj;
{
    obj->file_wrapper.selection_policy = XmBROWSE_SELECT;   
}

/*
 * FSBWActivate: activate object
 */
 
void FSBWActivate (obj)
XmFileSBWrapperObj obj;
{

   if (!(obj->core.object_flags & RtOBJ_REALIZED) && 
   	(obj->core.object_flags & RtOBJ_AUTO_REALIZE))
   	FSBWRealize (obj);

   if (!obj->widget.widget)
        return;

   XtManageChild (obj->widget.widget);
   	
   RtSetValue (obj, RtNmsgId, RtWIDGET_POPUP);    
   /* Invoke the superclass method to popup the widget */
   (*rtWidgetObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);
}

/*
 * FSBWOkButtonCB: OK button callback
 */

void FSBWOkButtonCB (widget, client_data, cbs)
Widget widget;
XtPointer client_data;
XmFileSelectionBoxCallbackStruct *cbs;
{
  XmFileSBWrapperObj obj = (XmFileSBWrapperObj) client_data;
  char *filename;
  
   if (!obj)
     return;
     
   obj->file_wrapper.pressed_button = RtOK_BUTTON;
   
   if (obj->file_wrapper.file_selected) {
        XtFree ( obj->file_wrapper.file_selected);
        obj->file_wrapper.file_selected = NULL;
   }
           
   if (!XmStringGetLtoR (cbs->value, XmSTRING_DEFAULT_CHARSET, &filename))
       return;
   obj->file_wrapper.file_selected = filename;    

#ifdef DEBUG
   fprintf (stderr, "activate_callback\n");
#endif
   
   /* The push button has been pressed                              */
   /* Send a message to the receiver objects                        */
   /* Because an object is also a message, I send the object itself */
   RtSetValue (obj, RtNmsgId, RtFSBW_PRESSED_BUTTON);
   RtSetValue (obj, RtNmsgContent, filename);
   RtSetValue (obj, RtNmsgFlags, 0);
        
   /* Invoke the superclass method to broadcast the message */
   (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);

}

/*
 * FSBWCancelButtonCB: Cancel button callback
 */

void FSBWCancelButtonCB (widget, client_data, cbs)
Widget widget;
XtPointer client_data;
XtPointer *cbs;
{
  XmFileSBWrapperObj obj = (XmFileSBWrapperObj) client_data;
  
   obj->file_wrapper.pressed_button = RtCANCEL_BUTTON;
}

/*
 * FSBWHelpButtonCB: help button callback
 */

void FSBWHelpButtonCB (widget, client_data, cbs)
Widget widget;
XtPointer client_data;
XtPointer *cbs;
{
  XmFileSBWrapperObj obj = (XmFileSBWrapperObj) client_data;
  
  obj->file_wrapper.pressed_button = RtHELP_BUTTON;
}

/*
 * FSBWDestroy: destroy object
 */

void FSBWDestroy (obj)
XmFileSBWrapperObj obj;
{
   
   if (obj->widget.widget) {
        XtDestroyWidget (obj->widget.widget);
        obj->widget.widget = NULL;
   }           
}


/*
 * FSBWProcessMessage: process object messages
 */

void FSBWProcessMessage (obj, data, client)
XmFileSBWrapperObj obj;
void *data;
void *client;
{
MessageObj msg;
int message_id;

   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
      
   switch (message_id) {
      case RtADD_RECEPTOR:
      case RtADD_CONVERSION:
      case RtADD_ID_CONVERSION:
        /* Invoke the superclass method to add a new receptor */
        (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) data, NULL);
        break;
      case RtACTIVATE:
        FSBWActivate (obj);
        break;
      default:
#ifdef DEBUG      
        fprintf (stderr, 
        "FSBWProcessMessage: I don't know how to process this message\n");
#endif
	break;
   }

}

/*
 * create_list_wrapper: create a object wrapper for the list widget
 */
 
static XmListWrapperObj create_list_wrapper (obj)
XmFileSBWrapperObj obj;
{
Widget list_widget;

  if (!obj->widget.widget)
        return;
        
  list_widget = XmFileSelectionBoxGetChild (obj->widget.widget,
                        XmDIALOG_LIST);

  if (!list_widget)
        return;

  if (obj->file_wrapper.list_wrapper)
        return;
        
  obj->file_wrapper.list_wrapper = (XmListWrapperObj) RtCreateObject 
                                  (NULL, xmListWrapperObjClass);
  
  if (!obj->file_wrapper.list_wrapper)
        return;

  
  XtVaSetValues (list_widget, XmNselectionPolicy, 
        obj->file_wrapper.selection_policy, NULL);
  
  RtSetValue (obj->file_wrapper.list_wrapper, RtNwidget, list_widget);  
  /* Release the data (selected items) on the fly */
  RtSetValue (obj->file_wrapper.list_wrapper, RtNxmlwImmediateMode, 1);
  RtRealizeObject (obj->file_wrapper.list_wrapper);
                
}

/*
 * create_text_wrapper: create a object wrapper for the text widget
 */
 
static XmTextWrapperObj create_text_wrapper (obj)
XmFileSBWrapperObj obj;
{
Widget text_widget;

  if (!obj->widget.widget)
        return;
        
  text_widget = XmFileSelectionBoxGetChild (obj->widget.widget,
                        XmDIALOG_TEXT);

  if (!text_widget)
        return;

  if (obj->file_wrapper.text_wrapper)
        return;
        
  obj->file_wrapper.text_wrapper = (XmTextWrapperObj) 
                     RtCreateObject (NULL, xmTextWrapperObjClass);
  
  if (!obj->file_wrapper.text_wrapper)
        return;

  
  RtSetValue (obj->file_wrapper.text_wrapper, RtNwidget, text_widget);  
}

/*
 * extended_file_selection: make the information (list of files) flow from 
 *                          the file list to the selection field in the 
 *                          file selection dialog. Create the object wrappers 
 *                          needed to accomplish this task.
 *                           
 */
 
static void extended_file_selection (obj) 
XmFileSBWrapperObj obj;
{
StringObj add_space, str_concat;

   /* Create the list wrapper */
   create_list_wrapper (obj);

   /* Create the string object used to append a space after the  */
   /* file name                                                  */
   
   add_space = (StringObj) RtCreateObject (NULL, stringObjClass);
   RtSetValue (add_space, RtNstrFormat, "%s "); 
   RtSetValue (add_space, RtNbcNewId, RtSTR_CAT);
   RtRealizeObject (add_space);
   
   /* Create the string object used to concatenate the selected */
   /* Files                                                     */
   
   str_concat= (StringObj) RtCreateObject (NULL, stringObjClass);
   RtRealizeObject (str_concat);
   
   /* Create Text wrapper */
   create_text_wrapper (obj);
   
   if (!obj->file_wrapper.list_wrapper ||
        !obj->file_wrapper.text_wrapper)
        return;
        
   /* Plug objects together */

   RtPlugObjectInto (add_space, obj->file_wrapper.list_wrapper, 0);
   RtPlugObjectInto (str_concat, add_space, 0);
   RtPlugObjectInto (obj->file_wrapper.text_wrapper, str_concat, 0);
    
}
