/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * Library to handle entry forms 
 */

#include "Image.h"

#include <varargs.h>
#include <malloc.h>
#include <errno.h>

void IMInitialize ();
void IMActivate ();
void IMDestroy ();
void IMSetValues ();
void IMCancelButtonCB ();
void IMOkButtonCB ();
void IMHelpButtonCB ();
void IMProcessMessage ();
void IMRealize ();

static RtResource resources[] = {
   {RtNimageX, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(ImageObj,image.x), 0, NULL, 0, NULL},
   {RtNimageY, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(ImageObj,image.y), 0, NULL, 0, NULL},
   {RtNimageWidth, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(ImageObj,image.width), 0, NULL, 0, NULL},
   {RtNimageHeight, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(ImageObj,image.height), 0, NULL, 0, NULL},
   {RtNimageFormat, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(ImageObj,image.format), 0, NULL, 0, NULL},
   {RtNimageOfile, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(ImageObj,image.ofile), 0, NULL, 0, NULL},
   {RtNimage, NULL, RtPOINTER_TYPE, sizeof(XImage *), 
   RtOffset(ImageObj,image.ximage), 0, NULL, 0, NULL}   
};


ImageClassRec imageClassRec = {
  {
    (ObjClass) &objClassRec,	/* superclass		*/
    "Image",			/* class name		*/
    NULL,	
    0,
    resources,			/* resource table	*/
    RtNumber (resources),	/* number of resources  */
    /* object size              */  sizeof(ImageRec),
    IMInitialize,
    IMRealize,
    NULL,
    IMSetValues,
    IMActivate,
    IMDestroy,
    IMProcessMessage,
    "image",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass imageObjClass = (ObjClass) &imageClassRec; 

dump_image_to_file (obj)
ImageObj obj;
{
register int i;
register int j;
short pixel;
FILE *fp = NULL;

   if (obj->image.ofile) {
	fp = fopen (obj->image.ofile, "w");
	if (!fp) {
	   perror (obj->image.ofile);
	   return;
	}	
   } else
	fp = stdout;
   	   
   for (i = 0; i < obj->image.width; i++) {
#ifdef OLD
     for (j = obj->image.height - 1; j >= 0; j--) {
#endif
     for (j = 0; j < obj->image.height; j++) {
	pixel = (short) XGetPixel (obj->image.ximage, i, j);
#ifdef DEBUG
	fprintf (stderr, "%d ", pixel);
#endif 
	fwrite ((char *) &pixel, sizeof (short), 1, fp);
     }
#ifdef DEBUG
     fprintf (stderr, "\n");
#endif
   }

   if (fp != stdout)
   	fclose (fp);   
}

void IMSetValues (current, new)
Obj current, new;
{
}


void IMInitialize (new)
ImageObj new;
{
}

void IMRealize (new)
Obj new;
{
  XImage *ximage;
  
    
}

void IMActivate (new)
Obj new;
{
  ImageObj obj = (ImageObj) new; 
  
}


void IMProcessMessage (obj, message_id, data)
ImageObj obj;
int message_id; /* check - old format */
void *data;
{

   if (!obj)
   	return;

   switch (message_id) {
      case RtIMAGE_GET:
          if (!obj->image.widget || !obj->image.width ||
          	!obj->image.height || !XtIsRealized(obj->image.widget))
          	return;
  	  obj->image.ximage = XGetImage(XtDisplay (obj->image.widget), 
  	    	XtWindow (obj->image.widget),
            	obj->image.x, obj->image.y, obj->image.width, 
            	obj->image.height, AllPlanes,
            	obj->image.format);
	  break;
      case RtIMAGE_PUT:
          if (!obj->image.widget || !obj->image.width ||
          	!obj->image.height || !XtIsRealized(obj->image.widget))
          	return;

  	  obj->image.gc = DefaultGCOfScreen (XtScreen (obj->image.widget));
          XPutImage (XtDisplay(obj->image.widget), 
                XtWindow (obj->image.widget), 
                obj->image.gc, 
          	obj->image.ximage, 0, 0, 0, 0,
          	obj->image.width,
          	obj->image.height);
          break;
      case RtIMAGE_TO_FILE:
	  if (!obj->image.ximage)
	  	return;
	  dump_image_to_file (obj);
          break;
      default:
   	fprintf (stderr, 
   		"Entry Form: I don't know how to process this message\n");
   }
   		   
}


void IMDestroy (obj)
ImageObj obj;
{
   if (obj->image.ximage)
   	XDestroyImage (obj->image.ximage);
   free (obj);    
}
