/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * Core object - All the other objects are a subclass of this one
 */
 
#include "Rt.h"
 
void OBJInitialize ();
void OBJActivate ();
void OBJRealize ();
void OBJDestroy ();
void OBJSetValues ();
void OBJProcessMessage ();
extern void initialize_class ();

static RtResource resources[] = {
   {RtNobjName, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(Obj,core.object_name), 0, NULL, 0, NULL},
   {RtNobjStatus, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(Obj,core.status), 0, NULL, 0, NULL },   
   {RtNobjParent, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(Obj,core.parent_object), 0, NULL, 0, NULL },   
   {RtNobjClass, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(Obj,core.object_class), 0, NULL, 0, NULL },   
   {RtNobjStdin, NULL, RtOBJ_TYPE, sizeof(Obj), 
   RtOffset(Obj,core.obj_stdin), 0, NULL, 0, NULL },   
   {RtNobjStdout, NULL, RtOBJ_TYPE, sizeof(Obj), 
   RtOffset(Obj,core.obj_stdout), 0, NULL, 0, NULL },   
   {RtNobjStderr, NULL, RtOBJ_TYPE, sizeof(Obj), 
   RtOffset(Obj,core.obj_stderr), 0, NULL, 0, NULL },   
   {RtNobjChained, NULL, RtBIT_TYPE, 1, 
   RtOffset(Obj,core.object_flags), 0, NULL, 0, RtOBJ_CHAINED},   
   {RtNobjAutoRealize , NULL, RtBIT_TYPE, 1, 
   RtOffset(Obj,core.object_flags), 0, NULL, 0, RtOBJ_AUTO_REALIZE},   
   {RtNobjRealized , NULL, RtBIT_TYPE, 1, 
   RtOffset(Obj,core.object_flags), 0, NULL, 0, RtOBJ_REALIZED},   
   {RtNobjOutput, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(Obj,core.obj_output), 0, NULL, 0, NULL},
};
	
ObjClassRec objClassRec = {
  {
    NULL,			/* superclass			*/
    "Core",			/* class name			*/
    NULL,	
    0,
    resources,			/* resource table		*/
    RtNumber(resources),	/* number of resources  	*/
    sizeof(ObjRec),		/* object size              	*/
    OBJInitialize,
    OBJRealize,
    NULL,
    OBJSetValues,
    OBJActivate,
    OBJDestroy,
    OBJProcessMessage,
    "obj",
    "Rt1.00",
    NULL
  }
};

ObjClass objClass = (ObjClass) &objClassRec; 

/*
 * OBJSetValues: set object resources
 */
 
void OBJSetValues (current, new)
Obj current, new;
{
   /* Check - This should be done by the superclass */
   
   if (current->core.object_name != new->core.object_name)
        RtUpdateString (current->core.object_name, 
        	new->core.object_name);
}


/*
 * OBJInitialize: initialize object
 */

void OBJInitialize (obj)
Obj obj;
{
#ifdef DEBUG
   obj->core.object_name = strdup ("Core Object");
#endif
}

/*
 * BCActivate: activate object
 */
 
void OBJActivate (obj)
Obj obj;
{
}


/*
 * BCRealize: realize object
 */
 
void OBJRealize (obj)
Obj obj;
{
}


/*
 * BCDestroy: destroy object
 */
 
void OBJDestroy (obj)
Obj obj;
{
RtLinksTbl rlinks;

   RtDestroyString (obj->core.object_name);
   if (rlinks = obj->core.rlinks) {
	free (rlinks->rlink_list);
	free (rlinks); 
	obj->core.rlinks = NULL; 
   }
   
}

void OBJProcessMessage (obj, data, client)
Obj obj;
void *data;
char *client;
{
MessageObj msg;
char *content;
int flags;
int message_id;
char *value = NULL;
char *msg_client;
int status;

   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
   RtGetValue (msg, RtNmsgContent, &content);   
   RtGetValue (msg, RtNmsgFlags, &flags);   
   
   /* ignore the function paramenter  		*/
   /* get the client info from the message 	*/
   RtGetValue (msg, RtNmsgClient, &msg_client); 

   switch (message_id) {
      case RtSET_VALUE:
         RtSetValue (obj, content, msg_client);
         break;
      case RtDESTROY:
         RtDestroyObject (obj);
         break;
      case RtMATCH:
         if (!content || !msg_client) {
            obj->core.status = RtINVALID_PARAMETERS;
            return;
         }
         RtGetValue (obj, content, &value);
	 /* careful - this only works for strings */
	 if (!value) {
	   obj->core.status = RtINVALID_RESOURCES;
	   return;
	 }
	   
	 status = strcmp (msg_client, value);
	 if (status == 0)
	 	obj->core.status = 0;
	 else if (status > 0)
	 	obj->core.status = RtGREATER_THAN;
	 else
	 	obj->core.status = RtLESS_THAN;
      default:
#ifdef DEBUG
   	fprintf (stderr, 
   	"OBJProcessMessage: I don't know how to process this message\n");
#endif
        break;
   }
}


/*
 * cmp_res_name: compare resource names
 */
static int cmp_res_name (item, item1)
char *item, *item1;
{
   RtResource *res = (RtResource *) item;
   RtResource *res1 = (RtResource *) item1;
   
   if (!res && !res1)
   	return (0);
   
   if (!res)
   	return (-1);
   	
   if (!res1) 
   	return (1);
   	
   return (strcmp (res->name, res1->name));
}

 
/*
 * initialize_class: Initialize class 
 */
 
void initialize_class (class)
ObjClass class;
{
 ObjClass superclass;
   if (!class || class->core_class.class_inited)   
	return;

   if (!class->core_class.resources)
   	return;

   /* sort the resource table for fast access */
   
   qsort (class->core_class.resources,
   	class->core_class.num_resources,
   	sizeof (RtResource),
   	cmp_res_name);
   
   class->core_class.class_inited++; 
   
   /* attempt to initialize superclass */
   initialize_class (class->core_class.superclass);
   
}
