#include "SignalHandler.h"

void SHInitialize ();
void SHActivate ();
void SHRealize ();
void SHDestroy ();
void SHSetValues ();
void SHProcessMessages ();

static RtResource resources[] = {
   {RtNsigMask, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(SignalHandlerObj, signal.signal_mask), 0, NULL, 0, NULL},
   {RtNsigCurrent, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(SignalHandlerObj, signal.current_signal), 0, NULL, 0, NULL},
   {RtNsigIsPending, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(SignalHandlerObj, signal.is_pending), 0, NULL, 0, NULL},
};


SignalHandlerClassRec signalHandlerClassRec = {
  {
    (ObjClass) &messageClassRec,/* superclass		*/
    "Signal Handler",		/* class name		*/
    NULL,	
    0,
    resources,			/* resource table	*/
    RtNumber(resources),	/* number of resources  */
    /* widget_size              */  sizeof(SignalHandlerRec),
    SHInitialize,
    SHRealize,
    NULL,
    SHSetValues,
    SHActivate,
    SHDestroy,
    SHProcessMessages,
    "sig",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass signalHandlerObjClass = (ObjClass) &signalHandlerClassRec; 

void SHSetValues (current, new)
SignalHandlerObj current, new;
{
}


void SHInitialize (new)
SignalHandlerObj new;
{
   sigemptyset (&new->signal.signal_mask);
}


void SHRealize (new)
SignalHandlerObj new;
{
}


void SHDestroy (obj)
SignalHandlerObj obj;
{
}

void SHActivate (obj)
SignalHandlerObj obj;
{
}

void SHProcessMessages (obj, data, client)
SignalHandlerObj obj;
void *data;
void *client;
{
MessageObj msg;
int message_id;
char *content;
int flags;
struct sigaction ignore;

   
   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
   RtGetValue (msg, RtNmsgContent, &content);   
   RtGetValue (msg, RtNmsgFlags, &flags);   
   
   /* ignore the function paramenter  		*/
   /* get the client info from the message 	*/
   RtGetValue (msg, RtNmsgClient, &client); 

   switch (message_id) {
      case RtSIG_ADD_SET:
        if (!content)
           return;
        if (sigaddset (&obj->signal.signal_mask, (int) content) < 0)
           perror ("sigaddset");
        break;
      case RtSIG_BLOCK:
        if (content)
           sigaddset (&obj->signal.signal_mask, (int) content);
        if (sigprocmask (SIG_BLOCK, &obj->signal.signal_mask, 
                &obj->signal.old_mask) < 0) {
           perror ("sigprocmask");
           return;
        }
        break;
      case RtSIG_MASK_RESTORE:
        if (sigprocmask (SIG_SETMASK, &obj->signal.old_mask, 
                NULL) < 0) {
           perror ("sigprocmask");
           return;
        } 
        break;       
      case RtSIG_PENDING:
        sigpending (&obj->signal.pending_mask);
        if (!content && !obj->signal.current_signal)
          return;
                
        if (content)
          obj->signal.current_signal = (int) content;
            
        obj->signal.is_pending = sigismember (&obj->signal.pending_mask,
                                            obj->signal.current_signal);
        break;
      case RtSIG_IGNORE:
        if ((int) content >= RtMAX_SIGNAL || (int) content < 0)
           return;
        ignore.sa_handler = SIG_IGN;
        sigemptyset (&ignore.sa_mask);
        ignore.sa_flags = 0;
        if (sigaction ((int) content, &ignore, 
        	&obj->signal.signal_table[(int) content]) < 0)
           perror ("sigaction");           
	break;
      case RtSIG_RESTORE:
        if ((int) content >= RtMAX_SIGNAL || (int) content < 0)
           return;
	sigaction ((int) content, &obj->signal.signal_table[(int) content],
		NULL);
	break;        
      default:
#ifdef DEBUG
        fprintf (stderr,
           "Signal_Handler: unknown message ID, I don't know how to process this message\n");
#endif
	RtSuperclassProcessMessage (signalHandlerObjClass,
		obj, data, client); 
   }
}

