#include "String.h"

void STRInitialize ();
void STRActivate ();
void STRRealize ();
void STRDestroy ();
void STRSetValues ();
void STRProcessMessage ();
static char *get_current_format ();
static char *_strconcat ();
static void reset_string ();
static int compare_strings ();
static int concatenate_string ();
static int get_tokens ();
static void get_n_token ();

static RtResource resources[] = {
   {RtNstrString1, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(StringObj, string.string1), 0, NULL, 0, NULL},
   {RtNstrString2, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(StringObj, string.string2), 0, NULL, 0, NULL},
   {RtNstrFormat, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(StringObj, string.format), 0, NULL, 0, NULL}
};


StringClassRec stringClassRec = {
  {
    (ObjClass) &broadCasterClassRec, /* superclass		*/
    "String",			/* class name		*/
    NULL,	
    0,
    resources,			/* resource table	*/
    RtNumber (resources),	/* number of resources  */
    /* object size              */  sizeof(StringRec),
    STRInitialize,
    STRRealize,
    NULL,
    STRSetValues,
    STRActivate,
    STRDestroy,
    STRProcessMessage,
    "str",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass stringObjClass = (ObjClass) &stringClassRec; 

void STRSetValues (current, new)
StringObj current, new;
{
   /* Check - This should be done by the superclass */
   
   if (current->core.object_name != new->core.object_name)
        RtUpdateString (current->core.object_name, new->core.object_name);
}


void STRInitialize (obj)
StringObj obj;
{
}

void STRActivate (new)
StringObj new;
{
}


void STRRealize (obj)
StringObj obj;
{
    obj->string.rem_format = obj->string.format;
#ifdef OLD
    if (!obj->core.object_name)
        obj->core.object_name = strdup ("String Object");
#endif
}


void STRDestroy (obj)
StringObj obj;
{
}

static void release_sdata (obj)
StringObj obj;
{
   /* broadcast output */             
   RtSetValue (obj, RtNmsgId, RtMESSAGE);
   RtSetValue (obj, RtNmsgContent, obj->string.output);
        
   /* Invoke the superclass method to broadcast the output */
   (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);
                        
   reset_string (obj);
}

void STRProcessMessage (obj, data, client)
StringObj obj;
void *data;
void *client;
{
MessageObj msg;
char *content, *content1;
char *tmp, *tmp1;
int  flags;     /* message flags */
int message_id;

#ifdef OLD
   if (obj->core.status) {      /* An error has been detected. */
        return;                 /* Stop working until reset    */   
   }
#endif
   
   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
   RtGetValue (msg, RtNmsgContent, &content);   
   RtGetValue (msg, RtNmsgFlags, &flags);
   RtGetValue (msg, RtNmsgClient, &client);   

   switch (message_id) {
      case RtSET_STRING1:
          if (!content)
                return;
                
          RtSetValue (obj, RtNstrString1, content);        

          if (!(flags&RtMSG_ACTIVATE_OBJECT))
                return;
                
          compare_strings (obj);

          /* Invoke the superclass method to broadcast the message */
          (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);
                    
          break;
      case RtSET_STRING2:
          if (!content)
                return;
                
          RtSetValue (obj, RtNstrString2, content);        

          if (!(flags&RtMSG_ACTIVATE_OBJECT))
                return;
                
          compare_strings (obj);

          /* Invoke the superclass method to broadcast the message */
          (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);
                    
          break;
      case RtSTR_TOK: /* Split a string  */
           if (!obj->string.string1 || !content)
                return;                 
           get_tokens (obj, content);
           break;
      case RtSTR_SUB_STRING:
           if (!obj->string.string1 || !content || !client)
                return;                 
 	   get_n_token (obj, content, (int) client);     
      	   break;
#ifdef OLD
      case RtSTR_TOK_CNT:
           if (!obj->string.string1 || !content)
                return;
           token_cnt (obj, content);                
           break;
#endif
      case RtSTR_CAT: /* Concatenate to string1 */
                      /* Broadcast result after receiving a null */
           if (content)
                concatenate_string (obj, content);

           if (content && (!flags&RtMSG_ACTIVATE_OBJECT))
                return;
                
           /* broadcast output */             
           RtSetValue (obj, RtNmsgId, RtMESSAGE);
           RtSetValue (obj, RtNmsgContent, obj->string.output);
        
           /* Invoke the superclass method to broadcast the output */
           (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);
                        
           reset_string (obj);
          
          break;  
      case RtSTR_CMP: /* Change this */
          compare_strings (obj);

          /* Invoke the superclass method to broadcast the message */
          (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);
                    
        break;
      case RtADD_RECEPTOR:
        /* Invoke the superclass method to add a new receptor */
        (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) data, NULL);
        break;
      case RtRESET: /* reset object */
        obj->broadcaster.reset = (int) content;
        if ((int) content)
           reset_string (obj);
        break;
      case RtRELEASE_DATA:      /* Release the content of the string object */
        release_sdata (obj);
        break;   
      case RtMESSAGE:
         if (!content || (flags&RtMSG_ACTIVATE_OBJECT)) {
           /* broadcast output */             
           RtSetValue (obj, RtNmsgId, RtMESSAGE);
           RtSetValue (obj, RtNmsgContent, obj->string.output);
        
           /* Invoke the superclass method to broadcast the output */
           (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);
                        
#ifdef DEBUG
           fprintf (stderr, "STRProcessMessage: %s\n", obj->string.output);
#endif
           reset_string (obj);
           return;
         }
         if (!obj->string.format) {
           if (obj->string.output) {
              free (obj->string.output);
           }
           if (content)
              obj->string.output = strdup (content);
           else
              obj->string.output = NULL;
#ifdef DEBUG
           fprintf (stderr, "STRProcessMessage(RtMESSAGE): %s\n", obj->string.output);
#endif
           return;                               
         
         }
         
         if (obj->string.format) {
           
           /* create big string */
           tmp = malloc (sizeof (char) * RtSTR_LARGE_SIZE);
           
           if (!tmp) {
             obj->core.status = 1;
             return;
           }
             
           /* Get the next format component */
           obj->string.current_format = get_current_format (obj);
           if (!obj->string.current_format &&
                        !obj->string.done) {
             obj->core.status = 1; /* something went wrong */
             free (tmp);
             return;
           }
           
           sprintf (tmp, obj->string.current_format, content);
           free (obj->string.current_format);
           obj->string.current_format = NULL;
           
           /* concatenate tmp with previous stuff */
           tmp1 = _strconcat (obj->string.output, tmp);
           free (tmp);
           
           if (!tmp1)
              obj->core.status = 1; /* something went wrong */

           if (obj->string.output) {
              free (obj->string.output);
              obj->string.output = NULL;
           }
              
           obj->string.output = tmp1;
           if (!obj->string.done)
              return;
#ifdef DEBUG
           fprintf (stderr, "STRProcessMessage: %s\n", obj->string.output);
#endif
           
           /* broadcast output */             
           RtSetValue (obj, RtNmsgId, RtMESSAGE);
           RtSetValue (obj, RtNmsgContent, obj->string.output);
        
           /* Invoke the superclass method to broadcast the output */
           (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);
                        
           reset_string (obj);
         }              
         break;
      default:
#ifdef OLD
        fprintf (stderr, 
           "STRProcessMessage (%d): I don't know how to process this message\n",
           message_id);
#endif
	RtSuperclassProcessMessage (stringObjClass, obj, data, 
		client);
   }
   

}

/*
 * reset_string: reset string object
 */
 
static void reset_string (obj)
StringObj obj;
{

   /* reset object */
   obj->core.status = 0;
   obj->string.rem_format = obj->string.format;
   obj->string.reset = 0;
   if (obj->string.current_format) {
      free (obj->string.current_format);
      obj->string.current_format = NULL;
   }
   if (obj->string.output) {
      free (obj->string.output);
      obj->string.output = NULL;
   }
   obj->string.done = 0;      
}


static char *get_current_format (obj)
StringObj obj;
{

char *c;
int len = 0;
char *fp;

        if (!obj->string.rem_format)
           return (NULL);         

        fp = obj->string.rem_format;

        /* Look for the first format specification */

        c = strchr (fp, '%');

        if (!c) {
           obj->string.done = 1;
           c = obj->string.rem_format;
           obj->string.rem_format = NULL;
           return (strdup(c));
        }
      
retry:
        /* Look for the next format specification */
        fp = ++c;
        c = strchr (fp, '%');

        if (!c) { /* only one format specification remaining */
           obj->string.done = 1;
           c = obj->string.rem_format;
           obj->string.rem_format = NULL;
           return (strdup(c));
        }

        /* There might be a second one */ 
        if (c == fp) {   /* %% found */
           goto retry;   /* retry again */
        }
        
        c--;
        
        /* Allocate memory for current_format */
        
        len = c-obj->string.rem_format+1;
        obj->string.current_format = 
           (char *) malloc (len+1 * sizeof (char));
        if (!obj->string.current_format) {
           obj->core.status = 1;
           return (NULL);
        }
        memcpy (obj->string.current_format,
                obj->string.rem_format, len);
        obj->string.current_format[len] = '\0';
                        
        obj->string.rem_format = c+1; /* remaining format */
        
        return (obj->string.current_format);
}

/*
 * _strconcat: concatenate two strings (improved version)
 */

static char *_strconcat (s1, s2)
char *s1, *s2;
{
   register char *result, *sp;
   register int length = 0;
   static int charsize = sizeof (char);

   if (s1)
        length += strlen (s1);

   if (s2)
        length += strlen (s2);

   if (!length) {
        return (NULL);
   }

   if (!(result = (char *) malloc ((length+1) * charsize))) {
        return (NULL);
   }

   *result = '\0';
   sp = result;

   if (s1) {
        strcpy (sp, s1);
        sp += strlen (s1);
   }    

   if (s2) {
        strcpy (sp, s2);
   }
   return (result);
}

static int compare_strings (obj)
StringObj obj;
{
   obj->message.id = RtMESSAGE;
   obj->message.type = RtMSG_INT;
   if (!obj->string.string1 && !obj->string.string2) { 
        obj->message.content = (char *) 0;
   } else if (!obj->string.string1) {
        obj->message.content = (char *) -1;
   } else if (!obj->string.string2) {
        obj->message.content = (char *) 1;
   } else
        obj->message.content = (char *) strcmp (obj->string.string1,
                obj->string.string2);
}               

static int concatenate_string (obj, string)
StringObj obj;
char *string;
{

   char *tmp;
   
   if (!string)
        return;
           
   tmp = _strconcat (obj->string.output, string);    

   if (obj->string.output)
        free (obj->string.output);
   obj->string.output = tmp;
#ifdef DEBUG
   fprintf (stderr, "concatenate_string: %s\n", obj->string.output);
#endif
   
}

/*
 * get_n_token: get the n-th token
 */
 
static void  get_n_token (obj, string, n)
StringObj obj;
char *string;
int n;
{
char *tmp;
char *tmp1;
char *cp;
int len;
register int i = 0;

   if (!string)
      return;
      
   cp = tmp1 = strdup (string);
   
   if (!tmp1)
        return;
        
   
   len = strlen (tmp1); 
      
   tmp = strtok (tmp1, obj->string.string1);

   while (tmp) {
        /* broadcast substrings */            
        RtSetValue (obj, RtNmsgId, RtMESSAGE);
        RtSetValue (obj, RtNmsgContent, tmp);
        
        if (++i == n) {
           /* Invoke the superclass method to broadcast the output */
           (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);
           free (tmp1);
           return;
        }
                        
#ifdef OLD        
        tmp = strtok (NULL, " "); /* static data */
#endif
        cp += (strlen (tmp) + 1);
        
        if (cp - tmp1 > len)
                break;
                
        tmp = strtok (cp, obj->string.string1); /* static data */
        
#ifdef DEBUG
        fprintf (stderr, "get_tokens: %s\n", tmp);
#endif

   }
   
   free (tmp1);
}


static int  get_tokens (obj, string)
StringObj obj;
char *string;
{
char *tmp;
char *tmp1;
char *cp;
int len;

   if (!string)
      return;
      
   cp = tmp1 = strdup (string);
   
   if (!tmp1)
        return;
        
   
   len = strlen (tmp1); 
      
   tmp = strtok (tmp1, obj->string.string1);

   while (tmp) {
        /* broadcast substrings */            
        RtSetValue (obj, RtNmsgId, RtMESSAGE);
        RtSetValue (obj, RtNmsgContent, tmp);
        
        /* Invoke the superclass method to broadcast the output */
        (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);
                        
#ifdef OLD        
        tmp = strtok (NULL, " "); /* static data */
#endif
        cp += (strlen (tmp) + 1);
        
        if (cp - tmp1 > len)
                break;
                
        tmp = strtok (cp, " "); /* static data */
        
#ifdef DEBUG
        fprintf (stderr, "get_tokens: %s\n", tmp);
#endif

   }
   
   /* Broadcast a NULL */
   RtSetValue (obj, RtNmsgId, RtMESSAGE);
   RtSetValue (obj, RtNmsgContent, NULL);
   /* Invoke the superclass method to broadcast the output */
   (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);
   free (tmp1);
}


static int  token_cnt (obj, string)
StringObj obj;
char *string;
{
char *tmp;
char *tmp1;
char *cp;
int cnt = 0;

   if (!string)
      return;
      
   cp = tmp1 = strdup (string);
   
   if (!tmp1)
        return;
        
   tmp = strtok (tmp1, obj->string.string1);

   while (tmp) {
        cnt++;
                        
        tmp = strtok (NULL, " "); /* static data */
        
#ifdef DEBUG
        fprintf (stderr, "get_tokens: %s\n", tmp);
#endif
   }
   
   /* Broadcast a NULL */
   RtSetValue (obj, RtNmsgId, RtMESSAGE);
   RtSetValue (obj, RtNmsgContent, cnt);
   RtSetValue (obj, RtNmsgType, RtMSG_INT);
   
   /* Invoke the superclass method to broadcast the output */
   (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);
   free (tmp1);
}
