/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * XmText wrapper object
 */
 
#include "TextWrapper.h"

void TEXTWInitialize ();
void TEXTWActivate ();
int TEXTWRealize ();
void TEXTWDestroy ();
void TEXTWSetValues ();
void TEXTWGetValues ();
void TEXTWProcessMessage ();
static void verify_value ();

static RtResource resources[] = {
   {RtNtextValue, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(RtWidgetObj,widget.widget), 0, NULL, 
   RtInvokeClassGetValue | RtWidgetXtResource, 
   XmNvalue},
   {RtNtextMonitor, NULL, RtBIT_TYPE, 1, 
   RtOffset(XmTextWrapperObj,text_wrapper.flags), 0, NULL,
   0, RtXMTW_MONITOR},   
};

XmTextWrapperClassRec xmTextWrapperClassRec = {
  {
    (ObjClass) &rtWidgetClassRec,/* superclass		*/
    "Text",			/* class name		*/
    NULL,	
    0,
    resources,			/* resource table	*/
    RtNumber (resources),	/* number of resources  */
    /* object size              */  sizeof(XmTextWrapperRec),
    TEXTWInitialize,
    TEXTWRealize,
    TEXTWGetValues,
    TEXTWSetValues,
    TEXTWActivate,
    TEXTWDestroy,
    TEXTWProcessMessage,
    "text",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass xmTextWrapperObjClass = (ObjClass) &xmTextWrapperClassRec; 


/*
 * TEXTWGetValues: get object resources
 */
void TEXTWGetValues (obj, res, value_pointer)
XmTextWrapperObj obj;
char *res;
void **value_pointer;
{
char **str_ptr;
RtResource *resources;
char *str = NULL;


   if (!obj->widget.widget || !res || !value_pointer)
   	return;

   resources = RtLocateClassResource (xmTextWrapperObjClass, res);
   
   if (!resources->client)
   	return;
   
   XtVaGetValues (obj->widget.widget,
			(char *) resources->client, &str, NULL);

   str_ptr = (char **) value_pointer;
   *str_ptr = str;
   
   /* careful - this can cause problems */
   if (obj->text_wrapper.saved_value) {
        /* careful - XtFree is not used */
	free (obj->text_wrapper.saved_value);
   }
   obj->text_wrapper.saved_value = str;	   
}

/*
 * TEXTWSetValues: set object resources
 */
 
void TEXTWSetValues (current, new)
XmTextWrapperObj current, new;
{
   RtUpdateString (current->core.object_name, new->core.object_name);
}

/*
 * TEXTWInitialize: initialize object
 */
 
void TEXTWInitialize (obj)
XmTextWrapperObj obj;
{
#ifdef DEBUG
   obj->core.object_name = strdup ("TextWrapper");
#endif
}

/*
 * TEXTWActivate: activate object
 */
 
void TEXTWActivate (obj)
XmTextWrapperObj obj;
{
}


/*
 * TEXTWRealize: realize object
 */
 

int TEXTWRealize (obj)
XmTextWrapperObj obj;
{
Widget widget = obj->widget.widget;

   if (widget && (obj->text_wrapper.flags & RtXMTW_MONITOR)) {
        XtAddCallback (widget, XmNvalueChangedCallback, 
        	verify_value, obj);
   } 
}

/*
 * TEXTWDestroy: destroy object
 */

void TEXTWDestroy (obj)
XmTextWrapperObj obj;
{
   /* destroy the broadcaster portion of the object */
   (*broadCasterObjClass->core_class.destroy) (obj);

   /* destroy core portion of the object */
   RtDestroyString (obj->core.object_name);   

   /* free the object itself */
   if (obj->core.object_class == xmTextWrapperObjClass)
      free (obj);   
}

/*
 * TEXTWProcessMessage: process object messages
 */
 
void TEXTWProcessMessage (obj, data, client)
XmTextWrapperObj obj;
void *data;
void *client;
{
MessageObj msg;
char *content;
int message_id;
char *tmp;

   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
      
   switch (message_id) {
      case RtXMTW_CLEAR:
      case RtCLEAR:
        if (!obj->widget.widget)
           return;
#ifdef OLD
        XmTextSetString (obj->widget.widget, "");
#endif        
        RtSetValue (obj, RtNtextValue, "");
        break;
      case RtWIDGET_SET_XT_RESOURCE:
        if (!obj->widget.widget)
           return;
        RtGetValue (msg, RtNmsgClient, &content);        
        XmTextSetString (obj->widget.widget, content);
        tmp = obj->text_wrapper.saved_value;
        obj->text_wrapper.saved_value = 
           	(content?strdup (content):NULL);
        if (tmp)
           free (tmp);
	break;
      case RtXMTW_SAVE:
	/* Invoke Rt to ensure among other things that the */
	/* resource links are followed. A RtWIDGET_SET_XT_RESOURCE */
	/* message will be sent to this object. 		   */        
        content = XmTextGetString(obj->widget.widget);
        RtSetValue (obj, RtNtextValue, content);
        XtFree (content);
	break;
      case RtXMTW_RESTORE:
	/* Invoke Rt to ensure among other things that the */
	/* resource links are followed. A RtWIDGET_SET_XT_RESOURCE */
	/* message will be sent to this object. 		   */
	if (obj->text_wrapper.saved_value)        
        	RtSetValue (obj, RtNtextValue, 
        		obj->text_wrapper.saved_value);
	break;
      case RtMESSAGE:   /* default message - load the widget */
        RtGetValue (msg, RtNmsgContent, &content);
        if (!content || !obj->widget.widget)
           return;
#ifdef OLD              
        XmTextSetString (obj->widget.widget, content);
#endif
	/* Invoke Rt to ensure among other things that the */
	/* resource links are followed. A RtWIDGET_SET_XT_RESOURCE */
	/* message will be sent to this object. 		   */
	 
        RtSetValue (obj, RtNtextValue, content);
        break;      
      case RtADD_RECEPTOR:
      case RtRESET: /* reset object */
        /* Invoke the superclass method to add a new receptor */
        (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) data, NULL);
        break;
      case RtXMTW_APPEND: {
        XmTextPosition last;
        
           RtGetValue (msg, RtNmsgContent, &content);
           if (!content || !obj->widget.widget)
                return; 
           last = XmTextGetLastPosition (obj->widget.widget);
           XmTextReplace (obj->widget.widget, last, last, content);
        } 
        break;     
      case RtRELEASE_DATA:      /* Broadcast data */
        RtSetValue (obj, RtNmsgId, RtMESSAGE); /* For now */
        
        if (!obj->widget.widget)
            return;
        content = XmTextGetString(obj->widget.widget);
#ifdef DEBUG
        fprintf (stderr, "TEXTWProcessMessage: release data %s\n", content);
#endif  
        if (!content)
           return;              
        RtSetValue (obj, RtNmsgContent, content);
        /* Invoke the superclass method to broadcast the message */
        (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);
        XtFree (content);                
        break;
      case RtWIDGET_POPUP: /* check */
      case RtWIDGET_POPDOWN:
        /* Invoke the superclass method  */
        (*rtWidgetObjClass->core_class.process_message) (obj, 
                        (char *) data, NULL);
        break;
      default:
#ifdef DEBUG      
        fprintf (stderr, 
        "TEXTWProcessMessage: I don't know how to process this message\n");
#endif
        RtSuperclassProcessMessage (xmTextWrapperObjClass,
        	obj, data, client);
	break;
   }
}

static void verify_value (widget, client_data, cbs)
Widget widget;
XtPointer client_data;
XmTextVerifyCallbackStruct *cbs;
{
XmTextWrapperObj obj = (XmTextWrapperObj) client_data;
char *content;

   if (!obj)
     return;

   if (!cbs->event)
     return;
     
   RtSetValue (obj, RtNmsgId, RtMESSAGE);
   content = XmTextGetString(obj->widget.widget);
   RtSetValue (obj, RtNmsgContent, content);
   
   /* Invoke the superclass method to broadcast the message */
   (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);
   XtFree (content);  
}
