/*
 * Freedom Desktop 
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * Widget - Widget superclass
 */
  
#include "Widget.h"

void RTWInitialize ();
void RTWActivate ();
void RTWRealize ();
void RTWDestroy ();
void RTWSetValues ();
void RTWProcessMessage ();

static Widget locate_shell ();

static RtResource resources[] = {
   {RtNwidgetParent, NULL, RtPOINTER_TYPE, sizeof(Widget), 
   RtOffset(RtWidgetObj,widget.parent), 0, NULL, 0, NULL},
   {RtNwidget, NULL, RtPOINTER_TYPE, sizeof(Widget), 
   RtOffset(RtWidgetObj,widget.widget), 0, NULL, 0, NULL},
   {RtNwidgetCreate, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(RtWidgetObj,widget.create_widget), 0, NULL, 0, NULL},
   {RtNwidgetSynchronous, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(RtWidgetObj,widget.synchronous), 0, NULL, 0, NULL},
   {RtNwidgetTitle, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(RtWidgetObj,widget.title), 0, NULL, 0, NULL},
   {RtNwidgetX, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(RtWidgetObj,widget.x), 0, NULL, 0, NULL},
   {RtNwidgetY, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(RtWidgetObj,widget.y), 0, NULL, 0, NULL},
   {RtNwidgetWidth, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(RtWidgetObj,widget.width), 0, NULL, 0, NULL},
   {RtNwidgetHeight, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(RtWidgetObj,widget.height), 0, NULL, 0, NULL},
};
	
RtWidgetClassRec rtWidgetClassRec = {
  {
    (ObjClass) &containerClassRec,
    "Widget",
    NULL,
    0,
    resources,
    RtNumber (resources),
    /* object size              */  sizeof(RtWidgetRec),
    RTWInitialize,
    RTWRealize,
    NULL,
    RTWSetValues,
    RTWActivate,
    RTWDestroy,
    RTWProcessMessage,
    "widget",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass rtWidgetObjClass = (ObjClass) &rtWidgetClassRec; 

/*
 * RTWSetValues: set object values
 */
 
void RTWSetValues (current, new)
RtWidgetObj current, new;
{
}

/*
 * RTWInitialize: initialize object
 */
 
void RTWInitialize (new)
RtWidgetObj new;
{
}


/*
 * RTWActivate: activate object
 */
 
void RTWActivate (new)
RtWidgetObj new;
{
}



/*
 * RTWRealize: realize object
 */
 
void RTWRealize (obj)
RtWidgetObj obj;
{

Widget dialog_shell;
extern Widget _XmCLocateShell ();
   
   if (!obj->widget.widget)
	return;

   dialog_shell = _XmCLocateShell (obj->widget.widget);

   if (!dialog_shell)
	return;

   if (obj->widget.title)
           XtVaSetValues (dialog_shell, 
           	XtNtitle, obj->widget.title, NULL);
   
}

/*
 * RTWDestroy: destroy object
 */
 
void RTWDestroy (obj)
RtWidgetObj obj;
{
}


/*
 * RTWProcessMessage: process object messages
 */
 
void RTWProcessMessage (obj, data, client)
RtWidgetObj obj;
void *data;
void *client;
{
MessageObj msg;
int message_id;
Widget shell;
Widget widget;
extern Widget _XmCLocateShell ();
char *content;

   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
      
   switch (message_id) {
      case RtWIDGET_POPUP: /* popup widget */
        widget = obj->widget.widget;
        
        if (!widget)
           return;

        /* locate the shell */
        shell = _XmCLocateShell (widget);
        if (!shell)
           return;

        XtManageChild (widget); /* check */
        XtPopup (shell, XtGrabNone);
        XRaiseWindow (XtDisplay(shell), XtWindow (shell));        
        break;
      case RtWIDGET_POPDOWN: /* popdown widget */
        shell = _XmCLocateShell (obj->widget.widget);
        if (!shell)
           return;
        XtPopdown (shell);      
        break;
      case RtWIDGET_SET_SENSITIVE:
   	RtGetValue (msg, RtNmsgContent, &content); 
	if ((int) content)
	   XtSetSensitive (obj->widget.widget, True);
	else
	   XtSetSensitive (obj->widget.widget, False);
	   	  
        break;
      case RtWIDGET_MANAGE:
        if (obj->widget.widget)
           XtManageChild (obj->widget.widget);
        break;
      case RtWIDGET_UNMANAGE:
        if (obj->widget.widget)
           XtUnmanageChild (obj->widget.widget);
        break;
      default:
        RtSuperclassProcessMessage (rtWidgetObjClass,
        	obj, data, client);
        break;
   }

}

