
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * Library to handle entry forms
 */

#include <stdio.h>
#include <Xm/Label.h>
#include <Xm/SashP.h>
#include <Xm/DialogS.h>
#include "X.h"
#include <Xm/Protocols.h>

/*
 * XLabelGetString: get label string 
 */

char *XLabelGetString(label) 
  Widget label;
{
  XmString XmStr;
  char *str;

   XtVaGetValues (label, XmNlabelString, &XmStr, NULL); 
   if (!XmStringGetLtoR (XmStr, XmSTRING_DEFAULT_CHARSET, &str)) {
	fprintf (stderr, "XLabelGetString: Can't get value, Possibly wrong charset?"); 
	return (NULL);
   }
   return (str);
}

/*
 * _XtCautoDestroyCB: Autodestroy callback
 */

void _XtCautoDestroyCB(w, client_data, call_data) 
Widget w;
XtPointer client_data, call_data;
{
	XtDestroyWidget(w);
}


/*
 * locateShell: locate shell widget
 */

Widget locateShell (widget)
Widget widget;
{
   if (!widget)
	return (NULL);

   while (widget) {
	if (XtIsShell (widget) || XmIsDialogShell (widget))
   	   return (widget);

	widget = XtParent (widget);

   }
   return (NULL);
}

/*
 * _XmCLocateShell: locate the shell
 */
  
_XmCLocateShell (widget)
Widget widget;
{
   if (!widget)
	return (NULL);

   while (widget) {
	if (XtIsShell (widget))
   	   return (widget);

	widget = XtParent (widget);

   }
   return (NULL);
}

/*
 * _XCsetIconEnterLeaveHandler: Install enter/Leave window event handler
 */

_XCsetIconEnterLeaveHandler (shell)
Widget shell;
{
   Window window;

   XtVaGetValues (shell, XmNiconWindow, &window, NULL);
   if (!window) {
	fprintf (stderr, 
        "_XCSetIconEnterLeaveHandler: there is no window associated with the shell\n");
	return;	
   }
   XSelectInput (XtDisplay(shell), window, EnterWindowMask | LeaveWindowMask);
	
}

/*
 * _XCreadInput: read data from fd
 */

char *_XCreadInput (fd)
int fd;
{
  static char buf[BUFSIZ];
  int        nbytes, i;

  nbytes = read(fd, buf, BUFSIZ-1); 

  if (nbytes == -1)
	perror ("_XCreadInput");
  
  if (nbytes > 0) {
	buf[nbytes] = '\0';
	return (buf);
  } else
	return (NULL);

}


/*
 * _XmCtextInsert: insert text in text widget
 */

_XmCtextInsert (text_widget, buf)
     Widget   text_widget;
     char    *buf;
{
  int pos = XmTextGetInsertionPosition(text_widget);
  XmTextReplace(text_widget, pos, pos, buf);
}


/*
 * _XCgetFromCmd: read from command and insert in text widget
 */

char *_XCgetFromCmd (w, fid, id)
Widget w;
int *fid;
XtInputId *id;
{

  char *buf;

  buf = _XCreadInput (*fid);

  if (!buf || !*buf)
	return; 

  _XmCtextInsert (w, buf);
}

/*
 * _XmCTurnOffSashTraversal: turn off sash tarversal
 */

void 
_XmCTurnOffSashTraversal (pane)
Widget pane;
{
   Widget *children;
   int num_children;

   XtVaGetValues (pane,
	XmNchildren, &children,
	XmNnumChildren, &num_children,
	NULL);
   while (num_children-- > 0)
	if (XmIsSash (children[num_children])) {
	   XtVaSetValues (children[num_children], XmNtraversalOn, False, NULL);
#ifdef DEBUG
	   fprintf (stderr, "sash\n");
#endif
	}
}

/*
 * _XmCSetShellPixmap: Set shell pixmap (iconic mode)
 */

_XmCSetShellPixmap (toplevel, path)
Widget toplevel;
char *path;
{

   Screen *screen;
   Pixmap pixmap;


	screen = XtScreen (toplevel);
	pixmap = XmGetPixmap (screen, path,
		BlackPixelOfScreen(screen), WhitePixelOfScreen (screen));

	XtVaSetValues (toplevel,
		XmNiconPixmap, pixmap,
		NULL);
}

/*
 * _XmCWidgetMakeInvisible: Make widget invisible
 */

_XmCWidgetMakeInvisible (widget)
Widget widget;
{
   Pixel bg;

	XtVaGetValues (widget, XmNbackground, &bg, NULL);
	XtVaSetValues (widget, XmNforeground, bg, NULL);

}

/*
 * _XmCSetDeleteWindowCB: callback invoked as a reponse
 *			 to the Close window action.
 */
 
void _XmCSetDeleteWindowCB (widget, delete_response, client)
Widget widget;
void (*delete_response) ();
void *client;
{
Atom WM_DELETE_WINDOW;

   if (!widget || !delete_response)
   	return;
   	
/*
   XtVaSetValues (widget, XmNdeleteResponse, XmDO_NOTHING, NULL);
*/   
   WM_DELETE_WINDOW = XmInternAtom (XtDisplay (widget),
      				"WM_DELETE_WINDOW", False);
   XmAddWMProtocolCallback (widget, WM_DELETE_WINDOW, 
      				delete_response, client);
}

/* Written by Dan Heller.  Copyright 1991, O'Reilly && Associates.
 * See Motif Programming Manual.
 */


_XmCForceUpdate (w)
Widget w;
{
   Widget diashell, topshell;
   Window diawindow, topwindow;
   XtAppContext cxt = XtWidgetToApplicationContext (w);
   Display *dpy;
   XWindowAttributes xwa;
   XEvent event;

   /* Locate the we are interested in */

   for (diashell =w; !XtIsShell(diashell); diashell = XtParent(diashell));

   /* Locate its primary window's shell (which may be the same) */

   for (topshell = diashell; !XtIsTopLevelShell (topshell);
	topshell = XtParent(topshell))
	;

   if (XtIsRealized(diashell) && XtIsRealized(topshell)) {
	dpy = XtDisplay(topshell);
	diawindow = XtWindow (diashell);
	topwindow = XtWindow (topshell);

	/* Wait for the dialog to be mapped. It's guaranteed to become so */

	while (XGetWindowAttributes (dpy, topwindow, &xwa) &&
		xwa.map_state != IsViewable) {
		
		if (XGetWindowAttributes (dpy, topwindow, &xwa) &&
			xwa.map_state != IsViewable)
			break;

		XtAppNextEvent (cxt, &event);	
		XtDispatchEvent (&event);

	}
   }

   /* The next Xsync() will get an expose event */
   XmUpdateDisplay (topshell);
}

/*
 * _XmCGetSubmenu: Get the widget id of the submenu widget
 */
 
Widget _XmCGetSubmenu (w)
Widget w;
{
   Widget menu;
   
   XtVaGetValues (w, XmNsubMenuId, &menu, NULL);
   if (!menu) {
#ifdef DEBUG
	fprintf (stderr, "_XmCGetSubmenu: couldn't get submenu widget\n");
#endif
   }
   return (menu);

}

  
/*
 * _XmCTraverseChildren: traverse the children of a composite widget
 */
 
int _XmCTraverseChildren (w, func, client)
Widget w;
int (*func) ();
char *client;
{

WidgetList children;
int cnt;

   if (!XtIsComposite (w)) {
#ifdef DEBUG
      fprintf (stderr, "_XmCTraverseChildren: widget is not a subclass of Composite\n");
#endif
      return (-1);
   }

   XtVaGetValues (w, XmNchildren, &children, XmNnumChildren, &cnt, NULL);
   
   while (cnt--) {
#ifdef DEBUG
   	fprintf (stderr, "_XmCTraverseChildren: %d\n", cnt);
#endif
	(*func) (*children++, client);
   }
   
   return (1);   
}    


/*
 * _XmCChildrenCount: Determine how many children the widget has
 */

int _XmCChildrenCount (w)
Widget w;
{
int cnt;

   if (!w)
   	return (-1);
   	
   if (!XtIsComposite (w))
   	return (-1);

   XtVaGetValues (w, XmNnumChildren, &cnt, NULL);
   
   return (cnt);	
}

/*
 * _XmCFindChild: traverse the children of a composite widget and try to find
 *                a specific one.
 */
 
Widget _XmCFindChild (w, func, client)
Widget w;
int (*func) ();
char *client;
{
WidgetList children;
int cnt;
int ret;

   if (!XtIsComposite (w)) {
#ifdef DEBUG
      fprintf (stderr, "_XmCFindChild: widget is not a subclass of Composite\n");
#endif
      return (NULL);
   }

   XtVaGetValues (w, XmNchildren, &children, XmNnumChildren, &cnt, NULL);
   
   while (cnt--) {
#ifdef DEBUG
   	fprintf (stderr, "_XmCTraverseChildren: %d\n", cnt);
#endif
	if ((ret = (*func) (*children, client)) == 0)
	   return (*children);
	if (ret > 0)		/* Stop searching				 */			
	   return (NULL);	/* This assumes that the widget are in some kind */
				/* of order                                      */
	children++;
   }
   
   return (NULL);   
}    

static int entrycmp (e1, e2)
char *e1, *e2;
{
   Widget w = (Widget) e1;
   char *str;
   
   if (!XmIsLabel (w))
     return (-1);
     
   str = _XmClabelGetString(w);
   
   if (!str)
   	return (-1);
   
   if (!strcmp (str, e2))
        return (0);
   else
   	return (-1);
}
/*
 * _XmCFindMenuItem: find a specific menu item
 */
 
Widget _XmCFindMenuItem (menu, label)
Widget menu;
char *label;
{
   if (!label || !menu)
   	return (NULL);
   	
   return(_XmCFindChild (menu, entrycmp, label));
}

Widget _XmCDeleteMenuItems (menu)
Widget menu;
{
   if (!menu) {
	return;
   
   }
   _XmCTraverseChildren (menu, XtDestroyWidget, NULL);      
}


void _XmSetDeleteWindowCB (widget, delete_response)
Widget widget;
void (*delete_response) ();
{
Widget shell;
Atom WM_DELETE_WINDOW;

   if (!widget || !delete_response)
   	return;
   	
   if (shell = locateShell (widget)) {
          XtVaSetValues (shell, XmNdeleteResponse, XmDO_NOTHING, NULL);
          WM_DELETE_WINDOW = XmInternAtom (XtDisplay (shell),
      				"WM_DELETE_WINDOW", False);
      	  XmAddWMProtocolCallback (shell, WM_DELETE_WINDOW, 
      				delete_response, NULL);
   }      
}

int _XCIsSubWindow (display, window, subwindow)
Display *display;
Window window;
Window subwindow;
{

   Window *children;
   Window root;
   Window parent;
   unsigned int nchildren;	

   if (window == subwindow)
   	return (1);
   	
   if (!XQueryTree (display, window, &root, &parent, &children, &nchildren))
   	return (0);

#ifdef OLD
   fprintf (stderr, "window and subwindow %X %X\n", window, subwindow);
#endif
   while (nchildren--) {
#ifdef OLD
        fprintf (stderr, "windows %X\n", *children);
#endif
	if (*children == subwindow)
		return (1);
	if (_XCIsSubWindow (display, *children, subwindow))
		return (1);
	children++;
   }

   return (0);

}
