/* Based on code written by Dan Heller.  Copyright 1991, O'Reilly && Associates.
 */

/* build_option.c -- The final version of BuildMenu() is used to
 * build popup, option, pulldown -and- pullright menus.  Menus are
 * defined by declaring an array of MenuItem structures as usual.
 */
#include <stdio.h>
#include <Xm/MainW.h>
#include <Xm/PanedW.h>
#include <Xm/RowColumn.h>
#include <Xm/DrawingA.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>

#include "build_option.h"

/* Build popup, option and pulldown menus, depending on the menu_type.
 * It may be XmMENU_PULLDOWN, XmMENU_OPTION or  XmMENU_POPUP.  Pulldowns
 * return the CascadeButton that pops up the menu.  Popups return the menu.
 * Option menus are created, but the RowColumn that acts as the option
 * "area" is returned unmanaged. (The user must manage it.)
 * Pulldown menus are built from cascade buttons, so this function
 * also builds pullright menus.  The function also adds the right
 * callback for PushButton or ToggleButton menu items.
 */

Widget
BuildMenu(parent, menu_type, menu_title, menu_mnemonic, items, flags)
Widget parent;
int menu_type;
char *menu_title, menu_mnemonic;
MenuItem *items;
int flags;
{
    Widget menu, cascade, widget;

    int i;
    XmString str;
    unsigned char rcType;

     if (flags & _SKIP_CREATION) {
     if (XmIsCascadeButton (parent)) { 
           XtVaGetValues (parent, XmNsubMenuId, &menu, NULL);
           if (!menu) {
                fprintf (stderr, "BuildMenu: couldn't get submenu widget\n");
                return (NULL);
           }
	   cascade = parent;
	   goto skip_creation;
     }

     if (XmIsRowColumn (parent)) {
        XtVaGetValues (parent, XmNrowColumnType, &rcType, NULL);
        if (rcType == XmMENU_OPTION) {
           XtVaGetValues (parent, XmNsubMenuId, &menu, NULL);
           if (!menu) {
                fprintf (stderr, "BuildMenu: couldn't get submenu widget\n");
                return (NULL);
           }
	   cascade = parent;
	   goto skip_creation;
	}
     }
     }
     
    if (menu_type == XmMENU_PULLDOWN || menu_type == XmMENU_OPTION) {
    	Widget dummy = XtCreatePopupShell("dummy1", transientShellWidgetClass,
                                      (Widget) parent, NULL, 0);
        menu = XmCreatePulldownMenu(dummy, "_pulldown", NULL, 0);
    } else if (menu_type == XmMENU_POPUP) {
    	/* Modification 12/94 */
    	Widget dummy = XtCreatePopupShell("dummy", transientShellWidgetClass,
                                      (Widget) parent, NULL, 0);
        menu = XmCreatePopupMenu(dummy, "_popup", NULL, 0);
    } else {
        XtWarning("Invalid menu type passed to BuildMenu()");
        return NULL;
    }

    /* Pulldown menus require a cascade button to be made */
    if (menu_type == XmMENU_PULLDOWN) {
        str = XmStringCreateSimple(menu_title);
        cascade = XtVaCreateManagedWidget(menu_title,
            xmCascadeButtonWidgetClass, parent,
            XmNsubMenuId,   menu,
            XmNlabelString, str,
            XmNmnemonic,    menu_mnemonic,
            NULL);
        XmStringFree(str);
    } else if (menu_type == XmMENU_OPTION) {
        /* Option menus are a special case, but not hard to handle */
        Arg args[2];
        str = XmStringCreateSimple(menu_title);
        XtSetArg(args[0], XmNsubMenuId, menu);
        XtSetArg(args[1], XmNlabelString, str);
        /* This really isn't a cascade, but this is the widget handle
         * we're going to return at the end of the function.
         */
        cascade = XmCreateOptionMenu(parent, menu_title, args, 2);
        XmStringFree(str);
    }

skip_creation:
    /* Now add the menu items */
    for (i = 0; items[i].label != NULL; i++) {
        /* If subitems exist, create the pull-right menu by calling this
         * function recursively.  Since the function returns a cascade
         * button, the widget returned is used..
         */
        if (items[i].subitems)
            if (menu_type == XmMENU_OPTION) {
                XtWarning("You can't have submenus from option menu items.");
                continue;
            } else
                widget = BuildMenu(menu, XmMENU_PULLDOWN,
                    items[i].label, items[i].mnemonic, items[i].subitems,
			_SKIP_CREATION);
        else {
            widget = XtVaCreateManagedWidget(items[i].label,
                *items[i].class, menu,
                NULL); /* check */
	}

        /* Whether the item is a real item or a cascade button with a
         * menu, it can still have a mnemonic.
         */
        if (items[i].mnemonic)
            XtVaSetValues(widget, XmNmnemonic, items[i].mnemonic, NULL);

        /* any item can have an accelerator, except cascade menus. But,
         * we don't worry about that; we know better in our declarations.
         */
        if (items[i].accelerator) {
            str = XmStringCreateSimple(items[i].accel_text);
            XtVaSetValues(widget,
                XmNaccelerator, items[i].accelerator,
                XmNacceleratorText, str,
                NULL);
            XmStringFree(str);
        }

        if (items[i].callback)
            XtAddCallback(widget,
                (items[i].class == &xmToggleButtonWidgetClass ||
                 items[i].class == &xmToggleButtonGadgetClass)?
                    XmNvalueChangedCallback : /* ToggleButton class */
                    XmNactivateCallback,      /* PushButton class */
                items[i].callback, items[i].callback_data);
    }

    /* for popup menus, just return the menu; pulldown menus, return
     * the cascade button; option menus, return the thing returned
     * from XmCreateOptionMenu().  This isn't a menu, or a cascade button!
     */
    return menu_type == XmMENU_POPUP? menu : cascade;
}
