
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * Functions to handle dialogs
 */

#include <Xm/MessageB.h>
#include "X.h"
#include <stdio.h>

/*
 * _XtCWidgetDestroyCB: callback to destroy a widget
 */

_XtCWidgetDestroyCB (dialog, client_data, cbs)
Widget dialog;
XtPointer client_data;
XtPointer *cbs;
{
   XtDestroyWidget (dialog);
#ifdef DEBUG
   fprintf (stderr, "_XtCWidgetDestroyCB called\n");
#endif
}

/*
 * _XmCDialogPost: post a dialog
 */

Widget 
_XmCDialogPost (parent, msg, title, dialog_type, modality, manage_mask)
Widget parent;
char *msg;
char *title;
int dialog_type;
unsigned char modality;
int manage_mask;
{
   Widget dialog, shell;
   XmString text;

	/* locate the shell associated to this object */
        shell = locateShell (parent); 

        /* Map the shell window */
        if (shell)
	   XMapRaised (XtDisplay (shell), 
	   		XtWindow (shell));       

	dialog = XmCreateMessageDialog(parent, "dialog", NULL, 0);
	text = XmStringCreateLtoR (msg, XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues (dialog, XmNdialogType, dialog_type,
		XmNdialogStyle, modality,
		XmNmessageString, text,
		NULL);
	if (title)
	   XtVaSetValues (XtParent(dialog), XtNtitle, title, NULL);


	XtVaSetValues (XtParent(dialog), XmNdeleteResponse, XmDESTROY, NULL);

	XtAddCallback (dialog, XmNokCallback, _XtCWidgetDestroyCB, NULL);
	XtAddCallback (dialog, XmNcancelCallback, _XtCWidgetDestroyCB, NULL);
	XtAddCallback (dialog, XmNhelpCallback, _XtCWidgetDestroyCB, NULL);

	if (!(manage_mask & _OK_BUTTON))
   	   XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
	if (!(manage_mask & _CANCEL_BUTTON))
   	   XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_CANCEL_BUTTON));
	if (!(manage_mask & _HELP_BUTTON))
   	   XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_HELP_BUTTON));

	XmStringFree (text);
	XtManageChild(dialog);
	XtPopup (XtParent(dialog), XtGrabNone);
	return dialog;
}

/*
 * _XmCExitDialogPost: post an exit dialog
 */

Widget
_XmCExitDialogPost (parent, msg, title)
Widget parent;
char *msg;
char *title;
{
   Widget dialog;

	dialog = _XmCDialogPost (parent, msg, title, XmDIALOG_QUESTION, 
	XmDIALOG_FULL_APPLICATION_MODAL, _OK_BUTTON|_CANCEL_BUTTON);
	XtAddCallback (dialog, XmNokCallback, exit, NULL);
	return dialog;
}

/*
 * _XmCConfirmationDialogPost: post a confirmation dialog
 */

Widget
_XmCConfirmationDialogPost (parent, msg, title, OkCB, Okclient, CancelCB, 
Cancelclient)
Widget parent;
char *msg;
char *title;
void (*OkCB) ();
caddr_t *Okclient;
void (*CancelCB) ();
caddr_t *Cancelclient;
{
   Widget dialog;

        dialog = _XmCDialogPost (parent, msg, title, XmDIALOG_QUESTION,
        XmDIALOG_FULL_APPLICATION_MODAL, _OK_BUTTON|_CANCEL_BUTTON);
	XtVaSetValues (dialog, XmNdefaultButton, 
		XmMessageBoxGetChild (dialog, XmDIALOG_CANCEL_BUTTON), NULL);
	if (OkCB)
        	XtAddCallback (dialog, XmNokCallback, OkCB, Okclient);
	if (CancelCB)
        	XtAddCallback (dialog, XmNcancelCallback, CancelCB, Cancelclient);
        return dialog;
}

/*
 * _XmCPerror: post a system error message
 */

_XmCPerror (parent,msg)
Widget parent;
char *msg;
{
   char *message;
   extern char * _vstrconcat ();

   message = _vstrconcat (msg, ":", _syserror (), NULL);

   _XmCErrorDialogPost (parent, message, "Warning");
   free (message);
}

