/* Based on code written by Dan Heller.  Copyright 1991, O'Reilly && Associates.
 */

/*
 * _XmCloadTextFromFile: read file into text widget
 */

#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include <Xm/Text.h>
#include <Xm/MessageB.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>


void
_XmCloadTextFromFile (w, helpfile)
Widget w;
char *helpfile;
{
char *text;
char message[256];
long len;
FILE *fp;
struct stat statb;


        if (stat(helpfile, &statb) < 0
                || !(fp = fopen (helpfile, "r"))) {
                perror (helpfile);
                sprintf (message, "Can't read or find %s", helpfile);
                return;
        }

        len = statb.st_size;

        if (!(text = XtMalloc ((unsigned) (len+1)))) {
                fprintf (stderr, "helpfile_open: not enough memory\n");
                return;
        }

        if (fread(text, sizeof(char), len, fp) != len)
	   fprintf (stderr, "helpfile_open: did not read entire file\n");

        text[len] = '\0';

        XmTextSetString (w, text);
        XtFree (text);
        fclose (fp);
        return;
}
