/* $XConsortium: List.c,v 1.34 91/09/27 18:35:07 converse Exp $ */

/*
 * Copyright 1989 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * XedwList.c - XedwList widget
 *
 * This is the XedwList widget. It is very similar to the Athena Widget List,
 * except it has the ability to display an icon with the string. Plus allows
 * multiple selections.
 * It allows the user to select one or more items in a list and notifies the
 * application through a callback function.
 *
 *  List Created:   8/13/88
 *  By:     Chris D. Peterson
 *                      MIT X Consortium
 *
 *  Modified to XedwList: 1/26/91
 *  By:     Edward Groenendaal
 *                      University of Sussex, UK.
 */


/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#include <stdio.h>
#include <ctype.h>
#include <Xm/Xm.h>
#include "pixmaps.h"
#include "rdd.h"
#include "X.h"

#undef DEBUG		/* for now */


#include <stdio.h>
#include <ctype.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Drawing.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xatom.h>
#include <X11/Xmu/Atoms.h>
#include <X11/Xmu/StdSel.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/cursorfont.h>
#include <Xm/ScrolledW.h>


#include "ool.h"
#include "XedwListP.h"
#include <string.h>
#include "etc.h"

#define INFINITE 10000
extern Window activeWindow;


/*
 * Default icon
 */

#include "DefIcon.icon"

#define DEFAULTWIDTH	600
#define DEFAULTHEIGHT	600

/*
 * Default translation table.
 */


static char defaultTranslations[] =
  "!Shift<Btn1Down>:            MultipleSet()\n\
   <Btn1Down>:                  Set()\n\
   <Btn1Motion>: 		DragItem()\n\
   !Shift Ctrl<Btn1Up>:	        Notify(Shift Ctr)\n\
   !Ctrl<Btn1Up>:		Notify(Ctrl)\n\
   <Btn3Down>:			Set() popup-menu()\n\
   <Btn1Up>:      		Notify()";

#define offset(field) XtOffset(XedwListWidget, field)

/*
 * Resources
 */

static XtResource resources[] = {
  {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
     offset(xedwList.foreground), XtRString, "XtDefaultForeground"},
  {XtNfont,  XtCFont, XtRFontStruct, sizeof(XFontStruct *),
     offset(xedwList.font),XtRString, "XtDefaultFont"},
  {XtNxedwList, XtCXedwList, XtRPointer, sizeof(XedwList **), /* XedwList */
     offset(xedwList.xedw_item_lst), XtRString, NULL},
  {XtNdefaultColumns, XtCColumns, XtRInt,  sizeof(int),
     offset(xedwList.default_cols), XtRImmediate, (caddr_t)2},
  {XtNnumberStrings, XtCNumberStrings, XtRInt,  sizeof(int),
     offset(xedwList.nitems), XtRImmediate, (caddr_t)0},
  {XtNpasteBuffer, XtCBoolean, XtRBoolean,  sizeof(Boolean),
     offset(xedwList.paste), XtRString, (caddr_t) "False"},
  {XtNforceColumns, XtCColumns, XtRBoolean,  sizeof(Boolean),
     offset(xedwList.force_cols), XtRString, (caddr_t) "False"},
  {XtNfitParent, XtCFitParent, XtRBoolean, sizeof (Boolean),
     offset(xedwList.fit_parent), XtRImmediate, (XtPointer) TRUE},
  {XtNrubberbanding, XtCBoolean, XtRBoolean,  sizeof(Boolean),
     offset(xedwList.rubberbanding), XtRString, (caddr_t) "False"},
  {XtNverticalList, XtCBoolean, XtRBoolean,  sizeof(Boolean),
     offset(xedwList.vertical_cols), XtRString, (caddr_t) "False"},
  {XtNinternalWidth, XtCWidth, XtRDimension,  sizeof(Dimension),
     offset(xedwList.internal_width), XtRImmediate, (caddr_t)4},
  {XtNinternalHeight, XtCHeight, XtRDimension, sizeof(Dimension),
     offset(xedwList.internal_height), XtRImmediate, (caddr_t)2},
  {XtNcolumnSpacing, XtCSpacing, XtRDimension,  sizeof(Dimension),
     offset(xedwList.column_space), XtRImmediate, (caddr_t)10},
  {XtNrowSpacing, XtCSpacing, XtRDimension,  sizeof(Dimension),
     offset(xedwList.row_space), XtRImmediate, (caddr_t)10},
  {XtNiconWidth, XtCWidth, XtRDimension, sizeof(Dimension),    /* IconWidth */
     offset(xedwList.icon_width), XtRImmediate, (caddr_t)32},
  {XtNiconHeight, XtCHeight, XtRDimension, sizeof(Dimension),  /* IconHeight */
     offset(xedwList.icon_height), XtRImmediate, (caddr_t)32},
  {XtNshowIcons, XtCBoolean, XtRBoolean, sizeof(Boolean),      /* ShowIcons */
     offset(xedwList.show_icons), XtRString, (caddr_t) "False"},
  {XtNmSelections, XtCBoolean, XtRBoolean, sizeof(Boolean),    /* Multiple   */
     offset(xedwList.multiple), XtRString, (caddr_t) "False"}, /* Selections */
  {XtNdefaultIcon, XtCPixmap, XtRPixmap, sizeof(Pixmap),      /* DefaultIcon */
     offset(xedwList.default_icon), XtRPixmap, (caddr_t) NULL},
  {XtNcallback, XtCCallback, XtRCallback, sizeof(caddr_t),
     offset(xedwList.callback), XtRCallback, NULL},
  {XtNdoubleClick, XtCCallback, XtRCallback, sizeof(caddr_t),
     offset(xedwList.doubleclick), XtRCallback, NULL},
  {XtNdrop, XtCCallback, XtRCallback, sizeof(caddr_t),
     offset(xedwList.drop), XtRCallback, NULL},
  {XtNexpose, XtCCallback, XtRCallback, sizeof(caddr_t),
     offset(xedwList.expose), XtRCallback, NULL},
  {XtNconvertProc, XtCCallback, XtRCallback, sizeof(caddr_t),
     offset(xedwList.convertproc), XtRCallback, NULL},
  {XtNlayoutPolicy, XtCLayoutPolicy, XtRUnsignedChar, sizeof(unsigned char),
     offset(xedwList.layout_policy), XtRImmediate, (XtPointer) XedwDYNAMIC},
  {XtNhandlePopup, XtCCallback, XtRCallback, sizeof(caddr_t),
     offset(xedwList.popupproc), XtRCallback, NULL},

};

static void XwCollInitialize ();
static void Resize ();
static void Realize ();
static void Redisplay ();
static XtGeometryResult PreferredGeom();
static Boolean XwCollSetValues();
static void Notify(), Set(), MultipleSet (), drag_item (), Unset ();
static void StartAction ();
static void DropAction ();
static void HandlePopupMenu ();
int ncmp ();
void XwWidgetForceSize ();
static void XwCollFitParent ();
static void CreateCursors ();
static void XwDropEventHandler();
static char *BuildNameBlk();

Display *display;

static XtActionsRec actions[] = {
  {"Notify",         Notify},
  {"Set",            Set},
  {"DragItem",       drag_item},
  {"Unset",          Unset},
  {"MultipleSet",    MultipleSet},
  {"StartAction",    StartAction},
  {"DropAction",     DropAction},
  { "popup-menu",    HandlePopupMenu },
  {NULL,NULL}
};

XedwListClassRec xedwListClassRec = {
  {
/* core_class fields */
#define superclass                  (&widgetClassRec)
    /* superclass               */  (WidgetClass) superclass,
    /* class_name               */  "XedwList",
    /* widget_size              */  sizeof(XedwListRec),
    /* class_initialize         */  NULL,
    /* class_part_initialize    */  NULL,
    /* class_inited             */  FALSE,
    /* initialize               */  XwCollInitialize,
    /* initialize_hook          */  NULL,
    /* realize                  */  Realize,
    /* actions                  */  actions,
    /* num_actions              */  XtNumber(actions),
    /* resources                */  resources,
    /* num_resources            */  XtNumber(resources),
    /* xrm_class                */  NULLQUARK,
    /* compress_motion          */  TRUE,
    /* compress_exposure        */  TRUE,
    /* compress_enterleave      */  TRUE,
    /* visible_interest         */  FALSE,
    /* destroy                  */  NULL,
    /* resize                   */  Resize,
    /* expose                   */  Redisplay,
    /* set_values               */  XwCollSetValues,
    /* set_values_hook          */  NULL,
    /* set_values_almost        */  XtInheritSetValuesAlmost,
    /* get_values_hook          */  NULL,
    /* accept_focus             */  NULL,
    /* version                  */  XtVersion,
    /* callback_private         */  NULL,
    /* tm_table                 */  defaultTranslations,
    /* query_geometry           */  PreferredGeom,
				NULL,
				NULL,
  },
/* Simple class fields initialization */
  {
	0,
  }
};

WidgetClass xedwListWidgetClass = (WidgetClass)&xedwListClassRec;
Widget ParentWidget;

_SimpleList *kk;


/*
 * GetGCs: get GC's
 */

static void GetGCs(w)
Widget w;
{

  XGCValues   values;
  XedwListWidget ilw = (XedwListWidget) w;
  Window  win = RootWindowOfScreen(XtScreen((Widget) w));


  values.foreground   = ilw->xedwList.foreground;
  values.background   = ilw->core.background_pixel;
  values.font         = ilw->xedwList.font->fid;
  ilw->xedwList.normgc = 
	XtGetGC(w, (unsigned) GCBackground | GCForeground | GCFont, &values);

  values.foreground   = ilw->core.background_pixel;
  values.background   = ilw->xedwList.foreground;
  ilw->xedwList.revgc = 
	XtGetGC(w, (unsigned) GCBackground | GCForeground | GCFont, &values);


{
  static char stipple_bits[] = {0xaa, 0x55};
  values.stipple = XCreateBitmapFromData (XtDisplay(w), win, 
		stipple_bits, 8, 2);
  values.fill_style = FillStippled;
  values.function = GXcopy;
  values.foreground = ilw->core.background_pixel;

  ilw->xedwList.graygc = XtGetGC(w, (unsigned) GCFunction | GCStipple | GCForeground | GCFillStyle, &values);
}


  values.background   = ilw->core.background_pixel;
  values.foreground   = ilw->xedwList.foreground ^ ilw->core.background_pixel;
  values.line_style = LineOnOffDash;
  values.function = GXxor;
  ilw->xedwList.xorgc = 
  	XtGetGC(w, GCBackground | GCForeground | GCFunction 
		| GCLineStyle | GCLineStyle, &values);
}


/*
 * DoLayout    - Reset collection when important things change
 * w	       - Collection widget
 */

static void DoLayout (w)
Widget w;
{
  XedwListWidget ilw = (XedwListWidget) w;
  register int len;
  _ITEM *item;


  ilw->xedwList.nitems = _ListLength(ilw->xedwList.xedw_item_lst);

  item = (_ITEM *) _ListFirst(ilw->xedwList.xedw_item_lst);

  ilw->xedwList.longest = 0; 
  while (item) {

	len = XTextWidth(ilw->xedwList.font, 
                           item->item_label,
                           strlen(item->item_label));

        if (len > ilw->xedwList.longest)
                ilw->xedwList.longest = len;

          item = (_ITEM *) _ListNext(ilw->xedwList.xedw_item_lst);
   }

  /* If longest string is less than the width of a bitmap then the longest is
   * the width of a bitmap
   */
  if (ilw->xedwList.show_icons)
    if (ilw->xedwList.longest < ilw->xedwList.icon_width)
      ilw->xedwList.longest = ilw->xedwList.icon_width;

  ilw->xedwList.col_width = ilw->xedwList.longest + 
				ilw->xedwList.column_space;

  XwCollBoundingBox ((Widget) ilw, 0);

  XedwItemsInit ((Widget) w);
}


/*  
 * XwCollInitialize
 * Description: Initialize the widget instance.
 */

static void XwCollInitialize(request, ilw)
register XedwListWidget request, ilw;
{
  register _ITEM *item;
  register _LST *lst = ilw->xedwList.xedw_item_lst;

  int len;
  Dimension width, height;
  int mclick;
  
  display = XtDisplay (ilw);

   ilw->xedwList.desired_width = ilw->core.width;
   ilw->xedwList.desired_height = ilw->core.height;

  /* for now - To be handled by the resource manager */
  
  if (XtGetMultiClickTime (display) <= 200)
  	XtSetMultiClickTime (display, 450);
  
/*
 * Initialize all private resources.
 */

  CreateCursors (ilw);

  GetGCs((Widget) ilw);

  /* Set row height. */
  if (ilw->xedwList.show_icons)
    ilw->xedwList.row_height = ilw->xedwList.font->max_bounds.ascent
      + ilw->xedwList.font->max_bounds.descent
      + ilw->xedwList.row_space
      + ilw->xedwList.icon_height;
  else
    ilw->xedwList.row_height = ilw->xedwList.font->max_bounds.ascent
      + ilw->xedwList.font->max_bounds.descent
      + ilw->xedwList.row_space;


  if (lst && !_ListEmpty(lst)) {  
        if (ilw->xedwList.fit_parent) {
       		XtVaGetValues (XtParent(ilw), XtNwidth,
                &width, XtNheight, &height, NULL); 
		ilw->core.width = width;
		ilw->core.height = height;
		DoLayout ((Widget) ilw);
	   	ilw->core.width = max (ilw->xedwList.min_width, width);
	   	ilw->core.height = max (ilw->xedwList.min_height, height);
		goto out;
	}

	DoLayout ((Widget) ilw);
	if (ilw->xedwList.desired_width == 0) {
	   ilw->core.width = ilw->xedwList.min_width;
	   ilw->core.height = ilw->xedwList.min_height;
  	}
  }

out:

  ilw->xedwList.xedw_h_item = NULL;
  ilw->xedwList.xedw_receptor = NULL;
  ilw->xedwList.xedw_state = XedwIdle;

  if ((ilw->xedwList.xedw_h_lst = _SListCreate ()) == NULL) {
	fprintf (stderr, "XwCollInitialize: Not enough memory\n");
	return;
  }

  if (ilw->xedwList.fit_parent) {
  	XtAddEventHandler (XtParent (ilw), StructureNotifyMask, False,
                                XwCollFitParent, ilw);
  }
  XtAddEventHandler (ilw, EnterWindowMask|LeaveWindowMask, FALSE,
                                           rddEnterLeaveProc, NULL);
  XtRegisterGrabAction (HandlePopupMenu, False,
			      (ButtonPressMask|ButtonReleaseMask),
			      GrabModeAsync, GrabModeAsync);
  rddSetDragCursor (ilw->xedwList.move_cursor);

} /* XwCollInitialize */


/*
 * HandlePopupMenu: handle popup menu
 */

static void HandlePopupMenu (widget, event, params, param_count)
    Widget widget;
    XEvent *event;
    String *params;
    Cardinal *param_count;
{
   XedwListWidget w = (XedwListWidget) widget;
   XedwCallbackStruct cbs;

   cbs.reason = XedwCR_HANDLE_POPUP;
   cbs.event = event;
   cbs.xedw_h_item = NULL;	/* check this */
   cbs.xedw_h_lst = NULL;
   cbs.xedw_receptor = NULL;
#ifdef OLD
   fprintf (stderr, "HandlePopupMenu: action invoked\n");
#endif
   XtCallCallbacks (w, XtNhandlePopup, &cbs);
}


/*
 * XwCollFitParent: increase widget size until it fits the parent widget
 */

static void XwCollFitParent (w, client_data, event)
Widget w;
XtPointer client_data;
XEvent *event;
{
  Dimension width, height;
  XedwListWidget ilw = (XedwListWidget) client_data;
        XtVaGetValues (w, XtNwidth,
                &width, XtNheight, &height, NULL); 

        width = max (ilw->xedwList.min_width, width);
        height = max (ilw->xedwList.min_height, height);

	XtVaSetValues (ilw, XtNwidth, width, XtNheight, height, NULL);
}


#define XshPointInRectangle(x,y,width,height,x0,y0)              \
(((x0) >= (x)) && ((x0) < (x)+width) && ((y0) >= (y)) && ((y0) < (y)+height))
#define min(x,y) ((x)<=(y)?(x):(y))


/*
 * XshPointIntersectLabel: determine if coordinates intersect label
 */

XshPointIntersectLabel(ilw, item, xloc, yloc)
register XedwListWidget ilw;
register _ITEM *item;
int xloc, yloc;
{
register XFontStruct *font = ilw->xedwList.font;


   return (XshPointInRectangle(item->item_label_x,
        item->item_label_y - font->max_bounds.ascent,
        item->item_label_width,
        font->max_bounds.ascent + font->max_bounds.descent,
        xloc, yloc));

}

/*
 * XedwItemInRubberbox: item intersects rubber box
 */

void XedwItemInRubberbox(w, item)
Widget w;
register _ITEM *item;
{

  XedwListWidget ilw = ( XedwListWidget ) w;
  register _SimpleList *hl = ilw->xedwList.xedw_h_lst;
#ifdef DEBUG
  extern int func ();
#endif

#ifdef DEBUG
   	fprintf (stderr, "XedwItemInRubberbox:%s\n", item->item_label);
#endif
	if (item->item_stat & _ItemInRubberBox) {
#ifdef DEBUG
   	   fprintf (stderr, "XedwItemInRubberbox: item %s\n",item->item_label);
#endif
	   return;
	}

        item->item_stat |= _ItemInRubberBox;

        _SListAppend(hl, item);
        PaintItemName(w, item);
#ifdef DEBUG
	_SListTraverse (hl, func);
#endif
}

/* func - for debugging purposes only */

func (p)
_ITEM *p;
{
	fprintf (stderr, "func: p = %d \n", p->item_stat);
}

/* 
 * XedwItemsInRubberBox: return list of items inside the rubber box
 */

void XedwItemsInRubberBox(w, x, y, width, height)
Widget w;
int x, y, width, height;
{
  XedwListWidget ilw = (XedwListWidget) w;
  register _SimpleList *hl = ilw->xedwList.xedw_h_lst;
  register XFontStruct *font = ilw->xedwList.font;
  register _ITEM *item;
  _ITEM *tmp;
#ifdef DEBUG
  extern int func ();
#endif
   Region r;
   XRectangle rec;
   int box_y, box_height;


  rec.x = x;
  rec.y = y;
  rec.width = width;
  rec.height = height;
  r = XCreateRegion ();
  XUnionRectWithRegion (&rec, r, r);

#ifdef DEBUG
  fprintf (stderr, "XedwItemsInRubberBox: %d %d %d %d\n", x, y, width, height);
#endif

      item = (_ITEM *) _SListFirst (hl);

      while (item) {

	if (!IsInRubberBox(item)) {
#ifdef DEBUG
	   fprintf (stderr, "XedwItemsInRubberBox: item = %s\n", 
			item->item_label);
	   _SListTraverse (hl, func);
#endif
           item = (_ITEM *) _SListNext (hl);
	   continue;
	}

        if (ilw->xedwList.show_icons)
           if (XRectInRegion (r, item->item_x, item->item_y
               ,ilw->xedwList.icon_width
               ,ilw->xedwList.icon_height) != RectangleOut ) {
        	item = (_ITEM *) _SListNext (hl);
		continue;
           }

        if (XRectInRegion (r, item->item_label_x,
        item->item_label_y - font->max_bounds.ascent,
        item->item_label_width,
        font->max_bounds.ascent+font->max_bounds.descent) != RectangleOut ) {
           item = (_ITEM *) _SListNext (hl);
	   continue;
	}

        tmp = item;
        item->item_stat &= ~_ItemInRubberBox;
        PaintItemName (w, item);
#ifdef DEBUG1
	fprintf (stderr, "XedwItemsInRubberBox:%s (OUT)\n", item->item_label);
	_SListTraverse (hl, func);
#endif
        item = (_ITEM *) _SListNext (hl);
        _SListUnlink(hl, tmp);
#ifdef DEBUG1
	_SListTraverse (hl, func);
#endif
     }
     

  if (ilw->xedwList.show_icons)
     box_height = font->max_bounds.ascent + font->max_bounds.descent +
     ilw->xedwList.icon_height;
  else
     box_height = font->max_bounds.ascent + font->max_bounds.descent;



  item = (_ITEM *) _ListFirst(ilw->xedwList.xedw_item_lst);

  while (item) {

	if (IsInRubberBox(item)) {
           item = (_ITEM *) _ListNext (ilw->xedwList.xedw_item_lst);
           continue;
        }

        if (ilw->xedwList.show_icons) {
                box_y = item->item_y;
        } else {
                box_y = item->item_label_y - font->max_bounds.ascent;
        }

        /*
         * Item outside expose area (above)
         */

	if (y > box_y + box_height) {
           item = (_ITEM *) _ListNext (ilw->xedwList.xedw_item_lst);
           continue;
        }

        /*
         * Item outside expose area (below)
         */

        if (y + height < box_y)
           break;

        if (ilw->xedwList.show_icons)
  	   if (XRectInRegion (r, item->item_x, item->item_y
               ,ilw->xedwList.icon_width
               ,ilw->xedwList.icon_height) != RectangleOut ) {
	   	   XedwItemInRubberbox(w, item);
		item = (_ITEM *) _ListNext (ilw->xedwList.xedw_item_lst);
		continue;
	   }

        box_y = item->item_label_y - font->max_bounds.ascent;

        if (XRectInRegion (r, item->item_label_x,
        item->item_label_y - font->max_bounds.ascent,
        item->item_label_width,
        font->max_bounds.ascent+font->max_bounds.descent) 
		!= RectangleOut ) {
                   XedwItemInRubberbox(w, item);
		item = (_ITEM *) _ListNext (ilw->xedwList.xedw_item_lst);
		continue;
        }

	item = (_ITEM *) _ListNext (ilw->xedwList.xedw_item_lst);

  }
  XDestroyRegion (r);

}


/*  Function Name: CvtToItem
 *  Description: Converts Xcoord to item number of the item containing that
 *               point.
 *  Arguments: w - the xedwList widget.
 *             xloc, yloc - x location, and y location.
 *  Returns: the item number.
 */

_ITEM *CvtToItem (w, xloc, yloc)
Widget w;
int xloc, yloc;
{
  register XedwListWidget ilw = (XedwListWidget) w;
  register _ITEM *item = (_ITEM *) _ListLast(ilw->xedwList.xedw_item_lst);

     while (item) {

        if (ilw->xedwList.show_icons)
           if (XshPointInRectangle (item->item_x, item->item_y,
                                ilw->xedwList.icon_width,
                                ilw->xedwList.icon_height,
                                xloc,
                                yloc)) {
		return (item);
           }

        if (XshPointIntersectLabel (ilw, item, xloc, yloc)) {
		return (item);
        }

        item = (_ITEM *) _ListPrev (ilw->xedwList.xedw_item_lst);
    }
    return (NULL);
}


/*  Function Name: HighlightBackground
 *  Description: paints the color of the background for the given item.
 *  Arguments: w - the widget.
 *             x, y - ul corner of the area item occupies.
 *             item - the item we are dealing with.
 *             gc - the gc that is used to paint this rectangle
 *  Returns:
 */

static int HighlightBackground(w, item, gc)
Widget w;
_ITEM *item;
GC gc;
{
  XedwListWidget ilw = (XedwListWidget) w;
  int hl_x, hl_y, width, height;
  int x, y;
  x = item->item_label_x;
  y = item->item_y;


  hl_x = x - ilw->xedwList.column_space/2;
  width = XTextWidth(ilw->xedwList.font, item->item_label,
                 strlen (item->item_label))
    + ilw->xedwList.column_space;

  hl_y = y + ((ilw->xedwList.show_icons) ? ilw->xedwList.icon_height : 0);
  height = ilw->xedwList.row_height - ilw->xedwList.row_space -
    ((ilw->xedwList.show_icons) ? ilw->xedwList.icon_height : 0);

  XFillRectangle(XtDisplay(w), XtWindow(w), gc, hl_x, hl_y, width, height);
}

/*
 * XedwItemsInit - Initialize Items
 */


XedwItemsInit (w)
Widget w;
{
  register XedwListWidget ilw = (XedwListWidget) w;
  register int row, col;
  int x, y, str_x, str_y;
  register _ITEM *item;
  char *str;


   item = (_ITEM *) _ListFirst(ilw->xedwList.xedw_item_lst);

   x = ilw->xedwList.internal_width;
   y = ilw->xedwList.internal_height;
   row = col = 1;
   while (item) {

	str = item->item_label;

	str_y = y + ilw->xedwList.font->max_bounds.ascent;

  	if (ilw->xedwList.show_icons) {
    	  str_x = x + ((ilw->xedwList.longest/2) -
                 (XTextWidth(ilw->xedwList.font, str, strlen(str))/2));
    	  item->item_x = x
    		+((ilw->xedwList.longest/2)-(ilw->xedwList.icon_width/2));
    	  item->item_y = y;

          item->item_label_x = str_x;
          item->item_label_y = str_y+ilw->xedwList.icon_height;
          item->item_label_width = XTextWidth (ilw->xedwList.font,
    					  item->item_label,
        				  strlen(item->item_label));
  	} else {
    	   item->item_label_x = x;
    	   item->item_label_y = str_y;
    	   item->item_label_width = XTextWidth (ilw->xedwList.font,
    					  item->item_label,
        				  strlen(item->item_label));
        }


        if (!ilw->xedwList.vertical_cols)
           if (col++ == ilw->xedwList.ncols) {
                col = 1;
                x = ilw->xedwList.internal_width;
                y += ilw->xedwList.row_height;
            } else
                x += ilw->xedwList.col_width;
        else
            if (row++ == ilw->xedwList.nrows) {
                row = 1;
                x += ilw->xedwList.col_width;
                y = ilw->xedwList.internal_height;
             } else
                y += ilw->xedwList.row_height;

    	item = (_ITEM *) _ListNext(ilw->xedwList.xedw_item_lst);
   }
}


/*  Function Name: PaintItemName
 *  Description: paints the name of the item in the appropriate location.
 *  NOTE: no action taken on an unrealized widget.
 */

int PaintItemName(w, item)
Widget w;
_ITEM *item; 
{
  char * str;
  GC gc;
  unsigned normalmode, inversemode;
  XedwListWidget ilw = (XedwListWidget) w;
  Pixmap icon;
  Pixmap mask;


  if (!XtIsRealized(w)) return; /* Just in case... */

  if (item->item_stat & _ItemDeleted) {
	fprintf (stderr, "PaintItemName: Repainting a deleted item (%s)\n", 
			item->item_label);
	return;
  }

  str = item->item_label;
  
  if (DefaultDepthOfScreen(XtScreen(ilw)) == 1) {
    /* Monochrome */
    if ((BlackPixelOfScreen(XtScreen(ilw))) == 1 &&
        ilw->core.background_pixel == WhitePixelOfScreen(XtScreen(ilw))) {
      normalmode = GXcopy;
      inversemode = GXcopyInverted;
    } else {                            /* On a machine with black = 0 OR  */
      normalmode = GXcopyInverted;      /* reverse video has been selected */
      inversemode = GXcopy;
    }
  } else {
    /* Colour */
    normalmode = GXcopy;
    inversemode = GXcopy;
  }

  if (IsHighlighted (item) || IsInRubberBox (item)
	|| IsReceptor(item)) { 
          gc = ilw->xedwList.revgc;
          XSetFunction(XtDisplay(w), gc, inversemode);
  } else {
#ifdef DEBUG
	  fprintf (stderr, "%s OFF\n", item->item_label);
#endif
          gc = ilw->xedwList.normgc;
          XSetFunction(XtDisplay(ilw), gc, normalmode);
  }


  if (ilw->xedwList.show_icons){
    icon = item->item_icon;
    mask = item->item_mask;

    XSetClipMask (XtDisplay(ilw), gc, mask);
    XSetClipOrigin (XtDisplay(ilw), gc, item->item_x, item->item_y);
    XSetPlaneMask (XtDisplay(ilw), gc, AllPlanes);

    if (DefaultDepthOfScreen(XtScreen(ilw)) == 1)
      XCopyArea(XtDisplay(ilw), icon,
                XtWindow(ilw), gc, 0, 0,
                ilw->xedwList.icon_width, ilw->xedwList.icon_height,
                item->item_x, item->item_y);
    else
     XCopyArea(XtDisplay(ilw), icon,
                XtWindow(ilw), gc, 0, 0,
                ilw->xedwList.icon_width, ilw->xedwList.icon_height,
                item->item_x, item->item_y);


    if (item->item_stat & _ItemGreyedOut) {
       XSetTSOrigin (XtDisplay(ilw), ilw->xedwList.graygc, item->item_x, 
		item->item_y);
       XFillRectangle (XtDisplay(ilw),
       XtWindow(ilw), ilw->xedwList.graygc,
       item->item_x, item->item_y,
       ilw->xedwList.icon_width, ilw->xedwList.icon_height);
    }

    XSetClipMask (XtDisplay(ilw), gc, None);
    /* Draw string */
  } 



    XSetFunction(XtDisplay(ilw), gc, GXcopy); 

    XDrawImageString(XtDisplay(ilw), XtWindow(ilw), gc, item->item_label_x,
        item->item_label_y, str, strlen(str));
        
}

/*
 * XwCollItemDelete - Delete item
 */

XwCollItemDelete (w, obj)
Widget w;
ObjectT obj;
{
  _ITEM *item = (_ITEM *) obj;
  XedwListWidget ilw = (XedwListWidget) w;
  _SimpleList *hl = ilw->xedwList.xedw_h_lst;
  _LST *lst = ilw->xedwList.xedw_item_lst;
  int x, y, width, height;


	if (IsHighlighted(item)) {
           if (ilw->xedwList.xedw_h_item == item)
           	ilw->xedwList.xedw_h_item = NULL;
	   item->item_stat &= ~_ItemHighlighted;
           _SListUnlink(hl, item);
    	   XtCallCallbacks(w, XtNcallback, (caddr_t) 0);
	}
        item->item_stat = _ItemDeleted;


	XedwItemBoundingBox (w, item, &x, &y, &width, &height);
	XtFree ((void *) item->item_label); item->item_label = NULL;
        _ListDelete(lst, (char *) item); /* Mark item as deleted */
	ilw->xedwList.nitems  = _ListLength (lst);
	

	XClearArea (XtDisplay(w), XtWindow(w), x, y, width, height, True);

}

/*
 * XwCollItemInsertO: insert item
 */

_ITEM *XwCollItemInsertO (w, obj, cmp)
Widget w;
ObjectT obj;
int (*cmp) ();
{
  _ITEM *item = (_ITEM *) obj;
  XedwListWidget ilw = (XedwListWidget) w;
  _LST *lst = ilw->xedwList.xedw_item_lst;
  _SimpleList *hl = ilw->xedwList.xedw_h_lst;


	item = (_ITEM *) _ListInsertO (lst, (char *) item, cmp);  /* Insert Item      */
        XtVaSetValues (ilw, XtNxedwList, lst, NULL);     /* Force call to    */
                                                         /* SetValues        */
	return (item);
}

_ITEM *XwCollItemUInsertO (w, obj, cmp)
Widget w;
ObjectT obj;
int (*cmp) ();
{
  _ITEM *item = (_ITEM *) obj;
  XedwListWidget ilw = (XedwListWidget) w;
  _LST *lst = ilw->xedwList.xedw_item_lst;
  _SimpleList *hl = ilw->xedwList.xedw_h_lst;


        item = (_ITEM *) _ListInsertO (lst, (char *) item, cmp);  /* Insert Item
      */
        return (item);
}

/*
 * Redisplay: resdiplay widget
 */

static void Redisplay(w, event, junk)
Widget w;
XEvent *event;
Region junk;
{
  _ITEM *item;
   Region r;
   XedwListWidget ilw = (XedwListWidget) w;
   register XFontStruct *font;
   int box_x, box_y, box_width, box_height;
   XedwCallbackStruct cbs;

#ifdef DEBUG
  fprintf (stderr, "Redisplay: %d, %d\n", w->core.width, w->core.height);
#endif

    cbs.reason = XedwCR_EXPOSE;
    cbs.event = event;
    cbs.xedw_h_item = NULL;
    cbs.xedw_h_lst = NULL;
    cbs.xedw_receptor = NULL;

    XtCallCallbacks (w, XtNexpose, &cbs);


{
  XExposeEvent *ev = (XExposeEvent *) event;

#ifdef DEBUG
  if (ev) {
  fprintf (stderr, "Redisplay: %d,%d,%d,%d\n",ev->x,ev->y,ev->width,ev->height);
  fprintf (stderr, "Redisplay: %d\n",ev->send_event);
  }
#endif

}

        item = (_ITEM *) _ListFirst (ilw->xedwList.xedw_item_lst);


        if (event == NULL) {     /* repaint all */
	   fprintf (stderr, "Null event\n");
           XClearWindow(XtDisplay(w), XtWindow(w));
           while (item) {
                PaintItemName(w, item);
           	item = (_ITEM *) _ListNext (ilw->xedwList.xedw_item_lst);
           }
           return;
        }


        r = XCreateRegion ();
        XtAddExposureToRegion (event, r);
        font = ilw->xedwList.font;

	if (ilw->xedwList.show_icons)
	   box_height = font->ascent + font->descent +
			     ilw->xedwList.icon_height;
	else
	   box_height = font->ascent + font->descent;

        while (item) {
	
	   if (ilw->xedwList.show_icons) {
		box_x = min(item->item_x,item->item_label_x);
		box_y = item->item_y;
		box_width = max(item->item_label_width,ilw->xedwList.icon_width);
	   } else {
		box_x = item->item_label_x;
		box_y = item->item_label_y - font->ascent;
		box_width = item->item_label_width;
	   }

           /*
            * Item outside expose area (above)
            */

           if (event->xexpose.y > box_y + box_height) {
                item = (_ITEM *) _ListNext (ilw->xedwList.xedw_item_lst);
                continue;
           }

           /*
            * Item outside expose area (below)
            */

           if (event->xexpose.y + event->xexpose.height < box_y)
                break;

           /*
            * Check intersection between item and expose area
            */

           if (XRectInRegion (r, box_x, box_y,
                              box_width,
                              box_height) != RectangleOut ) {
           	PaintItemName(w, item);
#ifdef DEBUG
		fprintf (stderr, "Redisplay: %s\n", item->item_label);
#endif
	   }


           item = (_ITEM *) _ListNext (ilw->xedwList.xedw_item_lst);
        }
        XDestroyRegion (r);
}



/*  Function Name: PreferredGeom
 *  Description: This tells the parent what size we would like to be
 *                   given certain constraints.
 *  Arguments: w - the widget.
 *                 intended - what the parent intends to do with us.
 *                 requested - what we want to happen.
 *  Returns: none.
 */

static XtGeometryResult PreferredGeom(w, intended, requested)
Widget w;
XtWidgetGeometry *intended, *requested;
{
  Dimension new_width, new_height;
  Boolean change, width_req, height_req;


  width_req = intended->request_mode & CWWidth;
  height_req = intended->request_mode & CWHeight;

#ifdef DEBUG
  fprintf (stderr, "PreferedGeom: %d, %d\n", w->core.width, w->core.height);
  fprintf (stderr, "PreferedGeom: %d, %d\n", intended->width, intended->height);
#endif

  if (width_req)
    new_width = intended->width;
  else
    new_width = w->core.width;

  if (height_req)
    new_height = intended->height;
  else
    new_height = w->core.height;

  fprintf (stderr, "PreferedGeom: %d, %d\n", width_req, height_req);

  requested->request_mode = 0;

  /*
   * We only care about our height and width.
   */

  if ( !width_req && !height_req)
    return(XtGeometryYes);

  requested->request_mode |= CWWidth;
  requested->width = new_width;
  requested->request_mode |= CWHeight;
  requested->height = new_height;

  if (change)
    return(XtGeometryAlmost);
  return(XtGeometryYes);
}

/*
 * Realize: realize widget
 */

static void Realize (w, valueMask, attributes)
XedwListWidget w;
XtValueMask *valueMask;
XSetWindowAttributes *attributes;
{
        /*
     	 * Set gravity for our window
     	 */

	*valueMask |= CWBitGravity;
	attributes->bit_gravity = StaticGravity;

	(*superclass->core_class.realize) (w, valueMask, attributes);
        rddRegisterDropSite ((Widget) w, XwDropEventHandler);
}

/*  Function Name: Resize
 *  Description: resizes the widget, by changing the number of rows and
 *               columns.
 *  Arguments: w - the widget.
 *  Returns: none.
 */

static void Resize(w)
Widget w;
{


#ifdef DEBUG
  fprintf (stderr, "Resize: %d, %d\n", w->core.width, w->core.height);
#endif

}

#define _NMAGIC 32768
/*
 * XwCollBoundingBox: calculate a bounding box (widget)
 */

XwCollBoundingBox (w, flag)
Widget w;
int flag;
{

  XedwListWidget ilw = (XedwListWidget) w;
  short done = 0;
  long lheight;

  if (ilw->xedwList.force_cols) {
    ilw->xedwList.ncols = ilw->xedwList.default_cols;
    if (ilw->xedwList.ncols <= 0) ilw->xedwList.ncols = 1;
    /* 12/3 = 4 and 10/3 = 4, but 9/3 = 3 */

    goto check_maximum_size; /* hack to fix maximum size */
    ilw->xedwList.nrows = ( ( ilw->xedwList.nitems - 1) / 
				ilw->xedwList.ncols) + 1 ;

    ilw->xedwList.min_width = ilw->xedwList.ncols * ilw->xedwList.col_width
        + 2 * ilw->xedwList.internal_width;
    ilw->xedwList.min_height = (ilw->xedwList.nrows * ilw->xedwList.row_height)
        + 2 * ilw->xedwList.internal_height;
    return;
   }

    if (ilw->core.width == 0)
       ilw->xedwList.ncols = ilw->xedwList.default_cols;
    else
       ilw->xedwList.ncols = ((ilw->core.width - 2 * ilw->xedwList.internal_width)
                           / ilw->xedwList.col_width);


check_maximum_size:
    if (ilw->xedwList.ncols <= 0) ilw->xedwList.ncols = 1;

    /* The next is a fix which needs to be improved                     */
    /* Strange things happen after reaching the magic number 2**16 - 1  */
    /* It might be a bug inside the X window system or Motif            */
    
    while (!done) {
      ilw->xedwList.min_width = ilw->xedwList.ncols * ilw->xedwList.col_width
        + 2 * ilw->xedwList.internal_width;

      ilw->xedwList.nrows = ((ilw->xedwList.nitems - 1) / ilw->xedwList.ncols) 
				+ 1 ;
      lheight =  
      ((long) ilw->xedwList.nrows * ilw->xedwList.row_height)
        + 2 * ilw->xedwList.internal_height;

      if (lheight > _NMAGIC)
         ilw->xedwList.min_height = _NMAGIC - 1;
      else
         ilw->xedwList.min_height = (Dimension) lheight;



      if (ilw->xedwList.ncols >= ilw->xedwList.nitems)
         done++;
      else if (lheight >= _NMAGIC)
         ilw->xedwList.ncols++;  /* increase the number of columns    */
         			 /* to reduce the height.             */
         			 /* Don't pay attention to fit_parent */
      else
      	 done++;
    }
    

}

/*
 * XedwItemTranslate: translate an item
 */

XedwItemTranslate (item, dx, dy)
_ITEM *item;
short dx;
short dy;
{
	item->item_x += dx;
	item->item_y += dy;
	item->item_label_x += dx;
	item->item_label_y += dy;
}

/*
 * XedwItemCompare: compare two items based on their coordinates
 */

int XedwItemCompare (item1, item2)
_ITEM *item1, *item2;
{
   if (item1->item_y < item2->item_y)
	return (-1);
   if (item1->item_y > item2->item_y)
	return (1);
   return (item1->item_x - item2->item_x);
}
	
/*
 * XedwItemBoundingBox: given an item, calculate its bounding box
 */

XedwItemBoundingBox (w, item, x, y, width, height)
Widget w;
_ITEM *item;
int *x, *y, *width, *height;
{
  XedwListWidget ilw = ( XedwListWidget ) w;
  register XFontStruct *font;

        font = ilw->xedwList.font;

        if (ilw->xedwList.show_icons)
           *height = font->max_bounds.ascent + font->max_bounds.descent +
                             ilw->xedwList.icon_height;
        else
           *height = font->max_bounds.ascent + font->max_bounds.descent;

           if (ilw->xedwList.show_icons) {
                *x = min(item->item_x,item->item_label_x);
                *y = item->item_y;
		*width = max(item->item_label_width,ilw->xedwList.icon_width);
           } else {
                *x = item->item_label_x;
                *y = item->item_label_y - font->max_bounds.ascent;
                *width = item->item_label_width;
           }

}



/*  Function Name: Notify
 *  Description: Notifies the user that a button has been pressed, and
 *               calles the callback, if the XtNpasteBuffer resource
 *               is true then the name of the item is also put in the
 *               X cut buffer ( buf (0) ).
 *  Arguments: w - the widget that the notify occured in.
 *             event - event that caused this notification.
 *             params, num_params - not used.
 *  Returns: none.
 */

static void Notify(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
  XedwListWidget ilw = ( XedwListWidget ) w;
  _SimpleList *hl = ilw->xedwList.xedw_h_lst;
  XedwCallbackStruct cbs;
  register Display *disp = XtDisplay (w);

  int item_len;
  _ITEM *item, *rec;
  int dx, dy, x, y, width, height;
  int min_x, min_y, max_x, max_y;
  register Window window = XtWindow (ilw);

   XUndefineCursor (display, window);

   if (ilw->xedwList.xedw_state & XedwRubberBox) {

	x = ilw->xedwList.xedw_loc_x;
	y = ilw->xedwList.xedw_loc_y;
        width = ilw->xedwList.xedw_drag_x - ilw->xedwList.xedw_loc_x;
        height = ilw->xedwList.xedw_drag_y - ilw->xedwList.xedw_loc_y;

        if (width != 0 || height != 0) {
                if (width < 0) {
                        x += width;
                        width = -width;
                }
                if (height < 0) {
                        y += height;
                        height = -height;
                }
                XDrawRectangle(XtDisplay(ilw), XtWindow(ilw),
                ilw->xedwList.xorgc ,
                x, y, width, height);
        }

        item = (_ITEM *) _SListFirst (hl);
        while (item) {
           if (IsInRubberBox(item)) {
		item->item_stat &= ~_ItemInRubberBox;
		item->item_stat |= _ItemHighlighted;
	   }

           item = (_ITEM *) _SListNext (hl);

	}
	XUngrabServer (display);

	ilw->xedwList.xedw_state = XedwIdle;
    	XtCallCallbacks(w, XtNcallback, (caddr_t) 0);
	return;
   }
   if (ilw->xedwList.xedw_state & XedwPickingItem) {
	ilw->xedwList.xedw_state = XedwIdle;
    	XtCallCallbacks(w, XtNcallback, (caddr_t) 0);
	return;
   }

   if (ilw->xedwList.xedw_state & XedwReadyToDrop) {

	if (*num_params) {
#ifdef DEBUG
	   fprintf (stderr, "%s\n", params[0]);
#endif
	   if (*num_params == 2) {
		cbs.reason = XedwCR_INTERNAL_LINK;
#ifdef DEMO
                _XmCErrorDialogPost (w, 
		"Link creation has been disable in this demo version", "Error");
		goto out1; /* for now */
#endif
	   } else if (!strcmp (params[0], "Shift"))
		cbs.reason = XedwCR_INTERNAL_MOVE;
	   else if (!strcmp (params[0], "Ctrl")) {
		cbs.reason = XedwCR_INTERNAL_COPY;
#ifdef DEMO
                _XmCErrorDialogPost (w, 
		"Copy has been disable in this demo version", "Error");
		goto out1; /* for now */
#endif
 
	   }

	} else
	   cbs.reason = XedwCR_INTERNAL_MOVE;

        cbs.event = event;
        cbs.xedw_h_item = NULL;
        cbs.xedw_h_lst = ilw->xedwList.xedw_h_lst;
        cbs.xedw_receptor = ilw->xedwList.xedw_receptor;

  	XtCallCallbacks (w, XtNdrop, &cbs);

out1:
	rec = ilw->xedwList.xedw_receptor;
	rec->item_stat &= ~_ItemReceptor;
        PaintItemName(w, rec);
        ilw->xedwList.xedw_receptor = NULL;
        ilw->xedwList.xedw_state = XedwIdle;
   }

   if (ilw->xedwList.xedw_state & XedwCheckDoubleClick ) {
#ifdef DEBUG
	fprintf (stderr, "time = %ld, %ld\n", event->xbutton.time - ilw->xedwList.xedw_tm_stamp, XtGetMultiClickTime(XtDisplay(w)));
#endif
	ilw->xedwList.xedw_state = XedwIdle;
        if (event->xbutton.time - ilw->xedwList.xedw_tm_stamp <= XtGetMultiClickTime(XtDisplay(w))) {

  	   if ((item = CvtToItem(w, event->xbutton.x, event->xbutton.y)) == NULL ||
  		ilw->xedwList.xedw_h_item != item)
		return;

      	   XedwAListUnhighlight(w);  /* Unhighlight the rest */
	   XedwListHighlight((Widget) w, item);
	   ilw->xedwList.xedw_h_item = item; /* careful */
#ifdef DEBUG
	   fprintf (stderr, "Double Click %s\n", item->item_label);
#endif

	   cbs.reason = XedwCR_DOUBLE_CLICK;
	   cbs.event = event;
	   cbs.xedw_h_item = ilw->xedwList.xedw_h_item;
	   cbs.xedw_h_lst = NULL;
	   cbs.xedw_receptor = NULL;
   	   XDefineCursor(XtDisplay(ilw),
        	XtWindow(ilw), ilw->xedwList.wait_cursor);
	   XSync (XtDisplay(ilw), False);
  	   XtCallCallbacks (w, XtNdoubleClick, &cbs);
	   XUndefineCursor (display, XtWindow(ilw));
	   XSync (XtDisplay(ilw), False);
	   return;
	}
   }


   if (ilw->xedwList.xedw_state & XedwDraggingItem) {
	ilw->xedwList.xedw_state = XedwIdle;

        if (!activeWindow) { /* cursor left this window */
                             /* try to drop somewhere else */


#ifdef DEMO
           if (*num_params) {
           if (*num_params == 2) {
                _XmCErrorDialogPost (w,
                "Link creation has been disable in this demo version", "Error");
                goto out2;
           } else if (!strcmp (params[0], "Ctrl")) {
                _XmCErrorDialogPost (w,
                "Copy has been disable in this demo version", "Error");
                goto out2;

           }
	   }
#endif

           XtCallActionProc (ilw,
                        "DropAction", event, params, *num_params);
out2:
           XUndefineCursor (display, window);

    	   XSync (display, False);
    	   XtCallCallbacks(w, XtNcallback, (caddr_t) 0);
	   /* This callback might be redundant */
	   /* since we are not sure that the   */
	   /* selection has changed            */
	   
           return;
        }

	if (ilw->xedwList.layout_policy == XedwSTATIC) {
    	   XtCallCallbacks(w, XtNcallback, (caddr_t) 0);
	   /* see note above */
	   return;
	}

	dx = ilw->xedwList.xedw_drag_x - ilw->xedwList.xedw_loc_x;
	dy = ilw->xedwList.xedw_drag_y - ilw->xedwList.xedw_loc_y;


	if (abs(dx) <= XedwEps && abs(dy) <= XedwEps) {
    	   XtCallCallbacks(w, XtNcallback, (caddr_t) 0);
	   /* see note above */
	   return;
	}

	if (abs(dx) > XedwEps || abs(dy) > XedwEps) {

        item = (_ITEM *) _SListFirst (hl);

#ifdef DEBUG
	if (!item)
	   fprintf (stderr, "item NULL\n");
#endif

	max_x = max_y = 0;
	min_x = min_y = INFINITE;

        while (item) {

	   XedwItemBoundingBox (w, item, &x, &y, &width, &height);

	   if (dx > 0)
		max_x = max (max_x, x + width - 1 + dx);
	   else
		min_x = min (min_x, x + dx);

           if (dy > 0)
                max_y = max (max_y, y + height - 1 + dy);
           else
                min_y = min (min_y, y + dy);


           item = (_ITEM *) _SListNext (hl);
	}

	if (dx > 0) {
	   if (ilw->core.width <= max_x) {
		dx -= (max_x - ilw->core.width + 1);
		max_x = ilw->core.width - 1;
	   }
	   
	} else
	   if (min_x < 0)
		dx -= min_x;

        if (dy > 0) {
           if (ilw->core.height <= max_y)
                dy -= (max_y - ilw->core.height + 1);
		max_y = ilw->core.height - 1;
        } else
           if (min_y < 0)
                dy -= min_y;

	if (max_x > ilw->xedwList.min_width)
		ilw->xedwList.min_width = max_x;

	if (max_y > ilw->xedwList.min_height)
		ilw->xedwList.min_height = max_y;

	if (abs(dx) <= XedwEps && abs(dy) <= XedwEps) {
    	   XtCallCallbacks(w, XtNcallback, (caddr_t) 0);
	   /* see note above */
	   return;
	}

        item = (_ITEM *) _SListFirst (hl);
        while (item) {

	  /*
	   * Update Screen
	   */


	   XedwItemBoundingBox (w, item, &x, &y, &width, &height);

	   XClearArea (XtDisplay(w), XtWindow(w), x, y, width,
		height, True);

	   XedwItemTranslate (item, dx, dy);

	  /*
	   * Relink Item
	   */

	   _ListReinsertO (ilw->xedwList.xedw_item_lst, (char *) item,
				XedwItemCompare);

	  /*
           * Update bounding box
	   */

   	   PaintItemName(w, item);
           item = (_ITEM *) _SListNext (hl);
	  }
	}	
    	XtCallCallbacks(w, XtNcallback, (caddr_t) 0);
	/* see note above */
	return;
   }
		

  return; 
out:

  if ((item = CvtToItem(w, event->xbutton.x, event->xbutton.y)) == NULL ||
  	ilw->xedwList.xedw_h_item != item) { 

    if (ilw->xedwList.xedw_h_item)
    	XedwListUnhighlight(w, ilw->xedwList.xedw_h_item);
    XtCallCallbacks(w, XtNcallback, (caddr_t) 0);
    return;
  }

#ifdef NEXT_VERSION
  /* Put the name of ALL highlighted strings into the X cut buffer,
   * separated by spaces.

  item_len = 0;
  while(list != NULL) {
    item_len +=  strlen(ilw->xedwList.xedwList[list.index]->string) + 1;
      list=list->next;
  }

  */
#endif

  item_len = strlen (item->item_label);


  if ( ilw->xedwList.paste )   /* if XtNpasteBuffer set then paste it. */
    {
      XStoreBytes(XtDisplay(w), item->item_label, item_len);
      {
#if NeedFunctionPrototypes
        static void selection_set_buffer(Widget, String);
#else
        static void selection_set_buffer();
#endif

        selection_set_buffer(w, item->item_label);

      }
    }

}

/*  Function Name: Unset
 *  Description: unhighlights the current elements.
 *  Arguments: w - the widget that the event occured in.
 *                 event - not used.
 *                 params, num_params - not used.
 *  Returns: none.
 */

static void Unset(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
  XedwAListUnhighlight (w);
}

/* An action routine that gets called when PointerMotion events arrive. If a
   piece is being dragged update its position */

static void drag_item (w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
  _ITEM *item, *rec;
  XedwListWidget ilw = (XedwListWidget) w;


#ifdef DEBUG
   fprintf (stderr, "%d %d\n", event->xmotion.x, event->xmotion.y);
#endif
   if (!(ilw->xedwList.xedw_state&XedwCheckDoubleClick ||
		ilw->xedwList.xedw_state & XedwRubberBox))
        if (!activeWindow) /* cursor left this window */
                           /* try to drop somewhere else */
		XtCallActionProc (ilw,
                        "rddDragAction", event, params, num_params);
	


   if (ilw->xedwList.xedw_state & XedwReadyToDrop) {

    rec = ilw->xedwList.xedw_receptor;

    if (!rec) { /* just in case */
	ilw->xedwList.xedw_state = XedwDraggingItem;
        return;
    }
    if ( (item = CvtToItem(w, event->xmotion.x, event->xmotion.y))
        == NULL) {
     	rec->item_stat &= ~_ItemReceptor;
     	PaintItemName(w, rec);
     	ilw->xedwList.xedw_receptor = NULL;
	ilw->xedwList.xedw_state = XedwDraggingItem;
        return;
    }

    if (item == rec)
	return;

    if (IsHighlighted(item)) { 
    	rec->item_stat &= ~_ItemReceptor;
     	ilw->xedwList.xedw_receptor = NULL;
    	PaintItemName(w, rec);
	ilw->xedwList.xedw_state = XedwDraggingItem;
	return;
    }
    
    rec->item_stat &= ~_ItemReceptor;
    PaintItemName(w, rec);
    ilw->xedwList.xedw_receptor = item;

    item->item_stat |= _ItemReceptor;
    PaintItemName(w, item);
    
    return;

   }
   if (ilw->xedwList.xedw_state & XedwPickingItem) {
        Display *disp = XtDisplay(ilw);

	ilw->xedwList.xedw_state = XedwDraggingItem;
	
	/* Following line might be removed */
        XDefineCursor(XtDisplay(ilw), XtWindow(ilw), ilw->xedwList.move_cursor);
	XChangeActivePointerGrab (XtDisplay(ilw),
	ButtonPressMask|ButtonReleaseMask|EnterWindowMask|LeaveWindowMask|
	PointerMotionMask|Button1MotionMask|
	Button2MotionMask|Button3MotionMask|Button4MotionMask|
	Button5MotionMask|ButtonMotionMask|KeymapStateMask, 
	ilw->xedwList.move_cursor,
	CurrentTime);
        XSync (XtDisplay(ilw), False);

	ilw->xedwList.xedw_drag_x = event->xmotion.x;
	ilw->xedwList.xedw_drag_y = event->xmotion.y;

        if ( (item = CvtToItem(w, event->xmotion.x, event->xmotion.y))
        == NULL || IsHighlighted (item))
	return;

       /*
        * If item accepts drops, Recursive ?
        */

        ilw->xedwList.xedw_state = XedwReadyToDrop;
        ilw->xedwList.xedw_receptor = item;

        item->item_stat |= _ItemReceptor;
        PaintItemName(w, item);
    
        return;
   }

   if (ilw->xedwList.xedw_state & XedwCheckDoubleClick )
        if (event->xmotion.time - ilw->xedwList.xedw_tm_stamp <= XtGetMultiClickTime(XtDisplay(w)))
	   return;
	else {
     	   ilw->xedwList.xedw_state = XedwDraggingItem;
     	   /* The next line might not be needed */
           XDefineCursor(XtDisplay(ilw), XtWindow(ilw), ilw->xedwList.move_cursor);

	   XChangeActivePointerGrab (XtDisplay(ilw),
	   ButtonPressMask|ButtonReleaseMask|EnterWindowMask|LeaveWindowMask|
	   PointerMotionMask|Button1MotionMask|
	   Button2MotionMask|Button3MotionMask|Button4MotionMask|
	   Button5MotionMask|ButtonMotionMask|KeymapStateMask, 
	   ilw->xedwList.move_cursor,
	   CurrentTime);

           XSync (XtDisplay(ilw), False);

	   /* test this */
           if (!activeWindow) /* cursor left this window */
                              /* try to drop somewhere else */
	      XtCallActionProc (ilw, 
                        "rddDragAction", event, params, num_params);
	}

	
   if (ilw->xedwList.xedw_state & XedwRubberBox) {

   int x, y, width, height;


	x = ilw->xedwList.xedw_loc_x;
	y = ilw->xedwList.xedw_loc_y;
        width = ilw->xedwList.xedw_drag_x - ilw->xedwList.xedw_loc_x;
        height = ilw->xedwList.xedw_drag_y - ilw->xedwList.xedw_loc_y;

	if (width != 0 || height != 0) {
		if (width < 0) {
			x += width;
			width = -width;
		}
		if (height < 0) {
			y += height;
			height = -height;
		}
        	XDrawRectangle(XtDisplay(ilw), XtWindow(ilw), 
		ilw->xedwList.xorgc , 
		x, y, width, height);
	}


	ilw->xedwList.xedw_drag_x = event->xmotion.x;
	ilw->xedwList.xedw_drag_y = event->xmotion.y;
	x = ilw->xedwList.xedw_loc_x;
	y = ilw->xedwList.xedw_loc_y;

        width = ilw->xedwList.xedw_drag_x - ilw->xedwList.xedw_loc_x;
        height = ilw->xedwList.xedw_drag_y - ilw->xedwList.xedw_loc_y;

        if (width != 0 || height != 0) {
                if (width < 0) {
                        x += width;
                        width = -width;
                }
                if (height < 0) {
                        y += height;
                        height = -height;
                }
		XedwItemsInRubberBox (w, x, y, width, height);
                XDrawRectangle(XtDisplay(ilw), XtWindow(ilw),
                ilw->xedwList.xorgc ,
                x, y, width, height);
        }


   return;
   }
   if (ilw->xedwList.xedw_state & XedwDraggingItem) {

	XChangeActivePointerGrab (XtDisplay(ilw),
	ButtonPressMask|ButtonReleaseMask|EnterWindowMask|LeaveWindowMask|
	PointerMotionMask|Button1MotionMask|
	Button2MotionMask|Button3MotionMask|Button4MotionMask|
	Button5MotionMask|ButtonMotionMask|KeymapStateMask, 
	ilw->xedwList.move_cursor,
	CurrentTime);

	ilw->xedwList.xedw_drag_x = event->xmotion.x;
	ilw->xedwList.xedw_drag_y = event->xmotion.y;

        if (!activeWindow) { /* cursor left this window */
	   return;
        }

        if ( (item = CvtToItem(w, event->xmotion.x, event->xmotion.y))
        == NULL || IsHighlighted (item))
           return;

       /*
        * If item accepts drops, Recursive ?
        */

       ilw->xedwList.xedw_state = XedwReadyToDrop;
       ilw->xedwList.xedw_receptor = item;

       item->item_stat |= _ItemReceptor;
       PaintItemName(w, item);

	
       return;
   }


}

/*  Function Name: Set
 *  Description: Highlights the current element.
 *  Arguments: w - the widget that the event occured in.
 *                 event - event that caused this notification.
 *                 params, num_params - not used.
 *  Returns: none.
 */

static void Set(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
  _ITEM *item;
  XedwListWidget ilw = (XedwListWidget) w;
#ifdef DEBUG
  fprintf (stderr, "set\n");
#endif

  item = CvtToItem(w, event->xbutton.x, event->xbutton.y);

  if (event->xbutton.button == Button3) {
    if (!item) {
        XedwAListUnhighlight(w);
        ilw->xedwList.xedw_h_item = NULL;
    	XtCallCallbacks(w, XtNcallback, (caddr_t) 0);
    	return;
    }
    if (IsHighlighted(item)) {
    	ilw->xedwList.xedw_h_item = item;
    	ilw->xedwList.xedw_state = XedwIdle;
    } else {
        XedwAListUnhighlight(w);  /* Unhighlight all the items */
	XedwListHighlight(w, item);         /* highlight it */
    	ilw->xedwList.xedw_state = XedwIdle;	
    	XtCallCallbacks(w, XtNcallback, (caddr_t) 0);
    }
    return;
  }

  if (!item) {
    XGrabServer (display); 

    XedwAListUnhighlight(w);
    ilw->xedwList.xedw_h_item = NULL;
    ilw->xedwList.xedw_state = XedwRubberBox;
    ilw->xedwList.xedw_drag_x = ilw->xedwList.xedw_loc_x = event->xbutton.x;
    ilw->xedwList.xedw_drag_y = ilw->xedwList.xedw_loc_y = event->xbutton.y;

    return;
  }
#ifdef DEBUG
    fprintf (stderr, "set not NULL\n");
#endif

    if (item == ilw->xedwList.xedw_h_item) {
#ifdef DEBUG
	fprintf (stderr, "time = %ld, %ld\n", event->xbutton.time - ilw->xedwList.xedw_tm_stamp, XtGetMultiClickTime(XtDisplay(w)));
#endif
        if (event->xbutton.time - ilw->xedwList.xedw_tm_stamp <= XtGetMultiClickTime(XtDisplay(w))) {
    		ilw->xedwList.xedw_state = XedwCheckDoubleClick;
    		ilw->xedwList.xedw_drag_x = ilw->xedwList.xedw_loc_x = event->xbutton.x;
    		ilw->xedwList.xedw_drag_y = ilw->xedwList.xedw_loc_y = event->xbutton.y;
		return;
	}
    }

    if (IsHighlighted(item)) {
	Display *disp = XtDisplay(ilw);    	
        ilw->xedwList.xedw_h_item = item;
    	ilw->xedwList.xedw_state = XedwDraggingItem;

#ifdef OLD
	/* The next line is not needed */
        XDefineCursor(XtDisplay(ilw), XtWindow(ilw), ilw->xedwList.move_cursor);
	XChangeActivePointerGrab (XtDisplay(ilw),
	ButtonPressMask|ButtonReleaseMask|EnterWindowMask|LeaveWindowMask|
	PointerMotionMask|Button1MotionMask|
	Button2MotionMask|Button3MotionMask|Button4MotionMask|
	Button5MotionMask|ButtonMotionMask|KeymapStateMask, 
	ilw->xedwList.move_cursor,
	CurrentTime);
        XSync (XtDisplay(ilw), False);
#endif

    	ilw->xedwList.xedw_drag_x = ilw->xedwList.xedw_loc_x = event->xbutton.x;
    	ilw->xedwList.xedw_drag_y = ilw->xedwList.xedw_loc_y = event->xbutton.y;
    	ilw->xedwList.xedw_tm_stamp = event->xbutton.time;
    	XtCallActionProc (ilw,
                        "StartAction", event, params, num_params);
        return;
    }


    XedwAListUnhighlight(w);  /* Unhighlight all the items */

    
    XedwListHighlight(w, item);         /* highlight it */
    ilw->xedwList.xedw_h_item = item; 
    ilw->xedwList.xedw_state = XedwPickingItem;
    ilw->xedwList.xedw_drag_x = ilw->xedwList.xedw_loc_x = event->xbutton.x;
    ilw->xedwList.xedw_drag_y = ilw->xedwList.xedw_loc_y = event->xbutton.y;
    ilw->xedwList.xedw_tm_stamp = event->xbutton.time;

    XtCallActionProc (ilw,
                        "StartAction", event, params, num_params);

}

/*  Function Name: MultipleSet
 *  Description: Highlights the current element.
 *  Arguments: w - the widget that the event occured in.
 *                 event - event that caused this notification.
 *                 params, num_params - not used.
 *  Returns: none.
 */

static void MultipleSet(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
  _ITEM *item;
  XedwListWidget ilw = (XedwListWidget) w;

  if (ilw->xedwList.multiple == True) {
    if ( (item = CvtToItem(w, event->xbutton.x, event->xbutton.y))
        != NULL) {
      if (IsHighlighted(item))
        XedwListUnhighlight(w, item);   /* unhighlight it */
      else
       XedwListHighlight(w, item);     /* otherwise highlight it */
      XtCallCallbacks(w, XtNcallback, (caddr_t) 0);
    }
  } else
    XBell(XtDisplay(w), 100);

}

/*
 * Destroy an item
 */

static int terminator (iptr)
register char *iptr;
{
   XtFree (((_ITEM *) iptr)->item_label);
   ((_ITEM *) iptr)->item_label = NULL;
}

/*
 * XedwListUnhighlight: unhighlight item
 */

void XedwListUnhighlight(w, item)
     Widget w;
     _ITEM *item;
{
  XedwListWidget ilw = ( XedwListWidget ) w;
  _SimpleList *hl = ilw->xedwList.xedw_h_lst;


   if (!(item->item_stat & _ItemHighlighted)) {  
#ifdef HDEBUG
	fprintf (stderr, "XedwListUnhighlight: Item (%s) already highlighted\n",
			item->item_label);
#endif
      	return;
   }

   if (ilw->xedwList.xedw_h_item == item)
        ilw->xedwList.xedw_h_item = NULL; /* careful */

   item->item_stat &= ~_ItemHighlighted;
   PaintItemName(w, item);
   _SListUnlink(hl, (_ELEM *) item);
}

/*
 * XedwAListUnhighlight: unhighlight all items
 */

void XedwAListUnhighlight(w)
     Widget w;
{
  XedwListWidget ilw = ( XedwListWidget ) w;
  _SimpleList *hl = ilw->xedwList.xedw_h_lst;
  _ITEM *item, *tmp;

#ifdef DEBUG
      fprintf (stderr, "XedwAListUnhighlight\n");
#endif
      ilw->xedwList.xedw_h_item = NULL; /* careful */

      item = (_ITEM *) _SListFirst (hl);
      while (item) {

	item->item_stat &= ~_ItemHighlighted;
#ifdef DEBUG
        fprintf (stderr, "UnHighlight item %s\n", item->item_label);
#endif
        PaintItemName(w, item);
	tmp = item;
        item = (_ITEM *) _SListNext (hl); 
      	_SListUnlink(hl, tmp);
     }
}


/*  Function Name: XedwListHighlight
 *  Description: Highlights the given item.
 *  Arguments: w - the xedwList widget.
 *             item - the item to hightlight.
 *  Returns: none.
 */

void XedwListHighlight(w, item)
     Widget w;
     _ITEM *item;
{
  XedwListWidget ilw = ( XedwListWidget ) w;
  _SimpleList *hl = ilw->xedwList.xedw_h_lst;

	kk = hl;

#ifdef DEBUG
   fprintf (stderr, "Highlight item %s\n", item->item_label);
#endif
   if (XtIsSensitive(w)) {

	if (item->item_stat & _ItemHighlighted)
      	   return;

	item->item_stat |= _ItemHighlighted;
      	_SListAppend(hl, item);
        PaintItemName(w, item);
  }
}

/*
 * XwCollHighlightAll: highlight all items
 */

void XwCollHighlightAll(w) 
     Widget w;
{
  XedwListWidget ilw = ( XedwListWidget ) w;
  _SimpleList *hl = ilw->xedwList.xedw_h_lst;
  _LST *lst = ilw->xedwList.xedw_item_lst;
  _ITEM *item;

   if (XtIsSensitive(w)) {
      item = (_ITEM *) _ListFirst (lst);
      while (item) {

	if (item->item_stat & _ItemHighlighted) {
           item = (_ITEM *) _ListNext (ilw->xedwList.xedw_item_lst);
      	   continue; 
	}

	item->item_stat |= _ItemHighlighted;
      	_SListAppend(hl, item);
        PaintItemName(w, item);
        item = (_ITEM *) _ListNext (lst);
     }
  }
}

/* The following stuff is stolen from xcutsel. Actually, it IS
 * xcutsel.c */
/*
 * Author:  Ralph Swick, DEC/Project Athena
 */


static String selection_value;
static Atom selection_atom=0;

static Boolean ConvertSelection(w, selection, target,
                                type, value, length, format)
     Widget w;
     Atom *selection, *target, *type;
     caddr_t *value;
     unsigned long *length;
     int *format;
{
    Display* d = XtDisplay(w);
    XSelectionRequestEvent* req =
        XtGetSelectionRequest(w, *selection, (XtRequestId)NULL);

    if (*target == XA_TARGETS(d)) {
        Atom* targetP;
        Atom* std_targets;
        unsigned long std_length;
        XmuConvertStandardSelection(w, req->time, selection, target, type,
                                   (caddr_t*)&std_targets, &std_length, format);
        *value = XtMalloc(sizeof(Atom)*(std_length + 4));
        targetP = *(Atom**)value;
        *length = std_length + 4;
        *targetP++ = XA_STRING;
        *targetP++ = XA_TEXT(d);
        *targetP++ = XA_LENGTH(d);
        *targetP++ = XA_LIST_LENGTH(d);
        bcopy((char*)std_targets, (char*)targetP, sizeof(Atom)*std_length);
        XtFree((char*)std_targets);
        *type = XA_ATOM;
        *format = 32;
        return True;
    }
    if (*target == XA_STRING || *target == XA_TEXT(d)) {
        *type = XA_STRING;
        *value = selection_value;
        *length = strlen(selection_value);
        *format = 8;
        return True;
    }
    if (*target == XA_LIST_LENGTH(d)) {
        long *temp = (long *) XtMalloc (sizeof(long));
        *temp = 1L;
        *value = (caddr_t) temp;
        *type = XA_INTEGER;
        *length = 1;
        *format = 32;
        return True;
    }
    if (*target == XA_LENGTH(d)) {
        long *temp = (long *) XtMalloc (sizeof(long));
        *temp = strlen(selection_value);
        *value = (caddr_t) temp;
        *type = XA_INTEGER;
        *length = 1;
        *format = 32;
        return True;
    }
    if (XmuConvertStandardSelection(w, req->time, selection, target, type,
                                    value, length, format))
        return True;

    /* else */
    return False;
}

static void LoseSelection(w, selection)
    Widget w;
    Atom *selection;
{
    XtFree((char *)selection_value );
    selection_value = NULL;
}

static void selection_set_buffer(w,string)
    Widget w;
    String string;
{
    static char * name="PRIMARY";
    if (selection_atom==0)
     XmuInternStrings( XtDisplay(w), &name, ONE,
                      &selection_atom );
    XtFree((char *)selection_value );
    selection_value=XtNewString(string);
    XtOwnSelection(w, selection_atom,
                           XtLastTimestampProcessed(XtDisplay(w)),
                           ConvertSelection, LoseSelection, NULL);
}


/*
 * XedwListSelection - return false if nothing has been selected
 */

Boolean XedwListSelection(w)
Widget w;
{
  XedwListWidget ilw = ( XedwListWidget ) w;
  _SimpleList *hl = ilw->xedwList.xedw_h_lst;


  return(!_SListEmpty(hl));
}

/*
 * XwCollSort - sort items 
 */

XwCollSort (w, cmp)
Widget w;
int (*cmp) ();
{
   XedwAListUnhighlight(w); 
   _ListSort (((XedwListWidget)w)->xedwList.xedw_item_lst, cmp);
   XedwItemsInit ((Widget) w);
   XClearArea (XtDisplay(w), XtWindow(w), 0, 0, 0, 0, True);
}

/*
 * eprint: print item
 */

eprint (e1)
_ITEM *e1;
{
#ifdef DEBUG
   fprintf (stderr, "eprint: %s\n", e1->item_label);
#endif
}

/*
 * ncmp: compare items based on name
 */

int ncmp (e1, e2)
_ITEM *e1, *e2;
{
   return (strcmp (e1->item_name, e2->item_name));
}

#include "move_mask.bitmap"
#include "move_cursor.bitmap"
#include "point_mask.bitmap"
#include "wait_cursor.bitmap"
#include "wait_mask.bitmap"

/***********************************************************************\
 * Utility Routines
\***********************************************************************/
static void
CreateCursors(cbw)
XedwListWidget cbw;
{
    Display *dpy = XtDisplay((Widget) cbw);
    Window  win = RootWindowOfScreen(XtScreen((Widget) cbw));
    Pixmap tmp1, tmp2;
    XColor  fg, bg;

    bg.red   = 0xffff;
    bg.green = 0xffff;
    bg.blue  = 0xffff;
    bg.flags = DoRed | DoGreen | DoBlue;

    fg.red   = 0;
    fg.green = 0;
    fg.blue  = 0;
    fg.flags = DoRed | DoGreen | DoBlue;

    cbw->xedwList.move_cursor = 
      XCreatePixmapCursor(dpy,
			  tmp1 = XCreateBitmapFromData(dpy, win, move_cursor_bits,
						move_cursor_width,
						move_cursor_height),
			  tmp2 = XCreateBitmapFromData(dpy, win, move_mask_bits,
						move_mask_width,
						move_mask_height),
			  &fg, &bg,
			  move_cursor_x_hot, move_cursor_y_hot);
    XFreePixmap(dpy, tmp1);
    XFreePixmap(dpy, tmp2);
    cbw->xedwList.wait_cursor =
      XCreatePixmapCursor(dpy,
                          tmp1 = XCreateBitmapFromData(dpy, win, wait_cursor_bits,
                                                wait_cursor_width,
                                                wait_cursor_height),
                          tmp2 = XCreateBitmapFromData(dpy, win, wait_mask_bits,
                                                wait_mask_width,
                                                wait_mask_height),
                          &fg, &bg,
                          wait_cursor_x_hot, wait_cursor_y_hot);
    XFreePixmap(dpy, tmp1);
    XFreePixmap(dpy, tmp2);

}


/*
 * XwCollSetValues: Set resource values
 */

static Boolean XwCollSetValues(current, request, new)
Widget current, request, new;
{
  XedwListWidget cl = (XedwListWidget) current;
  XedwListWidget rl = (XedwListWidget) request;
  XedwListWidget nl = (XedwListWidget) new;
  Boolean redraw = FALSE;
  Dimension width, height;

  /* Update number of items */

  nl->xedwList.nitems = _ListLength(nl->xedwList.xedw_item_lst);

  if ((cl->xedwList.foreground != rl->xedwList.foreground) ||
      (cl->core.background_pixel != rl->core.background_pixel) ||
      (cl->xedwList.font != rl->xedwList.font) ) {
    XtReleaseGC(current, cl->xedwList.normgc);
    XtReleaseGC(current, cl->xedwList.graygc);
    XtReleaseGC(current, cl->xedwList.revgc);
    GetGCs ((Widget) nl);
    redraw = TRUE;
  }

  /* Reset row height. */

  if ((cl->xedwList.row_space != rl->xedwList.row_space) ||
      (cl->xedwList.font != rl->xedwList.font)           ||
      (cl->xedwList.show_icons != rl->xedwList.show_icons) ||
      (cl->xedwList.icon_width != rl->xedwList.icon_width)           ||
      (cl->xedwList.icon_height != rl->xedwList.icon_height))
    if (rl->xedwList.show_icons)
      nl->xedwList.row_height = nl->xedwList.font->max_bounds.ascent
        + nl->xedwList.font->max_bounds.descent
        + nl->xedwList.row_space
        + nl->xedwList.icon_height;
    else
      nl->xedwList.row_height = nl->xedwList.font->max_bounds.ascent
        + nl->xedwList.font->max_bounds.descent
        + nl->xedwList.row_space;


    if ((cl->xedwList.internal_width != nl->xedwList.internal_width)   ||
      (cl->xedwList.internal_height != nl->xedwList.internal_height) ||
      (cl->xedwList.column_space != nl->xedwList.column_space)       ||
      (cl->xedwList.row_space != nl->xedwList.row_space)             ||
      (cl->xedwList.default_cols != nl->xedwList.default_cols)       ||
      ((cl->xedwList.force_cols != nl->xedwList.force_cols) &&
       (nl->xedwList.force_cols != nl->xedwList.ncols))           ||
      (cl->xedwList.vertical_cols != nl->xedwList.vertical_cols)     ||
      (cl->xedwList.nitems != nl->xedwList.nitems)                   ||
      (cl->xedwList.font != nl->xedwList.font)                       ||
      (cl->xedwList.show_icons != nl->xedwList.show_icons)           ||
      (cl->xedwList.icon_width != nl->xedwList.icon_width)           ||
      (cl->xedwList.icon_height != nl->xedwList.icon_height)         ||
      (cl->xedwList.default_icon != nl->xedwList.default_icon)       ||
      (cl->xedwList.xedw_item_lst != nl->xedwList.xedw_item_lst)) {

	redraw = TRUE;

        if (nl->xedwList.fit_parent) {
                XtVaGetValues (XtParent(nl), XtNwidth,
                &width, XtNheight, &height, NULL);
                nl->core.width = width;
                nl->core.height = height;
                DoLayout ((Widget) nl);
	   	redraw = TRUE;
                nl->core.width = max (nl->xedwList.min_width, width);
                nl->core.height = max (nl->xedwList.min_height, height);
                goto out;
        }

	DoLayout ((Widget) nl);
	
        if (nl->core.width == 0) {
           nl->core.width = nl->xedwList.min_width;
	   redraw = FALSE;
	}

	if (nl->core.height == 0) {
           nl->core.height = nl->xedwList.min_height;
	   redraw = FALSE; 
	}
      }

out:
   if (cl->xedwList.xedw_item_lst != nl->xedwList.xedw_item_lst) {
#ifdef DEBUG
        fprintf (stderr, "XwCollSetValues: Free previous list, Redraw = %d\n",
                        redraw);
#endif
        /* Free previous list */

        _ListTraverse (cl->xedwList.xedw_item_lst, terminator);
        _ListDestroy (cl->xedwList.xedw_item_lst);
        /* Start with no highlight items */
        nl->xedwList.xedw_h_item = NULL;
        nl->xedwList.xedw_receptor = NULL;
        _SListReset (nl->xedwList.xedw_h_lst);
        XtCallCallbacks(nl, XtNcallback, (caddr_t) 0);

   }
   return (redraw);
}

/*
 * XwDropEventHandler: drop event handler
 */

static void
XwDropEventHandler(w, client_data, ev)
Widget w;
XtPointer client_data;
XClientMessageEvent *ev;
{
        int nbytes;
        u_char *sdata;
	_ITEM *rec = NULL;
        Display  *disp = XtDisplay (w);
	Window   win = XtWindow (w);
	int xloc = 0, yloc = 0;
	Window child;
   	XedwCallbackStruct cbs;
  	XedwListWidget ilw = ( XedwListWidget ) w;


	if (!rddIsRddMessageEvent(*((XEvent *) ev)))
		return;

	if (ev->data.l[0] & RDD_DRAG_EVENT || ((Window) ev->data.l[1] == win ||
		_XCIsSubWindow (disp, (Window) ev->data.l[1],
			win))) {
           if (!XTranslateCoordinates (disp,
                RootWindow(disp, DefaultScreen(disp)), win,
                (int) ev->data.l[3], (int) ev->data.l[4], &xloc,
                &yloc, &child)) {
                fprintf (stderr,
                        "XwDropEventHandler: XTranslateCoordinates  failed\n");
                return;
           }

	
	   rec = CvtToItem (w, xloc, yloc);
	}
	

	/* there was another one */
	if (ilw->xedwList.xedw_receptor) {
		ilw->xedwList.xedw_receptor->item_stat &= ~_ItemReceptor;
		PaintItemName (w, ilw->xedwList.xedw_receptor);
		ilw->xedwList.xedw_receptor = NULL;
	}
		
        /* check if I can handle drops */
	if (rec) {
	   ilw->xedwList.xedw_receptor = rec;
           rec->item_stat |= _ItemReceptor;
           PaintItemName(w, rec);
	}

	if (ev->data.l[0] & RDD_DRAG_EVENT) {
#ifdef DEBUG
            fprintf (stderr,"GOT DRAG MESSAGE \n");
#endif
	    return;
	}

        nbytes = rddGetSelection (&sdata);

        cbs.reason = XedwCR_EXTERNAL_MOVE;
        cbs.event = (XEvent *) ev;
        cbs.xedw_receptor = rec;
	/* when coming from outside */
        cbs.data        = (caddr_t)sdata;
        cbs.len         = nbytes;
        cbs.type        = (int) ev->data.l[0];
        cbs.from        = (Window) ev->data.l[1];
        cbs.keymask     = (u_int) ev->data.l[2];

        XDefineCursor(disp, win, ilw->xedwList.wait_cursor);
        XSync (disp, False);
        XtCallCallbacks (w, XtNdrop, &cbs);
	XUndefineCursor (display, win);
        XSync (disp, False);

	if (rec) {
	   rec->item_stat &= ~_ItemReceptor;
           PaintItemName(w, rec);
	   ilw->xedwList.xedw_receptor = NULL;
	}
}

static void StartAction (w, event, args, nargs)
        Widget w;
        XButtonEvent *event;
        String *args;
        int *nargs;
{
	/* use default action */
        rddStartAction (w, event, args, nargs);         
}

/* RDD DropAction */
static void DropAction (w, event, params, num_params)
        Widget w;
        XButtonEvent *event;
        String *params;
        int *num_params;
{
   char *nameblk;
   XedwListWidget ilw = (XedwListWidget) w;
   _SimpleList *lst = ilw->xedwList.xedw_h_lst;
   char cmdcode;

        if (!lst || _SListEmpty (lst)) 
                return;

        if (!(nameblk = BuildNameBlk (lst)) || (nameblk[0] == '\0'))
		return;

        rddSetDropDataType (nameblk, strlen(nameblk)+1, RDD_FILENAME_TYPE); /* + 1 */
	free (nameblk);

        if (*num_params) {
#ifdef DEBUG
           fprintf (stderr, "%s\n", params[0]);
#endif
           if (*num_params == 2) {
		cmdcode = XedwCR_EXTERNAL_LINK;
           } else if (!strcmp (params[0], "Shift"))
		cmdcode = XedwCR_EXTERNAL_MOVE;
           else if (!strcmp (params[0], "Ctrl")) {
                cmdcode = XedwCR_EXTERNAL_COPY;

           }
        } else 
	   cmdcode = XedwCR_EXTERNAL_MOVE;

        XtCallCallbacks (w, XtNconvertProc, &cmdcode);

        /* then use default action */
        rddDropAction (w, event, params, num_params);
}

#define CHARSIZE (sizeof(char))

static char *BuildNameBlk (lst)
_SimpleList *lst;
{
   int nbsiz = 0;
   char *nblk, *nbp;
   size_t charsize = CHARSIZE;
   int i;
   register _ITEM *item;
   static char emptyString[] = "";

	if (_SListEmpty (lst))
	   return (emptyString);

        item = (_ITEM *) _SListFirst (lst);

        while (item) {
           nbsiz += (strlen (item->item_name) + 1);
           item = (_ITEM *) _SListNext (lst);
        }

	if (!(nblk = malloc (nbsiz * charsize + 1))) {
	   return (NULL);
	}

	nbp = nblk;
        item = (_ITEM *) _SListFirst (lst);
        while (item) {
	   if (!strcmp (item->item_name, "..")) { /* patch */
           	item = (_ITEM *) _SListNext (lst);
		if (!item)
		   *nbp = '\0';
		continue;
	   }
           strcpy (nbp, item->item_name);
	   nbp += strlen (item->item_name);
           item = (_ITEM *) _SListNext (lst);
	   if (item)
		*nbp++ = ' ';
	   else
	        *nbp = '\0';
        }

	return (nblk);

}

/*
 * XwCollItemsSelected: return selected items
 */

char *XwCollItemsSelected (w) 
Widget w;
{
  XedwListWidget ilw = (XedwListWidget) w;
   _SimpleList *lst = ilw->xedwList.xedw_h_lst;


  return (BuildNameBlk (lst));
}


/*
 * XwCollVItemsSelected: return vector of selected items
 */

char **XwCollVItemsSelected (w)
Widget w;
{
XedwListWidget ilw = (XedwListWidget) w;
_SimpleList *lst = ilw->xedwList.xedw_h_lst;
register _ITEM *item;
register int cnt = 0;
char **vector, **vp;


   if (_SListEmpty (lst))
      return (NULL); 

   cnt = _SListLength (lst);

   if (!(vector = (char **) malloc ((cnt+1)*sizeof (char *)))) { 
	fprintf (stderr, "XwCollVItemsSelected: not enough memory\n");
	return (NULL);
   }

   item = (_ITEM *) _SListFirst (lst);
   vp = vector;
   while (item) {
	if (!strcmp (item->item_name, "..")) { /* patch */
                item = (_ITEM *) _SListNext (lst);
                continue;
        }
	/* issue - Does not allocate memory     */
	/* item name can change or be destroyed */
	*vp++ = item->item_name; 
	item = (_ITEM *) _SListNext (lst);
   }
   *(vp) = NULL;
   return (vector);
	   
}

