/* $XConsortium: List.c,v 1.34 91/09/27 18:35:07 converse Exp $ */

/*
 * Copyright 1989 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * XedwList.c - XedwList widget
 *
 * This is the XedwList widget. It is very similar to the Athena Widget List,
 * except it has the ability to display an icon with the string. Plus allows
 * multiple selections.
 * It allows the user to select one or more items in a list and notifies the
 * application through a callback function.
 *
 *  List Created:   8/13/88
 *  By:     Chris D. Peterson
 *                      MIT X Consortium
 *
 *  Modified to XedwList: 1/26/91
 *  By:     Edward Groenendaal
 *                      University of Sussex, UK.
 */


/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */


#ifndef _XedwListP_h
#define _XedwListP_h

#include "lst.h"
#include "XedwList.h"

#define NO_HIGHLIGHT            XDTM_LIST_NONE
#define XedwOff			 0
#define XedwOn			 1

/* New fields for the XedwList widget class record */

typedef struct {int foo;} XedwListClassPart;

/* Full class record declaration */
typedef struct _XedwListClassRec {
    CoreClassPart      	core_class;
    XedwListClassPart	xedwList_class;
} XedwListClassRec;

extern XedwListClassRec xedwListClassRec;


/* New fields for the XedwList widget record */

typedef struct {
  Pixel         foreground;
  Dimension     internal_width,
                internal_height,
                column_space,
                row_space,
                icon_width,
                icon_height;
  int           default_cols;
  Boolean       force_cols,
                paste,
                vertical_cols,
                show_icons,	/* Show icons with list */
  		multiple,       /* Allow multiple selections */
		fit_parent,
		layout_policy,
		rubberbanding;
  int           nitems;		/* check for consistency number of items in the xedwList. */
  XFontStruct	*font;
  _LST       *xedw_item_lst;
  XtCallbackList  callback;
  XtCallbackList  doubleclick;
  XtCallbackList  drop;
  XtCallbackList  expose; 
  XtCallbackList  convertproc;
  XtCallbackList  popupproc;	/* function to handle popup menu */
  /* private state */
  int         longest;	
  Dimension   desired_width, desired_height;
  Dimension   min_width, min_height;
  _SimpleList *xedw_h_lst;
  _ITEM       *xedw_h_item;
  _ITEM	      *xedw_receptor;
  int         xedw_loc_x;
  int         xedw_loc_y;
  int         xedw_drag_x;
  int         xedw_drag_y;
  int 	      xedw_state;
  Time 	      xedw_tm_stamp;
  int         col_width,	/* width of each column. */
              row_height,	/* height of each row. */
              nrows,		/* number of rows in the xedwList. */
              ncols;		/* number of columns in the xedwList. */
  GC	      normgc,		/* a couple o' GC's. */
              revgc,
              graygc,		/* used when inactive. */
	      xorgc;
  Pixmap      default_icon;
  Cursor      point_cursor;
  Cursor      move_cursor;
  Cursor      wait_cursor;

} XedwListPart;


typedef struct _XedwListRec {
  CorePart	core;
  XedwListPart	xedwList;
} XedwListRec;


extern PicInfo *get_icon ();


#endif /* _XedwListP_h */



