/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include <Xm/PushB.h>
#include <sys/stat.h>

#include "pixmaps.h" 
#include "build_option.h"
#include "XedwListP.h"
#include "XedwList.h"
#include "Dir.h"


extern void XwDirInvokeActionCB ();

/*
 * Action tables
 */


MenuItem edit_menu[] = {
        { "Edit", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
	NULL
};

Cmd edit_cmd[] = {
                {"$EDITOR $*", _CHECKEDITOR},
                NULL}; 

MenuItem c_menu[] = {
	{ "Edit", &xmPushButtonWidgetClass, 'E', NULL, 
	NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL }, 
	{ "Compile", &xmPushButtonWidgetClass, 'C', NULL, 
	NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL }, 

NULL};
Cmd c_cmd[] = {	
		{"$EDITOR $*", _CHECKEDITOR}, 
		{"cc $*", _XTERM|_PAUSE},  
		NULL};

MenuItem fortrn_menu[] = {
        { "Edit", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Compile", &xmPushButtonWidgetClass, 'C', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },

NULL};

Cmd fortrn_cmd[] = {
                {"$EDITOR $*", _CHECKEDITOR},
                {"f77 $*", _XTERM|_PAUSE},
                NULL}; 

MenuItem tar_menu[] = {
	{ "Content", &xmPushButtonWidgetClass, 'C', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
	{ "Extract", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },
	NULL
};

Cmd tar_cmd[] = {{"tar tvf $*", _XTERM|_PAUSE}, 
		 {"tar xvf $*", _XTERM|_PAUSE|_CONFIRM},  
		 NULL
		}; 

MenuItem reg_menu[] = {
        { "Edit", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        NULL
};

Cmd reg_cmd[] = {{"$EDITOR $*", _CHECKEDITOR},
                 NULL
                };

MenuItem oscrpt_menu[] = {
        { "Execute", &xmPushButtonWidgetClass, 'x', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Edit", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },
        NULL
};

Cmd oscrpt_cmd[] = {{"./$*", _SHELL|_NOWAIT}, 
		    {"$EDITOR $*", _CHECKEDITOR},
                    NULL
                };

MenuItem cpio_menu[] = {
        { "Content", &xmPushButtonWidgetClass, 'C', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Extract", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },
        NULL
};

Cmd cpio_cmd[] = {{"cpio -itv < $*", _XTERM|_PAUSE},
                 {"cpio -icdv < $*", _XTERM|_PAUSE|_CONFIRM},
                 NULL
                };

MenuItem pckd_menu[] = {
        { "View", &xmPushButtonWidgetClass, 'V', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Unpack", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },
        NULL
};

Cmd pckd_cmd[] = {{"pcat $*", _XTERM|_PAUSE},
                 {"unpack $*", _XTERM|_PAUSE},
                 NULL
                };

MenuItem cmp_menu[] = {
        { "View", &xmPushButtonWidgetClass, 'V', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Uncompress", &xmPushButtonWidgetClass, 'U', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },
        NULL
};

Cmd cmp_cmd[] = {{"zcat $*", _XTERM|_PAUSE},
                 {"uncompress -v  $*", _XTERM|_PAUSE},
                 NULL
                };

MenuItem ras_menu[] = {
        { "View", &xmPushButtonWidgetClass, 'V', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        NULL
};

Cmd ras_cmd[] = {{"screenload screenload $*", _NOWAIT},
                 NULL
                };


MenuItem ar_menu[] = {
        { "Content", &xmPushButtonWidgetClass, 'C', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Extract", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },
        { "Convert To Random (ranlib)", &xmPushButtonWidgetClass, 'R', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 2, NULL },
        NULL
};

Cmd ar_cmd[] = {{"ar tv $*", _XTERM|_PAUSE},
                 {"ar xv $*", _XTERM|_PAUSE|_CONFIRM},
                 {"ranlib $*", _XTERM|_PAUSE},
                 NULL
                };

MenuItem ps_menu[] = {
        { "Edit", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Print", &xmPushButtonWidgetClass, 'P', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },
        NULL
};

Cmd ps_cmd[] = {{"$EDITOR $*", _CHECKEDITOR},
		{"Xlp Xlp $*", _NOWAIT},
                 NULL
                };

MenuItem exc_menu[] = {
        { "Execute (xterm window)", &xmPushButtonWidgetClass, 'x', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Execute (without xterm window)", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },
        { "Debug", &xmPushButtonWidgetClass, 'D', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 2, NULL },
        NULL
};

Cmd exc_cmd[] = {{"./$*", _XTERM},
                 {"./$1 $1", _NOWAIT|_USEPATH},
		 {"dbx $1", _XTERM},
                    NULL
                };

MenuItem lex_menu[] = {
        { "Edit", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Lex", &xmPushButtonWidgetClass, 'L', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },

NULL};

Cmd lex_cmd[] = {
                {"$EDITOR $*", _CHECKEDITOR},
                {"lex $*", _XTERM|_PAUSE},
                NULL}; 


MenuItem pascl_menu[] = {
        { "Edit", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Compile (pi)", &xmPushButtonWidgetClass, 'C', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },

NULL};

Cmd pascl_cmd[] = {
                {"$EDITOR $*", _CHECKEDITOR},
                {"pi $*", _XTERM|_PAUSE},
                NULL};

MenuItem yacc_menu[] = {
        { "Edit", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Compile (yacc)", &xmPushButtonWidgetClass, 'C', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },

NULL};

Cmd yacc_cmd[] = {
                {"$EDITOR $*", _CHECKEDITOR},
                {"yacc $*", _XTERM|_PAUSE},
                NULL};

MenuItem data_menu[] = {
        { "View", &xmPushButtonWidgetClass, 'V', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },

NULL};

Cmd data_cmd[] = {
                {"od $*", _XTERM|_PAUSE},
                NULL}; 

MenuItem assm_menu[] = {
        { "Edit", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Compile (as)", &xmPushButtonWidgetClass, 'C', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },

NULL};

Cmd assm_cmd[] = {
                {"$EDITOR $*", _CHECKEDITOR},
                {"as $*", _XTERM|_PAUSE},
                NULL};

MenuItem ntroff_menu[] = {
        { "Edit", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Format (nroff -man)", &xmPushButtonWidgetClass, 'F', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },
	NULL};

Cmd ntroff_cmd[] = {
                {"$EDITOR $*", _CHECKEDITOR},
                {"nroff -man $*", _XTERM|_PAUSE},
                NULL}; 

MenuItem scrpt_menu[] = {
        { "Execute", &xmPushButtonWidgetClass, 'x', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Edit", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },
        NULL
};

Cmd scrpt_cmd[] = {{"./$*", _XTERM|_PAUSE},
                   {"$EDITOR $*", _CHECKEDITOR},
                    NULL
                  };

MenuItem ascii_menu[] = {
        { "Edit", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Check spelling", &xmPushButtonWidgetClass, 'C', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },
	NULL};

Cmd ascii_cmd[] = {
                {"$EDITOR $*", _CHECKEDITOR},
                {"spell < $*", _XTERM|_PAUSE},
                NULL}; 

MenuItem xwd_menu[] = {
        { "View", &xmPushButtonWidgetClass, 'V', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
	NULL};

Cmd xwd_cmd[] = {
                {"xwud xwud -in $*", _NOWAIT},
                NULL};

MenuItem make_menu[] = {
        { "Edit", &xmPushButtonWidgetClass, 'E', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 0, NULL },
        { "Make", &xmPushButtonWidgetClass, 'M', NULL,
        NULL, XwDirInvokeActionCB, (XtPointer) 1, NULL },

NULL};

Cmd make_cmd[] = {
                {"$EDITOR $*", _CHECKEDITOR},
                {"make -f $*", _XTERM|_PAUSE},
                NULL};




Action action_tbl[] = {
                    {edit_menu, edit_cmd},
                    {NULL, NULL},
                    {NULL, NULL},
                    {NULL, NULL},
                    {NULL, NULL},
                    {reg_menu, reg_cmd}, /* regular */
                    {NULL, NULL},
                    {NULL, NULL},
                    {NULL, NULL},
                    {oscrpt_menu, oscrpt_cmd},
                    {edit_menu, edit_cmd},
                    {NULL, NULL},
                    {cpio_menu, cpio_cmd},
                    {pckd_menu, pckd_cmd},
                    {cmp_menu, cmp_cmd},
                    {ar_menu, ar_cmd},
                    {ps_menu, ps_cmd}, /* ps */
                    {ras_menu, ras_cmd},
                    {exc_menu, exc_cmd},
                    {NULL, NULL}, /* o */
                    {lex_menu, lex_cmd},
                    {pascl_menu, pascl_cmd},
                    {edit_menu, edit_cmd}, 
                    {yacc_menu, yacc_cmd},
                    {edit_menu, edit_cmd},
                    {tar_menu, tar_cmd},  /* tar */
                    {data_menu, data_cmd},
                    {c_menu, c_cmd},  /* c */
                    {edit_menu, edit_cmd},
                    {fortrn_menu, fortrn_cmd},
                    {assm_menu, assm_cmd},
                    {ntroff_menu, ntroff_cmd},
                    {scrpt_menu, scrpt_cmd},
                    {ascii_menu, ascii_cmd},
                    {ascii_menu, ascii_cmd},
                    {xwd_menu, xwd_cmd},
                    {NULL, NULL}, /* core */
                    {make_menu, make_cmd}
                   };
