#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "ool.h"
#include "pixmaps.h"
#include "XedwListP.h"
#include "XedwList.h"
#include "build_option.h"
#include "Dir.h"
#include "DirP.h"
#include "file.h"
#include "etc.h"
#include "rdd.h"
#include <string.h>
#ifdef SUNOS
#include <strings.h>
#endif
#include <stdlib.h>
#include <signal.h>
#include <sys/wait.h>
#include "X.h"


extern Action action_tbl[];	/* action table */
extern char **_parseargv ();

struct _info {
   XwDirWidget dw;	/* directory widget 		 */
   char *path;    	/* path of the startup directory */    
};

/*
 * XwDirNewInvokeAction: Invoke a file
 * 
 * Bugs: This is very similar to XwDirInvokeAction. 
 */
 
void XwDirNewInvokeAction (dw, event, params, num_params)
XwDirWidget dw;
XEvent *event;
String *params;
Cardinal *num_params;
{
   char *fullname, *path;
   int flags;
   char **argv;
   int ftype;
   char *cmd;
   Action *action;
   char *files[2]; /* for now */

   if (*num_params != 2)
	return;

   /* determine fullname of the file to be */
   /* invoked (i.e. executed)		   */
   
   fullname = _dircat (params[0], params[1]);
   
   if (!fullname) {
#ifdef DEBUG
      fprintf (stderr, "_exec: not enough memory\n");
#endif
      return;
   }      
#ifdef OLD
   /* check if the file is executable */
   if (!_fexecutable (fullname)) {
      free (fullname);
      return;
   }
#endif

   /* determine the type of the file */
   ftype = _virtualtype (fullname);
   
   if (ftype == -1)
	   return;

   /* check that ftype is not outside the array limits */

   /* check the actions table        */
   /* determine an appropiate action */
   /* to be invoked		     */
   action = &action_tbl[ftype];
   if (!action)
	return;

   /* check that option is not outside the array limits */

   if (!action->cmd_tbl)
	return;

   cmd = ((action->cmd_tbl)[0]).cmd;
   flags = ((action->cmd_tbl)[0]).flags; /* execution flags */

   if (!cmd)
	return;

   cmd = strdup (cmd);

   if (!cmd) {
#ifdef DEBUG
	fprintf (stderr, "XwInvokeAction: strdup failed\n");
#endif
	return;
   }

   /* Convert string to argv */

   argv = cnvStrToArgv (cmd);

   if (!argv) {
#ifdef DEBUG
	fprintf (stderr, "XwInvokeAction: cnvStrToArgv failed\n");
#endif
	return;
   }

   files[0] = params[1]; /* for now */
   
   /* replace wild card sequences with  */
   /* specific filenames		*/
   argv = _parseargv (argv, files); /* carefull argv memory has not been freed */

   if (!argv) {
#ifdef DEBUG
	fprintf (stderr, "XwInvokeAction:_parseargv failed\n");
#endif
	return;
   }
   flags |= _SETCWD;	/* set current working directory at execution */
   XwDirExecute1 (dw, argv, flags, params[0]);
}

/*
 * _exec: invoke filename
 */
 
int _exec (filename, client)
char *filename;
char *client;
{
 XwDirWidget dw;
 char *params[3];

   dw = ((struct _info *)client)->dw;
   
   params[0] = ((struct _info *)client)->path;	/* path */
   params[1] = filename;			/* filename */
   params[2] = '\0';
   
   XtCallActionProc (dw, "NewInvokeAction", NULL, params, 2); 

}

/*
 * XwDirStart: invoke all the files inside a group directory
 */
 
void XwDirStart (dw, event, params, num_params)
XwDirWidget dw;
XEvent *event;
String *params;
Cardinal *num_params;
{

  int _exec ();
  struct _info info;

  if (*num_params != 1)
        return;
        
  info.dw = dw;			/* directory widget */
  info.path = params[0];	/* directory path   */

   /* traverse directory and invoke all of its files */
   _traversedir (info.path, _exec, &info);

}
