
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THE SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */


#include <Xm/Xm.h>
#include "lst.h"
#include "etc.h"
#include "X.h"
#include "PrintModule.h"

void exec_cmd ();
void bsd_print ();
EntryFormObject lpForm = NULL; /* LP form */


/*
 * selectPrinter: Callback invoked when a printer is selected
 *		  from the list
 */
 
void selectPrinter(list_w, client, cbs)
Widget list_w;
XtPointer client;
XmListCallbackStruct *cbs;
{
   char *choice;

  XmStringGetLtoR (cbs->item, XmSTRING_DEFAULT_CHARSET, &choice);
  _EntryFormSChangeField (lpForm, choice, 9);
  XtFree (choice);
}

/*
 * create_printerWrapperCB: associate a widget to the queues wrapper
 */
 
void create_printerWrapperCB(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
PrintModuleObj obj = (PrintModuleObj) client;

   RtSetValue(obj->pm.queues, RtNwidget, w);    

}


/* 
 * createPrForm: Create an EntryFormObject structure and add fields 
 *               to it.  
 */

void createPrForm(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   /* create the EntryFormObject structure */
   if (!lpForm) {
        lpForm = _EntryFormCreate ();
   }

   if (!lpForm ) {
        fprintf (stderr, "createprForm: _EntryFormCreate failed\n");
        return;
   }

   _EntryFormSInsertField (lpForm, w, (int) client);

   switch ((int) client) {
	case 3:
	   buildPrinterList (w); /* Stuff list of printers */
	   break;
	case 2:
	   _EntryFormSChangeField (lpForm, "1", 2); /* Print "1" copy */
	   break;
	default:
	   break;
   }
}

/* 
 * Dismiss button Activate callback 
 */

void
dismissCB(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
	exit (0);
}


/* 
 * printCB: Print button Activate callback 
 */

void printCB(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
char **data;
Widget shell;
char *argv[7]; /* check */
char **files;
char **cmdv;
char *ocopies = NULL;
char *otitle = NULL;
char *oprinter = NULL;
int ind;
int status;
PrintModuleObj pm = (PrintModuleObj) client;
int bsd;


   data = _EntryFormSDumpData (lpForm);
   
   RtGetValue (pm, RtNpmBsdPrint, &bsd);  
   if (bsd) {
   	bsd_print (pm, data);
   	return;
   }
   
   shell = locateShell (w); 

   argv[0] = FD_LP_PATH;
   argv[1] = "lp";
   ind = 2;
   /* check this - include in the library function to validate forms */
   if (!strcmp (data[0], "")) {
        _XmCErrorDialogPost (shell, "Please enter filename(s)", "Error");
	_EntryFormCDestroyData (data);
        return;
   }

   if (!strcmp (data[4], "ON"))
	argv[ind++] = "-m";

#ifdef SOLARIS
   if (strcmp (data[1], "")) {

	/* title option */
	otitle = _strconcat("-t", data[1]);
	if (!otitle) {
       	   _XmCErrorDialogPost 
		(shell, "Not enough memory, please close some applications", "Error"); 
	   _EntryFormCDestroyData (data);
	   return;
	}
	argv[ind++] = otitle;
   }
#endif

   /* validate copies */
   if (!_isnum (data[2])) {
       	_XmCErrorDialogPost 
	(shell, "Please enter a valid number of copies", "Error"); 
	_EntryFormCDestroyData (data);
	return;
   }
	
   if (strcmp (data[2], "1")) {
	ocopies = _strconcat("-n", data[2]);
	if (!ocopies) {
       	   _XmCErrorDialogPost 
		(shell, "Not enough memory, please close some applications", "Error");
	   if (!otitle)
		free (otitle);
	   _EntryFormCDestroyData (data);
	   return;
	}
	argv[ind++] = ocopies;
   }

   if (!strcmp (data[8], "")) {
            _XmCErrorDialogPost (shell, "Invalid printer name", "Error");

           if (!otitle)
                free (otitle);
           if (!ocopies)
                free (ocopies);
	   _EntryFormCDestroyData (data);
           return;
   }

   if (strcmp (data[8], "default")) {
	oprinter = _strconcat("-d", data[8]);
	if (!oprinter) {
       	   _XmCErrorDialogPost 
		(shell, "Not enough memory, please close some applications", "Error");
	   if (!otitle)
		free (otitle);
	   if (!ocopies)
		free (ocopies);
	   _EntryFormCDestroyData (data);
	   return;
	}
	argv[ind++] = oprinter;
   }
   argv[ind++] = '\0';
   
   /* convert names to argv */
   files = cnvStrToArgv (data[0]);

   if (!files) {
        if (!otitle)
                free (otitle);
        if (!ocopies)
                free (ocopies);
	if (!oprinter)
		free (oprinter);

#ifdef DEBUG
        fprintf (stderr, "printCB: not enough memory\n");
#endif
        return;
   }

   /* concatenate argv and files */
   cmdv = _argvconcat (argv, files);

   if (!cmdv) {

        if (!otitle)
                free (otitle);
        if (!ocopies)
                free (ocopies);
	if (!oprinter)
		free (oprinter);

	fprintf (stderr, "printCB: not enough memory\n");
	return;
   }

   RtSetValue (pm->pm.cmd, RtNcmdStderrIsStdout, 1);
   exec_cmd (pm, cmdv);
   RtSetValue (pm->pm.cmd, RtNcmdStderrIsStdout, 0);
   RtGetValue (pm->pm.cmd, RtNobjStatus, &status);
   
   _EntryFormCDestroyData (data); 
}

/* 
 * bsd_print: use the BSD print command
 */

void bsd_print(pm, data)
PrintModuleObj pm;
char **data;

{
Widget shell;
char *argv[7]; /* check */
char **files;
char **cmdv;
char *ocopies = NULL;
char *otitle = NULL;
char *oprinter = NULL;
int ind;
int status;



   shell = pm->pm.shell; 
   
   argv[0] = FD_LPR_PATH;
   argv[1] = "lpr";
   ind = 2;
   
   /* check this - include in the library function to validate forms */
   if (!strcmp (data[0], "")) {
        _XmCErrorDialogPost (shell, "Please enter filename(s)", "Error");
	_EntryFormCDestroyData (data);
        return;
   }

   if (!strcmp (data[4], "ON"))
	argv[ind++] = "-m";

   if (strcmp (data[1], "")) {

	/* title option */
	otitle = _strconcat("-T", data[1]);
	if (!otitle) {
       	   _XmCErrorDialogPost 
		(shell, "Not enough memory, please close some applications", "Error"); 
	   _EntryFormCDestroyData (data);
	   return;
	}
	argv[ind++] = otitle;
   }

   /* validate copies */
   if (!_isnum (data[2])) {
       	_XmCErrorDialogPost 
	(shell, "Please enter a valid number of copies", "Error"); 
	_EntryFormCDestroyData (data);
	return;
   }

   if (strcmp (data[2], "1")) {
	ocopies = _strconcat("-#", data[2]);
	if (!ocopies) {
       	   _XmCErrorDialogPost 
		(shell, "Not enough memory, please close some applications", "Error");
	   if (!otitle)
		free (otitle);
	   _EntryFormCDestroyData (data);
	   return;
	}
	argv[ind++] = ocopies;
   }

   if (!strcmp (data[8], "")) {
            _XmCErrorDialogPost (shell, "Invalid printer name", "Error");

           if (!otitle)
                free (otitle);
           if (!ocopies)
                free (ocopies);
	   _EntryFormCDestroyData (data);
           return;
   }

   if (strcmp (data[8], "default")) {
	oprinter = _strconcat("-P", data[8]);
	if (!oprinter) {
       	   _XmCErrorDialogPost 
		(shell, "Not enough memory, please close some applications", "Error");
	   if (!otitle)
		free (otitle);
	   if (!ocopies)
		free (ocopies);
	   _EntryFormCDestroyData (data);
	   return;
	}
	argv[ind++] = oprinter;
   }
   argv[ind++] = '\0';
   
   /* convert names to argv */
   files = cnvStrToArgv (data[0]);

   if (!files) {
        if (!otitle)
                free (otitle);
        if (!ocopies)
                free (ocopies);
	if (!oprinter)
		free (oprinter);

#ifdef DEBUG
        fprintf (stderr, "printCB: not enough memory\n");
#endif
        return;
   }

   /* concatenate argv and files */
   cmdv = _argvconcat (argv, files);

   if (!cmdv) {

        if (!otitle)
                free (otitle);
        if (!ocopies)
                free (ocopies);
	if (!oprinter)
		free (oprinter);
#ifdef DEBUG
	fprintf (stderr, "printCB: not enough memory\n");
#endif
	return;
   }

   RtSetValue (pm->pm.cmd, RtNcmdStderrIsStdout, 1);
   exec_cmd (pm, cmdv);
   RtSetValue (pm->pm.cmd, RtNcmdStderrIsStdout, 0);
   RtGetValue (pm->pm.cmd, RtNobjStatus, &status);
   
   _EntryFormCDestroyData (data); 
}



/* 
 * showQueueCB: invoke a command to show the print queues
 */

void showQueueCB(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   Widget shell, text;
   char *argv[7];
   int bsd;
   int status;
   PrintModuleObj pm = (PrintModuleObj) client;
   char *printer, *oprinter;

   RtGetValue (pm, RtNpmBsdPrint, &bsd);  
   shell = locateShell (w);

   if (bsd) {
        argv[0] = FD_LPQ_PATH;
        argv[1] = "lpq";
   	printer = _EntryFormSPDumpPos (lpForm, 9);
        if (printer && *printer && strcmp (printer, "default")) {
	   oprinter = _strconcat("-P", printer);
	   argv[2] = oprinter;
	   argv[3] = '\0';
	} else
	   argv[2] = '\0';
   } else {
   	argv[0] = FD_LPSTAT_PATH;
   	argv[1] = "lpstat";
   	argv[2] = '\0';
   }
   
   XtSetSensitive (_EntryFormPosToWidget (lpForm, 7), False);
   XtSetSensitive (_EntryFormPosToWidget (lpForm, 6), False);
#ifdef OLD
   XSync (XtDisplay(w), False);
#endif

   RtSetValue (pm->pm.cmd, RtNcmdBroadcastStdout, 1);
   RtSetValue (stdmsg, RtNmsgId, RtXMTW_CLEAR);
   RtSendMessage (pm->pm.queues, stdmsg, NULL); 
   exec_cmd (pm, argv);
   RtSetValue (pm->pm.cmd, RtNcmdBroadcastStdout, 0);

   XtSetSensitive (_EntryFormPosToWidget (lpForm, 6), True);
   XtSetSensitive (_EntryFormPosToWidget (lpForm, 7), True);
#ifdef OLD
   XSync (XtDisplay(w), False);
#endif
}


/*
 * exec_cmd: execute command
 */

void exec_cmd (obj, argv)
PrintModuleObj obj;
char **argv;
{
Widget widget;

   RtSetValue (obj->pm.cmd, RtNcmdArgv, argv); 
   RtSetValue (stdmsg, RtNmsgId, RtCMD_EXECUTE)
   RtSendMessage (obj->pm.cmd, stdmsg, NULL);      
} 

