
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THE SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */


#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/Command.h>
#include <Xm/CutPaste.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/SeparatoG.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>

#include "PrintModule.h"

extern void createPrForm();
extern void create_printerWrapperCB();
extern void dismissCB();
extern void printCB();
extern void selectPrinter();
extern void showQueueCB();
extern Obj pm_object;

Widget
CreatemainW(parent)
Widget parent;
{
    Arg    	args[512];
    int    	argcnt;
    Widget 	retval;
    XmString	xmstr[32];
    XmString	*xmstrTable[8];
    Widget	mainW;
    Widget	print_form;
    Widget	file_label;
    Widget	file_text;
    Widget	copies_label;
    Widget	queues_window;
    Widget	queues_text;
    Widget	print_button;
    Widget	queues_button;
    Widget	dismiss_button;
    Widget	separator;
    Widget	title_text;
    Widget	title_label;
    Widget	toggle_button;
    Widget	printers_window;
    Widget	printers_list;
    Widget	printers_label;
    Widget	queues_label;
    Widget	printer_text;
    Widget	selection_label;
    Widget	copies_text;
    XmRegisterConverters();
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 405); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 461); argcnt++;
    mainW = XtCreateWidget("mainW",
		xmMainWindowWidgetClass,
		parent,
		args,
		argcnt);

    retval = mainW;
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 405); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 461); argcnt++;
    print_form = XtCreateWidget("print_form",
		xmFormWidgetClass,
		mainW,
		args,
		argcnt);

    XtManageChild(print_form);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNcolumns, (short)3); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 367); argcnt++;
    copies_text = XtCreateWidget("copies_text",
		xmTextWidgetClass,
		print_form,
		args,
		argcnt);

    createPrForm(copies_text, (caddr_t)2, (caddr_t)0);
    XtManageChild(copies_text);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Selection",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    selection_label = XtCreateWidget("selection_label",
		xmLabelWidgetClass,
		print_form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(selection_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNcolumns, (short)62); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, selection_label); argcnt++;
    printer_text = XtCreateWidget("printer_text",
		xmTextWidgetClass,
		print_form,
		args,
		argcnt);

    createPrForm(printer_text, (caddr_t)9, (caddr_t)0);
    XtManageChild(printer_text);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Queues",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, printer_text); argcnt++;
    queues_label = XtCreateWidget("queues_label",
		xmLabelWidgetClass,
		print_form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(queues_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Printers",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    printers_label = XtCreateWidget("printers_label",
		xmLabelWidgetClass,
		print_form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(printers_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNscrollingPolicy, XmAPPLICATION_DEFINED); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 385); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 50); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, printers_label); argcnt++;
    printers_window = XtCreateWidget("printers_window",
		xmScrolledWindowWidgetClass,
		print_form,
		args,
		argcnt);

    XtManageChild(printers_window);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Send mail when done printing",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)194); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 206); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, queues_label); argcnt++;
    toggle_button = XtCreateWidget("toggle_button",
		xmToggleButtonWidgetClass,
		print_form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPrForm(toggle_button, (caddr_t)4, (caddr_t)0);
    XtManageChild(toggle_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Title",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)20); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    title_label = XtCreateWidget("title_label",
		xmLabelWidgetClass,
		print_form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(title_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNcolumns, (short)42); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_POSITION); argcnt++;
    XtSetArg(args[argcnt], XmNrightPosition, (int)65); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, title_label); argcnt++;
    title_text = XtCreateWidget("title_text",
		xmTextWidgetClass,
		print_form,
		args,
		argcnt);

    createPrForm(title_text, (caddr_t)1, (caddr_t)0);
    XtManageChild(title_text);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 405); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 20); argcnt++;
    separator = XtCreateWidget("separator",
		xmSeparatorWidgetClass,
		print_form,
		args,
		argcnt);

    XtManageChild(separator);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"dismiss",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 315); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 80); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 30); argcnt++;
    dismiss_button = XtCreateWidget("dismiss_button",
		xmPushButtonWidgetClass,
		print_form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(dismiss_button, XmNactivateCallback, dismissCB, (caddr_t)0);
    createPrForm(dismiss_button, (caddr_t)8, (caddr_t)0);
    XtManageChild(dismiss_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"show queues",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
    XtSetArg(args[argcnt], XmNleftPosition, (int)40); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNx, 162); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 110); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 30); argcnt++;
    queues_button = XtCreateWidget("queues_button",
		xmPushButtonWidgetClass,
		print_form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(queues_button, XmNactivateCallback, showQueueCB, (caddr_t)pm_object);
    createPrForm(queues_button, (caddr_t)7, (caddr_t)0);
    XtManageChild(queues_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"print",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNshowAsDefault, (short)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 30); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 80); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 30); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, separator); argcnt++;
    print_button = XtCreateWidget("print_button",
		xmPushButtonWidgetClass,
		print_form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(print_button, XmNactivateCallback, printCB, (caddr_t)pm_object);
    createPrForm(print_button, (caddr_t)6, (caddr_t)0);
    XtManageChild(print_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNscrollingPolicy, XmAPPLICATION_DEFINED); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 385); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 94); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, queues_label); argcnt++;
    queues_window = XtCreateWidget("queues_window",
		xmScrolledWindowWidgetClass,
		print_form,
		args,
		argcnt);

    XtManageChild(queues_window);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Copies",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 317); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, title_text); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNrightWidget, copies_text); argcnt++;
    copies_label = XtCreateWidget("copies_label",
		xmLabelWidgetClass,
		print_form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(copies_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNcolumns, (short)52); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)12); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNy, 15); argcnt++;
    file_text = XtCreateWidget("file_text",
		xmTextWidgetClass,
		print_form,
		args,
		argcnt);

    createPrForm(file_text, (caddr_t)0, (caddr_t)0);
    XtManageChild(file_text);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"File(s)",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNy, 15); argcnt++;
    file_label = XtCreateWidget("file_label",
		xmLabelWidgetClass,
		print_form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(file_label);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNleftOffset, (int)12); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, file_label); argcnt++;
    XtSetValues(file_text, args, argcnt);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNeditMode, XmMULTI_LINE_EDIT); argcnt++;
    XtSetArg(args[argcnt], XmNcolumns, (short)59); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)5); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    queues_text = XtCreateWidget("queues_text",
		xmTextWidgetClass,
		queues_window,
		args,
		argcnt);

    create_printerWrapperCB(queues_text, (caddr_t)pm_object, (caddr_t)0);
    XtManageChild(queues_text);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, print_button); argcnt++;
    XtSetValues(queues_button, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, print_button); argcnt++;
    XtSetValues(dismiss_button, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, queues_window); argcnt++;
    XtSetValues(separator, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, file_text); argcnt++;
    XtSetValues(title_text, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)20); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, file_label); argcnt++;
    XtSetValues(title_label, args, argcnt);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 385); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 50); argcnt++;
    printers_list = XtCreateWidget("printers_list",
		xmListWidgetClass,
		printers_window,
		args,
		argcnt);

    XtAddCallback(printers_list, XmNbrowseSelectionCallback, selectPrinter, (caddr_t)0);
    createPrForm(printers_list, (caddr_t)3, (caddr_t)0);
    XtManageChild(printers_list);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, title_label); argcnt++;
    XtSetValues(printers_label, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, printers_window); argcnt++;
    XtSetValues(selection_label, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, title_text); argcnt++;
    XtSetValues(copies_text, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNdefaultButton, print_button); argcnt++;
    XtSetValues(print_form, args, argcnt);

    return( retval );
}

