/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf the Licensee.
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THE SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */


#include <stdio.h>
#ifdef SOLARIS
#include <string.h>
#else
#include <strings.h>
#endif
#include "X.h"
#include <dirent.h>

char printcap[] = "/etc/printcap";
#define MAXLINE 160

int blankline (s)
register char *s;
{
   if (!s)
        return (0);
   while (*s) {
        if (!isspace (*s))
           return (0);
        s++;
   }
   return (1);
}

int cntline (s) 
register char *s;
{
  char *cp;
   cp = rindex (s, '\\');

   if (cp) {
	return (1);
   } else
	return (0);
}

char *get_printer (s)
char *s;
{
  char *cp, *cp1;
  int len;
  static char s1[MAXLINE]; /* check */

   if (!(cp = index (s, '|'))) {
      if (!(cp = index (s, ':')))
	return (NULL);
   }

   if ((len = (cp - s)) == 0)
	return (NULL);

   strncpy (s1, s, len);

   s1[len] = '\0';
   return (s1);
}

char *get_printer_name (fp) 
FILE *fp;
{
   char s[MAXLINE];
   short found = 0;
   static short contline = 0;
   char *printer;


   while (!found) {
   	if (!fgets (s, MAXLINE, fp))
	   return (NULL);
	if (s[0] == '#') /* check */
	   continue;
	if (contline) {
	   if (!cntline (s))
		contline = 0;
	   continue;
	}
	if (blankline (s))  {
	   if (cntline (s))
		contline = 1;
	   continue;
	}

	/* check - continuation character */
	if (cntline (s))
	   contline = 1;

	/* get printer name */
	if (!(printer = get_printer (s))) {
#ifdef DEBUG
	   fprintf (stderr, "printcap file: invalid format\n");
#endif
	   continue;
	}

	if (blankline (printer))
	   continue;

	found = 1;
	
	
   }
   return (printer);

}

#ifdef SOLARIS

#define MAX_NAME_SIZE	256
buildPrinterList (w)
Widget w;
{

   extern char *get_directory_name ();
   static char 	printers[] = "/etc/lp/printers";
   static char  default_printer_file[] = "/etc/lp/default";
   char default_printer[MAX_NAME_SIZE];
   DIR		*dirp;
   struct dirent *dp;
   FILE		*fp;
   int 		cnt;
   XmString 	aux;

    if ((dirp = opendir(printers)) == NULL) {
	perror (printers);
	return (NULL);
    }

   XmListDeleteAllItems (w);

    while ((dp = readdir(dirp)) != NULL) {
	if (!_strcmp (dp->d_name, "."))
	  continue;
	if (!_strcmp (dp->d_name, ".."))
	  continue;
        _XmCListAddItemUnselected (w, dp->d_name, 0);	
   }
   closedir(dirp);

   XtVaGetValues (w, XmNitemCount, &cnt, NULL);
   
   if (!cnt)
   	return;
   	
   /* select default */
   fp = fopen (default_printer_file, "r");
   
   if (!fp) {
#ifdef DEBUG
   	perror (default_printer_file);
#endif
   	return;
   }

   if (!fgets (default_printer, MAX_NAME_SIZE, fp)) {
        fclose (fp);   
   	return;  /* error or EOF detected */ 
   }
   
   fclose (fp);
   
   cnt = strlen (default_printer);
   
   if (cnt <= 0)
   	return;
   
   if (default_printer[cnt-1] == '\n')
   	default_printer[cnt-1] = '\0';

   if (!(aux = XmStringCreateSimple (default_printer)))
   	return;
    		  
   XmListSelectItem (w, aux, True); /* careful - context sensitive */
   XmListSetItem (w, aux);
}

#else
buildPrinterList (w)
Widget w;
{

   FILE *fp;
   char *printer;
   extern char *get_printer_name ();

   XmListDeleteAllItems (w);
   _XmCListAddItemUnselected (w, "default", 0);

   fp = fopen (printcap, "r");

   if (!fp) {
	perror (printcap);
	return ;
   }

   while (printer = get_printer_name (fp))
 	_XmCListAddItemUnselected (w, printer, 0);

   /* select default */

   XmListSelectPos (w, 1, True); /* careful - context sensitive */
   XmListSetPos (w, 1);
   fclose (fp);
}
#endif
