
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/DialogS.h>
#include <sys/wait.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include "Xsh.h"
#include "X.h"
#include "Rt.h"
#include "xpm.h"
#include "XpmObj.h"
#include "appl50x50.xpm"

#define APP_NAME "Xpm"
#define APP_CLASS "Freedom"

#ifdef EDITRES
#include <X11/Xmu/Editres.h>
#endif

#include "appl.xbm"



Widget shell;
Widget shell1;
Widget shell2;
Widget shell3;
Widget shell4;
Widget shell5;
Widget shell6;
Widget main_window;
extern Widget Create_main_window(), Create_help_form ();
extern Widget Create_help_selection (), Create_new_group_selection ();
extern Widget Create_remove_group_selection(), Createmcform();
extern Widget Createappform ();
Widget Form1;
Widget selection_form;
Widget NewGroupBox;
Widget RemoveGroupBox;
Widget mcform;
Widget appform;

void reapchild ();


main(argc, argv)
int argc;
char **argv;
{
    Arg 	args[12];
    register int argcnt;
    Display *display;
    XtAppContext context;
    void closeCB ();
    Obj object;
    Pixmap pixmap, i_pixmap = NULL;
    Window window;

    XtToolkitInitialize();

    context = XtCreateApplicationContext();
    display = XtOpenDisplay(context, 0, APP_NAME, APP_CLASS, 0, 0, &argc, argv);

    if(!display) {
	XtWarning("cannot open display");
	exit(1);
    }

    XmRegisterConverters();

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtitle, "Program Manager"); argcnt++;
    XtSetArg(args[argcnt], XmNiconName, "Programs"); argcnt++;
    shell = XtAppCreateShell( APP_NAME, APP_CLASS,
        applicationShellWidgetClass, display, args, argcnt);

#ifndef DEMO
#ifdef EDITRES
    XtAddEventHandler (shell, (EventMask) 0, True, _XEditResCheckMessages
, NULL);
#endif
#endif

    /* Create an icon window */
    window = XCreateSimpleWindow (display, RootWindow(display,
		DefaultScreen(display)), 0, 0, 50, 
		50, (unsigned) 0, 
		CopyFromParent, CopyFromParent);

    /* Create Xpm object. This object is used to define a pixmap */
    /* for the icon window					 */
    
    object = RtCreateObject (NULL, xpmObjClass);
    RtSetValue (object, RtNxpmData, appl50x50_xpm);
    RtSetValue (object, RtNxpmDisplay, display);
    RtSetValue (object, RtNxpmWidget, shell);
    RtSetValue (object, RtNxpmWhiteBackground, 1);
    if (RtRealizeObject (object) >= 0)
       RtGetValue (object, RtNxpmPixmap, &i_pixmap);

    if (i_pixmap) {
       /* Set background of the icon window */
       XSetWindowBackgroundPixmap (display, window, i_pixmap);
       /* Set icon window resource */
       XtVaSetValues (shell, XmNiconWindow, window, NULL);
       XClearWindow (display, window);
    } else
       /* use the bitmap in case a pixmap couldn't be made */ 
       XtVaSetValues(shell, XmNiconPixmap,
            XCreateBitmapFromData(XtDisplay(shell),
            XtScreen(shell)->root,
            appl_bits, appl_width, appl_height),
            NULL
            );


    argcnt = 0;
    XtSetArg(args[argcnt], XmNtitle, "Help"); argcnt++;
    shell1 = XtCreatePopupShell( "shell1", xmDialogShellWidgetClass, 
	shell, args, argcnt);

    Form1 = Createhelp_form(shell1);


    argcnt = 0;
    XtSetArg(args[argcnt], XmNtitle, "Help Selection"); argcnt++;
    shell2 = XtCreatePopupShell( "shell2", xmDialogShellWidgetClass, 
	shell, args, argcnt);

    selection_form = Createhelp_selection(shell2);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtitle, "New Group"); argcnt++;
    shell3 = XtCreatePopupShell( "shell3",
        xmDialogShellWidgetClass, shell, args, argcnt);

    NewGroupBox = Createnew_group_selection(shell3);
    XtUnmanageChild (XmSelectionBoxGetChild(NewGroupBox, XmDIALOG_HELP_BUTTON));

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtitle, "Move To Trash"); argcnt++;
    shell4 = XtCreatePopupShell( "shell4",
        xmDialogShellWidgetClass, shell, args, argcnt);

    RemoveGroupBox = Createremove_group_selection(shell4);
    XtVaSetValues (RemoveGroupBox, XmNdialogStyle,
        XmDIALOG_PRIMARY_APPLICATION_MODAL, NULL);

    argcnt = 0;
    XtSetArg (args[argcnt], XtNallowShellResize, (XtArgVal) TRUE);argcnt++;
    shell5 = XtCreatePopupShell( "shell5",
        xmDialogShellWidgetClass, shell, args, argcnt);

    mcform = Createmcform(shell5);
    XtVaSetValues (mcform, XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL, 
	NULL);

    argcnt = 0;
    XtSetArg (args[argcnt], XtNallowShellResize, (XtArgVal) FALSE);argcnt++;
    shell6 = XtCreatePopupShell( "Item Properties",
        xmDialogShellWidgetClass, shell, args, argcnt);

    appform = Createappform(shell6);
    XtVaSetValues (appform, XmNdialogStyle,
        XmDIALOG_PRIMARY_APPLICATION_MODAL, NULL);


     /* RDD  initialize the rdd package */
     rddInit (shell, context);

    _usignal (SIGCHLD, reapchild);

    main_window = Createmain_window(shell);
    XtManageChild(main_window);
    XtRealizeWidget(shell);
    _XmCForceUpdate (main_window);
    _XmSetDeleteWindowCB (shell, closeCB);
    
    XtRealizeWidget(shell1);
    XtRealizeWidget(shell2);
    XtRealizeWidget(shell3);
    XtRealizeWidget(shell4);
    XtRealizeWidget(shell5);
    XtRealizeWidget(shell6);

#ifdef OLD
    if ((fcntl (ConnectionNumber(display), F_SETFD, 1)) == -1)
	fprintf (stderr, "Xpm: child cannot disinherit TCP fd");
#endif

    rddAppMainLoop(context);

}
