
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/Command.h>
#include <Xm/CutPaste.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/SeparatoG.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>

#include "Xsh.h"
#include "X.h"

extern void XpmCopyTo();
extern void XpmCreateActionMenu();
extern void XpmGroupCreate();
extern void XpmGroupToggle();
extern void XpmMoveTo();
extern void XpmNewGroup();
extern void XpmNewItem();
extern void XpmOpenItem();
extern void XpmProperties();
extern void XpmRemove();
extern void XpmRemoveGroup();
extern void XpmRemoveGroupOkCB();
extern void _XmCWidgetMakeInvisible();
extern void arrangeIconsCB();
extern void cancelAppForm();
extern void cancelCopyMoveCB();
extern void cancelHelpCB();
extern void cancelRemoveGroupCB();
extern void closeCB();
extern void createAppForm();
extern void createCascadeCB();
extern void createCopyMoveForm();
extern void createHelpForm();
extern void createHelpSelectionForm();
extern void createMoveToTrashForm();
extern void createScrolledWindow();
extern void createXpmForm();
extern void helpCB();
extern void okCopyMoveCB();
extern void pageToggleCB();
extern void pauseToggleCB();
extern void popupHelpFile();
extern void saveAppForm();
extern void xtermToggleCB();
extern int XshCbs;

Widget
Createmain_window(parent)
Widget parent;
{
    Arg    	args[512];
    int    	argcnt;
    Widget 	retval;
    XmString	xmstr[32];
    XmString	*xmstrTable[8];
    Widget	main_window;
    Widget	form;
    Widget	scrolled_window;
    Widget	text;
    Widget	menu_bar;
    Widget	menuShell;
    Widget	pulldown_menu;
    Widget	open_button;
    Widget	separator;
    Widget	new_group_button;
    Widget	new_item_button;
    Widget	separator1;
    Widget	properties_button;
    Widget	copy_button;
    Widget	move_button;
    Widget	separator2;
    Widget	remove_item_button;
    Widget	remove_group_button;
    Widget	close_button;
    Widget	file_button;
    Widget	menuShell1;
    Widget	pulldown_menu1;
    Widget	groups_button;
    Widget	menuShell2;
    Widget	pulldown_menu2;
    Widget	onFSButton;
    Widget	onVersionButton;
    Widget	onFDButton;
    Widget	help_cascade;
    Widget	menuShell3;
    Widget	pulldown_menu3;
    Widget	arrange_icons_button;
    Widget	view_button;
    Widget	menuShell4;
    Widget	pulldown_menu4;
    Widget	actions_cascade;
    XmRegisterConverters();
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 490); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 260); argcnt++;
    main_window = XtCreateWidget("main_window",
		xmMainWindowWidgetClass,
		parent,
		args,
		argcnt);

    retval = main_window;
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 31); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 490); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 229); argcnt++;
    form = XtCreateWidget("form",
		xmFormWidgetClass,
		main_window,
		args,
		argcnt);

    XtManageChild(form);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNeditable, False); argcnt++;
    XtSetArg(args[argcnt], XmNcolumns, (short)80); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNbottomOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 206); argcnt++;
    text = XtCreateWidget("text",
		xmTextWidgetClass,
		form,
		args,
		argcnt);

    createXpmForm(text, (caddr_t)0, (caddr_t)0);
    XtManageChild(text);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNscrollingPolicy, XmAUTOMATIC); argcnt++;
    XtSetArg(args[argcnt], XmNscrollBarDisplayPolicy, XmSTATIC); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNbottomOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 490); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 206); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNbottomWidget, text); argcnt++;
    scrolled_window = XtCreateWidget("scrolled_window",
		xmScrolledWindowWidgetClass,
		form,
		args,
		argcnt);

    createScrolledWindow(scrolled_window, (caddr_t)&XshCbs, (caddr_t)0);
    XtManageChild(scrolled_window);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNmnemonic, 'G'); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 490); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 31); argcnt++;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_BAR); argcnt++;
    menu_bar = XtCreateWidget("menu_bar",
		xmRowColumnWidgetClass,
		main_window,
		args,
		argcnt);

    XtManageChild(menu_bar);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNwidth, 1); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 1); argcnt++;
    menuShell = XtCreatePopupShell("menuShell",
		xmMenuShellWidgetClass,
		menu_bar,
		args,
		argcnt);

    XtManageChild(menuShell);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 189); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 205); argcnt++;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_PULLDOWN); argcnt++;
    pulldown_menu = XtCreateWidget("pulldown_menu",
		xmRowColumnWidgetClass,
		menuShell,
		args,
		argcnt);

 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Open",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'O'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>O"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+O",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    open_button = XtCreateWidget("open_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(open_button, XmNactivateCallback, XpmOpenItem, (caddr_t)&XshCbs);
    XtManageChild(open_button);
 
    argcnt = 0;
    separator = XtCreateWidget("separator",
		xmSeparatorWidgetClass,
		pulldown_menu,
		args,
		argcnt);

    XtManageChild(separator);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"New Group ..",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'G'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>G"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+G",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    new_group_button = XtCreateWidget("new_group_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(new_group_button, XmNactivateCallback, XpmNewGroup, (caddr_t)0);
    XtManageChild(new_group_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"New Item ..",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'I'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>I"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+I",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    new_item_button = XtCreateWidget("new_item_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(new_item_button, XmNactivateCallback, XpmNewItem, (caddr_t)0);
    XtManageChild(new_item_button);
 
    argcnt = 0;
    separator1 = XtCreateWidget("separator1",
		xmSeparatorWidgetClass,
		pulldown_menu,
		args,
		argcnt);

    XtManageChild(separator1);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Properties ..",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'r'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>R"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+R",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    properties_button = XtCreateWidget("properties_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(properties_button, XmNactivateCallback, XpmProperties, (caddr_t)&XshCbs);
    XtManageChild(properties_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Copy To ..",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'C'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>C"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+C",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    copy_button = XtCreateWidget("copy_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(copy_button, XmNactivateCallback, XpmCopyTo, (caddr_t)&XshCbs);
    XtManageChild(copy_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Move To ..",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'M'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>M"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+M",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    move_button = XtCreateWidget("move_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(move_button, XmNactivateCallback, XpmMoveTo, (caddr_t)&XshCbs);
    XtManageChild(move_button);
 
    argcnt = 0;
    separator2 = XtCreateWidget("separator2",
		xmSeparatorWidgetClass,
		pulldown_menu,
		args,
		argcnt);

    XtManageChild(separator2);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNhighlightThickness, (short)0); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Move To Trash",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    remove_item_button = XtCreateWidget("remove_item_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(remove_item_button, XmNactivateCallback, XpmRemove, (caddr_t)&XshCbs);
    XtManageChild(remove_item_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Remove Group ..",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    remove_group_button = XtCreateWidget("remove_group_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(remove_group_button, XmNactivateCallback, XpmRemoveGroup, (caddr_t)0);
    XtManageChild(remove_group_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Close",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt F4"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+F4",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    close_button = XtCreateWidget("close_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(close_button, XmNactivateCallback, closeCB, (caddr_t)0);
    XtManageChild(close_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"File",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'F'); argcnt++;
    XtSetArg(args[argcnt], XmNx, 5); argcnt++;
    XtSetArg(args[argcnt], XmNy, 5); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 40); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 21); argcnt++;
    XtSetArg(args[argcnt], XmNsubMenuId, pulldown_menu); argcnt++;
    file_button = XtCreateWidget("file_button",
		xmCascadeButtonWidgetClass,
		menu_bar,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(file_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNwidth, 1); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 1); argcnt++;
    menuShell1 = XtCreatePopupShell("menuShell1",
		xmMenuShellWidgetClass,
		menu_bar,
		args,
		argcnt);

    XtManageChild(menuShell1);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 16); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 16); argcnt++;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_PULLDOWN); argcnt++;
    pulldown_menu1 = XtCreateWidget("pulldown_menu1",
		xmRowColumnWidgetClass,
		menuShell1,
		args,
		argcnt);

 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Groups",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'G'); argcnt++;
    XtSetArg(args[argcnt], XmNx, 45); argcnt++;
    XtSetArg(args[argcnt], XmNy, 5); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 52); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 21); argcnt++;
    XtSetArg(args[argcnt], XmNsubMenuId, pulldown_menu1); argcnt++;
    groups_button = XtCreateWidget("groups_button",
		xmCascadeButtonWidgetClass,
		menu_bar,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createCascadeCB(groups_button, (caddr_t)0, (caddr_t)0);
    XtManageChild(groups_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNwidth, 1); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 1); argcnt++;
    menuShell2 = XtCreatePopupShell("menuShell2",
		xmMenuShellWidgetClass,
		menu_bar,
		args,
		argcnt);

    XtManageChild(menuShell2);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 132); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 73); argcnt++;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_PULLDOWN); argcnt++;
    pulldown_menu2 = XtCreateWidget("pulldown_menu2",
		xmRowColumnWidgetClass,
		menuShell2,
		args,
		argcnt);

 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"On Freedom Software",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'S'); argcnt++;
    onFSButton = XtCreateWidget("onFSButton",
		xmPushButtonWidgetClass,
		pulldown_menu2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(onFSButton, XmNactivateCallback, helpCB, (caddr_t)0);
    XtManageChild(onFSButton);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"On Version",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'V'); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    onVersionButton = XtCreateWidget("onVersionButton",
		xmPushButtonWidgetClass,
		pulldown_menu2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(onVersionButton, XmNactivateCallback, helpCB, (caddr_t)1);
    XtManageChild(onVersionButton);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"On Freedom Desktop",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'D'); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    onFDButton = XtCreateWidget("onFDButton",
		xmPushButtonWidgetClass,
		pulldown_menu2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(onFDButton, XmNactivateCallback, helpCB, (caddr_t)2);
    XtManageChild(onFDButton);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Help",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'H'); argcnt++;
    XtSetArg(args[argcnt], XmNx, 445); argcnt++;
    XtSetArg(args[argcnt], XmNy, 5); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 40); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 21); argcnt++;
    XtSetArg(args[argcnt], XmNsubMenuId, pulldown_menu2); argcnt++;
    help_cascade = XtCreateWidget("help_cascade",
		xmCascadeButtonWidgetClass,
		menu_bar,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(help_cascade);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNwidth, 1); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 1); argcnt++;
    menuShell3 = XtCreatePopupShell("menuShell3",
		xmMenuShellWidgetClass,
		menu_bar,
		args,
		argcnt);

    XtManageChild(menuShell3);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 96); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 31); argcnt++;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_PULLDOWN); argcnt++;
    pulldown_menu3 = XtCreateWidget("pulldown_menu3",
		xmRowColumnWidgetClass,
		menuShell3,
		args,
		argcnt);

 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Arrange Icons",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'A'); argcnt++;
    arrange_icons_button = XtCreateWidget("arrange_icons_button",
		xmPushButtonWidgetClass,
		pulldown_menu3,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(arrange_icons_button, XmNactivateCallback, arrangeIconsCB, (caddr_t)&XshCbs);
    XtManageChild(arrange_icons_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"View",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'V'); argcnt++;
    XtSetArg(args[argcnt], XmNx, 97); argcnt++;
    XtSetArg(args[argcnt], XmNy, 5); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 40); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 21); argcnt++;
    XtSetArg(args[argcnt], XmNsubMenuId, pulldown_menu3); argcnt++;
    view_button = XtCreateWidget("view_button",
		xmCascadeButtonWidgetClass,
		menu_bar,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(view_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNwidth, 1); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 1); argcnt++;
    menuShell4 = XtCreatePopupShell("menuShell4",
		xmMenuShellWidgetClass,
		menu_bar,
		args,
		argcnt);

    XtManageChild(menuShell4);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 16); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 16); argcnt++;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_PULLDOWN); argcnt++;
    pulldown_menu4 = XtCreateWidget("pulldown_menu4",
		xmRowColumnWidgetClass,
		menuShell4,
		args,
		argcnt);

 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNsensitive, False); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Actions",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'A'); argcnt++;
    XtSetArg(args[argcnt], XmNx, 137); argcnt++;
    XtSetArg(args[argcnt], XmNy, 5); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 58); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 21); argcnt++;
    XtSetArg(args[argcnt], XmNsubMenuId, pulldown_menu4); argcnt++;
    actions_cascade = XtCreateWidget("actions_cascade",
		xmCascadeButtonWidgetClass,
		menu_bar,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(actions_cascade, XmNcascadingCallback, XpmCreateActionMenu, (caddr_t)&XshCbs);
    createXpmForm(actions_cascade, (caddr_t)1, (caddr_t)0);
    XtManageChild(actions_cascade);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNmenuHelpWidget, help_cascade); argcnt++;
    XtSetValues(menu_bar, args, argcnt);

    return( retval );
}

Widget
Createhelp_form(parent)
Widget parent;
{
    Arg    	args[512];
    int    	argcnt;
    Widget 	retval;
    XmString	xmstr[32];
    XmString	*xmstrTable[8];
    Widget	help_form;
    Widget	dismiss_button;
    Widget	scrolled_window1;
    Widget	help_text;
    XmRegisterConverters();
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 605); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 329); argcnt++;
    help_form = XtCreateWidget("help_form",
		xmFormWidgetClass,
		parent,
		args,
		argcnt);

    createHelpForm(help_form, (caddr_t)0, (caddr_t)0);
    retval = help_form;
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNscrollingPolicy, XmAUTOMATIC); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_POSITION); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNbottomPosition, (int)81); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 605); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 266); argcnt++;
    scrolled_window1 = XtCreateWidget("scrolled_window1",
		xmScrolledWindowWidgetClass,
		help_form,
		args,
		argcnt);

    XtManageChild(scrolled_window1);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNtraversalOn, True); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Dismiss",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNx, 40); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 80); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 32); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, scrolled_window1); argcnt++;
    dismiss_button = XtCreateWidget("dismiss_button",
		xmPushButtonWidgetClass,
		help_form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createHelpForm(dismiss_button, (caddr_t)2, (caddr_t)0);
    XtManageChild(dismiss_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNhighlightThickness, (short)0); argcnt++;
    XtSetArg(args[argcnt], XmNshadowThickness, (short)0); argcnt++;
    XtSetArg(args[argcnt], XmNeditMode, XmMULTI_LINE_EDIT); argcnt++;
    XtSetArg(args[argcnt], XmNeditable, False); argcnt++;
    XtSetArg(args[argcnt], XmNcolumns, (short)66); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)14); argcnt++;
    XtSetArg(args[argcnt], XmNscrollVertical, False); argcnt++;
    XtSetArg(args[argcnt], XmNscrollHorizontal, False); argcnt++;
    XtSetArg(args[argcnt], XmNcursorPositionVisible, False); argcnt++;
    XtSetArg(args[argcnt], XmNx, 2); argcnt++;
    XtSetArg(args[argcnt], XmNy, 2); argcnt++;
    help_text = XtCreateWidget("help_text",
		xmTextWidgetClass,
		scrolled_window1,
		args,
		argcnt);

    createHelpForm(help_text, (caddr_t)1, (caddr_t)0);
    XtManageChild(help_text);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNdefaultButton, dismiss_button); argcnt++;
    XtSetValues(help_form, args, argcnt);

    return( retval );
}

Widget
Createhelp_selection(parent)
Widget parent;
{
    Arg    	args[512];
    int    	argcnt;
    Widget 	retval;
    XmString	xmstr[32];
    XmString	*xmstrTable[8];
    Widget	help_selection;
    XmRegisterConverters();
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNautoUnmanage, False); argcnt++;
    XtSetArg(args[argcnt], XmNmustMatch, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 268); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 332); argcnt++;
    help_selection = XtCreateWidget("help_selection",
		xmSelectionBoxWidgetClass,
		parent,
		args,
		argcnt);

    XtAddCallback(help_selection, XmNcancelCallback, cancelHelpCB, (caddr_t)0);
    XtAddCallback(help_selection, XmNapplyCallback, popupHelpFile, (caddr_t)0);
    XtAddCallback(help_selection, XmNokCallback, popupHelpFile, (caddr_t)0);
    XtAddCallback(help_selection, XmNnoMatchCallback, popupHelpFile, (caddr_t)0);
    createHelpSelectionForm(help_selection, (caddr_t)0, (caddr_t)0);
    retval = help_selection;

    return( retval );
}

Widget
Createnew_group_selection(parent)
Widget parent;
{
    Arg    	args[512];
    int    	argcnt;
    Widget 	retval;
    XmString	xmstr[32];
    XmString	*xmstrTable[8];
    Widget	new_group_selection;
    XmRegisterConverters();
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNselectionLabelString, (xmstr[0]=XmStringCreateLtoR(
		"Group Name",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNdialogType, XmDIALOG_PROMPT); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 313); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 152); argcnt++;
    new_group_selection = XtCreateWidget("new_group_selection",
		xmSelectionBoxWidgetClass,
		parent,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(new_group_selection, XmNokCallback, XpmGroupCreate, (caddr_t)&XshCbs);
    retval = new_group_selection;

    return( retval );
}

Widget
Createremove_group_selection(parent)
Widget parent;
{
    Arg    	args[512];
    int    	argcnt;
    Widget 	retval;
    XmString	xmstr[32];
    XmString	*xmstrTable[8];
    Widget	remove_group_selection;
    XmRegisterConverters();
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNautoUnmanage, False); argcnt++;
    XtSetArg(args[argcnt], XmNselectionLabelString, (xmstr[0]=XmStringCreateLtoR(
		"Selection",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNlistLabelString, (xmstr[1]=XmStringCreateLtoR(
		"Groups",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmustMatch, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 247); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 319); argcnt++;
    remove_group_selection = XtCreateWidget("remove_group_selection",
		xmSelectionBoxWidgetClass,
		parent,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(remove_group_selection, XmNcancelCallback, cancelRemoveGroupCB, (caddr_t)0);
    XtAddCallback(remove_group_selection, XmNokCallback, XpmRemoveGroupOkCB, (caddr_t)0);
    XtAddCallback(remove_group_selection, XmNnoMatchCallback, XpmRemoveGroupOkCB, (caddr_t)0);
    createMoveToTrashForm(remove_group_selection, (caddr_t)0, (caddr_t)0);
    retval = remove_group_selection;

    return( retval );
}

Widget
Createmcform(parent)
Widget parent;
{
    Arg    	args[512];
    int    	argcnt;
    Widget 	retval;
    XmString	xmstr[32];
    XmString	*xmstrTable[8];
    Widget	mcform;
    Widget	cancel_button;
    Widget	ok_button;
    Widget	separator3;
    Widget	text2;
    Widget	to_label;
    Widget	from_label;
    Widget	text1;
    Widget	group_toggle;
    Widget	scrolled_window2;
    Widget	group_list;
    XmRegisterConverters();
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNborderWidth, (Dimension)0); argcnt++;
    XtSetArg(args[argcnt], XmNresizePolicy, XmRESIZE_ANY); argcnt++;
    XtSetArg(args[argcnt], XmNnoResize, False); argcnt++;
    XtSetArg(args[argcnt], XmNrubberPositioning, False); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 374); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 198); argcnt++;
    mcform = XtCreateWidget("mcform",
		xmFormWidgetClass,
		parent,
		args,
		argcnt);

    createCopyMoveForm(mcform, (caddr_t)0, (caddr_t)0);
    retval = mcform;
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNscrollingPolicy, XmAPPLICATION_DEFINED); argcnt++;
    XtSetArg(args[argcnt], XmNvisualPolicy, XmVARIABLE); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNbottomOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNresizable, True); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 359); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 69); argcnt++;
    scrolled_window2 = XtCreateWidget("scrolled_window2",
		xmScrolledWindowWidgetClass,
		mcform,
		args,
		argcnt);

    XtManageChild(scrolled_window2);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Move To Group",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNx, 15); argcnt++;
    XtSetArg(args[argcnt], XmNy, 10); argcnt++;
    group_toggle = XtCreateWidget("group_toggle",
		xmToggleButtonWidgetClass,
		mcform,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(group_toggle, XmNvalueChangedCallback, XpmGroupToggle, (caddr_t)0);
    createCopyMoveForm(group_toggle, (caddr_t)1, (caddr_t)0);
    XtManageChild(group_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNshadowThickness, (short)2); argcnt++;
    XtSetArg(args[argcnt], XmNcolumns, (short)47); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNresizable, True); argcnt++;
    text1 = XtCreateWidget("text1",
		xmTextWidgetClass,
		mcform,
		args,
		argcnt);

    createCopyMoveForm(text1, (caddr_t)2, (caddr_t)0);
    XtManageChild(text1);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"From:",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)20); argcnt++;
    XtSetArg(args[argcnt], XmNx, 20); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 40); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 20); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, group_toggle); argcnt++;
    from_label = XtCreateWidget("from_label",
		xmLabelWidgetClass,
		mcform,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(from_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"To:",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)20); argcnt++;
    XtSetArg(args[argcnt], XmNx, 20); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 20); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 20); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, from_label); argcnt++;
    to_label = XtCreateWidget("to_label",
		xmLabelWidgetClass,
		mcform,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(to_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNcolumns, (short)47); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNresizable, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, to_label); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, text1); argcnt++;
    text2 = XtCreateWidget("text2",
		xmTextWidgetClass,
		mcform,
		args,
		argcnt);

    createCopyMoveForm(text2, (caddr_t)3, (caddr_t)0);
    XtManageChild(text2);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNbottomOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)2); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)2); argcnt++;
    XtSetArg(args[argcnt], XmNx, 2); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 370); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 36); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, text2); argcnt++;
    separator3 = XtCreateWidget("separator3",
		xmSeparatorWidgetClass,
		mcform,
		args,
		argcnt);

    createCopyMoveForm(separator3, (caddr_t)5, (caddr_t)0);
    XtManageChild(separator3);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNhighlightOnEnter, True); argcnt++;
    XtSetArg(args[argcnt], XmNshadowThickness, (short)2); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"OK",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNshowAsDefault, (short)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)2); argcnt++;
    XtSetArg(args[argcnt], XmNbottomOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)30); argcnt++;
    XtSetArg(args[argcnt], XmNx, 30); argcnt++;
    XtSetArg(args[argcnt], XmNy, 151); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 60); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 32); argcnt++;
    ok_button = XtCreateWidget("ok_button",
		xmPushButtonWidgetClass,
		mcform,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(ok_button, XmNactivateCallback, okCopyMoveCB, (caddr_t)&XshCbs);
    XtManageChild(ok_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNshadowThickness, (short)2); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Cancel",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNbottomOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)30); argcnt++;
    XtSetArg(args[argcnt], XmNx, 284); argcnt++;
    XtSetArg(args[argcnt], XmNy, 151); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 60); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 32); argcnt++;
    cancel_button = XtCreateWidget("cancel_button",
		xmPushButtonWidgetClass,
		mcform,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(cancel_button, XmNactivateCallback, cancelCopyMoveCB, (caddr_t)0);
    XtManageChild(cancel_button);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNbottomOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNbottomWidget, ok_button); argcnt++;
    XtSetValues(separator3, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, from_label); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, from_label); argcnt++;
    XtSetValues(text1, args, argcnt);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNvisibleItemCount, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNlistSizePolicy, XmVARIABLE); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 359); argcnt++;
    group_list = XtCreateWidget("group_list",
		xmListWidgetClass,
		scrolled_window2,
		args,
		argcnt);

    createCopyMoveForm(group_list, (caddr_t)4, (caddr_t)0);
    XtManageChild(group_list);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, to_label); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, text1); argcnt++;
    XtSetValues(scrolled_window2, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNdefaultButton, ok_button); argcnt++;
    XtSetValues(mcform, args, argcnt);

    return( retval );
}

Widget
Createappform(parent)
Widget parent;
{
    Arg    	args[512];
    int    	argcnt;
    Widget 	retval;
    XmString	xmstr[32];
    XmString	*xmstrTable[8];
    Widget	appform;
    Widget	name_label;
    Widget	name_text;
    Widget	command_label;
    Widget	command_text;
    Widget	working_label;
    Widget	working_text;
    Widget	icon_label;
    Widget	icon_text;
    Widget	output_label;
    Widget	frame;
    Widget	row_column;
    Widget	xterm_toggle;
    Widget	pause_toggle;
    Widget	dummy_toggle;
    Widget	page_toggle;
    Widget	description_label;
    Widget	description_window;
    Widget	description_text;
    Widget	separator5;
    Widget	save_button;
    Widget	cancel_pushButton;
    Widget	separator4;
    Widget	optionals_label;
    XmRegisterConverters();
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNautoUnmanage, False); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 431); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 523); argcnt++;
    appform = XtCreateWidget("appform",
		xmFormWidgetClass,
		parent,
		args,
		argcnt);

    createAppForm(appform, (caddr_t)0, (caddr_t)0);
    retval = appform;
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Optional fields",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
    XtSetArg(args[argcnt], XmNleftPosition, (int)35); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)-18); argcnt++;
    XtSetArg(args[argcnt], XmNx, 151); argcnt++;
    optionals_label = XtCreateWidget("optionals_label",
		xmLabelWidgetClass,
		appform,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(optionals_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)1); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)1); argcnt++;
    XtSetArg(args[argcnt], XmNx, 1); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 429); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 20); argcnt++;
    separator4 = XtCreateWidget("separator4",
		xmSeparatorWidgetClass,
		appform,
		args,
		argcnt);

    XtManageChild(separator4);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Cancel",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNshowAsDefault, (short)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNbottomOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)30); argcnt++;
    XtSetArg(args[argcnt], XmNx, 341); argcnt++;
    XtSetArg(args[argcnt], XmNy, 478); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 60); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 30); argcnt++;
    cancel_pushButton = XtCreateWidget("cancel_pushButton",
		xmPushButtonWidgetClass,
		appform,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(cancel_pushButton, XmNactivateCallback, cancelAppForm, (caddr_t)0);
    XtManageChild(cancel_pushButton);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Save",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNshowAsDefault, (short)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNbottomOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)30); argcnt++;
    XtSetArg(args[argcnt], XmNx, 30); argcnt++;
    XtSetArg(args[argcnt], XmNy, 478); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 60); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 30); argcnt++;
    save_button = XtCreateWidget("save_button",
		xmPushButtonWidgetClass,
		appform,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(save_button, XmNactivateCallback, saveAppForm, (caddr_t)&XshCbs);
    XtManageChild(save_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNbottomOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)1); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)1); argcnt++;
    XtSetArg(args[argcnt], XmNx, 1); argcnt++;
    XtSetArg(args[argcnt], XmNy, 448); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 429); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 20); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNbottomWidget, save_button); argcnt++;
    separator5 = XtCreateWidget("separator5",
		xmSeparatorWidgetClass,
		appform,
		args,
		argcnt);

    XtManageChild(separator5);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNscrollingPolicy, XmAPPLICATION_DEFINED); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNbottomOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 411); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 126); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNbottomWidget, separator5); argcnt++;
    description_window = XtCreateWidget("description_window",
		xmScrolledWindowWidgetClass,
		appform,
		args,
		argcnt);

    XtManageChild(description_window);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Description",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    description_label = XtCreateWidget("description_label",
		xmLabelWidgetClass,
		appform,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(description_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)7); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 411); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 55); argcnt++;
    frame = XtCreateWidget("frame",
		xmFrameWidgetClass,
		appform,
		args,
		argcnt);

    XtManageChild(frame);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Output",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)25); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    output_label = XtCreateWidget("output_label",
		xmLabelWidgetClass,
		appform,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(output_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNcolumns, (short)47); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    icon_text = XtCreateWidget("icon_text",
		xmTextWidgetClass,
		appform,
		args,
		argcnt);

    createAppForm(icon_text, (caddr_t)4, (caddr_t)0);
    XtManageChild(icon_text);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Icon file name",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    icon_label = XtCreateWidget("icon_label",
		xmLabelWidgetClass,
		appform,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(icon_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNcolumns, (short)47); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    working_text = XtCreateWidget("working_text",
		xmTextWidgetClass,
		appform,
		args,
		argcnt);

    createAppForm(working_text, (caddr_t)3, (caddr_t)0);
    XtManageChild(working_text);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Working directory",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    working_label = XtCreateWidget("working_label",
		xmLabelWidgetClass,
		appform,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(working_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNcolumns, (short)47); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)70); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    command_text = XtCreateWidget("command_text",
		xmTextWidgetClass,
		appform,
		args,
		argcnt);

    createAppForm(command_text, (caddr_t)2, (caddr_t)0);
    XtManageChild(command_text);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Command",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, separator4); argcnt++;
    command_label = XtCreateWidget("command_label",
		xmLabelWidgetClass,
		appform,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(command_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNcolumns, (short)66); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    name_text = XtCreateWidget("name_text",
		xmTextWidgetClass,
		appform,
		args,
		argcnt);

    createAppForm(name_text, (caddr_t)1, (caddr_t)0);
    XtManageChild(name_text);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Name",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNy, 10); argcnt++;
    name_label = XtCreateWidget("name_label",
		xmLabelWidgetClass,
		appform,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(name_label);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, name_label); argcnt++;
    XtSetValues(name_text, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, command_label); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)70); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, command_label); argcnt++;
    XtSetValues(command_text, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, command_label); argcnt++;
    XtSetValues(working_label, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, working_label); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, command_text); argcnt++;
    XtSetValues(working_text, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, working_label); argcnt++;
    XtSetValues(icon_label, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, icon_label); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, command_text); argcnt++;
    XtSetValues(icon_text, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)25); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, icon_label); argcnt++;
    XtSetValues(output_label, args, argcnt);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNspacing, (Dimension)3); argcnt++;
    XtSetArg(args[argcnt], XmNpacking, XmPACK_COLUMN); argcnt++;
    XtSetArg(args[argcnt], XmNnumColumns, (short)2); argcnt++;
    XtSetArg(args[argcnt], XmNx, 2); argcnt++;
    XtSetArg(args[argcnt], XmNy, 2); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 407); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 51); argcnt++;
    row_column = XtCreateWidget("row_column",
		xmRowColumnWidgetClass,
		frame,
		args,
		argcnt);

    XtManageChild(row_column);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"xterm window",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNset, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 3); argcnt++;
    XtSetArg(args[argcnt], XmNy, 3); argcnt++;
    xterm_toggle = XtCreateWidget("xterm_toggle",
		xmToggleButtonWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(xterm_toggle, XmNvalueChangedCallback, xtermToggleCB, (caddr_t)0);
    createAppForm(xterm_toggle, (caddr_t)5, (caddr_t)0);
    XtManageChild(xterm_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"pause after done",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 3); argcnt++;
    XtSetArg(args[argcnt], XmNy, 27); argcnt++;
    pause_toggle = XtCreateWidget("pause_toggle",
		xmToggleButtonWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(pause_toggle, XmNvalueChangedCallback, pauseToggleCB, (caddr_t)0);
    createAppForm(pause_toggle, (caddr_t)6, (caddr_t)0);
    XtManageChild(pause_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNsensitive, False); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"t",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNvisibleWhenOff, False); argcnt++;
    XtSetArg(args[argcnt], XmNset, False); argcnt++;
    XtSetArg(args[argcnt], XmNx, 147); argcnt++;
    XtSetArg(args[argcnt], XmNy, 3); argcnt++;
    dummy_toggle = XtCreateWidget("dummy_toggle",
		xmToggleButtonWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    _XmCWidgetMakeInvisible(dummy_toggle, (caddr_t)0, (caddr_t)0);
    XtManageChild(dummy_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"page through",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 147); argcnt++;
    XtSetArg(args[argcnt], XmNy, 27); argcnt++;
    page_toggle = XtCreateWidget("page_toggle",
		xmToggleButtonWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(page_toggle, XmNvalueChangedCallback, pageToggleCB, (caddr_t)0);
    createAppForm(page_toggle, (caddr_t)7, (caddr_t)0);
    XtManageChild(page_toggle);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)7); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, output_label); argcnt++;
    XtSetValues(frame, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, frame); argcnt++;
    XtSetValues(description_label, args, argcnt);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNeditMode, XmMULTI_LINE_EDIT); argcnt++;
    XtSetArg(args[argcnt], XmNcolumns, (short)63); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)7); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    description_text = XtCreateWidget("description_text",
		xmTextWidgetClass,
		description_window,
		args,
		argcnt);

    createAppForm(description_text, (caddr_t)8, (caddr_t)0);
    XtManageChild(description_text);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, description_label); argcnt++;
    XtSetValues(description_window, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, name_text); argcnt++;
    XtSetValues(separator4, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)-18); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, separator4); argcnt++;
    XtSetValues(optionals_label, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNdefaultButton, save_button); argcnt++;
    XtSetValues(appform, args, argcnt);

    return( retval );
}

