/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */


#include <stdio.h>
#include <unistd.h>
extern char *_freedompath;
extern char *_homepath;
extern char *_lfreedompath;
extern char *_treename;
extern char *_treepath;

#include "etc.h"

/*
 * _setup: set up system files
 */

int _setup () {

  char *cmd;
  char *loc_res_path;
  int status = 0;

  /* resource file */
  loc_res_path = _dircat (_homepath, "Freedom");
  if (!loc_res_path) {
	fprintf (stderr, "setup: dircat failed\n");
	return (-1);
  }

  /* check if resource file exists */
  if (access (loc_res_path, R_OK ) < 0) {
	inst_resfile (); /* install resource file */
  }

  if (access (loc_res_path, R_OK ) < 0) {
        perror (loc_res_path);
        free (loc_res_path);
        return (-1);
  }

  /* check if .freedom exists */
  if (access (_lfreedompath, R_OK ) < 0) {
	status = inst_tree (); /* create the groups directory */
  }

  if (access (_lfreedompath, R_OK ) < 0) {
        perror (_lfreedompath);
	return (-1);
  }

  return (status);
   
}

/* 
 * inst_resfile: install resource file
 */

int inst_resfile ()
{

char *sys_res_path;
char *cmd;
int status;
char *argv[5];

  sys_res_path = _dircat (_freedompath, "Freedom");
  if (!sys_res_path) {
        fprintf (stderr, "setup: dircat failed\n");
        return (-1);
  }

#ifdef OLD
  cmd = cmcat ("/bin/cp", sys_res_path, _homepath, NULL);

  free (sys_res_path);
  if (!cmd) {
        fprintf (stderr, "setup: cmcat failed\n");
        return (0);
  }
  
  if ((status = system (cmd)) < 0)
	perror ("system");  
  
  free (cmd);
#endif
  argv[0] = "/bin/cp";
  argv[1] = "cp";
  argv[2] = sys_res_path;
  argv[3] = _homepath;
  argv[4] = '\0';
  if ((status = executev (argv, NULL, 1)) < 0)
	return (-1);

  free (sys_res_path);
  return (status);
}

/*
 * inst_tree: Install .freedom directory
 */

int inst_tree ()
{
  char *cmd;
  int status;
  char *argv[6];

  _treepath = _dircat (_freedompath, _treename);
  
  if (!_treepath) {
        fprintf (stderr, "setup: _dircat failed\n");
	return (-1);
  }

  argv[0] = "/bin/cp";
  argv[1] = "cp";
  argv[2] = "-r";
  argv[3] = _treepath;
  argv[4] = _homepath;
  argv[5] = '\0';

#ifdef OLD
  cmd = cmcat ("/bin/cp -r", _treepath, _homepath, NULL);

  if ((status = system (cmd)) < 0)
        perror ("system");

  free (cmd);
#endif

  if ((status = executev (argv, NULL, 1)) < 0)
	return (-1);

  free (_treepath);
  return (status);
}
