#include	<stdio.h>
#include        <sys/wait.h>
#include        <signal.h>

/*
 * _usignal: reliable signal function taken from the book Advanced 
 *          programming in the Unix environment by Richard Stevens
 */

void *_usignal (signo, func)
int signo;
void (*func) ();
{
   struct sigaction act, oact;

   act.sa_handler = func;
   sigemptyset (&act.sa_mask);
   act.sa_flags = 0;

   if (signo == SIGALRM) {
#ifdef SA_INTERRUPT
        act.sa_flags |= SA_INTERRUPT; /* SunOS */
#endif
   } else {
#ifdef SA_RESTART
        act.sa_flags |= SA_RESTART; /* SunOS */
#endif
   }

   if (sigaction (signo, &act, &oact) < 0) {
        perror ("_signal");
        return (SIG_ERR);
   }
   return (oact.sa_handler);
}

void reapchild ()
{
 int ret;
   while ((ret = waitpid (-1, NULL, WNOHANG)) > 0) {
#ifdef DEBUG
        fprintf (stderr, "wait returned %d\n", ret);
#endif
   }
#ifdef DEBUG
   fprintf (stderr, "wait returned %d\n", ret);
#endif
}

