
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <X11/Shell.h>
#include <Xm/ScrolledW.h>
#include <Xm/LabelG.h>
#include <Xm/ScrollBar.h>
#include <Xm/Separator.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "lst.h"
#include "build_option.h"
#include "Dir.h"
#include "Xsh.h"
#include "etc.h"
#include "X.h"
#include "file.h"
#include "XedwList.h"
#include "pixmaps.h"
#include "ptyx.h" 

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <pwd.h>
#include <string.h>

extern XtermWidget term;
void XshDirWidgetResize ();
void XshDoubleClick ();
int ncmp();
static void UpdateDirText ();
int current_mode;
void XshCD();

void XshOpen ();
void XshNewDirectory ();
void XshChangeTo ();
void XshCopyTo ();
void XshMoveTo ();
void XshProperties ();
void XshRemove ();
void XshClose ();
void XshHome ();
void XshUp ();
void XshChangeTo ();
void XshPrint ();
void XshFind ();

String   cwd;
XwDirWidget dirWidget;
Widget scrolledWindow;
Widget widgetArray[MAX_WIDGET];
XshCallbackStruct XshCbs;
extern Widget panedWindow;

Widget fileSelectionBox, dirText;
extern Widget selection_box;
EntryFormObject menuForm = NULL;

MenuItem file_menu[] = {
#ifdef OLD
	{"File Items", &xmLabelGadgetClass, NULL, NULL, NULL,
	NULL, NULL, NULL},
#endif
	{"separator0", &xmSeparatorWidgetClass, NULL, NULL, NULL,
	NULL, NULL, NULL},
	{"Open", &xmPushButtonGadgetClass, NULL, NULL, NULL,
	XshOpen, (XtPointer) &XshCbs, NULL},
	{"separator1", &xmSeparatorWidgetClass, NULL, NULL, NULL,
	NULL, NULL, NULL},
	{"New Directory ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshNewDirectory, (XtPointer) &XshCbs, NULL}, 
	{"Home", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshHome, (XtPointer) &XshCbs, NULL}, 
	{"Up", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshUp, (XtPointer) &XshCbs, NULL}, 	
	{"Change To ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshChangeTo, (XtPointer) &XshCbs, NULL}, 
	{"separator2", &xmSeparatorWidgetClass, NULL, NULL, NULL,
	NULL, NULL, NULL},
	{"Copy To ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshCopyTo, (XtPointer) &XshCbs, NULL}, 
	{"Move To ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshMoveTo, (XtPointer) &XshCbs, NULL}, 
	{"separator3", &xmSeparatorWidgetClass, NULL, NULL, NULL,
	NULL, NULL, NULL},
	{"Print ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshPrint, (XtPointer) &XshCbs, NULL}, 
	{"Find ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshFind, (XtPointer) &XshCbs, NULL}, 	
	{"separator4", &xmSeparatorWidgetClass, NULL, NULL, NULL,
	NULL, NULL, NULL},
	{"Close", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshClose, (XtPointer) &XshCbs, NULL}, 
	NULL,
};

MenuItem dummy_actions[] = {
	{"Open", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshOpen, (XtPointer) &XshCbs, NULL},
	NULL,
};

MenuItem item_menu[] = {
	{"Actions", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshOpen, (XtPointer) &XshCbs, dummy_actions},
	{"separator1", &xmSeparatorWidgetClass, NULL, NULL, NULL,
	NULL, NULL, NULL},
	{"Copy To ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshCopyTo, (XtPointer) &XshCbs, NULL}, 
	{"Move To ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshMoveTo, (XtPointer) &XshCbs, NULL}, 
	{"Properties ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshProperties, (XtPointer) &XshCbs, NULL}, 
	{"separator2", &xmSeparatorWidgetClass, NULL, NULL, NULL,
	NULL, NULL, NULL},
	{"Print ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshPrint, (XtPointer) &XshCbs, NULL}, 
#ifdef OLD
	{"Move To Trash", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XshRemove, (XtPointer) &XshCbs, NULL},
#endif 
	NULL,
};

void XshHandlePopupMenu(w, client, call_data)
Widget w;
caddr_t client;
XedwCallbackStruct *call_data;
{
  static Widget fmenu = NULL;		/* file menu 				*/ 
  static Widget imenu = NULL;		/* item menu (one item selected) 	*/
  int cnt;
  Widget dw = w;
  static Widget actions_cascade = NULL;
  
   cnt = XwDirSelectedItemCount (dw);
   
   if (!cnt) {
      if (!fmenu) {
         fmenu = BuildMenu(dw, XmMENU_POPUP, "File", '\0', file_menu, NULL);
      }
      
      if (!fmenu) {
#ifdef DEBUG
	fprintf (stderr, "XshHandlePopupMenu: buildMenu failed\n");
#endif
      	return;
      }
      	
      XmMenuPosition(fmenu, (XButtonPressedEvent *) call_data->event);
      XtManageChild(fmenu);
      return;
   }
   
   if (cnt >= 1) {
      if (!imenu) {
         imenu = BuildMenu(w, XmMENU_POPUP, "Item", '\0', item_menu, NULL);
      }
      
      if (!imenu) {
#ifdef DEBUG
	fprintf (stderr, "XshHandlePopupMenu: buildMenu failed\n");
#endif
      	return;
      }

      if (!actions_cascade)
         actions_cascade = _XmCFindMenuItem (imenu, "Actions");
         
      if (actions_cascade) 
         _CreateASubMenu (dw, actions_cascade);
      	
      XmMenuPosition(imenu, (XButtonPressedEvent *) call_data->event);
      XtManageChild(imenu);
      return;
   }

}

/*
 * Create an entry form structure and add fields to it
 */

void createMenuForm(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{

   if (!menuForm) {
        menuForm = _EntryFormCreate ();
   }

   if (!menuForm ) {
        fprintf (stderr, "createMenuForm: _EntryFormCreate failed\n");
        return;
   }

   _EntryFormSInsertField (menuForm, w, (int) client);
}


/*
 * XshPanedWindowCreate: creation callback (paned window)
 */

void XshPanedWindowCreate(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
	panedWindow = w;
}

/*
 * XshFileSBoxCreate: creation callback (file selection box)
 */

void XshFileSBoxCreate(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
	fileSelectionBox = w;
	XtAddCallback (w, XmNokCallback, XshCD, dirWidget);
}

/*
 * XpmSelectCB: Callback invoked when there is a change
 *              in the list of items selected
 */

void XshSelectCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   int cnt;
   Widget dw = w;
   Widget actions_button = _EntryFormPosToWidget (menuForm, 16);
   
   cnt = XwDirSelectedItemCount (dw);
   
   if (cnt != 1) {
	XtSetSensitive (actions_button, False);
        _ActionMenuDelItems (actions_button);
        return;
   }
   
   _ActionMenuDelItems (actions_button); 
   
   /*
    * Slow
    */
    
   XwDirActionMenuAddItems (dw, actions_button, _SKIP_CREATION);
   if (!XwDirIfDefActions (dw))
	XtSetSensitive (actions_button, False);
   else   	   
	XtSetSensitive (actions_button, True);
}



/*
 * ScrollCreate:  create directory widget
 */

void ScrollCreate(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
    Arg         args[12];
    int         argcnt;
    Widget 	hsb, vsb;
    char	*kk;


    scrolledWindow = w;

    dirWidget = (XwDirWidget) XtVaCreateManagedWidget( "directoryManager",
        xwDirWidgetClass, w,
        XtNshowIcons, False,
        XtNrowSpacing, 5,
        XtNforceColumns,   False,
        XtNdefaultColumns, 4,
        XtNmSelections,    True,
        XtNshowIcons, True,
	XtNbaseDirectory, _freedompath,
        NULL ) ;

    argcnt = 0;
    XtSetArg(args[argcnt], XtNdirectoryPath, &kk);argcnt++; 
    XtGetValues (dirWidget, args, argcnt);

    ((XshCallbackStruct *) client)->XshDirWidget = (Widget) dirWidget; 

    XmTextSetString (dirText, kk);

    XtAddCallback(dirWidget, XtNdoubleClick,
                XshDoubleClick, NULL);

    XtAddCallback(dirWidget, XtNhandlePopup, XshHandlePopupMenu, 
  		NULL);

    XtAddCallback(dirWidget, XtNcallback, XshSelectCB , 
  		NULL);
   

    XtVaGetValues(w, XmNhorizontalScrollBar, &hsb, XmNverticalScrollBar, 
	&vsb, NULL);

    if (hsb)
	XtVaSetValues (hsb, XmNtraversalOn, False, NULL);

    if (vsb)
	XtVaSetValues (vsb, XmNtraversalOn, False, NULL);

}

/*
 * XshDoubleClick: doubleclick callback
 */

void XshDoubleClick (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   char *path;
    	XtVaGetValues (dirWidget, XtNdirectoryPath, &path, NULL);
        XmTextSetString (dirText, path);
}

/*
 * XshChangeTo: Change To ...  menu option activate callback
 */

void XshChangeTo(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   Widget dirWidget = ((XshCallbackStruct *) client)->XshDirWidget;
   char *path;
   XmString Path;


	/* Get current directory */

    	XtVaGetValues (dirWidget, XtNdirectoryPath, &path, NULL);

	Path = XmStringCreateSimple(path);


	XtVaSetValues (fileSelectionBox, XmNfileTypeMask, XmFILE_DIRECTORY, 
			XmNdirectory, Path, XmNdialogStyle, 
			XmDIALOG_PRIMARY_APPLICATION_MODAL,
			NULL);

#ifdef DEBUG
	fprintf (stderr, "XshChangeTo: %s\n", path);
#endif

	/* Popup dialog */

	XtManageChild (fileSelectionBox);
	XtPopup (XtParent(fileSelectionBox), XtGrabNone);

	/* Free memory */

	XmStringFree (Path);
}

/*
 * XshCleanupWindow: Arrange Icons menu option activate callback
 */

void XshCleanupWindow(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{

    Widget dir = ((XshCallbackStruct *) client)->XshDirWidget;

   XtCallActionProc (((XshCallbackStruct *) client)->XshDirWidget,
                        "Cleanup", NULL, NULL, 0);

}

/*
 * XshCleanupWindow: Close menu option activate callback
 */

void XshClose(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
	exit (0);
}

static Widget currDirLabel = NULL;
static Widget from = NULL;

/*
 * XshMoveTo: Move To ... menu option activate callback
 */

void XshMoveTo(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
  char *path;
  Widget dw = ((XshCallbackStruct *) client)->XshDirWidget;
  char *label;


        if (!currDirLabel)
           currDirLabel = XtNameToWidget (shellD, "*current_label");

        if (!from) 
	   from = XtNameToWidget (shellD, "*from_text");

        if (!currDirLabel || !from) {
           fprintf (stderr, "XshMoveTo: Invalid widget name\n");
           return;
        }

        XtVaSetValues (shellD, XmNtitle, "Move", NULL);

	/* get title */

        XtVaGetValues (dw, XtNdirectoryPath, &path, NULL);

	label = _strconcat ("Current directory is ", path);
	XLabelSetString (currDirLabel, label);
        free (label);

        XmTextSetString (from, XwDirFilesSelected(dw));

        XtManageChild (widgetArray[FORM1]);
        XtPopup (shellD, XtGrabNone);
}


/*
 * XshCopyTo: Copy To ... menu option activate callback
 */


void XshCopyTo(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
  char *path;
  Widget dw = ((XshCallbackStruct *) client)->XshDirWidget;
  char *label;


	if (!currDirLabel)
	   currDirLabel = XtNameToWidget (shellD, "*current_label");

        if (!from)
           from = XtNameToWidget (shellD, "*from_text");

	if (!currDirLabel || !from) {
           fprintf (stderr, "XshCopyTo: Invalid widget name\n");
           return;
	}

        XtVaSetValues (shellD, XmNtitle, "Copy", NULL);

        XtVaGetValues (dw, XtNdirectoryPath, &path, NULL);
	
	XLabelConcatString (currDirLabel, path);
        label = _strconcat ("Current directory is ", path);
        XLabelSetString (currDirLabel, label);
        free (label);

	XmTextSetString (from, XwDirFilesSelected(dw));
	
        XtManageChild (widgetArray[FORM1]);
	XtPopup (shellD, XtGrabNone);

}


/*
 * XshOpenTrash: Open Trash menu option activate callback
 */


void XshOpenTrash(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   char *argv[6];
   extern char *_freedompath;
   static char *cmdpath = NULL;

   if (!cmdpath)
	cmdpath = _dircat (_freedompath, "bin/Xtrash");

   if (!cmdpath) {
	fprintf (stderr, "XshOpenTrash: _dircat failed\n");
	return;
   }

   argv[0] = cmdpath;
   argv[1] = "Xtrash";
   argv[2] = '\0';

   if (executev (argv, NULL, 0) < 0) 
	fprintf (stderr, "XshOpenTrash: executev failed\n");
}

/*
 * XshEmptyTrash: empty trash menu option activate callback
 */

XshEmptyTrash(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   char **argv;
   char *tmp;
   XwDirWidget dw = (XwDirWidget) ((XshCallbackStruct *) client)->XshDirWidget;
   char *cmdpath;
   extern char *_freedompath,  *_homepath;

   XtCallActionProc (((XshCallbackStruct *) client)->XshDirWidget,
                        "EmptyTrash", NULL, NULL, 0);
   return;
}


/*
 * XshFind: Find .. menu option activate callback
 */

void XshFind(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   XwDirWidget dw = (XwDirWidget) ((XshCallbackStruct *) client)->XshDirWidget;
   char **argv;
   char *path;
   char *cmdpath;

   if (!(argv = (char **) malloc (sizeof (char *) * 4))) {
        fprintf (stderr,
              "XshFind: not enough memory\n");
        return;
   }

   cmdpath = _dircat (_freedompath, "bin/Xfind");

   if (!cmdpath)
	return;

   XtVaGetValues (dw, XtNdirectoryPath, &path, NULL);

   argv[0] = cmdpath;
   argv[1] = "Xfind";
   argv[2] = path;
   argv[3] = '\0';

   if (executev (argv, path, 0) < 0) 
        fprintf (stderr, "XshFind: executev failed\n");

   free (cmdpath);
   free (argv);
}


/*
 * XshHome: Home menu option activate callback
 */

void XshHome(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
    int         argcnt;
    static char *path;
    char *kk;


    XwDirChange (((XshCallbackStruct *) client)->XshDirWidget, NULL); 
    UpdateDirText (((XshCallbackStruct *) client)->XshDirWidget);

}

/*
 * XshShortListing: Short listing menu option activate callback
 */

void XshShortListing(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
        XmToggleButtonSetState (w, True, False);
        XmToggleButtonSetState (_EntryFormPosToWidget (menuForm, 10), False, 
		False);
        XmToggleButtonSetState (_EntryFormPosToWidget (menuForm, 12), False, 
		False);
    	XwDirShortListing (((XshCallbackStruct *) client)->XshDirWidget);
}

/*
 * XshLongListing: Long listing menu option activate callback
 */

void XshLongListing(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{

        XmToggleButtonSetState (w, True, False);
        XmToggleButtonSetState (_EntryFormPosToWidget (menuForm, 10), False, 
		False);
        XmToggleButtonSetState (_EntryFormPosToWidget (menuForm, 11), False, 
		False);
    	XwDirLongListing (((XshCallbackStruct *) client)->XshDirWidget);

}

#include "build_option.h"
extern  MenuItem c_menu[];

/*
 * XshHiddenFiles: hidden files menu option activate callback
 */

void XshHiddenFiles (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   XmToggleButtonCallbackStruct *cbs=(XmToggleButtonCallbackStruct*)call;

   if (!cbs->set)
       XtVaSetValues (((XshCallbackStruct *) client)->XshDirWidget, 
		XtNshowHidden, False, NULL);
   else
       XtVaSetValues (((XshCallbackStruct *) client)->XshDirWidget, 
		XtNshowHidden, True, NULL);

}

/*
 * XshNewDirectory: Popup new directory selection box
 */

void XshNewDirectory(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
	XtManageChild (selection_box);
        XtPopup (XtParent(selection_box), XtGrabNone);
}


/*
 * Create Directory Selection Box - Apply Callback
 */

void XshDirCreate (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{ 
   char *dname; /* Directory Name */

   XmSelectionBoxCallbackStruct *cbs=(XmSelectionBoxCallbackStruct*)call;

	XmStringGetLtoR (cbs->value, XmSTRING_DEFAULT_CHARSET, &dname);

	XwDirCreate (((XshCallbackStruct *) client)->XshDirWidget, dname);
	XtFree (dname);
}


/*
 * XshOpen: open menu option activate callback
 */

void XshOpen(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
    int         argcnt;
    static char *path;
    

   XtCallActionProc (((XshCallbackStruct *) client)->XshDirWidget,
			"Activate", NULL, NULL, 0);
   UpdateDirText (((XshCallbackStruct *) client)->XshDirWidget);

}


/*
 * XshPrint: print menu option activate callback
 */

void XshPrint(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   char **files, **argv;
   XedwListWidget ilw = (XedwListWidget) ((XshCallbackStruct *) client)->XshDirWidget;
   char **tmp;
   char *cmdpath;
   char *path;

	files = XwCollVItemsSelected (ilw);


	if (!files || !*files) {
	   files = (char **) malloc (sizeof (char *));
	   if (!files) {
	      fprintf (stderr, "malloc: not enough memory\n");
	      return;
	   }
	   files[0] = '\0';
	}

        cmdpath = _dircat (_freedompath, "bin/Xlp");

	argv = _preappend (files, cmdpath, "Xlp", NULL);

	if (!argv) {
	   fprintf (stderr, "XshPrint: _preappend failed\n");
	   return;
	}

        XtVaGetValues (ilw, XtNdirectoryPath, &path, NULL);


   	if (executev (argv, path, 0) < 0)
           fprintf (stderr, "XshPrint: executev failed\n");

	free (cmdpath);
	free (argv);

}

 
MenuItem *CreateOwnersMenu ()
{
  struct passwd *pw;
  int n = 0;
  MenuItem *ownersMenu = NULL, *tmp;
  
   setpwent ();

   if ((pw = getpwent ()) == NULL) { 
	fprintf (stderr, "CreateOwnersMenu: getwent failed\n");
	return (NULL);
   }

   ownersMenu = (MenuItem *) malloc (sizeof (MenuItem));
   if (!ownersMenu) {
	fprintf (stderr, "CreateOwnersMenu: not enough memory\n");
	return (NULL);
   }

   memset (ownersMenu, '\0', sizeof (MenuItem));
   ownersMenu->label = strdup (pw->pw_name);
   if (!ownersMenu->label) {
	fprintf (stderr, "CreateOwnersMenu: not enough memory\n");
	free (ownersMenu);
	return (NULL);
   }

   for (n = 1; pw = getpwent(); n++) {
	tmp = (MenuItem *) realloc (ownersMenu, (n + 1) * sizeof (MenuItem));

	if (!tmp) {
		fprintf (stderr, "CreateOwnersMenu: not enough memory\n");
		free (ownersMenu);
		return (NULL);
	}
	ownersMenu = tmp;
        memset (&ownersMenu[n], '\0', sizeof (MenuItem));
	ownersMenu[n].label = strdup (pw->pw_name);
	if (!ownersMenu[n].label) {
        	fprintf (stderr, "CreateOwnersMenu: not enough memory\n");
        	free (ownersMenu);
        	return (NULL);
   	}

   }
   tmp = (MenuItem *) realloc (ownersMenu, (n + 1) * sizeof (MenuItem));
   if (!tmp) {
	fprintf (stderr, "CreateOwnersMenu: not enough memory\n");
	free (ownersMenu);
	return (NULL);
   }
   ownersMenu = tmp;
   ownersMenu[n].label = NULL;
   endpwent ();
   return (ownersMenu);
}


/*
 * XshProperties: Properties .. menu option callback
 */

void XshProperties(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
char *path;
extern MenuItem *CreateOwnersMenu ();
Widget dw = ((XshCallbackStruct *) client)->XshDirWidget;
char **files;

        XtVaGetValues (dw, XtNdirectoryPath, &path, NULL);

	files = XwCollVItemsSelected (dw);

   	if (!files || !*files) {
             _XmCErrorDialogPost (dw,
             "Please select a file before invoking this operation", "Warning");
             return;
   	}

	if (!path)
	  return;

	if (showFirstFile (path, files) < 0)
		return;
        XtManageChild (widgetArray[FORM2]);
        XtPopup (shellC, XtGrabNone);
}

/*
 * XshRemove: Move To Trash menu option callback
 */

void XshRemove(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   char **files;
   Widget dw = ((XshCallbackStruct *) client)->XshDirWidget;

        files = XwCollVItemsSelected(dw);

        if (!files || !*files) {
           _XmCErrorDialogPost (dw,
           "Please select a file before invoking this operation",
"Warning");
           return;
        }

	XwDirEntriesRemove (dw);
	free (files);

}

/*
 * Select All menu option callback
 */

void XshSelectAll(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{

   XwCollHighlightAll (((XshCallbackStruct *) client)->XshDirWidget);

}


/*
 * Unselect All menu option callback
 */

void XshUnselectAll(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{

   XedwAListUnhighlight (((XshCallbackStruct *) client)->XshDirWidget);

}


/*
 * XshSmallIcons: Icons menu option activate callback
 */

void XshSmallIcons(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
    int         argcnt;
    XwDirWidget dw = (XwDirWidget) ((XshCallbackStruct *) client)->XshDirWidget;

    argcnt = 0;

    XmToggleButtonSetState (w, True, False);
    XmToggleButtonSetState (_EntryFormPosToWidget (menuForm, 11), False, False);
    XmToggleButtonSetState (_EntryFormPosToWidget (menuForm, 12), False, False);

    XwDirSmallIcons (dw);

}

/*
 * XshSortByDate: Sort by date menu option activate callback
 */

void XshSortByDate(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
        XwDirSortByDate (((XshCallbackStruct *) client)->XshDirWidget);
}

/*
 * XshSortByName: Sort by name menu option activate callback
 */

void XshSortByName(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
        XwDirSortByName (((XshCallbackStruct *) client)->XshDirWidget);
}

/*
 * XshSortBySize: Sort by size menu option activate callback
 */

void XshSortBySize(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
        XwDirSortBySize (((XshCallbackStruct *) client)->XshDirWidget);
}

/*
 * XshSortByType: Sort by type menu option activate callback
 */

void XshSortByType(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
        XwDirSortByType (((XshCallbackStruct *) client)->XshDirWidget);
}

/*
 * XshUp: Up menu option activate callback
 */

void
XshUp(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
    int         argcnt;
    static char *path;
    char cwd[512];

    XwDirChange (((XshCallbackStruct *) client)->XshDirWidget, "../");
    UpdateDirText (((XshCallbackStruct *) client)->XshDirWidget);

}

void XshDirWidgetResize (w, dw, event)
Widget w;
Widget dw;
XEvent *event;
{
    Arg         args[4];
    int         argcnt;
    XConfigureEvent *ev = (XConfigureEvent *) event;
    fprintf (stderr, "XshDirWidgetResize\n");

    argcnt = 0;
    XtSetArg(args[argcnt], XtNheight, ev->height);argcnt++;
    XtSetArg(args[argcnt], XtNwidth, ev->width);argcnt++;
    fprintf (stderr, "XshDirWidgetResize %d %d\n", ev->width, ev->height);
    XtSetValues (dw, args, argcnt);
}



/*
 * XshCD: Ok button activate callback (Change Directory dialog)
 */

void XshCD(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   XmFileSelectionBoxCallbackStruct *cbs=(XmFileSelectionBoxCallbackStruct*)call;
   char *path;

	XtUnmanageChild (w);
	XSync (XtDisplay(w), False);
        XtPopdown(XtParent(w));
	XSync (XtDisplay(w), False);
	if (!XmStringGetLtoR (cbs->value, XmSTRING_DEFAULT_CHARSET, &path))
		return;
	XwDirChange ((Widget) client, path);
	XtFree (path);
    	UpdateDirText (client);
}

void XshSetDirectory(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
 /* to do list */
}


/*
 * XshDirTextCreate: directory_text widget creation callback
 */

void XshDirTextCreate (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   dirText = w;
   XtVaSetValues (w, XmNtraversalOn, False, NULL);

}

/*
 * UpdateDirText: Update directory_text widget
 */

static void UpdateDirText (w)
Widget w;
{
   char *path;

        XtVaGetValues (w, XtNdirectoryPath, &path, NULL);
    	XmTextSetString (dirText, path);
}

createCopyMoveForm (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
	
}

/*
 * okCopyMoveCB: Ok button activate callback (Copy/Move dialog)
 */

okCopyMoveCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
  static Widget to = NULL;
  char *source, *target;
  char **argv;
  static char mvCmd[] = "mv";
  static char cpCmd[] = "cp -r";
  char *title;
  char *cmd;
  char *path;
  

   /* get source and target */

   if (!from) 
	from = XtNameToWidget (shellD, "*from_text");

   if (!to)
	to = XtNameToWidget (shellD, "*to_text");
	   
   if (!from || !to) {
	fprintf (stderr, "okCopyMoveCB: Invalid widget name\n");
   	XtPopdown((shellD));
	return;
   }

   XtVaGetValues (shellD, XmNtitle, &title, NULL);

   source = XmTextGetString (from);
   target = XmTextGetString (to);

   if (!strcmp (source, "") || !strcmp (target, "")) {
#ifdef DEBUG
	fprintf (stderr, "okCopyMoveCB: Missing source and/or target\n");
#endif
   	XtPopdown((shellD));
	return;
   }

   XmTextSetString (from, "");
   XmTextSetString (to, "");

   
   /* build command line */
   if (!strcmp (title, "Move"))
   	cmd = cmcat (mvCmd, source, target, NULL);
   else
   	cmd = cmcat (cpCmd, source, target, NULL);

   if (!cmd) {
	fprintf (stderr, "cmcat failed\n"); 
   	XtPopdown((shellD));
	return;
   }

#ifdef DEBUG
   fprintf (stderr, "cmd = %s\n", cmd);
#endif

   argv = cnvStrToArgv (cmd); 

   if (!argv) {
	fprintf (stderr, "okCopyMoveCB: Too many parameters\n"); 
   	XtPopdown((shellD));
	return;
   }

   XtVaGetValues (((XshCallbackStruct *) client)->XshDirWidget, 
		XtNdirectoryPath, &path, NULL);


   XwDirExecute (((XshCallbackStruct *) client)->XshDirWidget, argv, path, _SHELL);
   XtFree (source);
   XtFree (target);
   XtPopdown((shellD));
}

/*
 * cancelCopyMoveCB: cancel button activate callback
 */

cancelCopyMoveCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   XtPopdown((shellD));
}

/*
 * XshSynchronize: Synchronize menu option activate callback
 */

XshSynchronize (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   Widget dirWidget = ((XshCallbackStruct *) client)->XshDirWidget;

   XwDirSynchronize (dirWidget);
}

/*
 * XshKeepSynchronized: Keep synchronized menu option activate callback
 */

XshKeepSynchronized (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   XmToggleButtonCallbackStruct *cbs=(XmToggleButtonCallbackStruct*)call;
   Widget dirWidget = ((XshCallbackStruct *) client)->XshDirWidget;

   if (cbs->set)
      XtVaSetValues (dirWidget, XtNkeepSynchronized, True, NULL);
   else
      XtVaSetValues (dirWidget, XtNkeepSynchronized, False, NULL);

}

/*
 * XshTerminalMode: Terminal mode menu option activate callback
 */

XshTerminalMode (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   XmToggleButtonCallbackStruct *cbs=(XmToggleButtonCallbackStruct*)call;
   Widget dirWidget = ((XshCallbackStruct *) client)->XshDirWidget;

   if (cbs->set) {
        XtVaSetValues (dirWidget, XtNtermMode, True, NULL);
   } else
      XtVaSetValues (dirWidget, XtNtermMode, False, NULL);

}

/*
 * setXshPixmap: set label pixmap
 */

setXshPixmap (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
  extern char *_iconspath;
  char *icon_file;
  PicInfo Pic;
  int status;

   icon_file = _dircat (_iconspath, "cabinet1.xpm");
   if (!icon_file)
	return;
   memset ((char *) &Pic, '\0', sizeof (Pic));

   Pic.attributes.valuemask = XpmReturnPixels;

   status = XpmReadFileToPixmap(XtDisplay (w),
              XRootWindowOfScreen(XtScreen(w)),
              icon_file,
              &Pic.pixmap,
              &Pic.mask,
              &Pic.attributes); 
   free (icon_file);

   if (status != XpmSuccess &&
       status != XpmColorError)
	  return;

   XtVaSetValues (w, XmNlabelType, XmPIXMAP, 
	XmNlabelPixmap, Pic.pixmap, NULL);
}


/*
 * XshCreateActionMenu: create actions menu
 */

void XshCreateActionMenu (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   int cnt;
   Widget actions_button = _EntryFormPosToWidget (menuForm, 16);
   Widget dw = ((XshCallbackStruct *) client)->XshDirWidget;
   
   cnt = XwDirSelectedItemCount (dw);
   
   if (cnt != 1) {
	XtSetSensitive (actions_button, False);
        _ActionMenuDelItems (actions_button);
        return;
   }

   _ActionMenuDelItems (actions_button);
   XwDirActionMenuAddItems (dw, actions_button, _SKIP_CREATION);
   if (!XwDirIfDefActions (dw))
	XtSetSensitive (actions_button, False);
   else   	   
	XtSetSensitive (actions_button, True);

}


helpCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
/* to do list */
}


/*
 * XwDirInvokeActionCB: invoke action callback
 */

void XwDirInvokeActionCB (dw, client_data, call_data)
  XwDirWidget     dw;
  caddr_t    client_data;
  XedwCallbackStruct *call_data;
{
   char option[2]; 
   char *params[2];

   if ((int) client_data < 0 || (int) client_data > 30)
        return;

   sprintf (option, "%d", (int) client_data);
   params[0] = option;
   params[1] = NULL;

   XtCallActionProc (dirWidget, "InvokeAction", NULL, params, 1);
}
