#include "panel.h"
/****************************************************************************
*  Copyright (C) 1996 by Leo Khramov
*  email:   leo@pop.convey.ru
*  Fido:    2:5030/627.15
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/
//////////////////////Find files in filesystems//////////////////////

extern "C" void process_X();

Win   *fwin = NULL;
KEY   *ffind, *ffind2, *fstop, *fquit;
Panel *fpan;
Input *fin;
extern char *panlist[];
char   f_buf[256] = "";
int    findfl;
int    findmax;
int    retflag, qflag;
int    slave_work = 1;

char   fullpath[1024];

void   genfullpath(char *n)
{
  getcwd(fullpath, 800);
  strcat(fullpath, "/");
  strcat(fullpath, n);
}

//return -1 on error;
extern struct stat dstat;
#include "ives/ivestruct.h"

extern IVESid *sm;
extern char *smem;
extern char *umem;
int    slavepid;
void   ftw_func(int)
{
  char  *f;
  if (umem[0] == 0)
    {
      slavepid = sm->autopid;
      slave_work = 0;
      sm->ready = 1;
      return;
    }
  else
    {
      f = new char[strlen(umem) + 1];
      strcpy(f, umem);
      fpan->add_element(f);
      findmax++;
      if (findmax >= 200)
        {
          slave_work = 0;
          kill(sm->autopid, SIGUSR2);
          sm->ready = 1;
          kill(sm->autopid, SIGKILL);
        }
      else
        {
          signal(SIGUSR1, ftw_func);
          kill(sm->autopid, SIGUSR1);
          sm->ready = 1;
        }
    }
}

void   findcan()
{
  retflag = 1;
  if (slave_work)
    {
      slave_work = 0;
      kill(sm->autopid, SIGUSR2);
      sm->ready = 1;
    }
  fwin->hide();
  ffind->hide();
  ffind2->hide();
  fstop->hide();
  fquit->hide();
  fin->hide();
  fpan->hide();
  delete fpan;
  delete fwin;
  delete ffind;
  delete ffind2;
  delete fstop;
  delete fquit;
  delete fin;
  for (int i = 0; i < findmax; i++)
    delete panlist[i];
  fwin = NULL;
  XSetInputFocus(disp, panel->w, RevertToParent, CurrentTime);
}

void   findq()
{
  if (slave_work)
    {
      slave_work = 0;
      kill(sm->autopid, SIGUSR2);
      sm->ready = 1;
      kill(sm->autopid, SIGKILL);
    }
  if (retflag == 0)
    {
      retflag = 1;
      qflag = 1;
    }
  else
    findcan();
}

int    find_choice(int, char *path)
{
  char  *n;
  if (path != NULL)
    {
      if (chdir(path) == 0)
        {
          strcpy(panel->curdir, path);
        }
      else
        {
          n = strrchr(path, '/');
          *n = 0;
          n++;
          strcpy(panel->curdir, path);
          strcpy(panel->cur->name, n);
        }
      panel->reread();
    }
  findcan();
}

int    parpid;
void   runfinderslave(char *d)
{
  char   str[50];
  int    pid = fork();
  if (pid == -1)
    {
      slave_work = 0;
      slavepid = -1;
      return;
    };
  if (pid != 0)
    {
      slavepid = pid;
      signal(SIGUSR1, ftw_func);
      return;
    }
  else
    {
      sprintf(str, "%d", parpid);
//  sprintf(bb,"'%s'",f_buf);
      execlp("findslave.xnc", "findslave.xnc", d, f_buf, str, NULL);
      exit(-1);
    }
}

extern void xnc_sig();
int    workcoun;
char  *workstr = "Working... Please, be patient!!!";
void   myftw(char *p)
{
  int    ty = fontstr->max_bounds.ascent;
  int    coun = 0;
  slave_work = 1;
  parpid = getpid();
  runfinderslave(p);
  workcoun = 1;
  while (slave_work)
    {
//  delay(10);
   //  sleep(1);
      coun++;
      if (coun > 10000)
        {
          coun = 0;
          XSetForeground(disp, fwin->gcw, cols[2]);
          XDrawString(disp, fwin->w, fwin->gcw, 20, 320 + ty, workstr, workcoun);
          workcoun++;
          if (workcoun > 32)
            {
              XSetForeground(disp, fwin->gcw, keyscol[1]);
              XFillRectangle(disp, fwin->w, fwin->gcw, 20, 320, XTextWidth(fontstr, workstr, 32) + 20,
                             fontstr->max_bounds.descent + ty);
              workcoun = 1;
            }
        }
      process_X();
    }
  XSetForeground(disp, fwin->gcw, keyscol[1]);
  XFillRectangle(disp, fwin->w, fwin->gcw, 20, 322, XTextWidth(fontstr, workstr, 32) + 20,
                 fontstr->max_bounds.descent + ty);
  xnc_sig();
}

void   findfind()
{
  if (findfl)
    {
      findfl = 0;
      fpan->max = fpan->cur = fpan->base = 0;
      fpan->expose();
      for (int i = 0; i < 200; i++)
        {
          if (panlist[i])
            delete panlist[i];
          panlist[i] = NULL;
        }
      retflag = 0;
      myftw(panel->curdir);
      retflag = 1;
      XBell(disp, 0);
      if (qflag)
        findcan();
      else
        XSetInputFocus(disp, fpan->w, RevertToParent, CurrentTime);
      findfl = 1;
    }
}

void   findstop()
{
  retflag = 1;
  if (slave_work)
    {
      slave_work = 0;
      kill(sm->autopid, SIGUSR2);
      sm->ready = 1;
    }
}

void   findfind2()
{
  if (findfl)
    {
      findfl = 0;
      fpan->max = fpan->cur = fpan->base = 0;
      fpan->expose();
      for (int i = 0; i < 200; i++)
        {
          if (panlist[i])
            delete panlist[i];
          panlist[i] = NULL;
        }
      retflag = 0;
      myftw("/");
      retflag = 1;
      XBell(disp, 0);
      if (qflag)
        findcan();
      else
        XSetInputFocus(disp, fpan->w, RevertToParent, CurrentTime);
      findfl = 1;
    }
}

void   find_panel(int wl = 540)
{
  if (fwin == NULL)
    {
      findfl = 1;
      qflag = 0;
      retflag = 1;
      findmax = 0;
      slave_work = 0;
      for (int i = 0; i < 200; i++)
        panlist[i] = NULL;
      fwin = new Win(centerx - wl / 2, centery - 190, wl, 390, "Find file", 5);
      fpan = new Panel(20, 30, wl - 40, 250, panlist, 0, 1, find_choice);
      ffind = new KEY(20, -20, 100, 25, "Find", 3, findfind);
      ffind2 = new KEY(140, -20, 100, 25, "From '/'", 3, findfind2);
      fstop = new KEY(-140, -20, 100, 25, "Stop", 4, findstop);
      fquit = new KEY(-20, -20, 100, 25, "Quit", 2, findq);
      fin = new Input(20, 290, wl - 40, 1, findfind);
      fpan->escfunc(findcan);
      fin->set_escapefunc(findq);
      ffind->set_escapefunc(findq);
      ffind2->set_escapefunc(findq);
      fstop->set_escapefunc(findq);
      fquit->set_escapefunc(findq);
      fwin->init(Main);
      fpan->init(fwin->w);
      ffind->init(fwin->w);
      ffind2->init(fwin->w);
      fstop->init(fwin->w);
      fquit->init(fwin->w);
      fin->init(fwin->w);
      fwin->link(fin);
      fin->link(ffind);
      ffind->link(ffind2);
      ffind2->link(fstop);
      fstop->link(fquit);
      fquit->link(fpan);
      fpan->link(fin);
      fin->setbuf(f_buf, 255);
      fwin->show();
      fpan->show();
      fin->show();
      ffind->show();
      ffind2->show();
      fstop->show();
      fquit->show();
    }
}
