#include <globdef.h>
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#include <ftplib.h>


char *extract_last(char *path,char *to)
{
 int l=strlen(path);
 if(path[l-1]=='/') l--;
 path[l]='\0';
 char *b=strrchr(path,'/');
 strcpy(to, b ? b+1 : path);
 if(path[l-1]!='/') {path[l++]='/';path[l]='\0';};
 return to;
}

void addpathcontent(char *to,char *cont)
{
 int l;
 if(to[strlen(to)-1]!='/')
  strcat(to,"/");
 strcat(to,cont);
 l=strlen(to);
 if(to[l-1]!='/')
   {to[l++]='/';to[l++]='\0';};
}

void upperpath(char *curdir)
{
 int l=strlen(curdir);
 if(l>1 && curdir[l-1]=='/')
   curdir[l-1]='\0';
 char *bb=strrchr(curdir,'/');
 if(bb==NULL) bb=curdir;
 *bb=0;
 if(strlen(curdir)==0) strcpy(curdir,"/");
}

int Ftpget_direntry(FILE* fp,char *fname,int *mode,char *tmp)
{
 char str[20];
 int dummy,l;
 if(fgets(tmp,255,fp)==NULL) return 0;
 sscanf(tmp, "%d %o %X %[^\n]\n", &dummy, mode, &dummy,fname);
  l=strlen(fname);
  if(fname[l-1]=='\r')
          fname[l-1]=0;
 return 1;
}
 
int Ftpget_dirdir(char *lsfile,char *to,int coun,char *tmp1)
{
 FILE *fp=fopen(lsfile,"r");
 if(fp==NULL) return 0;
 int mode;
 while(Ftpget_direntry(fp,to,&mode,tmp1))
 {
   if((mode & S_IFDIR)==S_IFDIR)
   {
           if(strcmp(to,".")==0 || strcmp(to,"..")==0) continue;
           if(coun==0)
           {
                 fclose(fp);
                 return 1;        //Waw!!! We found it...
           }
           coun--;
   }
 }
 return 0;   //Not found :(
}

/*Recursive copy dir through FTP
* return 0 if success
* return 255 if err
* Parameters:
*        *netb - pointer to opened FTP connection
*        from  - remote path 'from' that we copy files
*        to      - local path to place files
*        TMPFILE - generated, unique file name uses as tempfile for 'ls' commands (overwritten)
*        tmp1  -  char tmp buffer
*        ftpname - char tmp buffer for ftp file names.
*/

int FtpGetDir(netbuf* netb,char *from,char *to,char *TMPFILE,char *tmp1,char *ftpname)
{
 int coun,mode;
 if(!FtpChdir(from,netb))
   return 255;
 extract_last(from,tmp1);        //extracting last name from path
// addpathcontent(to,tmp1);
 if(::mkdir(to,0755)==-1 && errno!=EEXIST)
  {
        FtpCdup(netb);
        strcpy(netb->response, "Error creating local directory!");
        return 255;
  }
 if(::chdir(to)==-1)
  {
        FtpCdup(netb);
        strcpy(netb->response, "Error changing to local directory!");
        return 255;
  }
 if(!FtpLS(TMPFILE,NULL,netb))
  {
        FtpCdup(netb);
        ::chdir("..");
        return 255;
  }
 FILE *fp=fopen(TMPFILE,"r");
 if(fp==NULL)
 {
         FtpCdup(netb);
         ::chdir("..");
         strcpy(netb->response, "Error opening local listing!");
         unlink(TMPFILE);
         return 255;
 }
 
//First we copy all files from current dir and skip subdirs
 while(Ftpget_direntry(fp,ftpname,&mode,tmp1))
 {
  if((mode & S_IFDIR)==0)
    {
          if(!FtpBinGet(ftpname,ftpname,mode,netb))
          {
                  unlink(TMPFILE);
                  strcpy(ftp_reason,netb->response);
                  FtpCdup(netb);
                  ::chdir("..");
                  fclose(fp);
                  return 255;
          }
    }
 }
 fclose(fp);
 coun=0;

//Now start scan subdirs and copying it
 while(Ftpget_dirdir(TMPFILE,ftpname,coun,tmp1))
 {
   addpathcontent(from,ftpname);
   addpathcontent(to,ftpname);
   strcat(TMPFILE,"1");
   if(FtpGetDir(netb,from,to,TMPFILE,tmp1,ftpname))
     {
                  TMPFILE[strlen(TMPFILE)-1]='\0';
                  unlink(TMPFILE);
                  strcpy(ftp_reason,netb->response);
                  FtpCdup(netb);
                  ::chdir("..");
                  upperpath(from);
                  upperpath(to);
                  return 255;
     }
   upperpath(from);
   upperpath(to);
   TMPFILE[strlen(TMPFILE)-1]='\0';
   coun++;
 }
 FtpCdup(netb);
 unlink(TMPFILE);
 ::chdir("..");
 return 0;
} 

