
/* This file contains internal images which need by XNC */
/* And routines for creating cursors, pixmaps etc...   */
#include "xh.h"
#include "image/image.h"
#include "bookmark.h"

//Bitmaps and Pixmaps
#include "dnd1.xbm"
#include "dnd1m.xbm"
#include "dnd2.xbm"
#include "dnd2m.xbm"
#include "banmask.xbm"
#include "foldm.xbm"
#include "execm.xbm"
#include "arcm.xbm"
#include "assocm.xbm"
#include "linkm.xbm"
#include "xncintro.c"

Win   *mwin = NULL;
Text  *mtext;
Window w_intro;
Pixmap p_intro, intropix;
int    l_intro = 0, h_intro;
unsigned long pt_intro[256];
int    ptnum_intro;
Colormap cmp_intro;

int    get_intro_size()
{
  return sizeof(xncintro_chr) - 256;
}

Pixmap dnd1pix;
Pixmap dnd1mpix;
Cursor cdnd1, cdnd2;

void   create_dnd_cursors()
{
  XColor xc1, xc2;
  xc1.pixel = cols[0];
  xc1.red = xc1.green = xc1.blue = 0l;
  xc1.flags = DoRed | DoBlue | DoGreen;
  xc2.pixel = cols[1];
  xc2.red = 65535l;
  xc2.green = 65535l;
  xc2.blue = 65535l;
  xc2.flags = DoRed | DoBlue | DoGreen;
  dnd1pix = XCreateBitmapFromData(disp, Main, (char *)dnd1_bits, dnd1_width, dnd1_height);
  dnd1mpix = XCreateBitmapFromData(disp, Main, (char *)dnd1m_bits, dnd1m_width, dnd1m_height);
  cdnd1 = XCreatePixmapCursor(disp, dnd1pix, dnd1mpix, &xc1, &xc2, 11, 8);
  XFreePixmap(disp, dnd1pix);
  XFreePixmap(disp, dnd1mpix);
  dnd1pix = XCreateBitmapFromData(disp, Main, (char *)dnd2_bits, dnd2_width, dnd2_height);
  dnd1mpix = XCreateBitmapFromData(disp, Main, (char *)dnd2m_bits, dnd2m_width, dnd2m_height);
  cdnd2 = XCreatePixmapCursor(disp, dnd1pix, dnd1mpix, &xc1, &xc2, 12, 13);
  XFreePixmap(disp, dnd1pix);
  XFreePixmap(disp, dnd1mpix);
}


void   win_nodecor(Window W)
{
  XSetWindowAttributes xswa;
  xswa.override_redirect = True;
  XChangeWindowAttributes(disp, W, CWOverrideRedirect, &xswa);
}

void   show_mes(char *head, char *mes)
{
  if (mwin == NULL)
    {
      mwin = new Win(centerx - 125, 150, 250, 100, head, 3);
      mtext = new Text(40, 60, mes, 5);
      mwin->init(Main);
      mtext->init(mwin->w);
      mtext->link(mtext);
      mwin->show();
      mtext->show();
      mwin->expose();
      XFlush(disp);
    }
}

void   hide_mes()
{
  mtext->hide();
  mwin->hide();
  delete mwin;
  delete mtext;
  mwin = NULL;
}


extern char strtmp[];
extern Pixmap panelpixs[];
extern Pixmap panelpixmask[];
extern int panelpixl[];
extern int panelpixh[];

void   load_pixmaps()
{
  int    x, y;
  if (allow_dir_icon)
    {
      strcpy(strtmp, syspath);
      strcat(strtmp, "/folder.gif");
      panelpixs[0] = LoadPixmap(strtmp, F_AUTO, x, y, CMP_COM);
      if (panelpixs[0])
	{
	  panelpixmask[0] = XCreateBitmapFromData(disp, Main, (char *)foldm_bits, foldm_width, foldm_height);
	  panelpixl[0] = x;
	  panelpixh[0] = y;
	  fprintf(stderr, ".");
	}
      else
	allow_dir_icon = 0;
    }
  if (allow_file_icon)
    {
      strcpy(strtmp, syspath);
      strcat(strtmp, "/exec.gif");
      panelpixs[1] = LoadPixmap(strtmp, F_AUTO, x, y, CMP_COM);
      if (panelpixs[1] == 0)
	{
	  allow_file_icon = 0;
	  return;
	};
      panelpixmask[1] = XCreateBitmapFromData(disp, Main, (char *)execm_bits, execm_width, execm_height);
      panelpixl[1] = x;
      panelpixh[1] = y;
      fprintf(stderr, ".");
      strcpy(strtmp, syspath);
      strcat(strtmp, "/norm.gif");
      panelpixs[2] = LoadPixmap(strtmp, F_AUTO, x, y, CMP_COM);
      if (panelpixs[2] == 0)
	{
	  allow_file_icon = 0;
	  return;
	};
      panelpixmask[2] = XCreateBitmapFromData(disp, Main, (char *)assocm_bits, assocm_width, assocm_height);
      panelpixl[2] = x;
      panelpixh[2] = y;
      fprintf(stderr, ".");
      strcpy(strtmp, syspath);
      strcat(strtmp, "/assoc.gif");
      panelpixs[3] = LoadPixmap(strtmp, F_AUTO, x, y, CMP_COM);
      if (panelpixs[3] == 0)
	{
	  allow_file_icon = 0;
	  return;
	};
      panelpixmask[3] = XCreateBitmapFromData(disp, Main, (char *)assocm_bits, assocm_width, assocm_height);
      panelpixl[3] = x;
      panelpixh[3] = y;
      fprintf(stderr, ".");
      strcpy(strtmp, syspath);
      strcat(strtmp, "/arc.gif");
      panelpixs[4] = LoadPixmap(strtmp, F_AUTO, x, y, CMP_COM);
      if (panelpixs[4] == 0)
	{
	  allow_file_icon = 0;
	  return;
	};
      panelpixmask[4] = XCreateBitmapFromData(disp, Main, (char *)arcm_bits, arcm_width, arcm_height);
      panelpixl[4] = x;
      panelpixh[4] = y;
      fprintf(stderr, ".");
      strcpy(strtmp, syspath);
      strcat(strtmp, "/link.gif");
      panelpixs[5] = LoadPixmap(strtmp, F_AUTO, x, y, CMP_COM);
      if (panelpixs[5] == 0)
	{
	  allow_file_icon = 0;
	  return;
	};
      panelpixmask[5] = XCreateBitmapFromData(disp, Main, (char *)linkm_bits, linkm_width, linkm_height);
      panelpixl[5] = x;
      panelpixh[5] = y;
      fprintf(stderr, ".");
    }
}


void   show_intro()
{
// static char tmp[100];
  int    es1, es2;
  if (l_intro == 0)
    {
/*
   strcpy(tmp,syspath);
   strcat(tmp,"/xncintro.jpeg");
   p_intro=LoadPixmap(tmp,F_JPEG,l_intro,h_intro,CMP_OWN);
 */

      p_intro = LoadPixmapFromMem(xncintro_chr, F_GIF, l_intro, h_intro, CMP_OWN, get_intro_size());

      if (p_intro)
	{
	  w_intro = create_win("X Northern Captain", ScreenL / 2 - l_intro / 2, ScreenH / 2 - h_intro / 2, l_intro, h_intro, ExposureMask, 0);
	  XSetWindowBorderWidth(disp, w_intro, 0);
	  win_nodecor(w_intro);
	  ptnum_intro = im_getpixels(pt_intro);
	  cmp_intro = im_get_colormap();
	  intropix = XCreateBitmapFromData(disp, Main, (char *)banmask_bits, banmask_width, banmask_height);
	  if (p_intro)
	    XSetWindowBackgroundPixmap(disp, w_intro, p_intro);
	  if (cmp_intro)
	    XSetWindowColormap(disp, w_intro, cmp_intro);
	  if (XShapeQueryExtension(disp, &es1, &es2))
	    XShapeCombineMask(disp, w_intro, ShapeBounding, 0, 0, intropix, ShapeSet);
	  else
	    fprintf(stderr, "XShape extensions not supported.\n");
	  XMapRaised(disp, w_intro);
	  if (DefaultDepth(disp, DefaultScreen(disp)) <= 8)
	    XInstallColormap(disp, cmp_intro);
	  XFlush(disp);
	}
      else
	l_intro = 0;
    }
}

void   hide_intro()
{
  if (l_intro)
    {
      if (DefaultDepth(disp, DefaultScreen(disp)) <= 8)
	XUninstallColormap(disp, cmp_intro);
      XDestroyWindow(disp, w_intro);
      XFreePixmap(disp, p_intro);
      XFreePixmap(disp, intropix);
      XFlush(disp);
      if (cmp_intro)
	im_freecmp(cmp_intro, pt_intro, ptnum_intro);
    }
}

void   x_free_pixmaps()
{
  int    i;
  for (i = 0; i < 4; i++)
    XFreePixmap(disp, pixrecycle[i]);
  if (allow_dir_icon)
    XFreePixmap(disp, panelpixs[0]);
  XFreePixmap(disp, panelpixmask[0]);
  if (allow_file_icon)
    for (i = 1; i < 6; i++)
      {
	XFreePixmap(disp, panelpixs[i]);
	XFreePixmap(disp, panelpixmask[i]);
      }
}
