
#include "xplore.h"
#include "fileops.h"
#include "icons.h"
#include "interface.h"
#include "mnttable.h"
#include "parse.h"
#include "signals.h"
#include "util.h"

String version = VERSION;
char basedir[MAXPATHLEN+1];
char libdir[MAXPATHLEN+1];
char libconfig[MAXPATHLEN+1];
char libmagic[MAXPATHLEN+1];
char libsetup[MAXPATHLEN+1];

Boolean WaitFlag = False, MsgFlag = False;
static Boolean init_flag = False;

void Wait()
{
  if (init_flag && !WaitFlag) {
    XDefineCursor(display, XtWindow(app_shell), wait_cursor);
    XmUpdateDisplay(app_shell);
    WaitFlag = True;
  }
}

void WaitMsg(String msg)
{
  if (init_flag) {
    StatusMessage(msg);
    if (!WaitFlag)
      Wait();
    else
      XmUpdateDisplay(app_shell);
    MsgFlag = True;
  }
}

void WaitMsg2(String msg, String arg)
{
  char s[MAXPATHLEN+100];

  sprintf(s, msg, arg);
  WaitMsg(s);
}

void Done()
{
  if (init_flag && WaitFlag) {
    XUndefineCursor(display, XtWindow(app_shell));
    WaitFlag = False;
    if (MsgFlag) {
      RestoreStatusLine();
      MsgFlag = False;
    }
  }
}

void cleanup(void)
{
    int d;

    /* try to unmount all mounted devices */

    for (d = 0; d < ndevs(); d++)
	while (devcount(d) && devumount(d)) ;

    /* free up allocated resources */

    init_file_types();
    free_icons();
}

void error(String msg)
{
    fprintf(stderr, "%s: %s\n", progname, msg);
}

void fatal(String msg)
{
    error(msg);
    cleanup();
    exit_app(1);
}

void quit(void)
{
    cleanup();
    exit_app(0);
}

int main(int argc, char **argv)
{
    String s;

    /* initialize the application: */

    getcwd(basedir, MAXPATHLEN);
    if ((s = getenv("XPLORELIBDIR")))
      abspath(libdir, basedir, s);
    else {
      strcpy(libdir, XPLORELIBDIR);
      setenv("XPLORELIBDIR", XPLORELIBDIR, True);
    }
    sprintf(libconfig, "%s/%s", libdir, XPLORE_RC);
    sprintf(libmagic, "%s/%s", libdir, XPLORE_MAGIC);
    sprintf(libsetup, "%s/%s", libdir, XPLORE_SETUP);

    init_app(argc, argv);

    user_umask = umask(0);
    umask(user_umask);
    user_umask = 0777777 ^ user_umask;

    /* other initializations: */

    /* install signal handlers first, to avoid zombie processes */
    install_signal_handlers();
    /* perform shell test */
    shellTest(sh_list);
    /* get the mount table */
    get_mnt_table();
    /* initialize the icons table */
    init_icons(display, ANY, iconpath);
    /* parse magic and config files */
    if (exists(magicfile))
	magic_parse_file(magicfile);
    else
	magic_parse_file(libmagic);
    initdevs(); init_file_types(); init_menus();
    if (exists(configfile))
	parse_config(configfile, CPP, cpp_options);
    else
	parse_config(libconfig, CPP, cpp_options);
    /* provide reasonable defaults for command menu and shelf tabs if not
       set */
    if (!n_cmd_actions())
      default_cmd_menu();
    if (!n_shelves())
      default_shelf_menu(curshelf);

    /* create the application widgets: */

    create_app();
    init_flag = True;

    /* run the application: */

    run_app();

}
