/* XMForm.C */

#include "XMForm.h"
// Super Class : XMBulletinBoard

/*oodB%XMForm*** Global Declarations and Stuffs ****/
Pixmap XMForm::XMForm_pixmap = XmUNSPECIFIED_PIXMAP;
res_rec XMForm::_formResources[4] = {
  /* name type value default option get set create modified */
  "fractionBase","int","100","100","NONE",
  True,True,True,False,
  "The denominator of a fraction that describes a child's relative \
position within a form.",
  "horizontalSpacing","Dimension","0","0","NONE",
  True,True,True,False,
  "The offset for left and right attachments.",
  "rubberPositioning","Boolean","False","False","True,False",
  True,True,True,False,
  "Child's top and left are positioned relative to form's size. If \
this resource is FALSE (default), the child's top and left sides \
are positioned using absolute values. If TRUE, the child's top and \
left sides are positioned relative to the size of the form.",
  "verticalSpacing","Dimension","0","0","NONE",
  True,True,True,False,
  "The offset for top and bottom attachments."
};
res_rec XMForm::_formConstraintResources[16] = {
  /* name type value default option get set create modified */
  "bottomAttachment","unsinged char","XmATTACH_NONE","XmATTACH_NONE","XmATTACH_NONE,XmATTACH_FORM,XmATTACH_OPPOSITE_FORM,XmATTACH_WIDGET,XmATTACH_OPPOSITE_WIDGET,XmATTACH_POSITION,XmATTACH_SELF",
  True,False,False,False,
  "The method of attachment for the childs side. Each of the four sides \
(left,right,top,bottom) has the same attachment resource choices.",
  "bottomOffset","int","0","0","NONE",
  True,False,False,False,
  "The distance between a childs side and the object it is attached to. \
Offsets are abolute. A nonzero offset is ignored when the side attachment \
is set to XmATTACH_POSITION.",
  "bottomPosition","int","0","0","NONE",
  True,False,False,False,
  "Used in conjuction with XmNfractionBase to calculate the side position \
of the child. This resource has not effect unless the side attachment is \
set to XmATTACH_POSITION.",
  "bottomWidget","Widget","NULL","NULL","NONE",
  True,False,False,False,
  "The name of the widget that serves as attachment point for the side of \
the child. The side attchemtn has to be set to XmATTACH_WIDGET or \
XmATTACH_OPPOSITE_WIDGET.",
  "leftAttachment","unsinged char","XmATTACH_NONE","XmATTACH_NONE","XmATTACH_NONE,XmATTACH_FORM,XmATTACH_OPPOSITE_FORM,XmATTACH_WIDGET,XmATTACH_OPPOSITE_WIDGET,XmATTACH_POSITION,XmATTACH_SELF",
  True,False,False,False,
  "The method of attachment for the childs side. Each of the four sides \
(left,right,top,bottom) has the same attachment resource choices.",
  "leftOffset","int","0","0","NONE",
  True,False,False,False,
  "The distance between a childs side and the object it is attached to. \
Offsets are abolute. A nonzero offset is ignored when the side attachment \
is set to XmATTACH_POSITION.",
  "leftPosition","int","0","0","NONE",
  True,False,False,False,
  "Used in conjuction with XmNfractionBase to calculate the side position \
of the child. This resource has not effect unless the side attachment is \
set to XmATTACH_POSITION.",
  "leftWidget","Widget","NULL","NULL","NONE",
  True,False,False,False,
  "The name of the widget that serves as attachment point for the side of \
the child. The side attchemtn has to be set to XmATTACH_WIDGET or \
XmATTACH_OPPOSITE_WIDGET.",
  "rightAttachment","unsinged char","XmATTACH_NONE","XmATTACH_NONE","XmATTACH_NONE,XmATTACH_FORM,XmATTACH_OPPOSITE_FORM,XmATTACH_WIDGET,XmATTACH_OPPOSITE_WIDGET,XmATTACH_POSITION,XmATTACH_SELF",
  True,False,False,False,
  "The method of attachment for the child's side. Each of the four sides \
(left,right,top,bottom) has the same attachment resource choices.",
  "rightOffset","int","0","0","NONE",
  True,False,False,False,
  "The distance between a child's side and the object it is attached to. \
Offsets are abolute. A nonzero offset is ignored when the side attachment \
is set to XmATTACH_POSITION.",
  "rightPosition","int","0","0","NONE",
  True,False,False,False,
  "Used in conjuction with XmNfractionBase to calculate the side position \
of the child. This resource has not effect unless the side attachment is \
set to XmATTACH_POSITION.",
  "rightWidget","Widget","NULL","NULL","NONE",
  True,False,False,False,
  "The name of the widget that serves as attachment point for the side of \
the child. The side attchemtn has to be set to XmATTACH_WIDGET or \
XmATTACH_OPPOSITE_WIDGET.",
  "topAttachment","unsinged char","XmATTACH_NONE","XmATTACH_NONE","XmATTACH_NONE,XmATTACH_FORM,XmATTACH_OPPOSITE_FORM,XmATTACH_WIDGET,XmATTACH_OPPOSITE_WIDGET,XmATTACH_POSITION,XmATTACH_SELF",
  True,False,False,False,
  "The method of attachment for the child's side. Each of the four sides \
(left,right,top,bottom) has the same attachment resource choices.",
  "topOffset","int","0","0","NONE",
  True,False,False,False,
  "The distance between a child's side and the object it is attached to. \
Offsets are abolute. A nonzero offset is ignored when the side attachment \
is set to XmATTACH_POSITION.",
  "topPosition","int","0","0","NONE",
  True,False,False,False,
  "Used in conjuction with XmNfractionBase to calculate the side position \
of the child. This resource has not effect unless the side attachment is \
set to XmATTACH_POSITION.",
  "topWidget","Widget","NULL","NULL","NONE",
  True,False,False,False,
  "The name of the widget that serves as attachment point for the side of \
the child. The side attchemtn has to be set to XmATTACH_WIDGET or \
XmATTACH_OPPOSITE_WIDGET."
};
/*oodE**********************************************/

XMForm::~XMForm()
{
}

XMForm::XMForm(Widget parent,Arg* al,int ac)
{
  if(ac > 0)
    setXtArgs(al,ac);
  setParent(parent);
  createWidget(form_v);
  _lastChildX = 0;
  _lastChildY = 0;

  _numResources = 4;
  _constraintNumResources = 16;
  memmove(_constraintResources,_formConstraintResources,
          _constraintNumResources*sizeof(res_rec));

  /* IF no pixmaps has been created */
  if(XMForm_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMForm_xpm, 
                                 &XMForm_pixmap, NULL, NULL ) != 0 )
       XMForm_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */

  /* get resources for this widget */
  storeResources();
}

Pixmap XMForm::getPixmap(void)
{
	return XMForm_pixmap;
}

res_rec * XMForm::getResources(void)
{
  return _resources;
}

res_rec * XMForm::getConstraintResources(void)
{
  return _constraintResources;
}

int XMForm::getNumConstraintResources(void)
{
  return _constraintNumResources;
}

int XMForm::getNumResources(void)      
{
  return _numResources;
}

void XMForm::storeResources(void)
{ /*  */ 
  res_rec * bulletinboardResources = XMBulletinBoard::getStaticResources();
  int bulletinboardNumResources = XMBulletinBoard::getStaticNumResources();
  res_rec * compositeResources = XtComposite::getResources();
  int compositeNumResources = XtComposite::getNumResources();
  res_rec * managerResources = XtManager::getResources();
  int managerNumResources = XtManager::getNumResources();
  res_rec * formConstraintResources;
  int formConstraintNumResources = 0;
  int totalNumResources;

  totalNumResources = _numResources + 
                      bulletinboardNumResources + 
                      compositeNumResources + 
                      managerNumResources;

  _resources = (res_rec *)malloc(totalNumResources*sizeof(res_rec));
 
  if(_resources == NULL)
    cout<< "malloc failed" << endl;

  memmove(_resources,_formResources,_numResources*sizeof(res_rec));

  memmove(&_resources[_numResources],
          bulletinboardResources,bulletinboardNumResources*sizeof(res_rec));

  _numResources = _numResources + bulletinboardNumResources;
  memmove(&_resources[_numResources],
          compositeResources,compositeNumResources*sizeof(res_rec));

  _numResources = _numResources + compositeNumResources;
  memmove(&_resources[_numResources],
          managerResources,managerNumResources*sizeof(res_rec));

  _numResources = totalNumResources;
} /*  */ 

void XMForm::getLastChildLocation(int &x, int &y)
{
  x = _lastChildX;
  y = _lastChildY;
}

void XMForm::setLastChildLocation(int x, int y)
{
  _lastChildX = x;
  _lastChildY = y;
}
