/* XMPushButton.C */

#include "XMPushButton.h"
// Super Class : XMLabel

/*oodB%XMPushButton*** Global Declarations and Stuffs ****/
Pixmap XMPushButton::XMPushButton_pixmap = XmUNSPECIFIED_PIXMAP; 
res_rec XMPushButton::_pushButtonResources[6] = {
  /* name type value default option get set create modified */
  "armColor","Pixel","dynamic","dynamic","NONE",
  True,True,True,False,
  "The color with which the armed button is filled. This resources is \
only affective when XmNfillOnArm is set to TRUE.",
  "armPixmap","Pixmap","XmUNSPECIFIED_PIXMAP","XmUNSPECIFIED_PIXMAP","NONE",
  True,True,True,False,
  "The pixmap that identifies the button when it is armed (and when it's \
XmNlabelType is XmPIXMAP). For a pushbutton in a mneu, this resource is \
disabled.",
  "defaultButtonShadowThickness","Dimension","dynamic","dynamic","NONE",
  True,True,True,False,
  "The width of the shadow used to indicate a default pushbutton.",
  "fillOnArm","Boolean","True","True","True,False",
  True,True,True,False,
  "If TRUE (default), the pushbutton widgets fills the button (when \
armed) with the color spcified by XmNarmColor. For a pushbutton in a \
menu this resource is disabled.",
  "multiClick","UnsignedChar","dynamic","dynamic","XmMULTICLICK_DISCARD,XmMULTICLICK_KEEP",
  True,True,True,False,
  "A flag that determines wether successive button clicks are processed \
or ignored.",
  "showAsDefault","Dimension","0","0","NONE",
  True,True,True,False,
  "Indicates a default pushbutton by displaying a shadow.",
  };

/*oodE****************************************************/

XMPushButton::~XMPushButton()
{
  free(_resources);
}

XMPushButton::XMPushButton(Widget self, Widget parent)
{
  setParent(parent);
  setWidget(self);
  setVirtual(True);
  _numResources = 6;

  /* IF no pixmaps has been created */
  if(XMPushButton_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMPushButton_xpm, 
                                 &XMPushButton_pixmap, NULL, NULL ) != 0 )
       XMPushButton_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */ 

  storeResources();
}

XMPushButton::XMPushButton(Widget parent,Arg* al,int ac)
{

  if(ac > 0)
    setXtArgs(al,ac);
  setParent(parent);
  createWidget(pushbutton_v);
  _numResources = 6;

  /* IF no pixmaps has been created */
  if(XMPushButton_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMPushButton_xpm, 
                                 &XMPushButton_pixmap, NULL, NULL ) != 0 )
       XMPushButton_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */ 

  storeResources();
}

Pixmap XMPushButton::getPixmap(void)
{
	return XMPushButton_pixmap;
}

Boolean XMPushButton::canbeParent(void)
{
  Boolean status = False;

  if(getCoreParent()->getType() == popupmenu_v)
    status = True;

  return status;
}

res_rec * XMPushButton::getResources(void)
{
  return _resources;
}

int XMPushButton::getNumResources(void)      
{
  return _numResources;
}

void XMPushButton::storeResources(void)
{ /*  */ 

  res_rec * labelResources = XMLabel::getStaticResources();
  int labelNumResources = XMLabel::getNumStaticResources();
  res_rec * primitiveResources = XtPrimitive::getResources();
  int primitiveNumResources = XtPrimitive::getNumResources();

  int totalNumResources;

  totalNumResources = _numResources + 
                      labelNumResources + 
                      primitiveNumResources;

  _resources = (res_rec *)malloc(totalNumResources*sizeof(res_rec));
 
  memmove(_resources,_pushButtonResources,_numResources*sizeof(res_rec));
  memmove(&_resources[_numResources],
          labelResources,labelNumResources*sizeof(res_rec));
  memmove(&_resources[_numResources+labelNumResources],
          primitiveResources,primitiveNumResources*sizeof(res_rec));
  _numResources = totalNumResources;
} /*  */ 
