/* -*-C-*-
********************************************************************************
*
* File:         w_funtab.c
* RCS:          $Header: /users/npm/src/widgit/src-server/RCS/w_funtab.c,v 2.10 1994/06/22 04:00:31 npm Exp $
* Description:  Function table for winterp (replaces xlisp/xlftab.c).
*		NOTE: IF YOU WANT TO ADD NEW C-IMPLEMENTED FUNCTIONS TO
*		YOUR OWN LOCAL VERSION OF WINTERP, SEE FILES app_fundecl.h,
*		app_funidx.h, and app_funextn.h. EVENTUALLY, YOU MAY WANT TO
*		MIGRATE ESTABLISHED FUNCTIONALITY TO w_funtab.{c,h}... NOTE
*		HOWEVER, THAT EACH CHANGE TO w_funtab.h WILL ALSO FORCE A
*		MASSIVE RECOMPILE OF w_funtab.c AND wc_*.c tic_*.c -- ALL THOSE
*		SOURCES DEPEND ON VALUES FROM w_funtab.h THAT MAY HAVE CHANGED!!
* Author:       Niels Mayer
* Created:      Tue Jul 18 00:12:30 1989
* Modified:     Wed Jun 28 03:01:40 1995 (Niels Mayer) npm@indeed
* Language:     C
* Package:      N/A
* Status:       X11r6 contrib release
*
* Copyright (C) 1994, Enterprise Integration Technologies Corp. and Niels Mayer.
* WINTERP 1.15-1.99, Copyright (c) 1993, Niels P. Mayer.
* WINTERP 1.0-1.14, Copyright (c) 1989-1992 Hewlett-Packard Co. and Niels Mayer.
* 
* Permission to use, copy, modify, distribute, and sell this software and its
* documentation for any purpose is hereby granted without fee, provided that
* the above copyright notice appear in all copies and that both that
* copyright notice and this permission notice appear in supporting
* documentation, and that the name of Enterprise Integration Technologies,
* Hewlett-Packard Company, or Niels Mayer not be used in advertising or
* publicity pertaining to distribution of the software without specific,
* written prior permission. Enterprise Integration Technologies, Hewlett-Packard
* Company, and Niels Mayer makes no representations about the suitability of
* this software for any purpose.  It is provided "as is" without express or
* implied warranty.
* 
* ENTERPRISE INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY AND NIELS MAYER
* DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL ENTERPRISE
* INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY OR NIELS MAYER BE LIABLE
* FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
* RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
* CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
* CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*
********************************************************************************
*/
static char rcs_identity[] = "@(#)$Header: /users/npm/src/widgit/src-server/RCS/w_funtab.c,v 2.10 1994/06/22 04:00:31 npm Exp $";

/*
*------------------------------------------------------------------------------
* See ./winterp/COPYRIGHT for information on contacting the authors.
* Please e-mail comments, modifications, questions, improvements and
* bugfixes to the WINTERP mailing list winterp@netcom.com. Please send 
* mailing list subscribe/unsubscribe notices to winterp-request@netcom.com .
* Post XLISP-specific questions/information to the USENET newsgroup
* comp.lang.lisp.x.
*------------------------------------------------------------------------------
*/

#include <stdio.h>
#include <Xm/Xm.h>
#include "winterp.h"
#include "w_funtab.h"

/*
 * To embed additional C-implemented primitives in WINTERP, you must
 * place application function extern declarations in file app_funextn.h. 
 * See comments preceding funtab[] declaration below for more
 * info on the files app_fundecl.h, app_funextn.h, and app_funidx.h .
 *
 * If you want to place your app_funextn.h file outside of 
 * the WINTERP source tree, just modify INCLUDES in the Makefile
 * such that the directory containing app_funextn.h precedes '-I.'
 */
#include <app_funextn.h>


/* SUBR/FSUBR indicator */
#define S	SUBR
#define F	FSUBR
#ifdef MULVALS
/* extra codes for subrs that return multiple values */
#define SM  (SUBR+ TYPEFIELD+1)
#define FM  (FSUBR+ TYPEFIELD+1)
#else
#define SM  SUBR
#define FM  FSUBR
#endif


/*
 * note that xlisp prims are extern'd in xlisp/xlftab.h; the file
 * also defined cpp sym 'V' which is either 'void' or '' if not ANSI...
 */
#include "xlisp/xlftab.h"

/****************** BEGIN: WINTERP PRIMITIVES (Motif >= 1.0)  **************/    
extern LVAL Application_Shell_Widget_Class_Method_GET_ARGV(V);
extern LVAL Application_Shell_Widget_Class_Method_ISNEW(V);
extern LVAL Application_Shell_Widget_Class_Method_SET_ARGV(V);
extern LVAL Popup_Shell_Widget_Class_Method_ISNEW(V);
extern LVAL Popup_Shell_Widget_Class_Method_POPDOWN(V);
extern LVAL Popup_Shell_Widget_Class_Method_POPUP(V);
extern LVAL Shell_Widget_Class_Method_ISNEW(V);
extern LVAL Shell_Widget_Class_Method_IS_MOTIF_WM_RUNNING(V);
extern LVAL Shell_Widget_Class_Method_LOWER_WINDOW(V);
extern LVAL Shell_Widget_Class_Method_MANAGE(V);
extern LVAL Shell_Widget_Class_Method_MAP_RAISED(V);
extern LVAL Shell_Widget_Class_Method_RAISE_WINDOW(V);
extern LVAL Shell_Widget_Class_Method_REALIZE(V);
extern LVAL Shell_Widget_Class_Method_UNMANAGE(V);
extern LVAL Shell_Widget_Class_Method_UNREALIZE(V);
extern LVAL Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Widget_Class_Method_ADD_EVENT_HANDLER(V);
extern LVAL Widget_Class_Method_ADD_GRAB(V);
extern LVAL Widget_Class_Method_ADD_TAB_GROUP(V);
extern LVAL Widget_Class_Method_AUGMENT_TRANSLATIONS(V);
extern LVAL Widget_Class_Method_BUILD_EVENT_MASK(V);
extern LVAL Widget_Class_Method_DESTROY(V);
extern LVAL Widget_Class_Method_EXISTS_P(V);
extern LVAL Widget_Class_Method_GET_VALUES(V);
extern LVAL Widget_Class_Method_HAS_CALLBACKS(V);
extern LVAL Widget_Class_Method_INSTALL_ACCELERATORS(V);
extern LVAL Widget_Class_Method_INSTALL_ALL_ACCELERATORS(V);
extern LVAL Widget_Class_Method_ISNEW(V);
extern LVAL Widget_Class_Method_IS_COMPOSITE(V);
extern LVAL Widget_Class_Method_IS_CONSTRAINT(V);
extern LVAL Widget_Class_Method_IS_GADGET(V);
extern LVAL Widget_Class_Method_IS_MANAGED(V);
extern LVAL Widget_Class_Method_IS_MANAGER(V);
extern LVAL Widget_Class_Method_IS_PRIMITIVE(V);
extern LVAL Widget_Class_Method_IS_REALIZED(V);
extern LVAL Widget_Class_Method_IS_SENSITIVE(V);
extern LVAL Widget_Class_Method_IS_SHELL(V);
extern LVAL Widget_Class_Method_MANAGE(V);
extern LVAL Widget_Class_Method_MAP(V);
extern LVAL Widget_Class_Method_OVERRIDE_TRANSLATIONS(V);
extern LVAL Widget_Class_Method_PARENT(V);
extern LVAL Widget_Class_Method_PRIN1(V);
extern LVAL Widget_Class_Method_REMOVE_ALL_CALLBACKS(V);
extern LVAL Widget_Class_Method_REMOVE_GRAB(V);
extern LVAL Widget_Class_Method_REMOVE_TAB_GROUP(V);
extern LVAL Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Widget_Class_Method_SET_EVENT_HANDLER(V);
extern LVAL Widget_Class_Method_SET_MAPPED_WHEN_MANAGED(V);
extern LVAL Widget_Class_Method_SET_SENSITIVE(V);
extern LVAL Widget_Class_Method_SET_VALUES(V);
extern LVAL Widget_Class_Method_UNINSTALL_TRANSLATIONS(V);
extern LVAL Widget_Class_Method_UNMANAGE(V);
extern LVAL Widget_Class_Method_UNMAP(V);
extern LVAL Widget_Class_Method_UPDATE_DISPLAY(V);
extern LVAL Widget_Class_Method_WINDOW(V);
extern LVAL Xm_Bulletin_Board_Widget_Class_Method_ISNEW(V);
extern LVAL Xm_Cascade_Button_Widget_Class_Method_HIGHLIGHT(V);
extern LVAL Xm_Command_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Xm_Command_Widget_Class_Method_APPEND_VALUE(V);
extern LVAL Xm_Command_Widget_Class_Method_ERROR(V);
extern LVAL Xm_Command_Widget_Class_Method_GET_CHILD(V);
extern LVAL Xm_Command_Widget_Class_Method_GET_HISTORY_ITEMS(V);
extern LVAL Xm_Command_Widget_Class_Method_ISNEW(V);
extern LVAL Xm_Command_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Xm_Command_Widget_Class_Method_SET_VALUE(V);
extern LVAL Xm_Drawing_Area_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Xm_Drawing_Area_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Xm_Drawn_Button_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Xm_Drawn_Button_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Xm_File_Selection_Box_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Xm_File_Selection_Box_Widget_Class_Method_DO_SEARCH(V);
extern LVAL Xm_File_Selection_Box_Widget_Class_Method_GET_CHILD(V);
extern LVAL Xm_File_Selection_Box_Widget_Class_Method_ISNEW(V);
extern LVAL Xm_File_Selection_Box_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Xm_Form_Widget_Class_Method_ISNEW(V);
extern LVAL Xm_List_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Xm_List_Widget_Class_Method_ADD_ITEM(V);
extern LVAL Xm_List_Widget_Class_Method_ADD_ITEM_UNSELECTED(V);
extern LVAL Xm_List_Widget_Class_Method_DELETE_ITEM(V);
extern LVAL Xm_List_Widget_Class_Method_DELETE_POS(V);
extern LVAL Xm_List_Widget_Class_Method_DESELECT_ALL_ITEMS(V);
extern LVAL Xm_List_Widget_Class_Method_DESELECT_ITEM(V);
extern LVAL Xm_List_Widget_Class_Method_DESELECT_POS(V);
extern LVAL Xm_List_Widget_Class_Method_GET_ITEMS(V);
extern LVAL Xm_List_Widget_Class_Method_GET_SELECTED_ITEMS(V);
extern LVAL Xm_List_Widget_Class_Method_ISNEW(V);
extern LVAL Xm_List_Widget_Class_Method_ITEM_EXISTS(V);
extern LVAL Xm_List_Widget_Class_Method_SELECT_ITEM(V);
extern LVAL Xm_List_Widget_Class_Method_SELECT_POS(V);
extern LVAL Xm_List_Widget_Class_Method_SET_BOTTOM_ITEM(V);
extern LVAL Xm_List_Widget_Class_Method_SET_BOTTOM_POS(V);
extern LVAL Xm_List_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Xm_List_Widget_Class_Method_SET_HORIZ_POS(V);
extern LVAL Xm_List_Widget_Class_Method_SET_ITEM(V);
extern LVAL Xm_List_Widget_Class_Method_SET_POS(V);
extern LVAL Xm_Main_Window_Widget_Class_Method_SEP1(V);
extern LVAL Xm_Main_Window_Widget_Class_Method_SEP2(V);
extern LVAL Xm_Main_Window_Widget_Class_Method_SET_AREAS(V);
extern LVAL Xm_Message_Box_Widget_Class_Method_GET_CHILD(V);
extern LVAL Xm_Message_Box_Widget_Class_Method_ISNEW(V);
extern LVAL Xm_Row_Column_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Xm_Row_Column_Widget_Class_Method_ISNEW(V);
extern LVAL Xm_Row_Column_Widget_Class_Method_MENU_POSITION(V);
extern LVAL Xm_Row_Column_Widget_Class_Method_OPTION_BUTTON_GADGET(V);
extern LVAL Xm_Row_Column_Widget_Class_Method_OPTION_LABEL_GADGET(V);
extern LVAL Xm_Row_Column_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Xm_Scale_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Xm_Scale_Widget_Class_Method_GET_VALUE(V);
extern LVAL Xm_Scale_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Xm_Scale_Widget_Class_Method_SET_VALUE(V);
extern LVAL Xm_Scroll_Bar_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Xm_Scroll_Bar_Widget_Class_Method_GET_VALUE(V);
extern LVAL Xm_Scroll_Bar_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Xm_Scroll_Bar_Widget_Class_Method_SET_VALUE(V);
extern LVAL Xm_Scrolled_Window_Widget_Class_Method_SET_AREAS(V);
extern LVAL Xm_Selection_Box_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Xm_Selection_Box_Widget_Class_Method_GET_CHILD(V);
extern LVAL Xm_Selection_Box_Widget_Class_Method_GET_LIST_ITEMS(V);
extern LVAL Xm_Selection_Box_Widget_Class_Method_ISNEW(V);
extern LVAL Xm_Selection_Box_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Xm_Text_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Xm_Text_Widget_Class_Method_CLEAR_SELECTION(V);
extern LVAL Xm_Text_Widget_Class_Method_DISABLE_REDISPLAY(V);
extern LVAL Xm_Text_Widget_Class_Method_ENABLE_REDISPLAY(V);
extern LVAL Xm_Text_Widget_Class_Method_GET_EDITABLE(V);
extern LVAL Xm_Text_Widget_Class_Method_GET_INSERTION_POSITION(V);
extern LVAL Xm_Text_Widget_Class_Method_GET_LAST_POSITION(V);
extern LVAL Xm_Text_Widget_Class_Method_GET_MAX_LENGTH(V);
extern LVAL Xm_Text_Widget_Class_Method_GET_SELECTION(V);
extern LVAL Xm_Text_Widget_Class_Method_GET_SELECTION_POSITION(V);
extern LVAL Xm_Text_Widget_Class_Method_GET_STRING(V);
extern LVAL Xm_Text_Widget_Class_Method_GET_TOP_CHARACTER(V);
extern LVAL Xm_Text_Widget_Class_Method_GOTO_LINE(V);
extern LVAL Xm_Text_Widget_Class_Method_ISNEW(V);
extern LVAL Xm_Text_Widget_Class_Method_POS_TO_XY(V);
extern LVAL Xm_Text_Widget_Class_Method_READ_FILE(V);
extern LVAL Xm_Text_Widget_Class_Method_READ_FILE_GOTO_LINE(V);
extern LVAL Xm_Text_Widget_Class_Method_REPLACE(V);
extern LVAL Xm_Text_Widget_Class_Method_SCROLL(V);
extern LVAL Xm_Text_Widget_Class_Method_SEARCH(V);
extern LVAL Xm_Text_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Xm_Text_Widget_Class_Method_SET_EDITABLE(V);
extern LVAL Xm_Text_Widget_Class_Method_SET_INSERTION_POSITION(V);
extern LVAL Xm_Text_Widget_Class_Method_SET_MAX_LENGTH(V);
extern LVAL Xm_Text_Widget_Class_Method_SET_SELECTION(V);
extern LVAL Xm_Text_Widget_Class_Method_SET_STRING(V);
extern LVAL Xm_Text_Widget_Class_Method_SET_TOP_CHARACTER(V);
extern LVAL Xm_Text_Widget_Class_Method_SHOW_POSITION(V);
extern LVAL Xm_Text_Widget_Class_Method_WRITE_FILE(V);
extern LVAL Xm_Text_Widget_Class_Method_XY_TO_POS(V);
extern LVAL Xm_Toggle_Button_Gadget_Class_Method_GET_STATE(V);
extern LVAL Xm_Toggle_Button_Gadget_Class_Method_SET_STATE(V);
extern LVAL Xm_Toggle_Button_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Xm_Toggle_Button_Widget_Class_Method_GET_STATE(V);
extern LVAL Xm_Toggle_Button_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Xm_Toggle_Button_Widget_Class_Method_SET_STATE(V);
extern LVAL Widget_Class_Method_SHOW(V);

extern LVAL Prim_FFLUSH(V);	/* NPM: xlisp/unixstuf.c */
extern LVAL Prim_FSCANF_FIXNUM(V); /* NPM: xlisp/unixstuf.c */
extern LVAL Prim_FSCANF_FLONUM(V); /* NPM: xlisp/unixstuf.c */
extern LVAL Prim_FSCANF_STRING(V); /* NPM: xlisp/unixstuf.c */
extern LVAL Prim_PCLOSE(V);	/* NPM: xlisp/unixstuf.c */
extern LVAL Prim_POPEN(V);	/* NPM: xlisp/unixstuf.c */
extern LVAL Prim_PROVIDE(V);
extern LVAL Prim_READ_EVAL_PRINT(V);
extern LVAL Prim_REDIRECT_STDERR(V);
extern LVAL Prim_REDIRECT_STDOUT(V);
extern LVAL Prim_SYSTEM(V);	/* NPM: xlisp/unixstuf.c */
extern LVAL Wcb_Prim_XT_REMOVE_CALLBACK(V);
extern LVAL Wcls_Prim_WIDGETOBJP(V);
extern LVAL Weh_Prim_XT_REMOVE_EVENT_HANDLER(V);
extern LVAL Prim_REQUIRE(V);
extern LVAL Wicb_Prim_INPUT_ACTIVE_P(V);
extern LVAL Wicb_Prim_XT_ADD_INPUT(V);
extern LVAL Wicb_Prim_XT_REMOVE_INPUT(V);
extern LVAL Wpm_Prim_XM_GET_IMAGE_FROM_FILE(V);
extern LVAL Wpm_Prim_XM_GET_PIXMAP(V);
extern LVAL Wpm_Prim_XM_INSTALL_IMAGE(V);
extern LVAL Wpm_Prim_XM_UNINSTALL_IMAGE(V);
extern LVAL Wshl_Prim_WINTERP_SHOW_BUSY(V);
extern LVAL Wto_Prim_TIMEOUT_ACTIVE_P(V);
extern LVAL Wto_Prim_XT_ADD_TIMEOUT(V);
extern LVAL Wto_Prim_XT_REMOVE_TIMEOUT(V);
extern LVAL Wtx_Prim_XT_PARSE_ACCELERATOR_TABLE(V);
extern LVAL Wtx_Prim_XT_PARSE_TRANSLATION_TABLE(V);
extern LVAL Wut_Prim_GET_EVENT_COORDS(V);
extern LVAL Wut_Prim_GET_MOUSED_WIDGET(V);
extern LVAL Wut_Prim_GET_MOUSE_LOCATION(V); /* uunet!cimshop!rhess */
extern LVAL Wut_Prim_X_ALLOC_COLOR(V);
extern LVAL Wut_Prim_X_ALLOC_N_COLOR_CELLS_NO_PLANES(V);
extern LVAL Wut_Prim_X_STORE_COLOR(V);
extern LVAL Wut_Prim_X_BELL(V);
extern LVAL Wxm_Prim_XM_SET_MENU_CURSOR(V);
extern LVAL Wxms_Prim_XM_STRING_BYTE_COMPARE(V);
extern LVAL Wxms_Prim_XM_STRING_COMPARE(V);
extern LVAL Wxms_Prim_XM_STRING_CONCAT(V);
extern LVAL Wxms_Prim_XM_STRING_COPY(V);
extern LVAL Wxms_Prim_XM_STRING_CREATE(V);
#ifdef WINTERP_MOTIF_20
extern LVAL Wxms_Prim_XM_STRING_GENERATE(V);
extern LVAL Wxms_Prim_XM_STRING_PUT_RENDITION(V);
extern LVAL Wxms_Prim_XM_TAB_CREATE(V);
extern LVAL Wxms_Prim_XM_TAB_LIST_INSERT_TABS(V);
extern LVAL Wxms_Prim_XM_RENDER_TABLE_ADD_RENDITIONS(V);
extern LVAL Wxms_Prim_XM_RENDITION_CREATE(V);
#else /* Motif 1.0, 1.1, 1.2 */
extern LVAL Wxms_Prim_XM_STRING_CREATE_L_TO_R(V);
#endif /* WINTERP_MOTIF_20 */
extern LVAL Wxms_Prim_XM_STRING_DIRECTION_CREATE(V);
extern LVAL Wxms_Prim_XM_STRING_EMPTY(V);
extern LVAL Wxms_Prim_XM_STRING_GET_L_TO_R(V);
extern LVAL Wxms_Prim_XM_STRING_LENGTH(V);
extern LVAL Wxms_Prim_XM_STRING_LINE_COUNT(V);
extern LVAL Wxms_Prim_XM_STRING_SEGMENT_CREATE(V);
extern LVAL Wxms_Prim_XM_STRING_SEPARATOR_CREATE(V);
extern LVAL Wxt_Prim_XT_MANAGE_CHILDREN(V);
extern LVAL Wxt_Prim_XT_UNMANAGE_CHILDREN(V);
/****************** END: WINTERP PRIMITIVES (Motif >= 1.0)  **************/    

/****************** BEGIN: WINTERP PRIMITIVES (Motif >= 1.1) *************/
#ifdef WINTERP_MOTIF_11
extern LVAL Widget_Class_Method_CALL_ACTION_PROC(V);
extern LVAL Widget_Class_Method_FORCED_EXPOSE_UPDATE(V);
extern LVAL Widget_Class_Method_GET_CHILDREN(V);
extern LVAL Widget_Class_Method_NAME(V);
extern LVAL Widget_Class_Method_PROCESS_TRAVERSAL(V);
extern LVAL Xm_Arrow_Button_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Xm_Arrow_Button_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Xm_Cascade_Button_Gadget_Class_Method_HIGHLIGHT(V);
extern LVAL Xm_File_Selection_Box_Widget_Class_Method_GET_DIR_LIST_ITEMS(V);
extern LVAL Xm_File_Selection_Box_Widget_Class_Method_GET_FILE_LIST_ITEMS(V);
extern LVAL Xm_List_Widget_Class_Method_ADD_ITEMS(V);
extern LVAL Xm_List_Widget_Class_Method_DELETE_ALL_ITEMS(V);
extern LVAL Xm_List_Widget_Class_Method_DELETE_ITEMS(V);
extern LVAL Xm_List_Widget_Class_Method_DELETE_ITEMS_POS(V);
extern LVAL Xm_List_Widget_Class_Method_GET_MATCH_POS(V);
extern LVAL Xm_List_Widget_Class_Method_GET_SELECTED_POS(V);
extern LVAL Xm_List_Widget_Class_Method_ITEM_POS(V);
extern LVAL Xm_List_Widget_Class_Method_PARENT(V);
extern LVAL Xm_List_Widget_Class_Method_REPLACE_ITEMS(V);
extern LVAL Xm_List_Widget_Class_Method_REPLACE_ITEMS_POS(V);
extern LVAL Xm_List_Widget_Class_Method_SET_ADD_MODE(V);
extern LVAL Xm_Main_Window_Widget_Class_Method_SEP3(V);
extern LVAL Xm_Push_Button_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Xm_Push_Button_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Xm_Row_Column_Widget_Class_Method_GET_POSTED_FROM_WIDGET(V);
extern LVAL Xm_Row_Column_Widget_Class_Method_GET_SUB_MENU_WIDGET(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_CLEAR_SELECTION(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_COPY(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_CUT(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_GET_ADD_MODE(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_GET_BASELINE(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_GET_CURSOR_POSITION(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_GET_EDITABLE(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_GET_INSERTION_POSITION(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_GET_LAST_POSITION(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_GET_MAX_LENGTH(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_GET_SELECTION(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_GET_SELECTION_POSITION(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_GET_STRING(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_INSERT(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_PASTE(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_POS_TO_XY(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_REMOVE(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_REPLACE(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_SET_ADD_MODE(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_SET_CURSOR_POSITION(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_SET_EDITABLE(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_SET_HIGHLIGHT(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_SET_INSERTION_POSITION(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_SET_MAX_LENGTH(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_SET_SELECTION(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_SET_STRING(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_SHOW_POSITION(V);
extern LVAL Xm_Text_Field_Widget_Class_Method_XY_TO_POS(V);
extern LVAL Xm_Text_Widget_Class_Method_COPY(V);
extern LVAL Xm_Text_Widget_Class_Method_CUT(V);
extern LVAL Xm_Text_Widget_Class_Method_GET_ADD_MODE(V);
extern LVAL Xm_Text_Widget_Class_Method_GET_BASELINE(V);
extern LVAL Xm_Text_Widget_Class_Method_GET_CURSOR_POSITION(V);
extern LVAL Xm_Text_Widget_Class_Method_INSERT(V);
extern LVAL Xm_Text_Widget_Class_Method_PARENT(V);
extern LVAL Xm_Text_Widget_Class_Method_PASTE(V);
extern LVAL Xm_Text_Widget_Class_Method_REMOVE(V);
extern LVAL Xm_Text_Widget_Class_Method_SET_ADD_MODE(V);
extern LVAL Xm_Text_Widget_Class_Method_SET_CURSOR_POSITION(V);
extern LVAL Xm_Text_Widget_Class_Method_SET_HIGHLIGHT(V);

extern LVAL Wxm_Prim_XM_CONVERT_UNITS(V);
extern LVAL Wxm_Prim_XM_GET_COLORS(V);
extern LVAL Wxm_Prim_XM_SET_FONT_UNITS(V);
extern LVAL Wxm_Prim_XM_TRACKING_LOCATE(V);
extern LVAL Wxms_Prim_XM_CVT_CT_TO_XM_STRING(V);
extern LVAL Wxms_Prim_XM_CVT_XM_STRING_TO_CT(V);
extern LVAL Wxms_Prim_XM_STRING_HAS_SUBSTRING(V);
extern LVAL Wxt_Prim_XT_RESOLVE_PATHNAME(V);
#endif				/* WINTERP_MOTIF_11 */
/****************** END: WINTERP PRIMITIVES (Motif >= 1.1) *************/

/****************** BEGIN: WINTERP PRIMITIVES (Motif >= 1.2) *************/
#ifdef WINTERP_MOTIF_12
extern LVAL Widget_Class_Method_CHANGE_COLOR(V);
extern LVAL Widget_Class_Method_GET_FOCUS_WIDGET(V);
extern LVAL Widget_Class_Method_GET_TAB_GROUP(V);
extern LVAL Widget_Class_Method_IS_TRAVERSABLE(V);
extern LVAL Widget_Class_Method_GET_VISIBILITY(V);
extern LVAL Wxm_Prim_XM_GET_DESTINATION(V);
extern LVAL Xm_Scrolled_Window_Widget_Class_Method_SCROLL_VISIBLE(V);
#endif /* WINTERP_MOTIF_12 */
/****************** END: WINTERP PRIMITIVES (Motif >= 1.2) *************/

/****************** BEGIN: WINTERP XmGraph PRIMITIVES (Motif >= 1.1) ***/
#ifdef HP_GRAPH_WIDGET		/* if HP_GRAPH_WIDGET defined */
extern LVAL Xm_Arc_Widget_Class_Method_ISNEW(V);
extern LVAL Xm_Graph_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Xm_Graph_Widget_Class_Method_CENTER_AROUND_WIDGET(V);
extern LVAL Xm_Graph_Widget_Class_Method_DESTROY_ALL_ARCS(V);
extern LVAL Xm_Graph_Widget_Class_Method_DESTROY_ALL_NODES(V);
extern LVAL Xm_Graph_Widget_Class_Method_DESTROY_SELECTED_ARCS_OR_NODES(V);
extern LVAL Xm_Graph_Widget_Class_Method_GET_ARCS(V);
extern LVAL Xm_Graph_Widget_Class_Method_GET_ARCS_BETWEEN_NODES(V);
extern LVAL Xm_Graph_Widget_Class_Method_GET_ARC_NODES(V);
extern LVAL Xm_Graph_Widget_Class_Method_GET_NODES(V);
extern LVAL Xm_Graph_Widget_Class_Method_GET_NODE_ARCS(V);
extern LVAL Xm_Graph_Widget_Class_Method_GET_ROOTS(V);
extern LVAL Xm_Graph_Widget_Class_Method_GET_SELECTED_ARCS(V);
extern LVAL Xm_Graph_Widget_Class_Method_GET_SELECTED_NODES(V);
extern LVAL Xm_Graph_Widget_Class_Method_INPUT_OVER_ARC(V);
extern LVAL Xm_Graph_Widget_Class_Method_INSERT_ROOTS(V);
extern LVAL Xm_Graph_Widget_Class_Method_ISNEW(V);
extern LVAL Xm_Graph_Widget_Class_Method_IS_POINT_IN_ARC(V);
extern LVAL Xm_Graph_Widget_Class_Method_IS_SELECTED_ARC(V);
extern LVAL Xm_Graph_Widget_Class_Method_IS_SELECTED_NODE(V);
extern LVAL Xm_Graph_Widget_Class_Method_LAYOUT(V);
extern LVAL Xm_Graph_Widget_Class_Method_MOVE_ALL(V);
extern LVAL Xm_Graph_Widget_Class_Method_MOVE_ARC(V);
extern LVAL Xm_Graph_Widget_Class_Method_MOVE_NODE(V);
extern LVAL Xm_Graph_Widget_Class_Method_NUM_ARCS(V);
extern LVAL Xm_Graph_Widget_Class_Method_NUM_NODES(V);
extern LVAL Xm_Graph_Widget_Class_Method_NUM_NODE_ARCS(V);
extern LVAL Xm_Graph_Widget_Class_Method_NUM_ROOTS(V);
extern LVAL Xm_Graph_Widget_Class_Method_NUM_SELECTED_ARCS(V);
extern LVAL Xm_Graph_Widget_Class_Method_NUM_SELECTED_NODES(V);
extern LVAL Xm_Graph_Widget_Class_Method_RELAY_SUBGRAPH(V);
extern LVAL Xm_Graph_Widget_Class_Method_REMOVE_ARC_BETWEEN_NODES(V);
extern LVAL Xm_Graph_Widget_Class_Method_REMOVE_ROOTS(V);
extern LVAL Xm_Graph_Widget_Class_Method_SELECT_ARC(V);
extern LVAL Xm_Graph_Widget_Class_Method_SELECT_ARCS(V);
extern LVAL Xm_Graph_Widget_Class_Method_SELECT_NODE(V);
extern LVAL Xm_Graph_Widget_Class_Method_SELECT_NODES(V);
extern LVAL Xm_Graph_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Xm_Graph_Widget_Class_Method_UNSELECT_ARC(V);
extern LVAL Xm_Graph_Widget_Class_Method_UNSELECT_ARCS(V);
extern LVAL Xm_Graph_Widget_Class_Method_UNSELECT_NODE(V);
extern LVAL Xm_Graph_Widget_Class_Method_UNSELECT_NODES(V);
#endif				/* HP_GRAPH_WIDGET */
/****************** END: WINTERP XmGraph PRIMITIVES  *****************/

/****************** BEGIN: WINTERP Xtango PRIMITIVES  ****************/
#ifdef WINTERP_XTANGO_WIDGET
extern LVAL Tango_Bitmap_Image_Class_Method_ISNEW(V);
extern LVAL Tango_Bitmap_Image_Class_Method_STOREON(V);
extern LVAL Tango_Bitmap_Image_Class_Method_TX_SHUFFLE(V);
extern LVAL Tango_Circle_Image_Class_Method_ISNEW(V);
extern LVAL Tango_Circle_Image_Class_Method_STOREON(V);
extern LVAL Tango_Composite_Image_Class_Method_ISNEW(V);
extern LVAL Tango_Composite_Image_Class_Method_STOREON(V);
extern LVAL Tango_Ellipse_Image_Class_Method_ISNEW(V);
extern LVAL Tango_Ellipse_Image_Class_Method_STOREON(V);
extern LVAL Tango_Image_Class_Method_EXISTS_P(V);
extern LVAL Tango_Image_Class_Method_IMAGE_COPY(V);
extern LVAL Tango_Image_Class_Method_ISNEW(V);
extern LVAL Tango_Image_Class_Method_PRIN1(V);
extern LVAL Tango_Image_Class_Method_TAP_COLOR(V);
extern LVAL Tango_Image_Class_Method_TAP_FILL(V);
extern LVAL Tango_Image_Class_Method_TAP_FLASH(V);
extern LVAL Tango_Image_Class_Method_TAP_JUMP(V);
extern LVAL Tango_Image_Class_Method_TAP_MOVE(V);
extern LVAL Tango_Image_Class_Method_TAP_SHOW(V);
extern LVAL Tango_Image_Class_Method_TAP_TRAVERSE(V);
extern LVAL Tango_Image_Class_Method_TAP_VIS_TOGGLE(V);
extern LVAL Tango_Image_Class_Method_TX_COLOR(V);
extern LVAL Tango_Image_Class_Method_TX_DELAY(V);
extern LVAL Tango_Image_Class_Method_TX_DELETE(V);
extern LVAL Tango_Image_Class_Method_TX_FILL(V);
extern LVAL Tango_Image_Class_Method_TX_LOWER(V);
extern LVAL Tango_Image_Class_Method_TX_MOVE(V);
extern LVAL Tango_Image_Class_Method_TX_RAISE(V);
extern LVAL Tango_Image_Class_Method_TX_REFRESH(V);
extern LVAL Tango_Image_Class_Method_TX_VISIBLE(V);
extern LVAL Tango_Image_Class_Method_TX_ZOOM(V);
extern LVAL Tango_Line_Image_Class_Method_ISNEW(V);
extern LVAL Tango_Line_Image_Class_Method_STOREON(V);
extern LVAL Tango_Non_Poly_Image_Class_Method_IMAGE_LOC(V);
extern LVAL Tango_Non_Poly_Image_Class_Method_TX_RESIZE(V);
extern LVAL Tango_Poly_Image_Class_Method_TX_GRAB1(V);
extern LVAL Tango_Poly_Image_Class_Method_TX_GRAB2(V);
extern LVAL Tango_Poly_Image_Class_Method_TX_GRAB3(V);
extern LVAL Tango_Poly_Image_Class_Method_TX_GRAB4(V);
extern LVAL Tango_Poly_Image_Class_Method_TX_GRAB5(V);
extern LVAL Tango_Poly_Image_Class_Method_TX_GRAB6(V);
extern LVAL Tango_Poly_Image_Class_Method_TX_GRAB7(V);
extern LVAL Tango_Poly_Image_Class_Method_TX_RESIZE1(V);
extern LVAL Tango_Poly_Image_Class_Method_TX_RESIZE2(V);
extern LVAL Tango_Poly_Image_Class_Method_TX_RESIZE3(V);
extern LVAL Tango_Poly_Image_Class_Method_TX_RESIZE4(V);
extern LVAL Tango_Poly_Image_Class_Method_TX_RESIZE5(V);
extern LVAL Tango_Poly_Image_Class_Method_TX_RESIZE6(V);
extern LVAL Tango_Poly_Image_Class_Method_TX_RESIZE7(V);
extern LVAL Tango_Polygon_Image_Class_Method_IMAGE_LOC(V);
extern LVAL Tango_Polygon_Image_Class_Method_ISNEW(V);
extern LVAL Tango_Polygon_Image_Class_Method_STOREON(V);
extern LVAL Tango_Polyline_Image_Class_Method_IMAGE_LOC(V);
extern LVAL Tango_Polyline_Image_Class_Method_ISNEW(V);
extern LVAL Tango_Polyline_Image_Class_Method_STOREON(V);
extern LVAL Tango_Rectangle_Image_Class_Method_ISNEW(V);
extern LVAL Tango_Rectangle_Image_Class_Method_STOREON(V);
extern LVAL Tango_Spline_Image_Class_Method_IMAGE_LOC(V);
extern LVAL Tango_Spline_Image_Class_Method_ISNEW(V);
extern LVAL Tango_Spline_Image_Class_Method_STOREON(V);
extern LVAL Tango_Text_Image_Class_Method_ISNEW(V);
extern LVAL Tango_Text_Image_Class_Method_STOREON(V);
extern LVAL Xtango_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Xtango_Widget_Class_Method_BEGIN_DRAWING(V);
extern LVAL Xtango_Widget_Class_Method_COLORS_STOREON(V);
extern LVAL Xtango_Widget_Class_Method_COPY_TO_2D_BITMAP_ARRAY(V);
extern LVAL Xtango_Widget_Class_Method_GET_EVENT_COORD(V);
extern LVAL Xtango_Widget_Class_Method_GET_EVENT_IMAGE(V);
extern LVAL Xtango_Widget_Class_Method_GET_IMAGES(V);
extern LVAL Xtango_Widget_Class_Method_INPUT_COORD(V);
extern LVAL Xtango_Widget_Class_Method_INPUT_IMAGE(V);
extern LVAL Xtango_Widget_Class_Method_INQ_COORD(V);
extern LVAL Xtango_Widget_Class_Method_ISNEW(V);
extern LVAL Xtango_Widget_Class_Method_LOAD_COLOR(V);
extern LVAL Xtango_Widget_Class_Method_MONO_PATTERN_REPRESENTATION(V);
extern LVAL Xtango_Widget_Class_Method_PAN(V);
extern LVAL Xtango_Widget_Class_Method_REFRESH(V);
extern LVAL Xtango_Widget_Class_Method_SET_ANIMATION_EVENT_PROCESSING(V);
extern LVAL Xtango_Widget_Class_Method_SET_BGCOLOR(V);
extern LVAL Xtango_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Xtango_Widget_Class_Method_SET_COORD(V);
extern LVAL Xtango_Widget_Class_Method_SET_DEBUG(V);
extern LVAL Xtango_Widget_Class_Method_SET_DELAY(V);
extern LVAL Xtango_Widget_Class_Method_ZOOM(V);
extern LVAL Tango_GIF_Image_Class_Method_ISNEW(V);
extern LVAL Tango_Image_Class_Method_SHOW(V);
extern LVAL Xtango_Widget_Class_Method_RESIZE_CANVAS(V);

extern LVAL Tcls_Prim_TANGOIMAGEOBJP(V);
extern LVAL Xtango_Prim_TANGO_PATH_ADD_HEAD(V);
extern LVAL Xtango_Prim_TANGO_PATH_ADD_TAIL(V);
extern LVAL Xtango_Prim_TANGO_PATH_COLOR(V);
extern LVAL Xtango_Prim_TANGO_PATH_COMPOSE(V);
extern LVAL Xtango_Prim_TANGO_PATH_CONCATENATE(V);
extern LVAL Xtango_Prim_TANGO_PATH_COPY(V);
extern LVAL Xtango_Prim_TANGO_PATH_CREATE(V);
extern LVAL Xtango_Prim_TANGO_PATH_DELETE_HEAD(V);
extern LVAL Xtango_Prim_TANGO_PATH_DELETE_TAIL(V);
extern LVAL Xtango_Prim_TANGO_PATH_DISTANCE(V);
extern LVAL Xtango_Prim_TANGO_PATH_DX(V);
extern LVAL Xtango_Prim_TANGO_PATH_DY(V);
extern LVAL Xtango_Prim_TANGO_PATH_EXAMPLE(V);
extern LVAL Xtango_Prim_TANGO_PATH_EXTEND(V);
extern LVAL Xtango_Prim_TANGO_PATH_FREE(V);
extern LVAL Xtango_Prim_TANGO_PATH_INTERPOLATE(V);
extern LVAL Xtango_Prim_TANGO_PATH_ITERATE(V);
extern LVAL Xtango_Prim_TANGO_PATH_LENGTH(V);
extern LVAL Xtango_Prim_TANGO_PATH_MOTION(V);
extern LVAL Xtango_Prim_TANGO_PATH_REVERSE(V);
extern LVAL Xtango_Prim_TANGO_PATH_ROTATE(V);
extern LVAL Xtango_Prim_TANGO_PATH_SCALE(V);
extern LVAL Xtango_Prim_TANGO_PATH_SMOOTH(V);
extern LVAL Xtango_Prim_TANGO_PATH_TYPE(V);
extern LVAL Xtango_Prim_TANGO_TAP_EXCHANGE(V);
extern LVAL Xtango_Prim_TANGO_TAP_SWITCH(V);
extern LVAL Xtango_Prim_TANGO_TX_COMPOSE(V);
extern LVAL Xtango_Prim_TANGO_TX_CONCATENATE(V);
extern LVAL Xtango_Prim_TANGO_TX_FREE(V);
extern LVAL Xtango_Prim_TANGO_TX_ITERATE(V);
extern LVAL Xtango_Prim_TANGO_TX_PERFORM(V);

extern LVAL Wpm_Prim_GIF_TO_PIXMAP(V);

#endif /* WINTERP_XTANGO_WIDGET */
/****************** END: WINTERP Xtango PRIMITIVES ***********************/

/****************** BEGIN: WINTERP Table PRIMITIVES **********************/
#ifdef WINTERP_TABLE_WIDGET
extern LVAL Prim_XT_TBL_CONFIG(V);
extern LVAL Prim_XT_TBL_OPTIONS(V);
extern LVAL Prim_XT_TBL_POSITION(V);
extern LVAL Prim_XT_TBL_RESIZE(V);
#endif /* WINTERP_TABLE_WIDGET */
/****************** END: WINTERP Table PRIMITIVES ************************/

/****************** BEGIN: WINTERP Expect FUNCTIONS **********************/
#ifdef WINTERP_EXPECT_SUBPROCESS
extern LVAL Prim_EXP_GET_PID(V);
extern LVAL Prim_EXP_POPEN(V);
extern LVAL Prim_EXP_SPAWN(V);
extern LVAL Prim_EXP_STTY_INIT(V);
extern LVAL Prim_EXP_WAIT(V);
extern LVAL Prim_EXP_KILL(V);
#endif /* WINTERP_EXPECT_SUBPROCESS */
/****************** END: WINTERP Expect FUNCTIONS *************************/    

/****************** BEGIN: WINTERP SgDropPocketWidget PRIMITIVES **********/
#ifdef SGI_DROP_POCKET_WIDGET	/* only for Irix 5.1 and IndigoMagic desktop */
extern LVAL Sg_Drop_Pocket_Widget_Class_Method_ADD_CALLBACK(V);
extern LVAL Sg_Drop_Pocket_Widget_Class_Method_SET_CALLBACK(V);
extern LVAL Sg_Finder_Widget_Class_Method_ADD_HISTORY_ITEM(V);
extern LVAL Sg_Finder_Widget_Class_Method_CLEAR_HISTORY(V);
extern LVAL Sg_Finder_Widget_Class_Method_SET_STRING(V);
extern LVAL Sg_Finder_Widget_Class_Method_GET_STRING(V);
extern LVAL Sg_Finder_Widget_Class_Method_GET_CHILD(V);
#endif /* SGI_DROP_POCKET_WIDGET */
/****************** END: WINTERP SgDropPocketWidget PRIMITIVES ************/

/* xnotimp - function table entries that are currently not implemented */
LVAL xnotimp()
{
    xlfail("function not implemented");
}


/* see #define INDEX_OF_LAST_FUNTAB_ENTRY_USED_BY_libWinterp below... */
#define SIZE_OF_FUNTAB_SEGMENT_0 0
#define SIZE_OF_FUNTAB_SEGMENT_1 0
#define SIZE_OF_FUNTAB_SEGMENT_2 0
#define SIZE_OF_FUNTAB_SEGMENT_3 0
#define SIZE_OF_FUNTAB_SEGMENT_4 0
#define SIZE_OF_FUNTAB_SEGMENT_5 0
#define SIZE_OF_FUNTAB_SEGMENT_6 0
#define SIZE_OF_FUNTAB_SEGMENT_7 0
#define SIZE_OF_FUNTAB_SEGMENT_8 0
#define SIZE_OF_FUNTAB_SEGMENT_9 0

/*
 * The function table -- funtab[].
 *
 * NOTE:
 * The order and number of METHOD entries in funtab[] must correspond to the
 * number and order of the enumerations (method-functiontable indexes) created
 * in w_funtab.h. FUNCTIONS need not be entered in w_funtab.h.
 *
 * When adding METHODS to funtab[] below, make sure to update the #define
 * SIZE_OF_FUNTAB_SEGMENT_i (for the appropriate value of i) to the number
 * of entries added by your new set of methods. Also, for each method in
 * funtab[], a corresponding entry must be added to w_funtab.h, with the
 * last method-entry being used to update the value of cpp-variable
 * LAST_FUNTAB_POINTER_USED_BY_libWinterp.
 * (You will also need to declare the function "extern" above in w_funtab.c)
 *
 * Function Wfu_Funtab_Sanity_Check() is called from main() and checks to make
 * sure that the number of entries in funtab[] correspond to the number of
 * indexes in w_funtab.h. This test catches the majority of errors in keeping
 * the funtab[] table up to date with the pointers in w_funtab.h. Note however
 * that the test will only work if you keep
 * LAST_FUNTAB_POINTER_USED_BY_libWinterp and
 * INDEX_OF_LAST_FUNTAB_ENTRY_USED_BY_libWinterp up to date.
 *
 * In order to decouple your c-language extensions to WINTERP from changes in
 * future releases of WINTERP, you should not add new entries to w_funtab.c
 * and w_funtab.h. To add a function or method <function> to WINTERP, you should
 * (1) declare the new function as "extern" by adding a line of the form
 * "extern LVAL <function>();" in app_funextn.h;
 * (2) create a symbolic index for the function or method by adding a line
 * "FTAB_<function>," to app_funidx.h;
 * (3) associate a lisp symbol name <FUNCTION-NAME> (must be all uppercase)
 * to the C function <function> by adding the following line to app_fundecl.h:
 * "{"<FUNCTION-NAME>", S, <function>},"
 *
 * If you are adding a method, rather than a function, do the same in
 * steps (1) and (2), but for (3) you should add a line like the following to
 * app_fundecl.h: "{NULL, S, <function>},".
 * To associate a message keyword <:MESSAGE> to a method on <widgetclass>,
 * you must call xladdmsg() in the portion of a file that initializes
 * a class. An example of such a call is:
 * xladdmsg(<widgetclass>, "<:MESSAGE>", FTAB_<function>).
 * The file defining a class and it's methods should #include w_funtab.h in
 * order to get FTAB_<function>.
 * See files wc_*.c for examples of defining methods/messages.
 */

/* Note also that as of WINTERP 2.10, I've extended funtab[] with
   an extra element which is a pointer to the packagename */

#ifdef PACKAGES

#define XLISP_PACKAGE_NAME ,&xlisppack
#define WINTERP_PACKAGE_NAME ,&xlwinterppack
#ifdef WINTERP_XTANGO_WIDGET
#define TANGO_PACKAGE_NAME ,&xltangopack
#endif /* WINTERP_XTANGO_WIDGET */

#else

#define XLISP_PACKAGE_NAME
#define WINTERP_PACKAGE_NAME
#ifdef WINTERP_XTANGO_WIDGET
#define TANGO_PACKAGE_NAME
#endif /* WINTERP_XTANGO_WIDGET */

#endif /* PACKAGES */

FUNDEF funtab[] = {
/* DO NOT ALTER ENTRIES UNTIL AFTER OBPRIN1 */
  /*
   * NOTE-FROM-NPM: if you re-order any entries between index 0-15, you must
   * also change the #defines in xlisp/xlisp.h accordingly:
   * #define FT_RMHASH   0
   * #define FT_RMQUOTE	 1
   * #define FT_RMDQUOTE 2
   * #define FT_RMBQUOTE 3
   * #define FT_RMCOMMA  4
   * #define FT_RMLPAR   5
   * #define FT_RMRPAR   6
   * #define FT_RMSEMI   7
   * -- #define xxxxxx   8 --
   * -- #define yyyyyy   9 --
   * #define FT_CLNEW	 10
   * #define FT_CLISNEW	 11
   * #define FT_CLANSWER 12
   * #define FT_OBISNEW	 13
   * #define FT_OBCLASS	 14
   * #define FT_OBSHOW	 15
   * #define FT_OBPRIN1	 16
   */

  /* read macro functions */
  {	NULL,				S, rmhash		XLISP_PACKAGE_NAME}, /*   0 */
  {	NULL,				S, rmquote		XLISP_PACKAGE_NAME}, /*   1 */
  {	NULL,				S, rmdquote		XLISP_PACKAGE_NAME}, /*   2 */
  {	NULL,				S, rmbquote		XLISP_PACKAGE_NAME}, /*   3 */
  {	NULL,				S, rmcomma		XLISP_PACKAGE_NAME}, /*   4 */
  {	NULL,				S, rmlpar		XLISP_PACKAGE_NAME}, /*   5 */
  {	NULL,				S, rmrpar		XLISP_PACKAGE_NAME}, /*   6 */
  {	NULL,				S, rmsemi		XLISP_PACKAGE_NAME}, /*   7 */
  {	NULL,				S, xnotimp		XLISP_PACKAGE_NAME}, /*   8 */
  {	NULL,				S, xnotimp		XLISP_PACKAGE_NAME}, /*   9 */

  /* methods */
  {	NULL,				S, clnew		XLISP_PACKAGE_NAME}, /*  10 */
  {	NULL,				S, clisnew		XLISP_PACKAGE_NAME}, /*  11 */
  {	NULL,				S, clanswer		XLISP_PACKAGE_NAME}, /*  12 */
  {	NULL,				S, obisnew		XLISP_PACKAGE_NAME}, /*  13 */
  {	NULL,				S, obclass		XLISP_PACKAGE_NAME}, /*  14 */
  {	NULL,				S, obshow		XLISP_PACKAGE_NAME}, /*  15 */
  {	NULL,				S, obprin1		XLISP_PACKAGE_NAME}, /*  16 */
  {	NULL,				S, xnotimp		XLISP_PACKAGE_NAME}, /*  17 */
  {	NULL,				S, xnotimp		XLISP_PACKAGE_NAME}, /*  18 */
  {	NULL,				S, xnotimp		XLISP_PACKAGE_NAME}, /*  19 */

/******************************************************************************/
/************************ BEGIN: WINTERP PRIMITIVES ***************************/
/******************************************************************************/

/****************** BEGIN: WINTERP METHODS (Motif >= 1.0) *********************/
  {NULL, S, Application_Shell_Widget_Class_Method_GET_ARGV	WINTERP_PACKAGE_NAME}, /* 20 */
  {NULL, S, Application_Shell_Widget_Class_Method_ISNEW		WINTERP_PACKAGE_NAME}, /* 21 */
  {NULL, S, Application_Shell_Widget_Class_Method_SET_ARGV	WINTERP_PACKAGE_NAME}, /* 22 */
  {NULL, S, Popup_Shell_Widget_Class_Method_ISNEW		WINTERP_PACKAGE_NAME}, /* 23 */
  {NULL, S, Popup_Shell_Widget_Class_Method_POPDOWN		WINTERP_PACKAGE_NAME}, /* 24 */
  {NULL, S, Popup_Shell_Widget_Class_Method_POPUP		WINTERP_PACKAGE_NAME}, /* 25 */
  {NULL, S, Shell_Widget_Class_Method_ISNEW			WINTERP_PACKAGE_NAME}, /* 26 */
  {NULL, S, Shell_Widget_Class_Method_IS_MOTIF_WM_RUNNING	WINTERP_PACKAGE_NAME}, /* 27 */
  {NULL, S, Shell_Widget_Class_Method_LOWER_WINDOW		WINTERP_PACKAGE_NAME}, /* 28 */
  {NULL, S, Shell_Widget_Class_Method_MANAGE			WINTERP_PACKAGE_NAME}, /* 29 */
  {NULL, S, Shell_Widget_Class_Method_MAP_RAISED		WINTERP_PACKAGE_NAME}, /* 30 */
  {NULL, S, Shell_Widget_Class_Method_RAISE_WINDOW		WINTERP_PACKAGE_NAME}, /* 31 */
  {NULL, S, Shell_Widget_Class_Method_REALIZE			WINTERP_PACKAGE_NAME}, /* 32 */
  {NULL, S, Shell_Widget_Class_Method_UNMANAGE			WINTERP_PACKAGE_NAME}, /* 33 */
  {NULL, S, Shell_Widget_Class_Method_UNREALIZE			WINTERP_PACKAGE_NAME}, /* 34 */
  {NULL, S, Widget_Class_Method_ADD_CALLBACK			WINTERP_PACKAGE_NAME}, /* 35 */
  {NULL, S, Widget_Class_Method_ADD_EVENT_HANDLER		WINTERP_PACKAGE_NAME}, /* 36 */
  {NULL, S, Widget_Class_Method_ADD_GRAB			WINTERP_PACKAGE_NAME}, /* 37 */
  {NULL, S, Widget_Class_Method_ADD_TAB_GROUP			WINTERP_PACKAGE_NAME}, /* 38 */
  {NULL, S, Widget_Class_Method_AUGMENT_TRANSLATIONS		WINTERP_PACKAGE_NAME}, /* 39 */
  {NULL, S, Widget_Class_Method_BUILD_EVENT_MASK		WINTERP_PACKAGE_NAME}, /* 40 */
  {NULL, S, Widget_Class_Method_DESTROY				WINTERP_PACKAGE_NAME}, /* 41 */
  {NULL, S, Widget_Class_Method_EXISTS_P			WINTERP_PACKAGE_NAME}, /* 42 */
  {NULL, S, Widget_Class_Method_GET_VALUES			WINTERP_PACKAGE_NAME}, /* 43 */
  {NULL, S, Widget_Class_Method_HAS_CALLBACKS			WINTERP_PACKAGE_NAME}, /* 44 */
  {NULL, S, Widget_Class_Method_INSTALL_ACCELERATORS		WINTERP_PACKAGE_NAME}, /* 45 */
  {NULL, S, Widget_Class_Method_INSTALL_ALL_ACCELERATORS	WINTERP_PACKAGE_NAME}, /* 46 */
  {NULL, S, Widget_Class_Method_ISNEW				WINTERP_PACKAGE_NAME}, /* 47 */
  {NULL, S, Widget_Class_Method_IS_COMPOSITE			WINTERP_PACKAGE_NAME}, /* 48 */
  {NULL, S, Widget_Class_Method_IS_CONSTRAINT			WINTERP_PACKAGE_NAME}, /* 49 */
  {NULL, S, Widget_Class_Method_IS_GADGET			WINTERP_PACKAGE_NAME}, /* 50 */
  {NULL, S, Widget_Class_Method_IS_MANAGED			WINTERP_PACKAGE_NAME}, /* 51 */
  {NULL, S, Widget_Class_Method_IS_MANAGER			WINTERP_PACKAGE_NAME}, /* 52 */
  {NULL, S, Widget_Class_Method_IS_PRIMITIVE			WINTERP_PACKAGE_NAME}, /* 53 */
  {NULL, S, Widget_Class_Method_IS_REALIZED			WINTERP_PACKAGE_NAME}, /* 54 */
  {NULL, S, Widget_Class_Method_IS_SENSITIVE			WINTERP_PACKAGE_NAME}, /* 55 */
  {NULL, S, Widget_Class_Method_IS_SHELL			WINTERP_PACKAGE_NAME}, /* 56 */
  {NULL, S, Widget_Class_Method_MANAGE				WINTERP_PACKAGE_NAME}, /* 57 */
  {NULL, S, Widget_Class_Method_MAP				WINTERP_PACKAGE_NAME}, /* 58 */
  {NULL, S, Widget_Class_Method_OVERRIDE_TRANSLATIONS		WINTERP_PACKAGE_NAME}, /* 59 */
  {NULL, S, Widget_Class_Method_PARENT				WINTERP_PACKAGE_NAME}, /* 60 */
  {NULL, S, Widget_Class_Method_PRIN1				WINTERP_PACKAGE_NAME}, /* 61 */
  {NULL, S, Widget_Class_Method_REMOVE_ALL_CALLBACKS		WINTERP_PACKAGE_NAME}, /* 62 */
  {NULL, S, Widget_Class_Method_REMOVE_GRAB			WINTERP_PACKAGE_NAME}, /* 63 */
  {NULL, S, Widget_Class_Method_REMOVE_TAB_GROUP		WINTERP_PACKAGE_NAME}, /* 64 */
  {NULL, S, Widget_Class_Method_SET_CALLBACK			WINTERP_PACKAGE_NAME}, /* 65 */
  {NULL, S, Widget_Class_Method_SET_EVENT_HANDLER		WINTERP_PACKAGE_NAME}, /* 66 */
  {NULL, S, Widget_Class_Method_SET_MAPPED_WHEN_MANAGED		WINTERP_PACKAGE_NAME}, /* 67 */
  {NULL, S, Widget_Class_Method_SET_SENSITIVE			WINTERP_PACKAGE_NAME}, /* 68 */
  {NULL, S, Widget_Class_Method_SET_VALUES			WINTERP_PACKAGE_NAME}, /* 69 */
  {NULL, S, Widget_Class_Method_UNINSTALL_TRANSLATIONS		WINTERP_PACKAGE_NAME}, /* 70 */
  {NULL, S, Widget_Class_Method_UNMANAGE			WINTERP_PACKAGE_NAME}, /* 71 */
  {NULL, S, Widget_Class_Method_UNMAP				WINTERP_PACKAGE_NAME}, /* 72 */
  {NULL, S, Widget_Class_Method_UPDATE_DISPLAY			WINTERP_PACKAGE_NAME}, /* 73 */
  {NULL, S, Widget_Class_Method_WINDOW				WINTERP_PACKAGE_NAME}, /* 74 */
  {NULL, S, Xm_Bulletin_Board_Widget_Class_Method_ISNEW		WINTERP_PACKAGE_NAME}, /* 75 */
  {NULL, S, Xm_Cascade_Button_Widget_Class_Method_HIGHLIGHT	WINTERP_PACKAGE_NAME}, /* 76 */
  {NULL, S, Xm_Command_Widget_Class_Method_ADD_CALLBACK		WINTERP_PACKAGE_NAME}, /* 77 */
  {NULL, S, Xm_Command_Widget_Class_Method_APPEND_VALUE		WINTERP_PACKAGE_NAME}, /* 78 */
  {NULL, S, Xm_Command_Widget_Class_Method_ERROR		WINTERP_PACKAGE_NAME}, /* 79 */
  {NULL, S, Xm_Command_Widget_Class_Method_GET_CHILD		WINTERP_PACKAGE_NAME}, /* 80 */
  {NULL, S, Xm_Command_Widget_Class_Method_GET_HISTORY_ITEMS	WINTERP_PACKAGE_NAME}, /* 81 */
  {NULL, S, Xm_Command_Widget_Class_Method_ISNEW		WINTERP_PACKAGE_NAME}, /* 82 */
  {NULL, S, Xm_Command_Widget_Class_Method_SET_CALLBACK		WINTERP_PACKAGE_NAME}, /* 83 */
  {NULL, S, Xm_Command_Widget_Class_Method_SET_VALUE		WINTERP_PACKAGE_NAME}, /* 84 */
  {NULL, S, Xm_Drawing_Area_Widget_Class_Method_ADD_CALLBACK	WINTERP_PACKAGE_NAME}, /* 85 */
  {NULL, S, Xm_Drawing_Area_Widget_Class_Method_SET_CALLBACK	WINTERP_PACKAGE_NAME}, /* 86 */
  {NULL, S, Xm_Drawn_Button_Widget_Class_Method_ADD_CALLBACK	WINTERP_PACKAGE_NAME}, /* 87 */
  {NULL, S, Xm_Drawn_Button_Widget_Class_Method_SET_CALLBACK	WINTERP_PACKAGE_NAME}, /* 88 */
  {NULL, S, Xm_File_Selection_Box_Widget_Class_Method_ADD_CALLBACK WINTERP_PACKAGE_NAME}, /* 89 */
  {NULL, S, Xm_File_Selection_Box_Widget_Class_Method_DO_SEARCH	WINTERP_PACKAGE_NAME}, /* 90 */
  {NULL, S, Xm_File_Selection_Box_Widget_Class_Method_GET_CHILD	WINTERP_PACKAGE_NAME}, /* 91 */
  {NULL, S, Xm_File_Selection_Box_Widget_Class_Method_ISNEW	WINTERP_PACKAGE_NAME}, /* 92 */
  {NULL, S, Xm_File_Selection_Box_Widget_Class_Method_SET_CALLBACK WINTERP_PACKAGE_NAME}, /* 93 */
  {NULL, S, Xm_Form_Widget_Class_Method_ISNEW			WINTERP_PACKAGE_NAME}, /* 94 */
  {NULL, S, Xm_List_Widget_Class_Method_ADD_CALLBACK		WINTERP_PACKAGE_NAME}, /* 95 */
  {NULL, S, Xm_List_Widget_Class_Method_ADD_ITEM_UNSELECTED	WINTERP_PACKAGE_NAME}, /* 96 */
  {NULL, S, Xm_List_Widget_Class_Method_ADD_ITEM		WINTERP_PACKAGE_NAME}, /* 97 */
  {NULL, S, Xm_List_Widget_Class_Method_DELETE_ITEM		WINTERP_PACKAGE_NAME}, /* 98 */
  {NULL, S, Xm_List_Widget_Class_Method_DELETE_POS		WINTERP_PACKAGE_NAME}, /* 99 */
  {NULL, S, Xm_List_Widget_Class_Method_DESELECT_ALL_ITEMS	WINTERP_PACKAGE_NAME}, /* 100 */
  {NULL, S, Xm_List_Widget_Class_Method_DESELECT_ITEM		WINTERP_PACKAGE_NAME}, /* 101 */
  {NULL, S, Xm_List_Widget_Class_Method_DESELECT_POS		WINTERP_PACKAGE_NAME}, /* 102 */
  {NULL, S, Xm_List_Widget_Class_Method_GET_ITEMS		WINTERP_PACKAGE_NAME}, /* 103 */
  {NULL, S, Xm_List_Widget_Class_Method_GET_SELECTED_ITEMS	WINTERP_PACKAGE_NAME}, /* 104 */
  {NULL, S, Xm_List_Widget_Class_Method_ISNEW			WINTERP_PACKAGE_NAME}, /* 105 */
  {NULL, S, Xm_List_Widget_Class_Method_ITEM_EXISTS		WINTERP_PACKAGE_NAME}, /* 106 */
  {NULL, S, Xm_List_Widget_Class_Method_SELECT_ITEM		WINTERP_PACKAGE_NAME}, /* 107 */
  {NULL, S, Xm_List_Widget_Class_Method_SELECT_POS		WINTERP_PACKAGE_NAME}, /* 108 */
  {NULL, S, Xm_List_Widget_Class_Method_SET_BOTTOM_ITEM		WINTERP_PACKAGE_NAME}, /* 109 */
  {NULL, S, Xm_List_Widget_Class_Method_SET_BOTTOM_POS		WINTERP_PACKAGE_NAME}, /* 110 */
  {NULL, S, Xm_List_Widget_Class_Method_SET_CALLBACK		WINTERP_PACKAGE_NAME}, /* 111 */
  {NULL, S, Xm_List_Widget_Class_Method_SET_HORIZ_POS		WINTERP_PACKAGE_NAME}, /* 112 */
  {NULL, S, Xm_List_Widget_Class_Method_SET_ITEM		WINTERP_PACKAGE_NAME}, /* 113 */
  {NULL, S, Xm_List_Widget_Class_Method_SET_POS			WINTERP_PACKAGE_NAME}, /* 114 */
  {NULL, S, Xm_Main_Window_Widget_Class_Method_SEP1		WINTERP_PACKAGE_NAME}, /* 115 */
  {NULL, S, Xm_Main_Window_Widget_Class_Method_SEP2		WINTERP_PACKAGE_NAME}, /* 116 */
  {NULL, S, Xm_Main_Window_Widget_Class_Method_SET_AREAS	WINTERP_PACKAGE_NAME}, /* 117 */
  {NULL, S, Xm_Message_Box_Widget_Class_Method_GET_CHILD	WINTERP_PACKAGE_NAME}, /* 118 */
  {NULL, S, Xm_Message_Box_Widget_Class_Method_ISNEW		WINTERP_PACKAGE_NAME}, /* 119 */
  {NULL, S, Xm_Row_Column_Widget_Class_Method_ADD_CALLBACK	WINTERP_PACKAGE_NAME}, /* 120 */
  {NULL, S, Xm_Row_Column_Widget_Class_Method_ISNEW		WINTERP_PACKAGE_NAME}, /* 121 */
  {NULL, S, Xm_Row_Column_Widget_Class_Method_MENU_POSITION	WINTERP_PACKAGE_NAME}, /* 122 */
  {NULL, S, Xm_Row_Column_Widget_Class_Method_OPTION_BUTTON_GADGET WINTERP_PACKAGE_NAME}, /* 123 */
  {NULL, S, Xm_Row_Column_Widget_Class_Method_OPTION_LABEL_GADGET WINTERP_PACKAGE_NAME}, /* 124 */
  {NULL, S, Xm_Row_Column_Widget_Class_Method_SET_CALLBACK	WINTERP_PACKAGE_NAME}, /* 125 */
  {NULL, S, Xm_Scale_Widget_Class_Method_ADD_CALLBACK		WINTERP_PACKAGE_NAME}, /* 126 */
  {NULL, S, Xm_Scale_Widget_Class_Method_GET_VALUE		WINTERP_PACKAGE_NAME}, /* 127 */
  {NULL, S, Xm_Scale_Widget_Class_Method_SET_CALLBACK		WINTERP_PACKAGE_NAME}, /* 128 */
  {NULL, S, Xm_Scale_Widget_Class_Method_SET_VALUE		WINTERP_PACKAGE_NAME}, /* 129 */
  {NULL, S, Xm_Scroll_Bar_Widget_Class_Method_ADD_CALLBACK	WINTERP_PACKAGE_NAME}, /* 130 */
  {NULL, S, Xm_Scroll_Bar_Widget_Class_Method_GET_VALUE		WINTERP_PACKAGE_NAME}, /* 131 */
  {NULL, S, Xm_Scroll_Bar_Widget_Class_Method_SET_CALLBACK	WINTERP_PACKAGE_NAME}, /* 132 */
  {NULL, S, Xm_Scroll_Bar_Widget_Class_Method_SET_VALUE		WINTERP_PACKAGE_NAME}, /* 133 */
  {NULL, S, Xm_Scrolled_Window_Widget_Class_Method_SET_AREAS	WINTERP_PACKAGE_NAME}, /* 134 */
  {NULL, S, Xm_Selection_Box_Widget_Class_Method_ADD_CALLBACK	WINTERP_PACKAGE_NAME}, /* 135 */
  {NULL, S, Xm_Selection_Box_Widget_Class_Method_GET_CHILD	WINTERP_PACKAGE_NAME}, /* 136 */
  {NULL, S, Xm_Selection_Box_Widget_Class_Method_GET_LIST_ITEMS	WINTERP_PACKAGE_NAME}, /* 137 */
  {NULL, S, Xm_Selection_Box_Widget_Class_Method_ISNEW		WINTERP_PACKAGE_NAME}, /* 138 */
  {NULL, S, Xm_Selection_Box_Widget_Class_Method_SET_CALLBACK	WINTERP_PACKAGE_NAME}, /* 139 */
  {NULL, S, Xm_Text_Widget_Class_Method_ADD_CALLBACK		WINTERP_PACKAGE_NAME}, /* 140 */
  {NULL, S, Xm_Text_Widget_Class_Method_CLEAR_SELECTION		WINTERP_PACKAGE_NAME}, /* 141 */
  {NULL, S, Xm_Text_Widget_Class_Method_DISABLE_REDISPLAY	WINTERP_PACKAGE_NAME}, /* 142 */
  {NULL, S, Xm_Text_Widget_Class_Method_ENABLE_REDISPLAY	WINTERP_PACKAGE_NAME}, /* 143 */
  {NULL, S, Xm_Text_Widget_Class_Method_GET_EDITABLE		WINTERP_PACKAGE_NAME}, /* 144 */
  {NULL, S, Xm_Text_Widget_Class_Method_GET_INSERTION_POSITION	WINTERP_PACKAGE_NAME}, /* 145 */
  {NULL, S, Xm_Text_Widget_Class_Method_GET_LAST_POSITION	WINTERP_PACKAGE_NAME}, /* 146 */
  {NULL, S, Xm_Text_Widget_Class_Method_GET_MAX_LENGTH		WINTERP_PACKAGE_NAME}, /* 147 */
  {NULL, S, Xm_Text_Widget_Class_Method_GET_SELECTION_POSITION	WINTERP_PACKAGE_NAME}, /* 148 */
  {NULL, S, Xm_Text_Widget_Class_Method_GET_SELECTION		WINTERP_PACKAGE_NAME}, /* 149 */
  {NULL, S, Xm_Text_Widget_Class_Method_GET_STRING		WINTERP_PACKAGE_NAME}, /* 150 */
  {NULL, S, Xm_Text_Widget_Class_Method_GET_TOP_CHARACTER	WINTERP_PACKAGE_NAME}, /* 151 */
  {NULL, S, Xm_Text_Widget_Class_Method_GOTO_LINE		WINTERP_PACKAGE_NAME}, /* 152 */
  {NULL, S, Xm_Text_Widget_Class_Method_ISNEW			WINTERP_PACKAGE_NAME}, /* 153 */
  {NULL, S, Xm_Text_Widget_Class_Method_POS_TO_XY		WINTERP_PACKAGE_NAME}, /* 154 */
  {NULL, S, Xm_Text_Widget_Class_Method_READ_FILE_GOTO_LINE	WINTERP_PACKAGE_NAME}, /* 155 */
  {NULL, S, Xm_Text_Widget_Class_Method_READ_FILE		WINTERP_PACKAGE_NAME}, /* 156 */
  {NULL, S, Xm_Text_Widget_Class_Method_REPLACE			WINTERP_PACKAGE_NAME}, /* 157 */
  {NULL, S, Xm_Text_Widget_Class_Method_SCROLL			WINTERP_PACKAGE_NAME}, /* 158 */
  {NULL, S, Xm_Text_Widget_Class_Method_SEARCH			WINTERP_PACKAGE_NAME}, /* 159 */
  {NULL, S, Xm_Text_Widget_Class_Method_SET_CALLBACK		WINTERP_PACKAGE_NAME}, /* 160 */
  {NULL, S, Xm_Text_Widget_Class_Method_SET_EDITABLE		WINTERP_PACKAGE_NAME}, /* 161 */
  {NULL, S, Xm_Text_Widget_Class_Method_SET_INSERTION_POSITION	WINTERP_PACKAGE_NAME}, /* 162 */
  {NULL, S, Xm_Text_Widget_Class_Method_SET_MAX_LENGTH		WINTERP_PACKAGE_NAME}, /* 163 */
  {NULL, S, Xm_Text_Widget_Class_Method_SET_SELECTION		WINTERP_PACKAGE_NAME}, /* 164 */
  {NULL, S, Xm_Text_Widget_Class_Method_SET_STRING		WINTERP_PACKAGE_NAME}, /* 165 */
  {NULL, S, Xm_Text_Widget_Class_Method_SET_TOP_CHARACTER	WINTERP_PACKAGE_NAME}, /* 166 */
  {NULL, S, Xm_Text_Widget_Class_Method_SHOW_POSITION		WINTERP_PACKAGE_NAME}, /* 167 */
  {NULL, S, Xm_Text_Widget_Class_Method_WRITE_FILE		WINTERP_PACKAGE_NAME}, /* 168 */
  {NULL, S, Xm_Text_Widget_Class_Method_XY_TO_POS		WINTERP_PACKAGE_NAME}, /* 169 */
  {NULL, S, Xm_Toggle_Button_Gadget_Class_Method_GET_STATE	WINTERP_PACKAGE_NAME}, /* 170 */
  {NULL, S, Xm_Toggle_Button_Gadget_Class_Method_SET_STATE	WINTERP_PACKAGE_NAME}, /* 171 */
  {NULL, S, Xm_Toggle_Button_Widget_Class_Method_ADD_CALLBACK	WINTERP_PACKAGE_NAME}, /* 172 */
  {NULL, S, Xm_Toggle_Button_Widget_Class_Method_GET_STATE	WINTERP_PACKAGE_NAME}, /* 173 */
  {NULL, S, Xm_Toggle_Button_Widget_Class_Method_SET_CALLBACK	WINTERP_PACKAGE_NAME}, /* 174 */
  {NULL, S, Xm_Toggle_Button_Widget_Class_Method_SET_STATE	WINTERP_PACKAGE_NAME}, /* 175 */
  {NULL, S, Widget_Class_Method_SHOW	WINTERP_PACKAGE_NAME}, /* 176 */

#undef SIZE_OF_FUNTAB_SEGMENT_0
#define SIZE_OF_FUNTAB_SEGMENT_0 176
/****************** END: WINTERP METHODS (Motif >= 1.0) *********************/

/****************** BEGIN: WINTERP METHODS (Motif >= 1.1) *********************/
#ifdef WINTERP_MOTIF_11
  {NULL, S, Widget_Class_Method_CALL_ACTION_PROC		WINTERP_PACKAGE_NAME}, /* 1 */
  {NULL, S, Widget_Class_Method_FORCED_EXPOSE_UPDATE		WINTERP_PACKAGE_NAME}, /* 2 */
  {NULL, S, Widget_Class_Method_GET_CHILDREN			WINTERP_PACKAGE_NAME}, /* 3 */
  {NULL, S, Widget_Class_Method_NAME				WINTERP_PACKAGE_NAME}, /* 4 */
  {NULL, S, Widget_Class_Method_PROCESS_TRAVERSAL		WINTERP_PACKAGE_NAME}, /* 5 */
  {NULL, S, Xm_Arrow_Button_Widget_Class_Method_ADD_CALLBACK	WINTERP_PACKAGE_NAME}, /* 6 */
  {NULL, S, Xm_Arrow_Button_Widget_Class_Method_SET_CALLBACK	WINTERP_PACKAGE_NAME}, /* 7 */
  {NULL, S, Xm_Cascade_Button_Gadget_Class_Method_HIGHLIGHT	WINTERP_PACKAGE_NAME}, /* 8 */
  {NULL, S, Xm_File_Selection_Box_Widget_Class_Method_GET_DIR_LIST_ITEMS WINTERP_PACKAGE_NAME}, /* 9 */
  {NULL, S, Xm_File_Selection_Box_Widget_Class_Method_GET_FILE_LIST_ITEMS WINTERP_PACKAGE_NAME}, /* 10 */
  {NULL, S, Xm_List_Widget_Class_Method_ADD_ITEMS		WINTERP_PACKAGE_NAME}, /* 11 */
  {NULL, S, Xm_List_Widget_Class_Method_DELETE_ALL_ITEMS	WINTERP_PACKAGE_NAME}, /* 12 */
  {NULL, S, Xm_List_Widget_Class_Method_DELETE_ITEMS_POS	WINTERP_PACKAGE_NAME}, /* 13 */
  {NULL, S, Xm_List_Widget_Class_Method_DELETE_ITEMS		WINTERP_PACKAGE_NAME}, /* 14 */
  {NULL, S, Xm_List_Widget_Class_Method_GET_MATCH_POS		WINTERP_PACKAGE_NAME},	/* 15 */
  {NULL, S, Xm_List_Widget_Class_Method_GET_SELECTED_POS	WINTERP_PACKAGE_NAME}, /* 16 */
  {NULL, S, Xm_List_Widget_Class_Method_ITEM_POS		WINTERP_PACKAGE_NAME}, /* 17 */
  {NULL, S, Xm_List_Widget_Class_Method_PARENT			WINTERP_PACKAGE_NAME}, /* 18 */
  {NULL, S, Xm_List_Widget_Class_Method_REPLACE_ITEMS_POS	WINTERP_PACKAGE_NAME}, /* 19 */
  {NULL, S, Xm_List_Widget_Class_Method_REPLACE_ITEMS		WINTERP_PACKAGE_NAME},	/* 20 */
  {NULL, S, Xm_List_Widget_Class_Method_SET_ADD_MODE		WINTERP_PACKAGE_NAME}, /* 21 */
  {NULL, S, Xm_Main_Window_Widget_Class_Method_SEP3		WINTERP_PACKAGE_NAME}, /* 22 */
  {NULL, S, Xm_Push_Button_Widget_Class_Method_ADD_CALLBACK	WINTERP_PACKAGE_NAME}, /* 23 */
  {NULL, S, Xm_Push_Button_Widget_Class_Method_SET_CALLBACK	WINTERP_PACKAGE_NAME}, /* 24 */
  {NULL, S, Xm_Row_Column_Widget_Class_Method_GET_POSTED_FROM_WIDGET WINTERP_PACKAGE_NAME}, /* 25 */
  {NULL, S, Xm_Row_Column_Widget_Class_Method_GET_SUB_MENU_WIDGET WINTERP_PACKAGE_NAME}, /* 26 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_CLEAR_SELECTION	WINTERP_PACKAGE_NAME},	/* 27 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_COPY		WINTERP_PACKAGE_NAME}, /* 28 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_CUT		WINTERP_PACKAGE_NAME}, /* 29 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_GET_ADD_MODE	WINTERP_PACKAGE_NAME}, /* 30 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_GET_BASELINE	WINTERP_PACKAGE_NAME}, /* 31 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_GET_CURSOR_POSITION WINTERP_PACKAGE_NAME}, /* 32 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_GET_EDITABLE	WINTERP_PACKAGE_NAME}, /* 33 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_GET_INSERTION_POSITION WINTERP_PACKAGE_NAME}, /* 34 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_GET_LAST_POSITION	WINTERP_PACKAGE_NAME}, /* 35 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_GET_MAX_LENGTH	WINTERP_PACKAGE_NAME}, /* 36 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_GET_SELECTION_POSITION WINTERP_PACKAGE_NAME}, /* 37 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_GET_SELECTION	WINTERP_PACKAGE_NAME}, /* 38 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_GET_STRING	WINTERP_PACKAGE_NAME}, /* 39 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_INSERT		WINTERP_PACKAGE_NAME}, /* 40 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_PASTE		WINTERP_PACKAGE_NAME}, /* 41 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_POS_TO_XY		WINTERP_PACKAGE_NAME}, /* 42 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_REMOVE		WINTERP_PACKAGE_NAME}, /* 43 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_REPLACE		WINTERP_PACKAGE_NAME},	/* 44 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_SET_ADD_MODE	WINTERP_PACKAGE_NAME}, /* 45 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_SET_CURSOR_POSITION WINTERP_PACKAGE_NAME}, /* 46 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_SET_EDITABLE	WINTERP_PACKAGE_NAME}, /* 47 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_SET_HIGHLIGHT	WINTERP_PACKAGE_NAME}, /* 48 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_SET_INSERTION_POSITION WINTERP_PACKAGE_NAME}, /* 49 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_SET_MAX_LENGTH	WINTERP_PACKAGE_NAME}, /* 50 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_SET_SELECTION	WINTERP_PACKAGE_NAME}, /* 51 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_SET_STRING	WINTERP_PACKAGE_NAME}, /* 52 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_SHOW_POSITION	WINTERP_PACKAGE_NAME}, /* 53 */
  {NULL, S, Xm_Text_Field_Widget_Class_Method_XY_TO_POS		WINTERP_PACKAGE_NAME}, /* 54 */
  {NULL, S, Xm_Text_Widget_Class_Method_COPY			WINTERP_PACKAGE_NAME}, /* 55 */
  {NULL, S, Xm_Text_Widget_Class_Method_CUT			WINTERP_PACKAGE_NAME}, /* 56 */
  {NULL, S, Xm_Text_Widget_Class_Method_GET_ADD_MODE		WINTERP_PACKAGE_NAME}, /* 57 */
  {NULL, S, Xm_Text_Widget_Class_Method_GET_BASELINE		WINTERP_PACKAGE_NAME}, /* 58 */
  {NULL, S, Xm_Text_Widget_Class_Method_GET_CURSOR_POSITION	WINTERP_PACKAGE_NAME}, /* 59 */
  {NULL, S, Xm_Text_Widget_Class_Method_INSERT			WINTERP_PACKAGE_NAME}, /* 60 */
  {NULL, S, Xm_Text_Widget_Class_Method_PARENT			WINTERP_PACKAGE_NAME}, /* 61 */
  {NULL, S, Xm_Text_Widget_Class_Method_PASTE			WINTERP_PACKAGE_NAME}, /* 62 */
  {NULL, S, Xm_Text_Widget_Class_Method_REMOVE			WINTERP_PACKAGE_NAME}, /* 63 */
  {NULL, S, Xm_Text_Widget_Class_Method_SET_ADD_MODE		WINTERP_PACKAGE_NAME}, /* 64 */
  {NULL, S, Xm_Text_Widget_Class_Method_SET_CURSOR_POSITION	WINTERP_PACKAGE_NAME}, /* 65 */
  {NULL, S, Xm_Text_Widget_Class_Method_SET_HIGHLIGHT		WINTERP_PACKAGE_NAME}, /* 66 */

#undef SIZE_OF_FUNTAB_SEGMENT_1
#define SIZE_OF_FUNTAB_SEGMENT_1 66
#endif				/* WINTERP_MOTIF_11 */
/****************** END: WINTERP METHODS (Motif >= 1.1) ***********************/  

/****************** BEGIN: WINTERP METHODS (Motif >= 1.2) *********************/
#ifdef WINTERP_MOTIF_12
  {NULL, S, Widget_Class_Method_CHANGE_COLOR			WINTERP_PACKAGE_NAME}, /* 1 */
  {NULL, S, Widget_Class_Method_GET_FOCUS_WIDGET		WINTERP_PACKAGE_NAME}, /* 2 */
  {NULL, S, Widget_Class_Method_GET_TAB_GROUP			WINTERP_PACKAGE_NAME}, /* 3 */
  {NULL, S, Widget_Class_Method_IS_TRAVERSABLE			WINTERP_PACKAGE_NAME}, /* 4 */
  {NULL, S, Widget_Class_Method_GET_VISIBILITY			WINTERP_PACKAGE_NAME}, /* 5 */
  {NULL, S, Xm_Scrolled_Window_Widget_Class_Method_SCROLL_VISIBLE WINTERP_PACKAGE_NAME}, /* 6 */
#undef SIZE_OF_FUNTAB_SEGMENT_2
#define SIZE_OF_FUNTAB_SEGMENT_2 6
#endif /* WINTERP_MOTIF_12 */
/****************** END: WINTERP METHODS (Motif >= 1.2) **********************/

/****************** BEGIN: WINTERP XmGraph METHODS (Motif >= 1.1) ***********/
#ifdef HP_GRAPH_WIDGET		/* if HP_GRAPH_WIDGET defined */
  {NULL, S, Xm_Arc_Widget_Class_Method_ISNEW			WINTERP_PACKAGE_NAME}, /* 1 */
  {NULL, S, Xm_Graph_Widget_Class_Method_ADD_CALLBACK		WINTERP_PACKAGE_NAME}, /* 2 */
  {NULL, S, Xm_Graph_Widget_Class_Method_CENTER_AROUND_WIDGET	WINTERP_PACKAGE_NAME}, /* 3 */
  {NULL, S, Xm_Graph_Widget_Class_Method_DESTROY_ALL_ARCS	WINTERP_PACKAGE_NAME}, /* 4 */
  {NULL, S, Xm_Graph_Widget_Class_Method_DESTROY_ALL_NODES	WINTERP_PACKAGE_NAME}, /* 5 */
  {NULL, S, Xm_Graph_Widget_Class_Method_DESTROY_SELECTED_ARCS_OR_NODES WINTERP_PACKAGE_NAME}, /* 6 */
  {NULL, S, Xm_Graph_Widget_Class_Method_GET_ARCS		WINTERP_PACKAGE_NAME}, /* 7 */
  {NULL, S, Xm_Graph_Widget_Class_Method_GET_ARCS_BETWEEN_NODES WINTERP_PACKAGE_NAME}, /* 8 */
  {NULL, S, Xm_Graph_Widget_Class_Method_GET_ARC_NODES		WINTERP_PACKAGE_NAME}, /* 9 */
  {NULL, S, Xm_Graph_Widget_Class_Method_GET_NODES		WINTERP_PACKAGE_NAME}, /* 10 */
  {NULL, S, Xm_Graph_Widget_Class_Method_GET_NODE_ARCS		WINTERP_PACKAGE_NAME}, /* 11 */
  {NULL, S, Xm_Graph_Widget_Class_Method_GET_ROOTS		WINTERP_PACKAGE_NAME}, /* 12 */
  {NULL, S, Xm_Graph_Widget_Class_Method_GET_SELECTED_ARCS	WINTERP_PACKAGE_NAME}, /* 13 */
  {NULL, S, Xm_Graph_Widget_Class_Method_GET_SELECTED_NODES	WINTERP_PACKAGE_NAME}, /* 14 */
  {NULL, S, Xm_Graph_Widget_Class_Method_INPUT_OVER_ARC		WINTERP_PACKAGE_NAME}, /* 15 */
  {NULL, S, Xm_Graph_Widget_Class_Method_INSERT_ROOTS		WINTERP_PACKAGE_NAME}, /* 16 */
  {NULL, S, Xm_Graph_Widget_Class_Method_ISNEW			WINTERP_PACKAGE_NAME}, /* 17 */
  {NULL, S, Xm_Graph_Widget_Class_Method_IS_POINT_IN_ARC	WINTERP_PACKAGE_NAME}, /* 18 */
  {NULL, S, Xm_Graph_Widget_Class_Method_IS_SELECTED_ARC	WINTERP_PACKAGE_NAME}, /* 19 */
  {NULL, S, Xm_Graph_Widget_Class_Method_IS_SELECTED_NODE	WINTERP_PACKAGE_NAME}, /* 20 */
  {NULL, S, Xm_Graph_Widget_Class_Method_LAYOUT			WINTERP_PACKAGE_NAME}, /* 21 */
  {NULL, S, Xm_Graph_Widget_Class_Method_MOVE_ALL		WINTERP_PACKAGE_NAME}, /* 22 */
  {NULL, S, Xm_Graph_Widget_Class_Method_MOVE_ARC		WINTERP_PACKAGE_NAME}, /* 23 */
  {NULL, S, Xm_Graph_Widget_Class_Method_MOVE_NODE		WINTERP_PACKAGE_NAME}, /* 24 */
  {NULL, S, Xm_Graph_Widget_Class_Method_NUM_ARCS		WINTERP_PACKAGE_NAME}, /* 25 */
  {NULL, S, Xm_Graph_Widget_Class_Method_NUM_NODES		WINTERP_PACKAGE_NAME}, /* 26 */
  {NULL, S, Xm_Graph_Widget_Class_Method_NUM_NODE_ARCS		WINTERP_PACKAGE_NAME}, /* 27 */
  {NULL, S, Xm_Graph_Widget_Class_Method_NUM_ROOTS		WINTERP_PACKAGE_NAME}, /* 28 */
  {NULL, S, Xm_Graph_Widget_Class_Method_NUM_SELECTED_ARCS	WINTERP_PACKAGE_NAME}, /* 29 */
  {NULL, S, Xm_Graph_Widget_Class_Method_NUM_SELECTED_NODES	WINTERP_PACKAGE_NAME}, /* 30 */
  {NULL, S, Xm_Graph_Widget_Class_Method_RELAY_SUBGRAPH		WINTERP_PACKAGE_NAME}, /* 31 */
  {NULL, S, Xm_Graph_Widget_Class_Method_REMOVE_ARC_BETWEEN_NODES WINTERP_PACKAGE_NAME}, /* 32 */
  {NULL, S, Xm_Graph_Widget_Class_Method_REMOVE_ROOTS		WINTERP_PACKAGE_NAME}, /* 33 */
  {NULL, S, Xm_Graph_Widget_Class_Method_SELECT_ARC		WINTERP_PACKAGE_NAME}, /* 34 */
  {NULL, S, Xm_Graph_Widget_Class_Method_SELECT_ARCS		WINTERP_PACKAGE_NAME}, /* 35 */
  {NULL, S, Xm_Graph_Widget_Class_Method_SELECT_NODE		WINTERP_PACKAGE_NAME}, /* 36 */
  {NULL, S, Xm_Graph_Widget_Class_Method_SELECT_NODES		WINTERP_PACKAGE_NAME}, /* 37 */
  {NULL, S, Xm_Graph_Widget_Class_Method_SET_CALLBACK		WINTERP_PACKAGE_NAME}, /* 38 */
  {NULL, S, Xm_Graph_Widget_Class_Method_UNSELECT_ARC		WINTERP_PACKAGE_NAME}, /* 39 */
  {NULL, S, Xm_Graph_Widget_Class_Method_UNSELECT_ARCS		WINTERP_PACKAGE_NAME}, /* 40 */
  {NULL, S, Xm_Graph_Widget_Class_Method_UNSELECT_NODE		WINTERP_PACKAGE_NAME}, /* 41 */
  {NULL, S, Xm_Graph_Widget_Class_Method_UNSELECT_NODES		WINTERP_PACKAGE_NAME}, /* 42 */
	                                                                          
#undef SIZE_OF_FUNTAB_SEGMENT_3
#define SIZE_OF_FUNTAB_SEGMENT_3 42
#endif				/* HP_GRAPH_WIDGET */
/****************** END: WINTERP XmGraph METHODS ****************************/

/****************** BEGIN: WINTERP Xtango METHODS ***************************/
#ifdef WINTERP_XTANGO_WIDGET
  {NULL, S, Tango_Bitmap_Image_Class_Method_ISNEW		TANGO_PACKAGE_NAME}, /* 1 */
  {NULL, S, Tango_Bitmap_Image_Class_Method_STOREON		TANGO_PACKAGE_NAME}, /* 2 */
  {NULL, S, Tango_Bitmap_Image_Class_Method_TX_SHUFFLE		TANGO_PACKAGE_NAME}, /* 3 */
  {NULL, S, Tango_Circle_Image_Class_Method_ISNEW		TANGO_PACKAGE_NAME}, /* 4 */
  {NULL, S, Tango_Circle_Image_Class_Method_STOREON		TANGO_PACKAGE_NAME}, /* 5 */
  {NULL, S, Tango_Composite_Image_Class_Method_ISNEW		TANGO_PACKAGE_NAME}, /* 6 */
  {NULL, S, Tango_Composite_Image_Class_Method_STOREON		TANGO_PACKAGE_NAME}, /* 7 */
  {NULL, S, Tango_Ellipse_Image_Class_Method_ISNEW		TANGO_PACKAGE_NAME}, /* 8 */
  {NULL, S, Tango_Ellipse_Image_Class_Method_STOREON		TANGO_PACKAGE_NAME}, /* 9 */
  {NULL, S, Tango_Image_Class_Method_EXISTS_P			TANGO_PACKAGE_NAME}, /* 10 */
  {NULL, S, Tango_Image_Class_Method_IMAGE_COPY			TANGO_PACKAGE_NAME}, /* 11 */
  {NULL, S, Tango_Image_Class_Method_ISNEW			TANGO_PACKAGE_NAME}, /* 12 */
  {NULL, S, Tango_Image_Class_Method_PRIN1			TANGO_PACKAGE_NAME}, /* 13 */
  {NULL, S, Tango_Image_Class_Method_TAP_COLOR			TANGO_PACKAGE_NAME}, /* 14 */
  {NULL, S, Tango_Image_Class_Method_TAP_FILL			TANGO_PACKAGE_NAME}, /* 15 */
  {NULL, S, Tango_Image_Class_Method_TAP_FLASH			TANGO_PACKAGE_NAME}, /* 16 */
  {NULL, S, Tango_Image_Class_Method_TAP_JUMP			TANGO_PACKAGE_NAME}, /* 17 */
  {NULL, S, Tango_Image_Class_Method_TAP_MOVE			TANGO_PACKAGE_NAME}, /* 18 */
  {NULL, S, Tango_Image_Class_Method_TAP_SHOW			TANGO_PACKAGE_NAME}, /* 19 */
  {NULL, S, Tango_Image_Class_Method_TAP_TRAVERSE		TANGO_PACKAGE_NAME}, /* 20 */
  {NULL, S, Tango_Image_Class_Method_TAP_VIS_TOGGLE		TANGO_PACKAGE_NAME}, /* 21 */
  {NULL, S, Tango_Image_Class_Method_TX_COLOR	       		TANGO_PACKAGE_NAME}, /* 22 */
  {NULL, S, Tango_Image_Class_Method_TX_DELAY			TANGO_PACKAGE_NAME}, /* 23 */
  {NULL, S, Tango_Image_Class_Method_TX_DELETE			TANGO_PACKAGE_NAME}, /* 24 */
  {NULL, S, Tango_Image_Class_Method_TX_FILL			TANGO_PACKAGE_NAME}, /* 25 */
  {NULL, S, Tango_Image_Class_Method_TX_LOWER			TANGO_PACKAGE_NAME}, /* 26 */
  {NULL, S, Tango_Image_Class_Method_TX_MOVE			TANGO_PACKAGE_NAME}, /* 27 */
  {NULL, S, Tango_Image_Class_Method_TX_RAISE			TANGO_PACKAGE_NAME}, /* 28 */
  {NULL, S, Tango_Image_Class_Method_TX_REFRESH			TANGO_PACKAGE_NAME}, /* 29 */
  {NULL, S, Tango_Image_Class_Method_TX_VISIBLE			TANGO_PACKAGE_NAME}, /* 30 */
  {NULL, S, Tango_Image_Class_Method_TX_ZOOM			TANGO_PACKAGE_NAME}, /* 31 */
  {NULL, S, Tango_Line_Image_Class_Method_ISNEW			TANGO_PACKAGE_NAME}, /* 32 */
  {NULL, S, Tango_Line_Image_Class_Method_STOREON		TANGO_PACKAGE_NAME}, /* 33 */
  {NULL, S, Tango_Non_Poly_Image_Class_Method_IMAGE_LOC		TANGO_PACKAGE_NAME}, /* 34 */
  {NULL, S, Tango_Non_Poly_Image_Class_Method_TX_RESIZE		TANGO_PACKAGE_NAME}, /* 35 */
  {NULL, S, Tango_Poly_Image_Class_Method_TX_GRAB1		TANGO_PACKAGE_NAME}, /* 36 */
  {NULL, S, Tango_Poly_Image_Class_Method_TX_GRAB2		TANGO_PACKAGE_NAME}, /* 37 */
  {NULL, S, Tango_Poly_Image_Class_Method_TX_GRAB3		TANGO_PACKAGE_NAME}, /* 38 */
  {NULL, S, Tango_Poly_Image_Class_Method_TX_GRAB4		TANGO_PACKAGE_NAME}, /* 39 */
  {NULL, S, Tango_Poly_Image_Class_Method_TX_GRAB5		TANGO_PACKAGE_NAME}, /* 40 */
  {NULL, S, Tango_Poly_Image_Class_Method_TX_GRAB6		TANGO_PACKAGE_NAME}, /* 41 */
  {NULL, S, Tango_Poly_Image_Class_Method_TX_GRAB7		TANGO_PACKAGE_NAME}, /* 42 */
  {NULL, S, Tango_Poly_Image_Class_Method_TX_RESIZE1		TANGO_PACKAGE_NAME}, /* 43 */
  {NULL, S, Tango_Poly_Image_Class_Method_TX_RESIZE2		TANGO_PACKAGE_NAME}, /* 44 */
  {NULL, S, Tango_Poly_Image_Class_Method_TX_RESIZE3		TANGO_PACKAGE_NAME}, /* 45 */
  {NULL, S, Tango_Poly_Image_Class_Method_TX_RESIZE4		TANGO_PACKAGE_NAME}, /* 46 */
  {NULL, S, Tango_Poly_Image_Class_Method_TX_RESIZE5		TANGO_PACKAGE_NAME}, /* 47 */
  {NULL, S, Tango_Poly_Image_Class_Method_TX_RESIZE6		TANGO_PACKAGE_NAME}, /* 48 */
  {NULL, S, Tango_Poly_Image_Class_Method_TX_RESIZE7		TANGO_PACKAGE_NAME}, /* 49 */
  {NULL, S, Tango_Polygon_Image_Class_Method_IMAGE_LOC		TANGO_PACKAGE_NAME}, /* 50 */
  {NULL, S, Tango_Polygon_Image_Class_Method_ISNEW		TANGO_PACKAGE_NAME}, /* 51 */
  {NULL, S, Tango_Polygon_Image_Class_Method_STOREON		TANGO_PACKAGE_NAME}, /* 52 */
  {NULL, S, Tango_Polyline_Image_Class_Method_IMAGE_LOC		TANGO_PACKAGE_NAME}, /* 53 */
  {NULL, S, Tango_Polyline_Image_Class_Method_ISNEW		TANGO_PACKAGE_NAME}, /* 54 */
  {NULL, S, Tango_Polyline_Image_Class_Method_STOREON		TANGO_PACKAGE_NAME}, /* 55 */
  {NULL, S, Tango_Rectangle_Image_Class_Method_ISNEW		TANGO_PACKAGE_NAME}, /* 56 */
  {NULL, S, Tango_Rectangle_Image_Class_Method_STOREON		TANGO_PACKAGE_NAME}, /* 57 */
  {NULL, S, Tango_Spline_Image_Class_Method_IMAGE_LOC		TANGO_PACKAGE_NAME}, /* 58 */
  {NULL, S, Tango_Spline_Image_Class_Method_ISNEW		TANGO_PACKAGE_NAME}, /* 59 */
  {NULL, S, Tango_Spline_Image_Class_Method_STOREON		TANGO_PACKAGE_NAME}, /* 60 */
  {NULL, S, Tango_Text_Image_Class_Method_ISNEW			TANGO_PACKAGE_NAME}, /* 61 */
  {NULL, S, Tango_Text_Image_Class_Method_STOREON		TANGO_PACKAGE_NAME}, /* 62 */
  {NULL, S, Xtango_Widget_Class_Method_ADD_CALLBACK		TANGO_PACKAGE_NAME}, /* 63 */
  {NULL, S, Xtango_Widget_Class_Method_BEGIN_DRAWING		TANGO_PACKAGE_NAME}, /* 64 */
  {NULL, S, Xtango_Widget_Class_Method_COLORS_STOREON		TANGO_PACKAGE_NAME}, /* 65 */
  {NULL, S, Xtango_Widget_Class_Method_COPY_TO_2D_BITMAP_ARRAY TANGO_PACKAGE_NAME}, /* 66 */
  {NULL, S, Xtango_Widget_Class_Method_GET_EVENT_COORD		TANGO_PACKAGE_NAME}, /* 67 */
  {NULL, S, Xtango_Widget_Class_Method_GET_EVENT_IMAGE		TANGO_PACKAGE_NAME}, /* 68 */
  {NULL, S, Xtango_Widget_Class_Method_GET_IMAGES		TANGO_PACKAGE_NAME}, /* 69 */
  {NULL, S, Xtango_Widget_Class_Method_INPUT_COORD		TANGO_PACKAGE_NAME}, /* 70 */
  {NULL, S, Xtango_Widget_Class_Method_INPUT_IMAGE		TANGO_PACKAGE_NAME}, /* 71 */
  {NULL, S, Xtango_Widget_Class_Method_INQ_COORD		TANGO_PACKAGE_NAME}, /* 72 */
  {NULL, S, Xtango_Widget_Class_Method_ISNEW			TANGO_PACKAGE_NAME}, /* 73 */
  {NULL, S, Xtango_Widget_Class_Method_LOAD_COLOR		TANGO_PACKAGE_NAME}, /* 74 */
  {NULL, S, Xtango_Widget_Class_Method_MONO_PATTERN_REPRESENTATION TANGO_PACKAGE_NAME}, /* 75 */
  {NULL, S, Xtango_Widget_Class_Method_PAN			TANGO_PACKAGE_NAME}, /* 76 */
  {NULL, S, Xtango_Widget_Class_Method_REFRESH			TANGO_PACKAGE_NAME}, /* 77 */
  {NULL, S, Xtango_Widget_Class_Method_SET_ANIMATION_EVENT_PROCESSING TANGO_PACKAGE_NAME}, /* 78 */
  {NULL, S, Xtango_Widget_Class_Method_SET_BGCOLOR		TANGO_PACKAGE_NAME}, /* 79 */
  {NULL, S, Xtango_Widget_Class_Method_SET_CALLBACK		TANGO_PACKAGE_NAME}, /* 80 */
  {NULL, S, Xtango_Widget_Class_Method_SET_COORD		TANGO_PACKAGE_NAME}, /* 81 */
  {NULL, S, Xtango_Widget_Class_Method_SET_DEBUG		TANGO_PACKAGE_NAME}, /* 82 */
  {NULL, S, Xtango_Widget_Class_Method_SET_DELAY		TANGO_PACKAGE_NAME}, /* 83 */
  {NULL, S, Xtango_Widget_Class_Method_ZOOM			TANGO_PACKAGE_NAME}, /* 84 */
  {NULL, S, Tango_GIF_Image_Class_Method_ISNEW			TANGO_PACKAGE_NAME}, /* 85 */
  {NULL, S, Tango_Image_Class_Method_SHOW			TANGO_PACKAGE_NAME}, /* 86 */
  {NULL, S, Xtango_Widget_Class_Method_RESIZE_CANVAS		TANGO_PACKAGE_NAME}, /* 87 */

#undef SIZE_OF_FUNTAB_SEGMENT_4
#define SIZE_OF_FUNTAB_SEGMENT_4 87
#endif /* WINTERP_XTANGO_WIDGET */
/****************** END: WINTERP Xtango METHODS *****************************/

/****************** BEGIN: WINTERP SgDropPocketWidget METHODS **********/
#ifdef SGI_DROP_POCKET_WIDGET	/* only for Irix 5.1 and IndigoMagic desktop */
  {NULL, S, Sg_Drop_Pocket_Widget_Class_Method_ADD_CALLBACK	WINTERP_PACKAGE_NAME}, /* 1 */
  {NULL, S, Sg_Drop_Pocket_Widget_Class_Method_SET_CALLBACK	WINTERP_PACKAGE_NAME}, /* 2 */
  {NULL, S, Sg_Finder_Widget_Class_Method_ADD_HISTORY_ITEM	WINTERP_PACKAGE_NAME}, /* 3 */
  {NULL, S, Sg_Finder_Widget_Class_Method_CLEAR_HISTORY		WINTERP_PACKAGE_NAME}, /* 4 */
  {NULL, S, Sg_Finder_Widget_Class_Method_SET_STRING		WINTERP_PACKAGE_NAME}, /* 5 */
  {NULL, S, Sg_Finder_Widget_Class_Method_GET_STRING		WINTERP_PACKAGE_NAME}, /* 6 */
  {NULL, S, Sg_Finder_Widget_Class_Method_GET_CHILD		WINTERP_PACKAGE_NAME}, /* 7 */

#undef SIZE_OF_FUNTAB_SEGMENT_5
#define SIZE_OF_FUNTAB_SEGMENT_5 7
#endif /* SGI_DROP_POCKET_WIDGET */
/****************** END: WINTERP SgDropPocketWidget METHODS ************/

  /*
   * To add new conditionally-compilable methods to WINTERP, create
   * "segments" similar to the conditional compilation portions above,
   * (e.g. #ifdef WINTERP_XTANGO_WIDGET ... #endif). Update the
   * appropriate SIZE_OF_FUNTAB_SEGMENT_i with the count of the number
   * of new methods added within the "segment".
   *
   * INDEX_OF_LAST_FUNTAB_ENTRY_USED_BY_libWinterp is a constant needed by
   * Wfu_Funtab_Sanity_Check() -- note how cpp symbol SIZE_OF_FUNTAB_SEGMENT_i
   * gets modified by conditional compilation of features such as
   * -DWINTERP_XTANGO_WIDGET, -DHP_GRAPH_WIDGET, etc
   */
#define INDEX_OF_LAST_FUNTAB_ENTRY_USED_BY_libWinterp SIZE_OF_FUNTAB_SEGMENT_0 + SIZE_OF_FUNTAB_SEGMENT_1 + SIZE_OF_FUNTAB_SEGMENT_2 + SIZE_OF_FUNTAB_SEGMENT_3 + SIZE_OF_FUNTAB_SEGMENT_4 + SIZE_OF_FUNTAB_SEGMENT_5 + SIZE_OF_FUNTAB_SEGMENT_6 + SIZE_OF_FUNTAB_SEGMENT_7 + SIZE_OF_FUNTAB_SEGMENT_8 + SIZE_OF_FUNTAB_SEGMENT_9
 
  /*
   * To embed additional C-implemented primitives in WINTERP, you must
   * place new function table entries in file app_fundecl.h.
   * The indexes of entries in this file must correspond
   * to the indexes computed by CPP in app_funidx.h.
   * See comments preceding funtab[] declaration above for more
   * info on file app_fundecl.h, app_funextn.h, and app_funidx.h.
   *
   * If you want to place your app_fundecl.h file outside of 
   * the WINTERP source tree, just modify INCLUDES in the Makefile
   * such that the directory containing app_fundecl.h precedes '-I.'
   */
#include <app_fundecl.h>

/* Past this point, don't track INDEX_OF_LAST_FUNTAB_ENTRY_USED_BY_libWinterp
   and don't bother updating w_funtab.h with corresponding entries unless you
   are adding methods... */

  /****************** BEGIN: WINTERP FUNCTIONS (Motif >= 1.0)  **************/
  {"FFLUSH",			S, Prim_FFLUSH				WINTERP_PACKAGE_NAME},
  {"FSCANF-FIXNUM",		S, Prim_FSCANF_FIXNUM			WINTERP_PACKAGE_NAME},
  {"FSCANF-FLONUM",		S, Prim_FSCANF_FLONUM			WINTERP_PACKAGE_NAME},
  {"FSCANF-STRING",		S, Prim_FSCANF_STRING			WINTERP_PACKAGE_NAME},
  {"GET_EVENT_COORDS",		S, Wut_Prim_GET_EVENT_COORDS		WINTERP_PACKAGE_NAME},
  {"GET_MOUSED_WIDGET",		S, Wut_Prim_GET_MOUSED_WIDGET		WINTERP_PACKAGE_NAME},	
  {"GET_MOUSE_LOCATION",        S, Wut_Prim_GET_MOUSE_LOCATION		WINTERP_PACKAGE_NAME},
  {"INPUT_ACTIVE_P",		S, Wicb_Prim_INPUT_ACTIVE_P		WINTERP_PACKAGE_NAME},
  {"PCLOSE",			S, Prim_PCLOSE				WINTERP_PACKAGE_NAME},
  {"POPEN",			S, Prim_POPEN				WINTERP_PACKAGE_NAME},
  {"PROVIDE",			S, Prim_PROVIDE				XLISP_PACKAGE_NAME},
  {"READ_EVAL_PRINT",		S, Prim_READ_EVAL_PRINT			WINTERP_PACKAGE_NAME},
  {"REDIRECT_STDERR",		S, Prim_REDIRECT_STDERR			WINTERP_PACKAGE_NAME},
  {"REDIRECT_STDOUT",		S, Prim_REDIRECT_STDOUT			WINTERP_PACKAGE_NAME},
  {"XT_REMOVE_EVENT_HANDLER",	S, Weh_Prim_XT_REMOVE_EVENT_HANDLER WINTERP_PACKAGE_NAME},
  {"REQUIRE",			S, Prim_REQUIRE				XLISP_PACKAGE_NAME},
  {"SYSTEM",			S, Prim_SYSTEM				WINTERP_PACKAGE_NAME},
  {"TIMEOUT_ACTIVE_P",          S, Wto_Prim_TIMEOUT_ACTIVE_P		WINTERP_PACKAGE_NAME},
  {"WIDGETOBJP",		S, Wcls_Prim_WIDGETOBJP			WINTERP_PACKAGE_NAME},
  {"WINTERP_SHOW_BUSY",		S, Wshl_Prim_WINTERP_SHOW_BUSY		WINTERP_PACKAGE_NAME},
  {"XM_GET_PIXMAP",		S, Wpm_Prim_XM_GET_PIXMAP		WINTERP_PACKAGE_NAME},
  {"XM_GET_XIMAGE_FROM_FILE",	S, Wpm_Prim_XM_GET_IMAGE_FROM_FILE	WINTERP_PACKAGE_NAME},
  {"XM_INSTALL_IMAGE",		S, Wpm_Prim_XM_INSTALL_IMAGE		WINTERP_PACKAGE_NAME},
  {"XM_SET_MENU_CURSOR",        S, Wxm_Prim_XM_SET_MENU_CURSOR		WINTERP_PACKAGE_NAME},
  {"XM_STRING_BYTE_COMPARE",	S, Wxms_Prim_XM_STRING_BYTE_COMPARE	WINTERP_PACKAGE_NAME},
  {"XM_STRING_COMPARE",		S, Wxms_Prim_XM_STRING_COMPARE		WINTERP_PACKAGE_NAME},
  {"XM_STRING_CONCAT",		S, Wxms_Prim_XM_STRING_CONCAT		WINTERP_PACKAGE_NAME},	
  {"XM_STRING_COPY",		S, Wxms_Prim_XM_STRING_COPY		WINTERP_PACKAGE_NAME},
  {"XM_STRING_CREATE",		S, Wxms_Prim_XM_STRING_CREATE		WINTERP_PACKAGE_NAME},	
#ifdef WINTERP_MOTIF_20		/* In 2.0, XM_STRING_CREATE becomes same as XM_STRING_CREATE_L_TO_R */
  {"XM_STRING_CREATE_L_TO_R",	S, Wxms_Prim_XM_STRING_CREATE		WINTERP_PACKAGE_NAME},
  {"XM_STRING_GENERATE",	S, Wxms_Prim_XM_STRING_GENERATE		WINTERP_PACKAGE_NAME},
  {"XM_STRING_PUT_RENDITION",	S, Wxms_Prim_XM_STRING_PUT_RENDITION	WINTERP_PACKAGE_NAME},
  {"XM_TAB_CREATE",		S, Wxms_Prim_XM_TAB_CREATE		WINTERP_PACKAGE_NAME},
  {"XM_TAB_LIST_INSERT_TABS",	S, Wxms_Prim_XM_TAB_LIST_INSERT_TABS	WINTERP_PACKAGE_NAME},
  {"XM_RENDER_TABLE_ADD_RENDITIONS", S, Wxms_Prim_XM_RENDER_TABLE_ADD_RENDITIONS WINTERP_PACKAGE_NAME},
  {"XM_RENDITION_CREATE",	S, Wxms_Prim_XM_RENDITION_CREATE	WINTERP_PACKAGE_NAME},
#else
  {"XM_STRING_CREATE_L_TO_R",	S, Wxms_Prim_XM_STRING_CREATE_L_TO_R	WINTERP_PACKAGE_NAME},
#endif /* WINTERP_MOTIF_20 */
  {"XM_STRING_DIRECTION_CREATE",S, Wxms_Prim_XM_STRING_DIRECTION_CREATE	WINTERP_PACKAGE_NAME},
  {"XM_STRING_EMPTY",		S, Wxms_Prim_XM_STRING_EMPTY		WINTERP_PACKAGE_NAME},
  {"XM_STRING_GET_L_TO_R",	S, Wxms_Prim_XM_STRING_GET_L_TO_R	WINTERP_PACKAGE_NAME},
  {"XM_STRING_LENGTH",		S, Wxms_Prim_XM_STRING_LENGTH		WINTERP_PACKAGE_NAME},	
  {"XM_STRING_LINE_COUNT",	S, Wxms_Prim_XM_STRING_LINE_COUNT	WINTERP_PACKAGE_NAME},
  {"XM_STRING_SEGMENT_CREATE",	S, Wxms_Prim_XM_STRING_SEGMENT_CREATE	WINTERP_PACKAGE_NAME},	
  {"XM_STRING_SEPARATOR_CREATE",S, Wxms_Prim_XM_STRING_SEPARATOR_CREATE	WINTERP_PACKAGE_NAME},
  {"XM_UNINSTALL_IMAGE",	S, Wpm_Prim_XM_UNINSTALL_IMAGE		WINTERP_PACKAGE_NAME},
  {"XT_ADD_INPUT",		S, Wicb_Prim_XT_ADD_INPUT		WINTERP_PACKAGE_NAME},
  {"XT_ADD_TIMEOUT",		S, Wto_Prim_XT_ADD_TIMEOUT		WINTERP_PACKAGE_NAME},
  {"XT_MANAGE_CHILDREN",	S, Wxt_Prim_XT_MANAGE_CHILDREN		WINTERP_PACKAGE_NAME},
  {"XT_PARSE_ACCELERATOR_TABLE", S, Wtx_Prim_XT_PARSE_ACCELERATOR_TABLE	WINTERP_PACKAGE_NAME},
  {"XT_PARSE_TRANSLATION_TABLE", S, Wtx_Prim_XT_PARSE_TRANSLATION_TABLE	WINTERP_PACKAGE_NAME},
  {"XT_REMOVE_CALLBACK",	S, Wcb_Prim_XT_REMOVE_CALLBACK		WINTERP_PACKAGE_NAME},
  {"XT_REMOVE_INPUT",		S, Wicb_Prim_XT_REMOVE_INPUT		WINTERP_PACKAGE_NAME},
  {"XT_REMOVE_TIMEOUT",		S, Wto_Prim_XT_REMOVE_TIMEOUT		WINTERP_PACKAGE_NAME},
  {"XT_UNMANAGE_CHILDREN",	S, Wxt_Prim_XT_UNMANAGE_CHILDREN	WINTERP_PACKAGE_NAME},
  {"X_ALLOC_COLOR",		S, Wut_Prim_X_ALLOC_COLOR		WINTERP_PACKAGE_NAME},
  {"X_ALLOC_N_COLOR_CELLS_NO_PLANES", S, Wut_Prim_X_ALLOC_N_COLOR_CELLS_NO_PLANES WINTERP_PACKAGE_NAME},
  {"X_STORE_COLOR",		S, Wut_Prim_X_STORE_COLOR		WINTERP_PACKAGE_NAME},
  {"X_BELL",			S, Wut_Prim_X_BELL			WINTERP_PACKAGE_NAME},

  /****************** END: WINTERP FUNCTIONS (Motif >= 1.0)  ****************/

  /****************** BEGIN: WINTERP FUNCTIONS (Motif >= 1.1) ***************/
#ifdef WINTERP_MOTIF_11
  {"XM_CONVERT_UNITS",		S, Wxm_Prim_XM_CONVERT_UNITS		WINTERP_PACKAGE_NAME},
  {"XM_CVT_CT_TO_XM_STRING",	S, Wxms_Prim_XM_CVT_CT_TO_XM_STRING	WINTERP_PACKAGE_NAME},
  {"XM_CVT_XM_STRING_TO_CT",	S, Wxms_Prim_XM_CVT_XM_STRING_TO_CT	WINTERP_PACKAGE_NAME},
  {"XM_GET_COLORS",		S, Wxm_Prim_XM_GET_COLORS		WINTERP_PACKAGE_NAME},
  {"XM_SET_FONT_UNITS",		S, Wxm_Prim_XM_SET_FONT_UNITS		WINTERP_PACKAGE_NAME},	
  {"XM_STRING_HAS_SUBSTRING",	S, Wxms_Prim_XM_STRING_HAS_SUBSTRING	WINTERP_PACKAGE_NAME},
  {"XM_TRACKING_LOCATE",	S, Wxm_Prim_XM_TRACKING_LOCATE		WINTERP_PACKAGE_NAME},
  {"XT_RESOLVE_PATHNAME",	S, Wxt_Prim_XT_RESOLVE_PATHNAME		WINTERP_PACKAGE_NAME},
#endif /* WINTERP_MOTIF_11 */
  /****************** END: WINTERP FUNCTIONS (Motif >= 1.1) ******************/    
  
  /****************** BEGIN: WINTERP FUNCTIONS (Motif >= 1.2) ***************/
#ifdef WINTERP_MOTIF_12
  {"XM_GET_DESTINATION",	S, Wxm_Prim_XM_GET_DESTINATION	WINTERP_PACKAGE_NAME},
#endif /* WINTERP_MOTIF_12 */
  /****************** END: WINTERP FUNCTIONS (Motif >= 1.2) ******************/    

  /****************** BEGIN: WINTERP Table FUNCTIONS *************************/    
#ifdef WINTERP_TABLE_WIDGET
  {"XT_TBL_CONFIG",		S, Prim_XT_TBL_CONFIG			WINTERP_PACKAGE_NAME},
  {"XT_TBL_OPTIONS",		S, Prim_XT_TBL_OPTIONS			WINTERP_PACKAGE_NAME},
  {"XT_TBL_POSITION",		S, Prim_XT_TBL_POSITION			WINTERP_PACKAGE_NAME},
  {"XT_TBL_RESIZE",		S, Prim_XT_TBL_RESIZE			WINTERP_PACKAGE_NAME},
#endif /* WINTERP_TABLE_WIDGET */
  /****************** END: WINTERP Table FUNCTIONS ***************************/    

  /****************** BEGIN: WINTERP Expect FUNCTIONS ************************/    
#ifdef WINTERP_EXPECT_SUBPROCESS
  {"EXP_GET_PID",		S, Prim_EXP_GET_PID			WINTERP_PACKAGE_NAME},
  {"EXP_POPEN",			S, Prim_EXP_POPEN			WINTERP_PACKAGE_NAME},
  {"EXP_SPAWN",			S, Prim_EXP_SPAWN			WINTERP_PACKAGE_NAME},
  {"EXP_STTY_INIT",		S, Prim_EXP_STTY_INIT			WINTERP_PACKAGE_NAME},
  {"EXP_WAIT",			S, Prim_EXP_WAIT			WINTERP_PACKAGE_NAME},
  {"EXP_KILL",			S, Prim_EXP_KILL			WINTERP_PACKAGE_NAME},
#endif /* WINTERP_EXPECT_SUBPROCESS */
  /****************** END: WINTERP Expect FUNCTIONS ***************************/    

  /****************** BEGIN: WINTERP Xtango FUNCTIONS *************************/    
#ifdef WINTERP_XTANGO_WIDGET
  {"IMAGEOBJP",		S, Tcls_Prim_TANGOIMAGEOBJP			TANGO_PACKAGE_NAME},
  {"PATH_ADD_HEAD",	S, Xtango_Prim_TANGO_PATH_ADD_HEAD		TANGO_PACKAGE_NAME},
  {"PATH_ADD_TAIL",	S, Xtango_Prim_TANGO_PATH_ADD_TAIL		TANGO_PACKAGE_NAME},
  {"PATH_COLOR",	S, Xtango_Prim_TANGO_PATH_COLOR			TANGO_PACKAGE_NAME},
  {"PATH_COMPOSE",	S, Xtango_Prim_TANGO_PATH_COMPOSE		TANGO_PACKAGE_NAME},
  {"PATH_CONCATENATE",	S, Xtango_Prim_TANGO_PATH_CONCATENATE		TANGO_PACKAGE_NAME},
  {"PATH_COPY",		S, Xtango_Prim_TANGO_PATH_COPY			TANGO_PACKAGE_NAME},
  {"PATH_CREATE",	S, Xtango_Prim_TANGO_PATH_CREATE		TANGO_PACKAGE_NAME},
  {"PATH_DELETE_HEAD",	S, Xtango_Prim_TANGO_PATH_DELETE_HEAD		TANGO_PACKAGE_NAME},
  {"PATH_DELETE_TAIL",	S, Xtango_Prim_TANGO_PATH_DELETE_TAIL		TANGO_PACKAGE_NAME},
  {"PATH_DISTANCE",	S, Xtango_Prim_TANGO_PATH_DISTANCE		TANGO_PACKAGE_NAME},
  {"PATH_DX",		S, Xtango_Prim_TANGO_PATH_DX			TANGO_PACKAGE_NAME},
  {"PATH_DY",		S, Xtango_Prim_TANGO_PATH_DY			TANGO_PACKAGE_NAME},
  {"PATH_EXAMPLE",	S, Xtango_Prim_TANGO_PATH_EXAMPLE		TANGO_PACKAGE_NAME},
  {"PATH_EXTEND",	S, Xtango_Prim_TANGO_PATH_EXTEND		TANGO_PACKAGE_NAME},
  {"PATH_FREE",		S, Xtango_Prim_TANGO_PATH_FREE			TANGO_PACKAGE_NAME},
  {"PATH_INTERPOLATE",	S, Xtango_Prim_TANGO_PATH_INTERPOLATE		TANGO_PACKAGE_NAME},
  {"PATH_ITERATE",	S, Xtango_Prim_TANGO_PATH_ITERATE		TANGO_PACKAGE_NAME},
  {"PATH_LENGTH",	S, Xtango_Prim_TANGO_PATH_LENGTH		TANGO_PACKAGE_NAME},
  {"PATH_MOTION",	S, Xtango_Prim_TANGO_PATH_MOTION		TANGO_PACKAGE_NAME},
  {"PATH_REVERSE",	S, Xtango_Prim_TANGO_PATH_REVERSE		TANGO_PACKAGE_NAME},
  {"PATH_ROTATE",	S, Xtango_Prim_TANGO_PATH_ROTATE		TANGO_PACKAGE_NAME},
  {"PATH_SCALE",	S, Xtango_Prim_TANGO_PATH_SCALE			TANGO_PACKAGE_NAME},
  {"PATH_SMOOTH",	S, Xtango_Prim_TANGO_PATH_SMOOTH		TANGO_PACKAGE_NAME},
  {"PATH_TYPE",		S, Xtango_Prim_TANGO_PATH_TYPE			TANGO_PACKAGE_NAME},
  {"TAP_EXCHANGE",	S, Xtango_Prim_TANGO_TAP_EXCHANGE		TANGO_PACKAGE_NAME},
  {"TAP_SWITCH",	S, Xtango_Prim_TANGO_TAP_SWITCH			TANGO_PACKAGE_NAME},
  {"TX_COMPOSE",	S, Xtango_Prim_TANGO_TX_COMPOSE			TANGO_PACKAGE_NAME},
  {"TX_CONCATENATE",	S, Xtango_Prim_TANGO_TX_CONCATENATE		TANGO_PACKAGE_NAME},
  {"TX_FREE",		S, Xtango_Prim_TANGO_TX_FREE			TANGO_PACKAGE_NAME},
  {"TX_ITERATE",	S, Xtango_Prim_TANGO_TX_ITERATE			TANGO_PACKAGE_NAME},
  {"TX_PERFORM",	S, Xtango_Prim_TANGO_TX_PERFORM			TANGO_PACKAGE_NAME},

  {"GIF_TO_PIXMAP",	S, Wpm_Prim_GIF_TO_PIXMAP			WINTERP_PACKAGE_NAME},

#endif /* WINTERP_XTANGO_WIDGET */
  /****************** END: WINTERP Xtango FUNCTIONS ***************************/    

/******************************************************************************/
/************************ END: WINTERP PRIMITIVES *****************************/
/******************************************************************************/

/******************************************************************************/
/************** BEGIN: entries [20-end] copied from xlftab.c:funtab[] *********/
/******************************************************************************/

    /* evaluator functions */
{   "EVAL",                     SM, xeval       	XLISP_PACKAGE_NAME},
{   "APPLY",                    SM, xapply      	XLISP_PACKAGE_NAME},
{   "FUNCALL",                  SM, xfuncall    	XLISP_PACKAGE_NAME},
{   "QUOTE",                    F, xquote       	XLISP_PACKAGE_NAME},
{   "IDENTITY",                 S, xquote       	XLISP_PACKAGE_NAME},/*IDENTITY is same as QUOTE*/
{   "FUNCTION",                 F, xfunction    	XLISP_PACKAGE_NAME},
{   "COMPLEMENT",               F, xcomplement  	XLISP_PACKAGE_NAME},
{   "BACKQUOTE",                F, xbquote      	XLISP_PACKAGE_NAME},
{   "LAMBDA",                   F, xlambda      	XLISP_PACKAGE_NAME},

    /* symbol functions */
{   "SET",                      S, xset         	XLISP_PACKAGE_NAME},
{   "SETQ",                     F, xsetq        	XLISP_PACKAGE_NAME},
{   "SETF",                     F, xsetf        	XLISP_PACKAGE_NAME},
{   "DEFUN",                    F, xdefun       	XLISP_PACKAGE_NAME},
{   "DEFMACRO",                 F, xdefmacro    	XLISP_PACKAGE_NAME},
{   "GENSYM",                   S, xgensym      	XLISP_PACKAGE_NAME},
{   "MAKE-SYMBOL",              S, xmakesymbol  	XLISP_PACKAGE_NAME},
{   "INTERN",                   SM, xintern     	XLISP_PACKAGE_NAME},
{   "SYMBOL-NAME",              S, xsymname     	XLISP_PACKAGE_NAME},
{   "SYMBOL-VALUE",             S, xsymvalue    	XLISP_PACKAGE_NAME},
{   "SYMBOL-PLIST",             S, xsymplist    	XLISP_PACKAGE_NAME},
{   "GET",                      S, xget         	XLISP_PACKAGE_NAME},
{   "GETF",                     S, xgetf        	XLISP_PACKAGE_NAME},
{   "PUTPROP",                  S, xputprop     	XLISP_PACKAGE_NAME},
{   "REMPROP",                  S, xremprop     	XLISP_PACKAGE_NAME},
{   "HASH",                     S, xhash        	XLISP_PACKAGE_NAME},

    /* array functions */
{   "MAKE-ARRAY",               S, xmkarray     	XLISP_PACKAGE_NAME},
{   "AREF",                     S, xaref        	XLISP_PACKAGE_NAME},
            
    /* list functions */
{   "CAR",                      S, xcar         	XLISP_PACKAGE_NAME},
{   "CDR",                      S, xcdr         	XLISP_PACKAGE_NAME},
            
{   "CAAR",                     S, xcaar        	XLISP_PACKAGE_NAME},
{   "CADR",                     S, xcadr        	XLISP_PACKAGE_NAME},
{   "CDAR",                     S, xcdar        	XLISP_PACKAGE_NAME},
{   "CDDR",                     S, xcddr        	XLISP_PACKAGE_NAME},

{   "CAAAR",                    S, xcaaar       	XLISP_PACKAGE_NAME},
{   "CAADR",                    S, xcaadr       	XLISP_PACKAGE_NAME},
{   "CADAR",                    S, xcadar       	XLISP_PACKAGE_NAME},
{   "CADDR",                    S, xcaddr       	XLISP_PACKAGE_NAME},
{   "CDAAR",                    S, xcdaar       	XLISP_PACKAGE_NAME},
{   "CDADR",                    S, xcdadr       	XLISP_PACKAGE_NAME},
{   "CDDAR",                    S, xcddar       	XLISP_PACKAGE_NAME},
{   "CDDDR",                    S, xcdddr       	XLISP_PACKAGE_NAME},

{   "CAAAAR",                   S, xcaaaar      	XLISP_PACKAGE_NAME},
{   "CAAADR",                   S, xcaaadr      	XLISP_PACKAGE_NAME},
{   "CAADAR",                   S, xcaadar      	XLISP_PACKAGE_NAME},
{   "CAADDR",                   S, xcaaddr      	XLISP_PACKAGE_NAME},
{   "CADAAR",                   S, xcadaar      	XLISP_PACKAGE_NAME},
{   "CADADR",                   S, xcadadr      	XLISP_PACKAGE_NAME},
{   "CADDAR",                   S, xcaddar      	XLISP_PACKAGE_NAME},
{   "CADDDR",                   S, xcadddr      	XLISP_PACKAGE_NAME},
{   "CDAAAR",                   S, xcdaaar      	XLISP_PACKAGE_NAME},
{   "CDAADR",                   S, xcdaadr      	XLISP_PACKAGE_NAME},
{   "CDADAR",                   S, xcdadar      	XLISP_PACKAGE_NAME},
{   "CDADDR",                   S, xcdaddr      	XLISP_PACKAGE_NAME},
{   "CDDAAR",                   S, xcddaar      	XLISP_PACKAGE_NAME},
{   "CDDADR",                   S, xcddadr      	XLISP_PACKAGE_NAME},
{   "CDDDAR",                   S, xcdddar      	XLISP_PACKAGE_NAME},
{   "CDDDDR",                   S, xcddddr      	XLISP_PACKAGE_NAME},

{   "CONS",                     S, xcons        	XLISP_PACKAGE_NAME},
{   "LIST",                     S, xlist        	XLISP_PACKAGE_NAME},
{   "LIST*",                    S, xliststar    	XLISP_PACKAGE_NAME},
{   "APPEND",                   S, xappend      	XLISP_PACKAGE_NAME},
{   "REVERSE",                  S, xreverse     	XLISP_PACKAGE_NAME},
{   "LAST",                     S, xlast        	XLISP_PACKAGE_NAME},
{   "NTH",                      S, xnth         	XLISP_PACKAGE_NAME},
{   "NTHCDR",                   S, xnthcdr      	XLISP_PACKAGE_NAME},
{   "MEMBER",                   S, xmember      	XLISP_PACKAGE_NAME},
{   "ASSOC",                    S, xassoc       	XLISP_PACKAGE_NAME},
{   "SUBST",                    S, xsubst       	XLISP_PACKAGE_NAME},
{   "SUBLIS",                   S, xsublis      	XLISP_PACKAGE_NAME},
{   "NSUBST",                   S, xnsubst      	XLISP_PACKAGE_NAME},
{   "NSUBST-IF",                S, xnsubstif    	XLISP_PACKAGE_NAME},
{   "NSUBST-IF-NOT",            S, xnsubstifnot 	XLISP_PACKAGE_NAME},
{   "NSUBLIS",                  S, xnsublis     	XLISP_PACKAGE_NAME},
{   "REMOVE",                   S, xremove      	XLISP_PACKAGE_NAME},
{   "LENGTH",                   S, xlength      	XLISP_PACKAGE_NAME},
{   "LIST-LENGTH",              S, xlistlength  	XLISP_PACKAGE_NAME},
{   "MAPC",                     S, xmapc        	XLISP_PACKAGE_NAME},
{   "MAPCAR",                   S, xmapcar      	XLISP_PACKAGE_NAME},
{   "MAPL",                     S, xmapl        	XLISP_PACKAGE_NAME},
{   "MAPLIST",                  S, xmaplist     	XLISP_PACKAGE_NAME},
{   "MAPCAN",                   S, xmapcan      	XLISP_PACKAGE_NAME},
{   "MAPCON",                   S, xmapcon      	XLISP_PACKAGE_NAME},

            
    /* destructive list functions */
{   "RPLACA",                   S, xrplca       	XLISP_PACKAGE_NAME},
{   "RPLACD",                   S, xrplcd       	XLISP_PACKAGE_NAME},
{   "NCONC",                    S, xnconc       	XLISP_PACKAGE_NAME},
{   "DELETE",                   S, xdelete      	XLISP_PACKAGE_NAME},

    /* predicate functions */
{   "ATOM",                     S, xatom        	XLISP_PACKAGE_NAME},
{   "SYMBOLP",                  S, xsymbolp     	XLISP_PACKAGE_NAME},
{   "NUMBERP",                  S, xnumberp     	XLISP_PACKAGE_NAME},
{   "BOUNDP",                   S, xboundp      	XLISP_PACKAGE_NAME},
{   "NULL",                     S, xnull        	XLISP_PACKAGE_NAME},
{   "LISTP",                    S, xlistp       	XLISP_PACKAGE_NAME},
{   "CONSP",                    S, xconsp       	XLISP_PACKAGE_NAME},
{   "MINUSP",                   S, xminusp      	XLISP_PACKAGE_NAME},
{   "ZEROP",                    S, xzerop       	XLISP_PACKAGE_NAME},
{   "PLUSP",                    S, xplusp       	XLISP_PACKAGE_NAME},
{   "EVENP",                    S, xevenp       	XLISP_PACKAGE_NAME},
{   "ODDP",                     S, xoddp        	XLISP_PACKAGE_NAME},
{   "EQ",                       S, xeq          	XLISP_PACKAGE_NAME},
{   "EQL",                      S, xeql         	XLISP_PACKAGE_NAME},
{   "EQUAL",                    S, xequal       	XLISP_PACKAGE_NAME},

    /* special forms */
{   "COND",                     FM, xcond       	XLISP_PACKAGE_NAME},
{   "CASE",                     FM, xcase       	XLISP_PACKAGE_NAME},
{   "AND",                      FM, xand        	XLISP_PACKAGE_NAME},
{   "OR",                       FM, xor         	XLISP_PACKAGE_NAME},
{   "LET",                      FM, xlet        	XLISP_PACKAGE_NAME},
{   "LET*",                     FM, xletstar    	XLISP_PACKAGE_NAME},
{   "IF",                       FM, xif         	XLISP_PACKAGE_NAME},
{   "PROG",                     FM, xprog       	XLISP_PACKAGE_NAME},
{   "PROG*",                    FM, xprogstar   	XLISP_PACKAGE_NAME},
{   "PROG1",                    F, xprog1       	XLISP_PACKAGE_NAME},
{   "PROG2",                    F, xprog2       	XLISP_PACKAGE_NAME},
{   "PROGN",                    FM, xprogn      	XLISP_PACKAGE_NAME},
{   "GO",                       F, xgo          	XLISP_PACKAGE_NAME},
{   "RETURN",                   F, xreturn      	XLISP_PACKAGE_NAME},
{   "DO",                       FM, xdo         	XLISP_PACKAGE_NAME},
{   "DO*",                      FM, xdostar     	XLISP_PACKAGE_NAME},
{   "DOLIST",                   FM, xdolist     	XLISP_PACKAGE_NAME},
{   "DOTIMES",                  FM, xdotimes    	XLISP_PACKAGE_NAME},
{   "CATCH",                    FM, xcatch      	XLISP_PACKAGE_NAME},
{   "THROW",                    F, xthrow       	XLISP_PACKAGE_NAME},
    
    /* debugging and error handling functions */
{   "ERROR",                    S, xerror       	XLISP_PACKAGE_NAME},
{   "CERROR",                   S, xcerror      	XLISP_PACKAGE_NAME},
{   "BREAK",                    S, xbreak       	XLISP_PACKAGE_NAME},
{   "CLEAN-UP",                 S, xcleanup     	XLISP_PACKAGE_NAME},
{   "TOP-LEVEL",                S, xtoplevel    	XLISP_PACKAGE_NAME},
{   "CONTINUE",                 S, xcontinue    	XLISP_PACKAGE_NAME},
{   "ERRSET",                   F, xerrset      	XLISP_PACKAGE_NAME},
{   "BAKTRACE",                 S, xbaktrace    	XLISP_PACKAGE_NAME},
{   "EVALHOOK",                 SM, xevalhook   	XLISP_PACKAGE_NAME},

    /* arithmetic functions */
{   "TRUNCATE",                 SM, xfix        	XLISP_PACKAGE_NAME},
{   "FLOAT",                    S, xfloat       	XLISP_PACKAGE_NAME},
{   "+",                        S, xadd         	XLISP_PACKAGE_NAME},
{   "-",                        S, xsub         	XLISP_PACKAGE_NAME},
{   "*",                        S, xmul         	XLISP_PACKAGE_NAME},
{   "/",                        S, xdiv         	XLISP_PACKAGE_NAME},
{   "1+",                       S, xadd1        	XLISP_PACKAGE_NAME},
{   "1-",                       S, xsub1        	XLISP_PACKAGE_NAME},
{   "REM",                      S, xrem         	XLISP_PACKAGE_NAME},
{   "MIN",                      S, xmin         	XLISP_PACKAGE_NAME},
{   "MAX",                      S, xmax         	XLISP_PACKAGE_NAME},
{   "ABS",                      S, xabs         	XLISP_PACKAGE_NAME},
{   "SIN",                      S, xsin         	XLISP_PACKAGE_NAME},
{   "COS",                      S, xcos         	XLISP_PACKAGE_NAME},
{   "TAN",                      S, xtan         	XLISP_PACKAGE_NAME},
{   "EXPT",                     S, xexpt        	XLISP_PACKAGE_NAME},
{   "EXP",                      S, xexp         	XLISP_PACKAGE_NAME},
{   "SQRT",                     S, xsqrt        	XLISP_PACKAGE_NAME},
{   "RANDOM",                   S, xrand        	XLISP_PACKAGE_NAME},
            
    /* bitwise logical functions */
{   "LOGAND",                   S, xlogand      	XLISP_PACKAGE_NAME},
{   "LOGIOR",                   S, xlogior      	XLISP_PACKAGE_NAME},
{   "LOGXOR",                   S, xlogxor      	XLISP_PACKAGE_NAME},
{   "LOGNOT",                   S, xlognot      	XLISP_PACKAGE_NAME},
#ifdef COMPLX
{   "ASH",                      S, xash         	XLISP_PACKAGE_NAME},
#endif

    /* numeric comparison functions */
{   "<",                        S, xlss         	XLISP_PACKAGE_NAME},
{   "<=",                       S, xleq         	XLISP_PACKAGE_NAME},
{   "=",                        S, xequ         	XLISP_PACKAGE_NAME},
{   "/=",                       S, xneq         	XLISP_PACKAGE_NAME},
{   ">=",                       S, xgeq         	XLISP_PACKAGE_NAME},
{   ">",                        S, xgtr         	XLISP_PACKAGE_NAME},
            
    /* string functions */

{   "CONCATENATE",              S, xconcatenate 	XLISP_PACKAGE_NAME},
{   "SUBSEQ",                   S, xsubseq      	XLISP_PACKAGE_NAME},
{   "STRING",                   S, xstring      	XLISP_PACKAGE_NAME},
{   "CHAR",                     S, xchar        	XLISP_PACKAGE_NAME},

    /* I/O functions */
{   "READ",                     S, xread        	XLISP_PACKAGE_NAME},
{   "PRINT",                    S, xprint       	XLISP_PACKAGE_NAME},
{   "PRIN1",                    S, xprin1       	XLISP_PACKAGE_NAME},
{   "PRINC",                    S, xprinc       	XLISP_PACKAGE_NAME},
{   "TERPRI",                   S, xterpri      	XLISP_PACKAGE_NAME},
{   "FLATSIZE",                 S, xflatsize    	XLISP_PACKAGE_NAME},
{   "FLATC",                    S, xflatc       	XLISP_PACKAGE_NAME},
            
    /* file I/O functions */
{   "OPEN",                     S, xopen        	XLISP_PACKAGE_NAME},
{   "FORMAT",                   S, xformat      	XLISP_PACKAGE_NAME},
{   "CLOSE",                    S, xclose       	XLISP_PACKAGE_NAME},
{   "READ-CHAR",                S, xrdchar      	XLISP_PACKAGE_NAME},
{   "PEEK-CHAR",                S, xpkchar      	XLISP_PACKAGE_NAME},
{   "WRITE-CHAR",               S, xwrchar      	XLISP_PACKAGE_NAME},
{   "READ-LINE",                S, xreadline    	XLISP_PACKAGE_NAME},

    /* system functions */
{   "LOAD",                     S, xload        	XLISP_PACKAGE_NAME},
{   "DRIBBLE",                  S, xtranscript  	XLISP_PACKAGE_NAME},

/* functions specific to xldmem.c */
{   "GC",                       S, xgc          	XLISP_PACKAGE_NAME},
{   "EXPAND",                   S, xexpand      	XLISP_PACKAGE_NAME},
{   "ALLOC",                    S, xalloc       	XLISP_PACKAGE_NAME},
{   "ROOM",                     S, xmem         	XLISP_PACKAGE_NAME},
#ifdef SAVERESTORE
{   "SAVE",                     S, xsave        	XLISP_PACKAGE_NAME},
{   "RESTORE",                  S, xrestore     	XLISP_PACKAGE_NAME},
#endif
/* end of functions specific to xldmem.c */

{   "TYPE-OF",                  S, xtype        	XLISP_PACKAGE_NAME},
{   "EXIT",                     S, xexit        	XLISP_PACKAGE_NAME},
{   "PEEK",                     S, xpeek        	XLISP_PACKAGE_NAME},
{   "POKE",                     S, xpoke        	XLISP_PACKAGE_NAME},
{   "ADDRESS-OF",               S, xaddrs       	XLISP_PACKAGE_NAME},

    /* new functions and special forms */
{   "VECTOR",                   S, xvector      	XLISP_PACKAGE_NAME},
{   "BLOCK",                    FM, xblock      	XLISP_PACKAGE_NAME},
{   "RETURN-FROM",              F, xrtnfrom     	XLISP_PACKAGE_NAME},
{   "TAGBODY",                  F, xtagbody     	XLISP_PACKAGE_NAME},
{   "PSETQ",                    F, xpsetq       	XLISP_PACKAGE_NAME},
{   "PSETF",                    F, xpsetf       	XLISP_PACKAGE_NAME},
{   "FLET",                     FM, xflet       	XLISP_PACKAGE_NAME},
{   "LABELS",                   FM, xlabels     	XLISP_PACKAGE_NAME},
{   "MACROLET",                 FM, xmacrolet   	XLISP_PACKAGE_NAME},
{   "UNWIND-PROTECT",           FM, xunwindprotect	XLISP_PACKAGE_NAME},
{   "PPRINT",                   SM, xpp         	XLISP_PACKAGE_NAME},
{   "STRING<",                  S, xstrlss      	XLISP_PACKAGE_NAME},
{   "STRING<=",                 S, xstrleq      	XLISP_PACKAGE_NAME},
{   "STRING=",                  S, xstreql      	XLISP_PACKAGE_NAME},
{   "STRING/=",                 S, xstrneq      	XLISP_PACKAGE_NAME},
{   "STRING>=",                 S, xstrgeq      	XLISP_PACKAGE_NAME},
{   "STRING>",                  S, xstrgtr      	XLISP_PACKAGE_NAME},
{   "STRING-LESSP",             S, xstrilss     	XLISP_PACKAGE_NAME},
{   "STRING-NOT-GREATERP",      S, xstrileq     	XLISP_PACKAGE_NAME},
{   "STRING-EQUAL",             S, xstrieql     	XLISP_PACKAGE_NAME},
{   "STRING-NOT-EQUAL",         S, xstrineq     	XLISP_PACKAGE_NAME},
{   "STRING-NOT-LESSP",         S, xstrigeq     	XLISP_PACKAGE_NAME},
{   "STRING-GREATERP",          S, xstrigtr     	XLISP_PACKAGE_NAME},
{   "INTEGERP",                 S, xintegerp    	XLISP_PACKAGE_NAME},
{   "FLOATP",                   S, xfloatp      	XLISP_PACKAGE_NAME},
{   "STRINGP",                  S, xstringp     	XLISP_PACKAGE_NAME},
{   "ARRAYP",                   S, xarrayp      	XLISP_PACKAGE_NAME},
{   "STREAMP",                  S, xstreamp     	XLISP_PACKAGE_NAME},
{   "OBJECTP",                  S, xobjectp     	XLISP_PACKAGE_NAME},
{   "STRING-UPCASE",            S, xupcase      	XLISP_PACKAGE_NAME},
{   "STRING-DOWNCASE",          S, xdowncase    	XLISP_PACKAGE_NAME},
{   "STRING-CAPITALIZE",        S, xcapcase     	XLISP_PACKAGE_NAME},
{   "NSTRING-UPCASE",           S, xnupcase     	XLISP_PACKAGE_NAME},
{   "NSTRING-DOWNCASE",         S, xndowncase   	XLISP_PACKAGE_NAME},
{   "NSTRING-CAPITALIZE",       S, xncapcase    	XLISP_PACKAGE_NAME},
{   "STRING-TRIM",              S, xtrim        	XLISP_PACKAGE_NAME},
{   "STRING-LEFT-TRIM",         S, xlefttrim    	XLISP_PACKAGE_NAME},
{   "STRING-RIGHT-TRIM",        S, xrighttrim   	XLISP_PACKAGE_NAME},
{   "WHEN",                     FM, xwhen       	XLISP_PACKAGE_NAME},
{   "UNLESS",                   FM, xunless     	XLISP_PACKAGE_NAME},
{   "LOOP",                     FM, xloop       	XLISP_PACKAGE_NAME},
{   "SYMBOL-FUNCTION",          S, xsymfunction 	XLISP_PACKAGE_NAME},
{   "FBOUNDP",                  S, xfboundp     	XLISP_PACKAGE_NAME},
{   "SEND",                     SM, xsend       	XLISP_PACKAGE_NAME},
{   "SEND-SUPER",               SM, xsendsuper  	XLISP_PACKAGE_NAME},
{   "PROGV",                    FM, xprogv      	XLISP_PACKAGE_NAME},
{   "CHARACTERP",               S, xcharp       	XLISP_PACKAGE_NAME},
{   "CHAR-INT",                 S, xcharint     	XLISP_PACKAGE_NAME},
{   "INT-CHAR",                 S, xintchar     	XLISP_PACKAGE_NAME},
{   "READ-BYTE",                S, xrdbyte      	XLISP_PACKAGE_NAME},
{   "WRITE-BYTE",               S, xwrbyte      	XLISP_PACKAGE_NAME},
{   "MAKE-STRING-INPUT-STREAM", S, xmkstrinput  	XLISP_PACKAGE_NAME},
{   "MAKE-STRING-OUTPUT-STREAM",S, xmkstroutput 	XLISP_PACKAGE_NAME},
{   "GET-OUTPUT-STREAM-STRING", S, xgetstroutput	XLISP_PACKAGE_NAME},
{   "GET-OUTPUT-STREAM-LIST",   S, xgetlstoutput	XLISP_PACKAGE_NAME},
{   "GCD",                      S, xgcd         	XLISP_PACKAGE_NAME},
{   "GET-LAMBDA-EXPRESSION",    S, xgetlambda   	XLISP_PACKAGE_NAME},
{   "MACROEXPAND",              SM, xmacroexpand	XLISP_PACKAGE_NAME},
{   "MACROEXPAND-1",            SM,x1macroexpand	XLISP_PACKAGE_NAME},
{   "CHAR<",                    S, xchrlss      	XLISP_PACKAGE_NAME},
{   "CHAR<=",                   S, xchrleq      	XLISP_PACKAGE_NAME},
{   "CHAR=",                    S, xchreql      	XLISP_PACKAGE_NAME},
{   "CHAR/=",                   S, xchrneq      	XLISP_PACKAGE_NAME},
{   "CHAR>=",                   S, xchrgeq      	XLISP_PACKAGE_NAME},
{   "CHAR>",                    S, xchrgtr      	XLISP_PACKAGE_NAME},
{   "CHAR-LESSP",               S, xchrilss     	XLISP_PACKAGE_NAME},
{   "CHAR-NOT-GREATERP",        S, xchrileq     	XLISP_PACKAGE_NAME},
{   "CHAR-EQUAL",               S, xchrieql     	XLISP_PACKAGE_NAME},
{   "CHAR-NOT-EQUAL",           S, xchrineq     	XLISP_PACKAGE_NAME},
{   "CHAR-NOT-LESSP",           S, xchrigeq     	XLISP_PACKAGE_NAME},
{   "CHAR-GREATERP",            S, xchrigtr     	XLISP_PACKAGE_NAME},
{   "UPPER-CASE-P",             S, xuppercasep  	XLISP_PACKAGE_NAME},
{   "LOWER-CASE-P",             S, xlowercasep  	XLISP_PACKAGE_NAME},
{   "BOTH-CASE-P",              S, xbothcasep   	XLISP_PACKAGE_NAME},
{   "DIGIT-CHAR-P",             S, xdigitp      	XLISP_PACKAGE_NAME},
{   "ALPHANUMERICP",            S, xalphanumericp	XLISP_PACKAGE_NAME},
{   "ALPHA-CHAR-P",             S, xalphacharp  	XLISP_PACKAGE_NAME},
{   "CHAR-UPCASE",              S, xchupcase    	XLISP_PACKAGE_NAME},
{   "CHAR-DOWNCASE",            S, xchdowncase  	XLISP_PACKAGE_NAME},
{   "DIGIT-CHAR",               S, xdigitchar   	XLISP_PACKAGE_NAME},
{   "CHAR-CODE",                S, xcharcode    	XLISP_PACKAGE_NAME},
{   "CODE-CHAR",                S, xcodechar    	XLISP_PACKAGE_NAME},
{   "ENDP",                     S, xendp        	XLISP_PACKAGE_NAME},
{   "REMOVE-IF",                S, xremif       	XLISP_PACKAGE_NAME},
{   "REMOVE-IF-NOT",            S, xremifnot    	XLISP_PACKAGE_NAME},
{   "DELETE-IF",                S, xdelif       	XLISP_PACKAGE_NAME},
{   "DELETE-IF-NOT",            S, xdelifnot    	XLISP_PACKAGE_NAME},
{   "TRACE",                    F, xtrace       	XLISP_PACKAGE_NAME},
{   "UNTRACE",                  F, xuntrace     	XLISP_PACKAGE_NAME},
{   "SORT",                     S, xsort        	XLISP_PACKAGE_NAME},
#ifdef ADDEDTAA
{   "GENERIC",                  S, xgeneric     	XLISP_PACKAGE_NAME},
#endif
#ifdef TIMES
{   "TIME",                     FM, xtime       	XLISP_PACKAGE_NAME},
{   "GET-INTERNAL-RUN-TIME",    S, xruntime     	XLISP_PACKAGE_NAME},
{   "GET-INTERNAL-REAL-TIME",   S, xrealtime    	XLISP_PACKAGE_NAME},
#endif
/* extra table entries */
#ifdef POSFCNS
{   "COUNT",                    S, xcount       	XLISP_PACKAGE_NAME},
{   "FIND",                     S, xfind        	XLISP_PACKAGE_NAME},
{   "POSITION",                 S, xposition    	XLISP_PACKAGE_NAME},
{   "COUNT-IF",                 S, xcountif     	XLISP_PACKAGE_NAME},
{   "FIND-IF",                  S, xfindif      	XLISP_PACKAGE_NAME},
{   "POSITION-IF",              S, xpositionif  	XLISP_PACKAGE_NAME},
{   "COUNT-IF-NOT",             S, xcountifnot  	XLISP_PACKAGE_NAME},
{   "FIND-IF-NOT",              S, xfindifnot   	XLISP_PACKAGE_NAME},
{   "POSITION-IF-NOT",          S, xpositionifnot	XLISP_PACKAGE_NAME},
#endif
{   "COERCE",                   S, xcoerce      	XLISP_PACKAGE_NAME},
{   "ELT",                      S, xelt         	XLISP_PACKAGE_NAME},
#ifdef SRCHFCN
{   "SEARCH",                   S, xsearch      	XLISP_PACKAGE_NAME},
#endif
#ifdef MAPFCNS
{   "MAP",                      S, xmap         	XLISP_PACKAGE_NAME},
{   "MAP-INTO",                 S, xmapinto     	XLISP_PACKAGE_NAME},
{   "SOME",                     S, xsome        	XLISP_PACKAGE_NAME},
{   "EVERY",                    S, xevery       	XLISP_PACKAGE_NAME},
{   "NOTANY",                   S, xnotany      	XLISP_PACKAGE_NAME},
{   "NOTEVERY",                 S, xnotevery    	XLISP_PACKAGE_NAME},
#endif
{   "FILE-POSITION",            S, xfileposition	XLISP_PACKAGE_NAME},
{   "FILE-LENGTH",              S, xfilelength  	XLISP_PACKAGE_NAME},
{   "FRESH-LINE",               S, xfreshline   	XLISP_PACKAGE_NAME},
{   "OPEN-STREAM-P",            S, xopenstreamp 	XLISP_PACKAGE_NAME},
{   "INPUT-STREAM-P",           S, xinputstreamp	XLISP_PACKAGE_NAME},
{   "OUTPUT-STREAM-P",          S, xoutputstreamp	XLISP_PACKAGE_NAME},
#ifdef FILETABLE
{   "TRUENAME",                 S, xtruename    	XLISP_PACKAGE_NAME},
{   "DELETE-FILE",              S, xdeletefile  	XLISP_PACKAGE_NAME},
#endif
{   "DEFSTRUCT",                F, xdefstruct   	XLISP_PACKAGE_NAME},
{   "%STRUCT-TYPE-P",           S, xstrtypep    	XLISP_PACKAGE_NAME},
{   "%MAKE-STRUCT",             S, xmkstruct    	XLISP_PACKAGE_NAME},
{   "%COPY-STRUCT",             S, xcpystruct   	XLISP_PACKAGE_NAME},
{   "%STRUCT-REF",              S, xstrref      	XLISP_PACKAGE_NAME},
{   "%STRUCT-SET",              S, xstrset      	XLISP_PACKAGE_NAME},
{   "ASIN",                     S, xasin        	XLISP_PACKAGE_NAME},
{   "ACOS",                     S, xacos        	XLISP_PACKAGE_NAME},
{   "ATAN",                     S, xatan        	XLISP_PACKAGE_NAME},
#ifdef APPLYHOOK
{   "APPLYHOOK",                SM, xapplyhook  	XLISP_PACKAGE_NAME},
#endif
{   "NREVERSE",                 S, xnreverse    	XLISP_PACKAGE_NAME},
{   "BUTLAST",                  S, xbutlast     	XLISP_PACKAGE_NAME},
{   "TYPEP",                    S, xtypep       	XLISP_PACKAGE_NAME},
#ifdef REDUCE
{   "REDUCE",                   S, xreduce      	XLISP_PACKAGE_NAME},
#endif
#ifdef REMDUPS
{   "REMOVE-DUPLICATES",        S, xremove_duplicates 	XLISP_PACKAGE_NAME},
#endif

#ifdef SETS
{   "ADJOIN",                   S, xadjoin          	XLISP_PACKAGE_NAME},
{   "UNION",                    S, xunion           	XLISP_PACKAGE_NAME},
{   "INTERSECTION",             S, xintersection    	XLISP_PACKAGE_NAME},
{   "SET-DIFFERENCE",           S, xset_difference  	XLISP_PACKAGE_NAME},
{   "SUBSETP",                  S, xsubsetp         	XLISP_PACKAGE_NAME},
#endif

#ifdef HASHFCNS
{   "GETHASH",                  SM, xgethash        	XLISP_PACKAGE_NAME},
{   "REMHASH",                  S, xremhash         	XLISP_PACKAGE_NAME},
{   "MAKE-HASH-TABLE",          S, xmakehash        	XLISP_PACKAGE_NAME},
{   "CLRHASH",                  S, xclrhash         	XLISP_PACKAGE_NAME},
{   "MAPHASH",                  S, xmaphash         	XLISP_PACKAGE_NAME},
{   "HASH-TABLE-COUNT",         S, xhashcount       	XLISP_PACKAGE_NAME},
#endif

#ifdef COMPLX
{   "COMPLEXP",                 S, xcomplexp        	XLISP_PACKAGE_NAME},
{   "COMPLEX",                  S, xcomplex         	XLISP_PACKAGE_NAME},
{   "CONJUGATE",                S, xconjugate       	XLISP_PACKAGE_NAME},
{   "REALPART",                 S, xrealpart        	XLISP_PACKAGE_NAME},
{   "IMAGPART",                 S, ximagpart        	XLISP_PACKAGE_NAME},
{   "LOG",                      S, xlog             	XLISP_PACKAGE_NAME},
{   "FLOOR",                    SM, xfloor          	XLISP_PACKAGE_NAME},
{   "CEILING",                  SM, xceil           	XLISP_PACKAGE_NAME},
{   "ROUND",                    SM, xround          	XLISP_PACKAGE_NAME},
{   "PHASE",                    S, xphase           	XLISP_PACKAGE_NAME},
{   "LCM",                      S, xlcm             	XLISP_PACKAGE_NAME},
{   "MOD",                      S, xmod             	XLISP_PACKAGE_NAME},
#endif

#ifdef RATIOS
{   "RATIONALP",                S, xrationalp       	XLISP_PACKAGE_NAME},
{   "NUMERATOR",                S, xnumerator       	XLISP_PACKAGE_NAME},
{   "DENOMINATOR",              S, xdenominator     	XLISP_PACKAGE_NAME},
{   "RATIONAL",                 S, xrational        	XLISP_PACKAGE_NAME},
#endif

{   "DEFCONSTANT",              F, xdefconstant     	XLISP_PACKAGE_NAME},
{   "CONSTANTP",                S, xconstantp       	XLISP_PACKAGE_NAME},
{   "DEFPARAMETER",             F, xdefparameter    	XLISP_PACKAGE_NAME},
{   "DEFVAR",                   F, xdefvar          	XLISP_PACKAGE_NAME},
{   "MAKUNBOUND",               S, xmakunbound      	XLISP_PACKAGE_NAME},
{   "FMAKUNBOUND",              S, xfmakunbound     	XLISP_PACKAGE_NAME},
{   "SPECIALP",                 S, xspecialp        	XLISP_PACKAGE_NAME},
{   "MARK-AS-SPECIAL",          S, xmarkspecial     	XLISP_PACKAGE_NAME},
/*
{   "TOP-LEVEL-LOOP",           S, xtoplevelloop    	XLISP_PACKAGE_NAME},
{   "RESET-SYSTEM",             S, xresetsystem     	XLISP_PACKAGE_NAME},
*/
#ifdef RANDOM
{   "MAKE-RANDOM-STATE",        S, xmakerandom      	XLISP_PACKAGE_NAME},
#endif
#ifdef STSZ
{   "SET-STACK-MARK",           S, xsetmark         	XLISP_PACKAGE_NAME},
#endif

#ifdef PACKAGES
{   "MAKE-PACKAGE",             S, xmakepackage     	XLISP_PACKAGE_NAME},
{   "IN-PACKAGE",               F, xinpackage       	XLISP_PACKAGE_NAME},
{   "EXPORT",                   S, xexport          	XLISP_PACKAGE_NAME},
{   "UNEXPORT",                 S, xunexport        	XLISP_PACKAGE_NAME},
{   "IMPORT",                   S, ximport          	XLISP_PACKAGE_NAME},
{   "SYMBOL-PACKAGE",           S, xsympackage      	XLISP_PACKAGE_NAME},
{   "USE-PACKAGE",              S, xusepackage      	XLISP_PACKAGE_NAME},
{   "UNUSE-PACKAGE",            S, xunusepackage    	XLISP_PACKAGE_NAME},
{   "PACKAGE-USE-LIST",         S, xpackageuselist  	XLISP_PACKAGE_NAME},
{   "PACKAGE-USED-BY-LIST",     S, xpackageusedbylist	XLISP_PACKAGE_NAME},
{   "PACKAGE-SHADOWING-SYMBOLS", S, xpackageshadows 	XLISP_PACKAGE_NAME},
{   "PACKAGE-NAME",             S, xpackagename     	XLISP_PACKAGE_NAME},
{   "PACKAGE-NICKNAMES",        S, xpackagenicknames	XLISP_PACKAGE_NAME},
{   "PACKAGE-OBARRAY",          S, xpackageobarray  	XLISP_PACKAGE_NAME},
{   "PACKAGE-VALID-P",          S, xpackagevalidp   	XLISP_PACKAGE_NAME},
{   "LIST-ALL-PACKAGES",        S, xlistallpackages 	XLISP_PACKAGE_NAME},
{   "UNINTERN",                 S, xunintern        	XLISP_PACKAGE_NAME},
{   "SHADOW",                   S, xshadow          	XLISP_PACKAGE_NAME},
{   "SHADOWING-IMPORT",         S, xshadowingimport 	XLISP_PACKAGE_NAME},
{   "FIND-PACKAGE",             S, xfindpackage     	XLISP_PACKAGE_NAME},
{   "FIND-SYMBOL",              SM, xfindsymbol     	XLISP_PACKAGE_NAME},
{   "DELETE-PACKAGE",           S, xdeletepackage   	XLISP_PACKAGE_NAME},
{   "RENAME-PACKAGE",           S, xrenamepackage   	XLISP_PACKAGE_NAME},
{   "FIND-ALL-SYMBOLS",         S, xfindallsymbols  	XLISP_PACKAGE_NAME},
#endif
#ifdef MULVALS
{   "VALUES",                   SM, xvalues         	XLISP_PACKAGE_NAME},
{   "MULTIPLE-VALUE-CALL",      FM, xmulvalcall     	XLISP_PACKAGE_NAME},
{   "MULTIPLE-VALUE-PROG1",     FM, xmulvalprog1       	XLISP_PACKAGE_NAME},
{   "NTH-VALUE",                F, xnthvalue        	XLISP_PACKAGE_NAME},
#endif

/* added by Niels Mayer to file xlbfun.c */
{   "COPY-ARRAY",	S, Prim_COPY_ARRAY		WINTERP_PACKAGE_NAME}, /* NPM  */
{   "ARRAY-INSERT-POS",	S, Prim_ARRAY_INSERT_POS	WINTERP_PACKAGE_NAME}, /* NPM */
{   "ARRAY-DELETE-POS",	S, Prim_ARRAY_DELETE_POS	WINTERP_PACKAGE_NAME}, /* NPM */

/******************************************************************************/
/************** END: entries [20-end] copied from xlftab.c:funtab[] ***********/
/******************************************************************************/

  {0,0,0}			/* end of table marker */

};

int ftabsize = sizeof(funtab); /* TAA MOD -- added validity check */

/*******************************************************************************
 * A sanity check called from main() which ensures that the number of indexes to
 * function table entries (in w_funtab.h) corresnpond to the actual number of
 * entries in funtab[] in this file.
 *
 * LAST_FUNTAB_POINTER_USED_BY_libWinterp is declared in w_funtab.h, and
 * INDEX_OF_LAST_FUNTAB_ENTRY_USED_BY_libWinterp is declared above.
 *******************************************************************************/
void Wfu_Funtab_Sanity_Check()
{
  extern char* app_name;	/* winterp.c */

  if ((LAST_FUNTAB_POINTER_USED_BY_libWinterp) != (INDEX_OF_LAST_FUNTAB_ENTRY_USED_BY_libWinterp)) {
    (void) fprintf(stderr,"%s: Fatal error: w_funtab.c out of sync with w_funtab.h\n\tLAST_FUNTAB_POINTER_USED_BY_libWinterp=%d\n\tINDEX_OF_LAST_FUNTAB_ENTRY_USED_BY_libWinterp=%d\n\t -- correct errors in those files and recompile!\n",
		   app_name,
		   LAST_FUNTAB_POINTER_USED_BY_libWinterp,
		   INDEX_OF_LAST_FUNTAB_ENTRY_USED_BY_libWinterp);
    exit(1);
  }
}
