                                        /*-------------------------------
                                         |    anim1.c                   |
                                         -------------------------------*/
/* Animations are normally better done using GC and Colormap manipulation */ 
#include <Xm/Form.h>
#include <Xm/DrawingA.h>
#include <Xm/PushB.h>
#include <Xm/Scale.h>
#include <X11/xpm.h>

#define START 0
#define STOP 1

typedef struct{
	Pixmap pix, mask;
	int width;
	int height;
	GC gc;
	}Picture;

Picture frame[3];
Pixmap draw_pixmap;
Widget draw;
Boolean stop = True;
int timeout = 200;

static char *filenames[] ={
 "animation/logo.xpm",
 "animation/text.xpm",
 "animation/text2.xpm"
  };           

void update_animation(frames, id)
 Picture  frames[];
 XtIntervalId *id;
{
	static Boolean do_key = True;
	static int x = 0  , y = 40, increment = 5;
	int start = 0;

 	if(!XtIsRealized(draw))return;
   		start = frame[0].width;

   	x = start - increment; 
   	XCopyArea(XtDisplay(draw), frames[0].pix, 
		draw_pixmap, frames[0].gc,
                0, 0, frames[0].width, frames[0].height, 0, 0 );

   	if(x < 15 && do_key == True)
	{
		printf("Copy to Pixmap 0\n");
   		XCopyArea(XtDisplay(draw), frames[2].pix, frames[0].pix, frames[0].gc,
                			0, 0, frames[2].width, frames[2].height,
							(frames[0].width/2) - (frames[2].width/2),
							(frames[0].height/2) - (frames[2].height/2) );
		do_key = False;
	}

	XCopyArea(XtDisplay(draw), frames[1].pix, draw_pixmap, frames[1].gc,
                0, 0, frames[1].width, frames[1].height, x, y );

	XCopyArea(XtDisplay(draw), draw_pixmap, XtWindow(draw), frames[0].gc,
                0, 0, frames[0].width, frames[0].height, 0, 0 );

	increment += 5;
	if(x < -(frame[0].width) ) 
		increment = 5; 

	if(!stop)
   		XtAppAddTimeOut(XtWidgetToApplicationContext(draw), timeout, 
			update_animation, frames);

}

void button_callback(w, client_data, call_data)
 Widget w;
 XtPointer client_data;
 XtPointer call_data;
{
 	int option = (int) client_data;

   	switch(option)
	{
		case START:	stop = False;
   					XtAppAddTimeOut(XtWidgetToApplicationContext(w), 
								timeout, update_animation, frame);
					break;
		case STOP:	stop = True;
					break;
	}
}

void scale_callback(w, client_data, call_data)
 Widget w;
 XtPointer client_data;
 XtPointer call_data;
{
	XmScaleCallbackStruct *calld = (XmScaleCallbackStruct *)call_data;

	timeout = calld->value;
}
		                                /*-------------------------------------
                                         |              MAIN                  |
                                         ------------------------------------*/
int main(argc, argv)
  unsigned int argc;
  char **argv;
{
   Widget toplevel, form, pb1, pb2, scale;
   XtAppContext context;
   Display *dpy;
   int ac = 0;
     
					   	    /* Initialize the toolkit */
   toplevel = XtAppInitialize(&context, "Anim2", NULL, 0, &argc, argv,
                              NULL, NULL, 0);
   dpy = XtDisplay(toplevel);

   form = XtVaCreateManagedWidget("form", xmFormWidgetClass, toplevel,
				NULL);

   draw = XtVaCreateManagedWidget("draw", xmDrawingAreaWidgetClass, form,
				XmNtopAttachment, XmATTACH_FORM,
				XmNtopOffset, 5,
				XmNleftAttachment, XmATTACH_FORM,
				XmNleftOffset, 5,
				XmNrightAttachment, XmATTACH_FORM,
				XmNrightOffset, 5,
				NULL);

   pb1 = XtVaCreateManagedWidget("Start", xmPushButtonWidgetClass, form,
				XmNtopAttachment, XmATTACH_WIDGET,
				XmNtopWidget, draw,
				XmNtopOffset, 5,
				XmNleftAttachment, XmATTACH_POSITION,
				XmNleftPosition, 5,
				XmNrightAttachment, XmATTACH_POSITION,
				XmNrightPosition, 45,
				NULL);

   pb2 = XtVaCreateManagedWidget("Stop", xmPushButtonWidgetClass, form,
				XmNtopAttachment, XmATTACH_WIDGET,
				XmNtopWidget, draw,
				XmNtopOffset, 5,
				XmNleftAttachment, XmATTACH_POSITION,
				XmNleftPosition, 55,
				XmNrightAttachment, XmATTACH_POSITION,
				XmNrightPosition, 95,
				NULL);

   scale = XtVaCreateManagedWidget("scale", xmScaleWidgetClass, form,
				XmNtopAttachment, XmATTACH_WIDGET,
				XmNtopWidget, pb1,
				XmNtopOffset, 5,
				XmNbottomAttachment, XmATTACH_FORM,
				XmNbottomOffset, 5,
				XmNleftAttachment, XmATTACH_POSITION,
				XmNleftPosition, 5,
				XmNrightAttachment, XmATTACH_POSITION,
				XmNrightPosition, 95,
				XmNmaximum, 200,
				XmNminimum, 5,
				XmNshowValue, True,
				XmNorientation, XmHORIZONTAL,
				XmNvalue, 125,
				NULL);

   XtAddCallback(pb1, XmNactivateCallback, 
			(XtCallbackProc) button_callback, (XtPointer)START);
   XtAddCallback(pb2, XmNactivateCallback, 
			(XtCallbackProc) button_callback, (XtPointer)STOP);
   XtAddCallback(scale, XmNvalueChangedCallback, 
			(XtCallbackProc) scale_callback, (XtPointer)NULL);

   create_pixmap(draw, filenames[0], &frame[0]);
   create_pixmap(draw, filenames[1], &frame[1]);
   create_pixmap(draw, filenames[2], &frame[2]);

   XtVaSetValues(draw, XmNwidth, frame[0].width,
					XmNheight, frame[0].height,
					NULL);

   draw_pixmap = XCreatePixmap(dpy, frame[0].pix,
					frame[0].width, frame[0].height, 
					DefaultDepth((dpy), DefaultScreen(dpy)) );

   XtRealizeWidget(toplevel);
   XtAppMainLoop(context);

}/*------------------------------------------------------------ End of MAIN --*/

create_pixmap(w, file, set_frame)
Widget w;
char *file;
Picture *set_frame;
{
   Display *dpy = XtDisplay(w);
   int  i;
   Pixel fg, bg;
   XpmAttributes xpmatts;
   XGCValues gcvals;
   long gcmask = 0L , dynamic_mask = 0L , dont_care_mask = 0L;

   XtVaGetValues(w, XmNbackground, &bg,
		 	XmNforeground, &fg,
			NULL);

   xpmatts.closeness = 40000;
   xpmatts.valuemask = XpmSize | XpmCloseness;
   if( XpmReadFileToPixmap(dpy, DefaultRootWindow(dpy),
			file, &(set_frame->pix), 
				&(set_frame->mask), &xpmatts) == XpmSuccess)
	{
		set_frame->width = xpmatts.width;
		set_frame->height = xpmatts.height;

   		gcmask = GCForeground | GCBackground;
   		dynamic_mask = GCForeground | GCBackground | GCClipMask;
  		gcvals.foreground = fg;
   		gcvals.background = bg;
   		set_frame->gc = XtAllocateGC(w, DefaultDepth( (dpy), DefaultScreen(dpy) ),
		 				gcmask, &gcvals, dynamic_mask, dont_care_mask);

	}
	else
	{
		printf("Pixmap creation error\n");
		exit(0);
	}
}
