/*	This file is part of e93.

	e93 is free software; you can redistribute it and/or modify
	it under the terms of the e93 LICENSE AGREEMENT.

	e93 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	e93 LICENSE AGREEMENT for more details.

	You should have received a copy of the e93 LICENSE AGREEMENT
	along with e93; see the file "LICENSE.TXT".
*/

/* view tracking modes
 */
#define	TM_mMODE			0x000F		/* masks out selection modes */
#define	TM_CHAR				0x0000		/* select by character */
#define	TM_WORD				0x0001		/* select by word */
#define	TM_LINE				0x0002		/* select by line */
#define	TM_ALL				0x0003		/* select everything */
#define	TM_mCOLUMNAR		0x2000		/* tells if the selection should be columnar */
#define	TM_mREPEAT			0x4000		/* tells if still tracking the same selection */
#define	TM_mCONTINUE		0x8000		/* tells if the selection should be continued from what is currently selected */

/* relative position modes (used to move cursor, delete, etc...)
 */

#define	RPM_mMODE			0x000F		/* masks out position modes */
#define	RPM_CHAR			0x0000
#define	RPM_WORD			0x0001
#define	RPM_LINE			0x0002
#define	RPM_LINEEDGE		0x0003
#define	RPM_PARAGRAPHEDGE	0x0004
#define	RPM_PAGE			0x0005
#define	RPM_DOCEDGE			0x0006
#define	RPM_mBACKWARD		0x8000		/* if set, move backward (towards start of file), if clear, move forward */

BOOLEAN EditorAddSelection(SELECTIONUNIVERSE *theSelectionUniverse,UINT32 thePosition,UINT32 numBytes);
void EditorFixSelections(SELECTIONUNIVERSE *theUniverse,UINT32 startOffset,UINT32 oldEndOffset,UINT32 newEndOffset);
void FixEditorUniverseSelections(EDITORUNIVERSE *theUniverse,UINT32 startOffset,UINT32 oldEndOffset,UINT32 newEndOffset);
void EditorHomeViewToPositionLenient(EDITORVIEW *theView,UINT32 thePosition);
void EditorHomeViewToPositionStrict(EDITORVIEW *theView,UINT32 thePosition);
void EditorHomeViewToPositionSemiStrict(EDITORVIEW *theView,UINT32 thePosition);
void EditorHomeViewToCursorLenient(EDITORVIEW *theView,BOOLEAN useEnd);
void EditorHomeViewToCursorStrict(EDITORVIEW *theView,BOOLEAN useEnd);
void EditorHomeViewToCursorSemiStrict(EDITORVIEW *theView,BOOLEAN useEnd);
void EditorVerticalScroll(EDITORVIEW *theView,INT32 amountToScroll);
void EditorVerticalScrollByPages(EDITORVIEW *theView,INT32 pagesToScroll);
void EditorHorizontalScroll(EDITORVIEW *theView,INT32 amountToScroll);
void EditorHorizontalScrollByPages(EDITORVIEW *theView,INT32 pagesToScroll);
void EditorStartSelectionChange(EDITORUNIVERSE *theUniverse);
void EditorEndSelectionChange(EDITORUNIVERSE *theUniverse);
void EditorStartTextChange(EDITORUNIVERSE *theUniverse);
void EditorEndTextChange(EDITORUNIVERSE *theUniverse);
void EditorInvalidateViews(EDITORUNIVERSE *theUniverse);
void EditorStartReplace(EDITORUNIVERSE *theUniverse);
BOOLEAN ReplaceEditorChunks(EDITORUNIVERSE *theUniverse,UINT32 startOffset,UINT32 endOffset,CHUNKHEADER *textChunk,UINT32 textOffset,UINT32 numBytes);
BOOLEAN ReplaceEditorText(EDITORUNIVERSE *theUniverse,UINT32 startOffset,UINT32 endOffset,UINT8 *theText,UINT32 numBytes);
BOOLEAN ReplaceEditorFile(EDITORUNIVERSE *theUniverse,UINT32 startOffset,UINT32 endOffset,char *thePath);
void EditorEndReplace(EDITORUNIVERSE *theUniverse);
void DeleteAllSelectedText(EDITORUNIVERSE *theEditorUniverse);
void GetSelectionEndPositions(SELECTIONUNIVERSE *theUniverse,UINT32 *startPosition,UINT32 *endPosition);
void EditorGetSelectionInfo(EDITORUNIVERSE *theEditorUniverse,UINT32 *startPosition,UINT32 *endPosition,UINT32 *startLine,UINT32 *endLine,UINT32 *startLinePosition,UINT32 *endLinePosition,UINT32 *totalSegments,UINT32 *totalSpan);
UINT8 *EditorNextSelectionToBuffer(EDITORUNIVERSE *theEditorUniverse,UINT32 *currentPosition,ARRAYCHUNKHEADER **currentChunk,UINT32 *currentOffset,UINT32 additionalLength,UINT32 *actualLength,BOOLEAN *atEnd);
void EditorDeleteSelection(EDITORUNIVERSE *theEditorUniverse);
void EditorSetNormalSelection(EDITORUNIVERSE *theEditorUniverse,UINT32 startPosition,UINT32 endPosition);
void EditorSetColumnarSelection(EDITORVIEW *theView,UINT32 startLine,UINT32 endLine,INT32 leftX,INT32 rightX,UINT16 trackMode);
void EditorTrackViewPointer(EDITORVIEW *theView,INT32 viewXPosition,INT32 viewLine,UINT16 trackMode);
void EditorMoveCursor(EDITORVIEW *theView,UINT16 relativeMode);
void EditorExpandNormalSelection(EDITORVIEW *theView,UINT16 relativeMode);
void EditorReduceNormalSelection(EDITORVIEW *theView,UINT16 relativeMode);
void EditorLocateLine(EDITORUNIVERSE *theEditorUniverse,UINT32 theLine);
void EditorSelectAll(EDITORUNIVERSE *theEditorUniverse);
void EditorDelete(EDITORVIEW *theView,UINT16 relativeMode);
void EditorInsert(EDITORUNIVERSE *theEditorUniverse,UINT8 *theText,UINT32 textLength);
void EditorAuxInsert(EDITORUNIVERSE *theEditorUniverse,UINT8 *theText,UINT32 textLength);
BOOLEAN EditorInsertFile(EDITORUNIVERSE *theEditorUniverse,char *thePath);
void EditorAutoIndent(EDITORUNIVERSE *theEditorUniverse);
BOOLEAN ClearEditorUniverse(EDITORUNIVERSE *theUniverse);
BOOLEAN LoadEditorUniverse(EDITORUNIVERSE *theUniverse,char *thePath);
BOOLEAN SaveEditorUniverse(EDITORUNIVERSE *theUniverse,char *thePath,BOOLEAN clearDirty);
void LinkViewToEditorUniverse(EDITORVIEW *theView,EDITORUNIVERSE *theUniverse);
void UnlinkViewFromEditorUniverse(EDITORVIEW *theView);
BOOLEAN GotoEditorMark(EDITORUNIVERSE *theUniverse,MARKLIST *theMark);
MARKLIST *LocateEditorMark(EDITORUNIVERSE *theUniverse,char *markName);
MARKLIST *SetEditorMark(EDITORUNIVERSE *theUniverse,char *markName);
void ClearEditorMark(EDITORUNIVERSE *theUniverse,MARKLIST *theMark);
EDITORUNIVERSE *OpenEditorUniverse();
void CloseEditorUniverse(EDITORUNIVERSE *theEditorUniverse);
