/*	This file is part of e93.

	e93 is free software; you can redistribute it and/or modify
	it under the terms of the e93 LICENSE AGREEMENT.

	e93 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	e93 LICENSE AGREEMENT for more details.

	You should have received a copy of the e93 LICENSE AGREEMENT
	along with e93; see the file "LICENSE.TXT".
*/

#define	EDITMINWIDTH		100
#define	EDITMAXWIDTH		32767
#define	EDITMINHEIGHT		100
#define	EDITMAXHEIGHT		32767

#define EDITTOPBORDER		0		/* the view of an edit window is offset by these borders (strictly for looks) */
#define EDITBOTTOMBORDER	0
#define EDITLEFTBORDER		0
#define EDITRIGHTBORDER		0

#define	STATUSBARFONT		"-*-lucidatypewriter-medium-r-normal-sans-12-*-*-*-*-*-*-*"
#define	STATUSBARLINEHEIGHT		2

void AdjustDocumentWindowStatus(EDITORWINDOW *theWindow);
void AdjustDocumentWindowViewStatus(EDITORVIEW *theView);
void UpdateDocumentWindow(EDITORWINDOW *theWindow);
void AdjustDocumentWindowForNewSize(EDITORWINDOW *theWindow);
void DocumentWindowButtonPress(EDITORWINDOW *theWindow,XEvent *theEvent);
void DocumentPeriodicProc(EDITORWINDOW *theWindow);
void DocumentWindowEvent(EDITORWINDOW *theWindow,XEvent *theEvent);
void SetTopDocumentWindow(EDITORWINDOW *theWindow);
EDITORWINDOW *GetActiveDocumentWindow();
EDITORWINDOW *GetTopDocumentWindow();
BOOLEAN GetSortedDocumentWindowList(UINT32 *numElements,EDITORWINDOW ***theList);
EDITORVIEW *GetDocumentWindowCurrentView(EDITORWINDOW *theWindow);
BOOLEAN GetDocumentWindowTitle(EDITORWINDOW *theWindow,char *theTitle,UINT32 stringBytes);
BOOLEAN SetDocumentWindowTitle(EDITORWINDOW *theWindow,char *theTitle);
BOOLEAN GetEditorDocumentWindowColors(EDITORWINDOW *theWindow,EDITORCOLOR *foregroundColor,EDITORCOLOR *backgroundColor);
BOOLEAN SetEditorDocumentWindowColors(EDITORWINDOW *theWindow,EDITORCOLOR foregroundColor,EDITORCOLOR backgroundColor);
BOOLEAN GetEditorDocumentWindowRect(EDITORWINDOW *theWindow,EDITORRECT *theRect);
BOOLEAN SetEditorDocumentWindowRect(EDITORWINDOW *theWindow,EDITORRECT *theRect);
EDITORWINDOW *OpenDocumentWindow(EDITORUNIVERSE *theUniverse,EDITORRECT *theRect,char *theTitle,char *fontName,UINT32 tabSize,EDITORCOLOR foreground,EDITORCOLOR background);
void CloseDocumentWindow(EDITORWINDOW *theWindow);
