/*	This file is part of e93.

	e93 is free software; you can redistribute it and/or modify
	it under the terms of the e93 LICENSE AGREEMENT.

	e93 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	e93 LICENSE AGREEMENT for more details.

	You should have received a copy of the e93 LICENSE AGREEMENT
	along with e93; see the file "LICENSE.TXT".
*/
#define		PATHSEP		'/'		/* path separation character */

#define		GRAY0	0x333333	/* default gray colors */
#define		GRAY1	0x666666
#define		GRAY2	0x999999
#define		GRAY3	0xCCCCCC

#define		WHITE	0xFFFFFF
#define		BLACK	0x000000

/* stuff needed to make the gui interface go
 */

/* this definition sets EDITORFILE to the structure needed by the gui */
struct editorFile
	{
	int
		fileHandle;
	};

/* this definition sets EDITORMENU to the structure needed by the gui */
struct editorMenu				/* actual structure of an editor menu */
	{
	EDITORWINDOW
		*theWindow;				/* if this menu currently has a window, it is pointed to by this (otherwise, its NULL) */
	char
		*itemText;				/* name of the item is stored here (semi-redundant with OS's name, but easier to get to) */
	char
		*attributes;			/* attribute string is stored here */
	char
		*dataText;				/* the text of the menu (used when menu is clicked on) */
	char
		*commandString;			/* command string is kept here (this is the string that is displayed at the end of the menu when there is a key sequence that can be used to select it) */
	BOOLEAN
		hasKey;					/* TRUE if this item has a key code associated with it */
	KeySym
		theKeySym;				/* keySymCode that we are looking for (if any) */
	XFontStruct
		*theFont;				/* the font that is used for this menu item */
	BOOLEAN
		active;					/* tells if the menu is active (can be selected) or not */
	BOOLEAN
		separator;				/* tells if the menu item is a separator */
	BOOLEAN
		highlight;				/* when a menu button is drawn, this tells if it should draw in its highlighted (pressed) state */
	EDITORMENU					/* linked list of menus */
		*parent,
		*nextSibling,
		*previousSibling,
		*firstChild;
	};

/* this definition sets EDITORTASK to the structure needed by the gui */
struct editorTask
	{
	int
		pid;				/* process id of task */
	BOOLEAN
		closedStdin;		/* set TRUE if EOF has been sent to task by closing our half of its input pipe */
	int
		fdin[2];			/* file handles used to pipe data between us and the task (if one is active) */
	int
		fdout[2];
	};

/* editor window types */
enum
	{
	EWT_DOCUMENT,						/* an actual window used to edit text */
	EWT_DIALOG,							/* a dialog window */
	EWT_MENU							/* menu window */
	};

#define XWINDOWBORDERWIDTH			0		/* border width used when creating x windows */
#define	DEFAULTVIEWFONT				"-*-lucidatypewriter-medium-r-normal-sans-12-*-*-*-*-*-*-*"	/* good font for viewing text */
#define	DEFAULTMENUFONT				"-*-new century schoolbook-bold-r-normal--14-*-*-*-*-*-*-*"
#define	DEFAULTDIALOGBUTTONFONT		"8x13bold"													/* font to use for dialog buttons */
#define	DEFAULTDIALOGSTATICFONT		"8x13bold"													/* font to use for dialog static text */

/* fallback fonts, (if we dont get the requested font, try these in succession) */
#define	FALLBACKFONT0			"-*-lucidatypewriter-medium-r-normal-sans-12-*-*-*-*-*-*-*"
#define	FALLBACKFONT1			"-*-lucidatypewriter-*-r-normal-sans-12-*-*-*-*-*-*-*"
#define	FALLBACKFONT2			"-*-lucidatypewriter-*-*-*-*-*-*-*-*-*-*-*-*"
#define	FALLBACKFONT3			"7x13"

/* this is the WINDOWLISTELEMENT structure which allows us to get
 * back from an x window to the editor window structures
 */

typedef struct windowListElement				/* this structure is used to locate our data based on an x window ID */
	{
	Window
		xWindow;								/* x window id */
	Window
		realTopWindow;							/* since window managers can reparent my windows (bad concept), and since it is necessary keep track of the hierarchy of editor windows, when a window is created, the TRUE root level parent is determined and stored here */
	GC
		graphicsContext;						/* graphics context for the given window */
	Region
		invalidRegion;							/* the region that collects our invalidation information */
	EDITORWINDOW
		*theEditorWindow;						/* pointer to our editor window structure */
	struct windowListElement
		*nextElement,							/* next one of our windows, or NULL if none */
		*previousElement;						/* previous window, or NULL if none */
	} WINDOWLISTELEMENT;


typedef struct
	{
	EDITORVIEW
		*theView;
	SCROLLBAR
		*verticalScrollBar,
		*horizontalScrollBar;
	XFontStruct
		*statusBarFont;							/* info about currently selected status bar font */
	Pixel
		backgroundColor;						/* color to use when drawing background */
	Pixel
		foregroundColor;						/* color to use when drawing foreground */
	} GUIDOCUMENTWINDOWINFO;

typedef struct
	{
	Window
		cursorWindow;		/* x InputOnly window used to make the cursor change to caret within the view (this is ALL it is used for!) */
	XFontStruct
		*theFont;			/* info about currently selected font */
	EDITORRECT
		bounds;				/* boundary of this view within its parent window */
	EDITORRECT
		textBounds;			/* roughly the bounds, but rounded down for the current font */
	UINT32
		topLine;			/* current first line of edit universe that is displayed in the view */
	INT32
		leftPixel;			/* current offset from left where text is being drawn in this view */
	UINT32
		lineHeight;			/* number of pixels per line vertically */
	UINT32
		numLines;			/* number of lines that can be displayed */
	UINT32
		tabSize;			/* number of columns per tab */
	Pixel
		backgroundColor;	/* color to use when drawing background */
	Pixel
		foregroundColor;	/* color to use when drawing foreground */
	BOOLEAN
		viewActive;			/* if TRUE, then view is displayed as active */
	BOOLEAN
		cursorOn;			/* if TRUE, and no selection, and view active, and blinkState, then cursor will be shown */
	BOOLEAN
		blinkState;			/* tells what state (TRUE = on) (FALSE = off) the cursor blink is currently in */
	UINT32
		nextBlinkTime;		/* tells the next time that the cursor should change blink state */
	BOOLEAN
		oldCursorShowing;	/* holds showing state of cursor across Start/EndCursorChange */
	Region
		oldSelectedRegion;	/* holds the view's selected region across calls to Start/EndSelectionChange */
	UINT16
		charWidths[256];	/* cache of widths of all the characters in the current font */
	} GUIVIEWINFO;

typedef struct
	{
	EDITORMENU
		*ownerMenu;			/* points to the menu that owns this window (if NULL, root menu owns window) */
	} GUIMENUWINDOWINFO;
