/* Low level stuff needed to init machine
   Copyright (C) 1995 Viacom New Media.

	This file is part of e93.

	e93 is free software; you can redistribute it and/or modify
	it under the terms of the e93 LICENSE AGREEMENT.

	e93 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	e93 LICENSE AGREEMENT for more details.

	You should have received a copy of the e93 LICENSE AGREEMENT
	along with e93; see the file "LICENSE.TXT".
*/

#include "includes.h"

static char localErrorFamily[]="Xguiinit";

enum
	{
	BADOPEN
	};

static char *errorMembers[]=
	{
	"BadOpen"
	};

static char *errorDescriptions[]=
	{
	"Could not open display"
	};

/* routines callable by the editor
 */

BOOLEAN AddSupplementalShellCommands(Tcl_Interp *theInterpreter)
/* if a given environment desires additional shell commands
 * it can add them here
 * if there is a problem, SetError, and return FALSE
 */
{
	return(TRUE);
}

static BOOLEAN AllocateInitialColors()
/* get colors needed to run the editor
 * if there is a fatal problem, SetError, return FALSE
 */
{
	gray0=AllocColor(GRAY0);
	gray1=AllocColor(GRAY1);
	gray2=AllocColor(GRAY2);
	gray3=AllocColor(GRAY3);

	return(TRUE);
}

static void DeallocateInitialColors()
/* return initial colors
 */
{
	FreeColor(gray3);
	FreeColor(gray2);
	FreeColor(gray1);
	FreeColor(gray0);
}

BOOLEAN InitEnvironment()
/* Initialize the machine, software libraries, etc...
 * if there is a problem, set the error and return FALSE
 */
{
	windowListHead=NULL;						/* no windows are open on the display yet */
	XSetErrorHandler(XErrorEventHandler);		/* set error handling routine */
	if(xDisplay=XOpenDisplay(NULL))				/* connect to the default X server */
		{
		xScreenNum=DefaultScreen(xDisplay);		/* keep this around for handy future reference */
		if(AllocateInitialColors())
			{
			selectionAtom=XInternAtom(xDisplay,"SELECTED_DATA",False);			/* define atoms needed by top-level windows */
			incrAtom=XInternAtom(xDisplay,"INCR",False);						/* incremental selection passing atom */
			takeFocusAtom=XInternAtom(xDisplay,"WM_TAKE_FOCUS",False);
			deleteWindowAtom=XInternAtom(xDisplay,"WM_DELETE_WINDOW",False);

			statusBackgroundColor=gray3;										/* set up colors */
			statusForegroundColor=BlackPixel(xDisplay,xScreenNum);

			if(InitPixmaps())
				{
				if(InitEditorMenus())
					{
					if(InitEvents())
						{
						timer=0;								/* timer ticks */
						ResetCursorBlinkTime();					/* reset the timeout value of the cursor blink timer */
						ResetEditorIntervalTimer();				/* reset the interval timer for the editor */
						StartAlarmTimer();						/* start the ualarm timer running (it wakes us to check events, and also updates timers) */
						showingBusy=0;							/* reset cursor busy depth */
						caretCursor=XCreateFontCursor(xDisplay,XC_xterm);	/* create the pointer cursor to use when inside view */
						arrowCursor=XCreateFontCursor(xDisplay,XC_arrow);	/* create the arrow cursor to use for other things */
						timeToQuit=FALSE;						/* clear the quit request flag */
						return(TRUE);
						}
					UnInitEditorMenus();
					}
				UnInitPixmaps();
				}
			DeallocateInitialColors();
			}
		XCloseDisplay(xDisplay);
		}
	else
		{
		SetError(localErrorFamily,errorMembers[BADOPEN],errorDescriptions[BADOPEN]);
		}
	return(FALSE);
}

void UnInitEnvironment()
/* undo what Init did
 */
{
	XFreeCursor(xDisplay,arrowCursor);
	XFreeCursor(xDisplay,caretCursor);
	UnInitEvents();
	UnInitEditorMenus();
	UnInitPixmaps();
	DeallocateInitialColors();
	XCloseDisplay(xDisplay);
}

BOOLEAN EarlyInit()
/* This is called before anything else in the editor, it can be used to fork off the
 * editor as a separate process, or do anything which may need to be done very early
 * if this returns FALSE, the editor will exit without complaint
 */
{
	return(TRUE);									/* ### the editor works better for things like mail if it does not return until done! */
/*													fork off, kill the parent, leave the child
	if(!fork())
		{
		return(TRUE);
		}
	return(FALSE);
*/
}

void EarlyUnInit()
/* This is the very last thing that the editor calls before exiting
 */
{
}
