/*	This file is part of e93.

	e93 is free software; you can redistribute it and/or modify
	it under the terms of the e93 LICENSE AGREEMENT.

	e93 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	e93 LICENSE AGREEMENT for more details.

	You should have received a copy of the e93 LICENSE AGREEMENT
	along with e93; see the file "LICENSE.TXT".
*/

#define MAXSTRINGPERNODE			32				/* maximum number of characters in a string within a node */
#define MAXREGISTERS				10				/* maximum number of registers to remember */
#define	MAXRECURSIONDEPTH			8000			/* maximum amount of recursion we deem allowable */

typedef enum
	{
	/* NOTE: the order of these IS important, there are tables in the code that match this order */
	PT_STRING=0,				/* matching constant string */
	PT_LIST,					/* matching one character to see if it is in a list */
	PT_PREVIOUSMATCH,			/* matching against data found in previous match */
	PT_SUBEXPRESSIONSTART,		/* matching against data found in a sub expression */
	PT_SUBEXPRESSIONEND,		/* end of sub expression match */
	PT_STARTOFLINE,				/* must currently be at start of a line or this fails */
	PT_ENDOFLINE				/* currently at end of line of this fails */
	} PATTERNTYPE;

typedef struct
	{
	CHUNKHEADER
		*theChunk;				/* chunk and offset that start this register (if NULL, register not yet matched) */
	UINT32
		theOffset;
	UINT32
		numBytes;				/* number of bytes matched by this register */
	} REGISTER;

typedef struct expressionNode
	{
	PATTERNTYPE
		theType;				/* type of pattern this element represents */
	UINT8
		dataLength;				/* length of string data if it exists */
	union
		{
		UINT8
			theData[MAXSTRINGPERNODE];		/* characters of the string to compare against (if string type) */
		UINT8
			theBits[256/8];		/* the bits that tell if a character is or is not to be accepted (in a group) */
		REGISTER
			*theRegister;		/* points to the register which holds the start and end of the last match we are to compare against (for register type) */
		struct
			{
			struct expressionListHeader
				*subExpressionList;	/* pointer to expression list for this subexpression */
			UINT32
				currentCount;	/* current number of successful iterations of the subexpression */
			REGISTER
				*theRegister;	/* points to the register to remember match of subexpression in */
			CHUNKHEADER
				*lastChunk;		/* the chunk pointer that was active last time */
			UINT32
				lastOffset;		/* the offset that was active last time */
			UINT32
				lastNumToSearch;	/* number of bytes we were asked to search last time */
			BOOLEAN
				justEntered;	/* tells if just entered this subexpression */
			} se;
		} pt;
	BOOLEAN
		matchSpecified;			/* user has specified a match limit for this node */
	UINT32
		matchMin,				/* minimum number of times to match pattern (0 means we dont even have to match this) */
		matchMax;				/* maximum number of times to match pattern (0 means infinite) */
	struct expressionNode
		*nextExpression,		/* next expression along the line at this level */
		*parentExpression;		/* parent expression, or NULL if at top */
	} EXPRESSIONNODE;

typedef struct expressionListHeader
	{
	EXPRESSIONNODE
		*firstExpression;		/* first expression in the list for this level */
	struct expressionListHeader
		*nextAlternate;			/* next alternate expression list for this level (NULL for no more) */
	} EXPRESSIONLISTHEADER;

typedef struct compiledExpression
	{
	EXPRESSIONLISTHEADER
		*firstList;				/* points to the first top-level expression list */
	UINT32
		numGroups;				/* incremented every time a group is encountered during compile */
	BOOLEAN
		registerDefined[MAXREGISTERS];	/* used during compilation to remember which registers have been defined already */
	REGISTER
		theRegisters[MAXREGISTERS];		/* the registers that keep track of various match points */
	} COMPILEDEXPRESSION;

void REFree(COMPILEDEXPRESSION *theExpression);
void REPrintExpressionList(EXPRESSIONLISTHEADER *theList,UINT32 depth);
void REPrintCompiledExpression(COMPILEDEXPRESSION *theExpression);
COMPILEDEXPRESSION *RECompile(UINT8 *theExpression,UINT32 numBytes,UINT8 *translateTable);
BOOLEAN REMatch(CHUNKHEADER *theChunk,UINT32 theOffset,COMPILEDEXPRESSION *theCompiledExpression,BOOLEAN leftEdge,BOOLEAN rightEdge,UINT32 numToSearch,UINT8 *translateTable,BOOLEAN *foundMatch,UINT32 *numMatched,CHUNKHEADER **endChunk,UINT32 *endOffset);
