/*
	Copyright (C)   1995
	Edward  Der-Hua Liu,    Hsin-Chu,       Taiwan
*/

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include "ted.h"

extern Display *display;
extern Window main_win;
extern int input_handler;

void receive_string(char *s, int len)
{
if (!len) return;
s[len]=0;
switch (input_handler) {
	case 0:
		if (len) {
			s_fmod();
			file_modified=-1;
		}
		u_del_str(s,len,1);
		put_str(s,len);
		break;
	case 1:
		put_str_xgets(s);
		break;
}
}

void paste_primary(int win,int property,int Delete)
{
Atom actual_type;
int actual_format,i;
long nitem, bytes_after, nread;
unsigned char *data;

if (property == None)
	return;
nread = 0;
do   {
		if (XGetWindowProperty(display,win,property,nread/4,32768,Delete,
			   AnyPropertyType,&actual_type,&actual_format,
			   &nitem,&bytes_after,(unsigned char **)&data)
	!= Success) return;
#if	0
		if (actual_type != XA_STRING) return;
#endif
		receive_string(data,nitem);
		nread += nitem;
		XFree(data);
} while (bytes_after > 0);
disp_fname();
}

void request_selection(int time)
{
Window w;
Atom property;
if ((w=XGetSelectionOwner(display,XA_PRIMARY)) == None) {
	paste_primary(DefaultRootWindow(display),XA_CUT_BUFFER0,False);
	return;
}
property = XInternAtom(display,"VT_SELECTION",False);
XConvertSelection(display,XA_PRIMARY,XA_STRING,property, main_win,time);
}

char *selection_text;
int selection_length;

void set_selection()
{
	int i,j,k,len=0;
	extern Time eve_time;

	if (cur_file!=mark_holder) return;
	if (mline_begin>=0) {
	for(i=mline_begin;i<=mline_end;i++)
		len+=edbf[i].len+1;
	if ((selection_text=(char *)mrealloc(selection_text,len,
			"set_selection 1"))==NULL) {
		return;
	}
	j=0;
	for(i=mline_begin;i<=mline_end;i++) {
		memcpy(&selection_text[j],edbf[i].cstr,edbf[i].len);
		j+=edbf[i].len;
		selection_text[j++]='\n';
	}
	selection_length=len;
	} else
	if (mblk_row0>=0) {
	for(i=mblk_row0;i<=mblk_row1;i++) {
		j=Min(mblk_col1, edbf[i].len-1)-mblk_col0+2;
		if (j>0) len+=j;
		else len++;
	}
	len--;
	if (len<=0) return;
	if ((selection_text=(char *)mrealloc(selection_text,len,"set_selection 2"))==NULL) {
		error("set_selection 2");
		return;
	}
	j=0;
	for(i=mblk_row0;i<=mblk_row1;i++) {
		k=Min(mblk_col1, edbf[i].len-1)-mblk_col0+1;
		if (k > 0) {
			memcpy(&selection_text[j],&edbf[i].cstr[mblk_col0],k);
			j+=k;
		}
		if (i<mblk_row1) selection_text[j++]='\n';
	}
	selection_length=len;
	}
	XSetSelectionOwner(display,XA_PRIMARY,main_win,(Time)eve_time);
	if (XGetSelectionOwner(display,XA_PRIMARY) != main_win)
	error("Could not set primary selection");
	XChangeProperty(display,DefaultRootWindow(display),XA_CUT_BUFFER0,
		  XA_STRING,8,PropModeReplace,selection_text,selection_length);
}

void send_selection(XSelectionRequestEvent *rq)
{
	XSelectionEvent notify;

	notify.type = SelectionNotify;
	notify.display = rq->display;
	notify.requestor = rq->requestor;
	notify.selection = rq->selection;
	notify.target = rq->target;
	notify.time = rq->time;
	XChangeProperty(display,rq->requestor,rq->property,XA_STRING,8,
		PropModeReplace, selection_text,selection_length);
	notify.property = rq->property;
	XSendEvent(display,rq->requestor,False,0,(XEvent *)&notify);
}
